/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

import io.tiledb.cloud.rest_api.JSON;

/**
 * Input/Output information required to create a new file
 */
@ApiModel(description = "Input/Output information required to create a new file")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class FileCreate {
  public static final String SERIALIZED_NAME_INPUT_URI = "input_uri";
  @SerializedName(SERIALIZED_NAME_INPUT_URI)
  private String inputUri;

  public static final String SERIALIZED_NAME_OUTPUT_URI = "output_uri";
  @SerializedName(SERIALIZED_NAME_OUTPUT_URI)
  private String outputUri;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public FileCreate() { 
  }

  public FileCreate inputUri(String inputUri) {
    
    this.inputUri = inputUri;
    return this;
  }

   /**
   * storage URI of the input file
   * @return inputUri
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "storage URI of the input file")

  public String getInputUri() {
    return inputUri;
  }


  public void setInputUri(String inputUri) {
    this.inputUri = inputUri;
  }


  public FileCreate outputUri(String outputUri) {
    
    this.outputUri = outputUri;
    return this;
  }

   /**
   * output location of the TileDB File
   * @return outputUri
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "output location of the TileDB File")

  public String getOutputUri() {
    return outputUri;
  }


  public void setOutputUri(String outputUri) {
    this.outputUri = outputUri;
  }


  public FileCreate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * name to set for registered file
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "name to set for registered file")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FileCreate fileCreate = (FileCreate) o;
    return Objects.equals(this.inputUri, fileCreate.inputUri) &&
        Objects.equals(this.outputUri, fileCreate.outputUri) &&
        Objects.equals(this.name, fileCreate.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(inputUri, outputUri, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FileCreate {\n");
    sb.append("    inputUri: ").append(toIndentedString(inputUri)).append("\n");
    sb.append("    outputUri: ").append(toIndentedString(outputUri)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("input_uri");
    openapiFields.add("output_uri");
    openapiFields.add("name");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to FileCreate
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (FileCreate.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in FileCreate is not found in the empty JSON string", FileCreate.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!FileCreate.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FileCreate` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("input_uri") != null && !jsonObj.get("input_uri").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `input_uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get("input_uri").toString()));
      }
      if (jsonObj.get("output_uri") != null && !jsonObj.get("output_uri").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `output_uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get("output_uri").toString()));
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FileCreate.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FileCreate' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FileCreate> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FileCreate.class));

       return (TypeAdapter<T>) new TypeAdapter<FileCreate>() {
           @Override
           public void write(JsonWriter out, FileCreate value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FileCreate read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FileCreate given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FileCreate
  * @throws IOException if the JSON string is invalid with respect to FileCreate
  */
  public static FileCreate fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FileCreate.class);
  }

 /**
  * Convert an instance of FileCreate to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

