/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * sharing state of a group with a namespace
 */
@ApiModel(description = "sharing state of a group with a namespace")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class GroupSharing {
  public static final String SERIALIZED_NAME_GROUP_ACTIONS = "group_actions";
  @SerializedName(SERIALIZED_NAME_GROUP_ACTIONS)
  private List<GroupActions> groupActions = null;

  public static final String SERIALIZED_NAME_ARRAY_ACTIONS = "array_actions";
  @SerializedName(SERIALIZED_NAME_ARRAY_ACTIONS)
  private List<ArrayActions> arrayActions = null;

  public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
  @SerializedName(SERIALIZED_NAME_NAMESPACE)
  private String namespace;

  public static final String SERIALIZED_NAME_NAMESPACE_TYPE = "namespace_type";
  @SerializedName(SERIALIZED_NAME_NAMESPACE_TYPE)
  private String namespaceType;

  public GroupSharing() { 
  }

  public GroupSharing groupActions(List<GroupActions> groupActions) {
    
    this.groupActions = groupActions;
    return this;
  }

  public GroupSharing addGroupActionsItem(GroupActions groupActionsItem) {
    if (this.groupActions == null) {
      this.groupActions = new ArrayList<>();
    }
    this.groupActions.add(groupActionsItem);
    return this;
  }

   /**
   * List of permitted actions for the group and all subgroups
   * @return groupActions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[read, write]", value = "List of permitted actions for the group and all subgroups")

  public List<GroupActions> getGroupActions() {
    return groupActions;
  }


  public void setGroupActions(List<GroupActions> groupActions) {
    this.groupActions = groupActions;
  }


  public GroupSharing arrayActions(List<ArrayActions> arrayActions) {
    
    this.arrayActions = arrayActions;
    return this;
  }

  public GroupSharing addArrayActionsItem(ArrayActions arrayActionsItem) {
    if (this.arrayActions == null) {
      this.arrayActions = new ArrayList<>();
    }
    this.arrayActions.add(arrayActionsItem);
    return this;
  }

   /**
   * List of permitted actions for all the subarrays of the group
   * @return arrayActions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[read, write]", value = "List of permitted actions for all the subarrays of the group")

  public List<ArrayActions> getArrayActions() {
    return arrayActions;
  }


  public void setArrayActions(List<ArrayActions> arrayActions) {
    this.arrayActions = arrayActions;
  }


  public GroupSharing namespace(String namespace) {
    
    this.namespace = namespace;
    return this;
  }

   /**
   * namespace being granted group access can be a user or organization
   * @return namespace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "MyOrganization", value = "namespace being granted group access can be a user or organization")

  public String getNamespace() {
    return namespace;
  }


  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }


  public GroupSharing namespaceType(String namespaceType) {
    
    this.namespaceType = namespaceType;
    return this;
  }

   /**
   * details on if the namespace is a organization or user
   * @return namespaceType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "organization", value = "details on if the namespace is a organization or user")

  public String getNamespaceType() {
    return namespaceType;
  }


  public void setNamespaceType(String namespaceType) {
    this.namespaceType = namespaceType;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GroupSharing groupSharing = (GroupSharing) o;
    return Objects.equals(this.groupActions, groupSharing.groupActions) &&
        Objects.equals(this.arrayActions, groupSharing.arrayActions) &&
        Objects.equals(this.namespace, groupSharing.namespace) &&
        Objects.equals(this.namespaceType, groupSharing.namespaceType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupActions, arrayActions, namespace, namespaceType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GroupSharing {\n");
    sb.append("    groupActions: ").append(toIndentedString(groupActions)).append("\n");
    sb.append("    arrayActions: ").append(toIndentedString(arrayActions)).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    namespaceType: ").append(toIndentedString(namespaceType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("group_actions");
    openapiFields.add("array_actions");
    openapiFields.add("namespace");
    openapiFields.add("namespace_type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to GroupSharing
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (GroupSharing.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in GroupSharing is not found in the empty JSON string", GroupSharing.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!GroupSharing.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GroupSharing` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      // ensure the json data is an array
      if (jsonObj.get("group_actions") != null && !jsonObj.get("group_actions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `group_actions` to be an array in the JSON string but got `%s`", jsonObj.get("group_actions").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("array_actions") != null && !jsonObj.get("array_actions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `array_actions` to be an array in the JSON string but got `%s`", jsonObj.get("array_actions").toString()));
      }
      if (jsonObj.get("namespace") != null && !jsonObj.get("namespace").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get("namespace").toString()));
      }
      if (jsonObj.get("namespace_type") != null && !jsonObj.get("namespace_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `namespace_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("namespace_type").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!GroupSharing.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'GroupSharing' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<GroupSharing> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(GroupSharing.class));

       return (TypeAdapter<T>) new TypeAdapter<GroupSharing>() {
           @Override
           public void write(JsonWriter out, GroupSharing value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public GroupSharing read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of GroupSharing given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of GroupSharing
  * @throws IOException if the JSON string is invalid with respect to GroupSharing
  */
  public static GroupSharing fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, GroupSharing.class);
  }

 /**
  * Convert an instance of GroupSharing to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

