/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

import io.tiledb.cloud.rest_api.JSON;

/**
 * User-defined function
 */
@ApiModel(description = "User-defined function")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class MultiArrayUDF {
  public static final String SERIALIZED_NAME_UDF_INFO_NAME = "udf_info_name";
  @SerializedName(SERIALIZED_NAME_UDF_INFO_NAME)
  private String udfInfoName;

  public static final String SERIALIZED_NAME_LANGUAGE = "language";
  @SerializedName(SERIALIZED_NAME_LANGUAGE)
  private UDFLanguage language;

  public static final String SERIALIZED_NAME_VERSION = "version";
  @SerializedName(SERIALIZED_NAME_VERSION)
  private String version;

  public static final String SERIALIZED_NAME_IMAGE_NAME = "image_name";
  @SerializedName(SERIALIZED_NAME_IMAGE_NAME)
  private String imageName;

  public static final String SERIALIZED_NAME_RESOURCE_CLASS = "resource_class";
  @SerializedName(SERIALIZED_NAME_RESOURCE_CLASS)
  private String resourceClass;

  public static final String SERIALIZED_NAME_EXEC = "exec";
  @SerializedName(SERIALIZED_NAME_EXEC)
  private String exec;

  public static final String SERIALIZED_NAME_EXEC_RAW = "exec_raw";
  @SerializedName(SERIALIZED_NAME_EXEC_RAW)
  private String execRaw;

  public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
  @SerializedName(SERIALIZED_NAME_RESULT_FORMAT)
  private ResultFormat resultFormat;

  public static final String SERIALIZED_NAME_TASK_NAME = "task_name";
  @SerializedName(SERIALIZED_NAME_TASK_NAME)
  private String taskName;

  public static final String SERIALIZED_NAME_ARGUMENT = "argument";
  @SerializedName(SERIALIZED_NAME_ARGUMENT)
  private String argument;

  public static final String SERIALIZED_NAME_ARGUMENTS_JSON = "arguments_json";
  @SerializedName(SERIALIZED_NAME_ARGUMENTS_JSON)
  private List<TGUDFArgument> argumentsJson = null;

  public static final String SERIALIZED_NAME_STORED_PARAM_UUIDS = "stored_param_uuids";
  @SerializedName(SERIALIZED_NAME_STORED_PARAM_UUIDS)
  private List<String> storedParamUuids = null;

  public static final String SERIALIZED_NAME_STORE_RESULTS = "store_results";
  @SerializedName(SERIALIZED_NAME_STORE_RESULTS)
  private Boolean storeResults;

  public static final String SERIALIZED_NAME_DONT_DOWNLOAD_RESULTS = "dont_download_results";
  @SerializedName(SERIALIZED_NAME_DONT_DOWNLOAD_RESULTS)
  private Boolean dontDownloadResults;

  public static final String SERIALIZED_NAME_RANGES = "ranges";
  @SerializedName(SERIALIZED_NAME_RANGES)
  private QueryRanges ranges;

  public static final String SERIALIZED_NAME_SUBARRAY = "subarray";
  @SerializedName(SERIALIZED_NAME_SUBARRAY)
  private UDFSubarray subarray;

  public static final String SERIALIZED_NAME_BUFFERS = "buffers";
  @SerializedName(SERIALIZED_NAME_BUFFERS)
  private List<String> buffers = null;

  public static final String SERIALIZED_NAME_ARRAYS = "arrays";
  @SerializedName(SERIALIZED_NAME_ARRAYS)
  private List<UDFArrayDetails> arrays = null;

  public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
  @SerializedName(SERIALIZED_NAME_TIMEOUT)
  private Integer timeout;

  public static final String SERIALIZED_NAME_TASK_GRAPH_UUID = "task_graph_uuid";
  @SerializedName(SERIALIZED_NAME_TASK_GRAPH_UUID)
  private String taskGraphUuid;

  public static final String SERIALIZED_NAME_CLIENT_NODE_UUID = "client_node_uuid";
  @SerializedName(SERIALIZED_NAME_CLIENT_NODE_UUID)
  private String clientNodeUuid;

  public MultiArrayUDF() { 
  }

  public MultiArrayUDF udfInfoName(String udfInfoName) {
    
    this.udfInfoName = udfInfoName;
    return this;
  }

   /**
   * name of UDFInfo to run, format is {namespace}/{udf_name}. Can not be used with exec
   * @return udfInfoName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "TileDB-Inc/quickstart_median", value = "name of UDFInfo to run, format is {namespace}/{udf_name}. Can not be used with exec")

  public String getUdfInfoName() {
    return udfInfoName;
  }


  public void setUdfInfoName(String udfInfoName) {
    this.udfInfoName = udfInfoName;
  }


  public MultiArrayUDF language(UDFLanguage language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public UDFLanguage getLanguage() {
    return language;
  }


  public void setLanguage(UDFLanguage language) {
    this.language = language;
  }


  public MultiArrayUDF version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Type-specific version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type-specific version")

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


  public MultiArrayUDF imageName(String imageName) {
    
    this.imageName = imageName;
    return this;
  }

   /**
   * Docker image name to use for UDF
   * @return imageName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Docker image name to use for UDF")

  public String getImageName() {
    return imageName;
  }


  public void setImageName(String imageName) {
    this.imageName = imageName;
  }


  public MultiArrayUDF resourceClass(String resourceClass) {
    
    this.resourceClass = resourceClass;
    return this;
  }

   /**
   * The resource class to use for the UDF execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the UDF will execute in the standard resource class of the TileDB Cloud provider. 
   * @return resourceClass
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "standard", value = "The resource class to use for the UDF execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the UDF will execute in the standard resource class of the TileDB Cloud provider. ")

  public String getResourceClass() {
    return resourceClass;
  }


  public void setResourceClass(String resourceClass) {
    this.resourceClass = resourceClass;
  }


  public MultiArrayUDF exec(String exec) {
    
    this.exec = exec;
    return this;
  }

   /**
   * Type-specific executable text
   * @return exec
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type-specific executable text")

  public String getExec() {
    return exec;
  }


  public void setExec(String exec) {
    this.exec = exec;
  }


  public MultiArrayUDF execRaw(String execRaw) {
    
    this.execRaw = execRaw;
    return this;
  }

   /**
   * optional raw text to store of serialized function, used for showing in UI
   * @return execRaw
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "optional raw text to store of serialized function, used for showing in UI")

  public String getExecRaw() {
    return execRaw;
  }


  public void setExecRaw(String execRaw) {
    this.execRaw = execRaw;
  }


  public MultiArrayUDF resultFormat(ResultFormat resultFormat) {
    
    this.resultFormat = resultFormat;
    return this;
  }

   /**
   * Get resultFormat
   * @return resultFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ResultFormat getResultFormat() {
    return resultFormat;
  }


  public void setResultFormat(ResultFormat resultFormat) {
    this.resultFormat = resultFormat;
  }


  public MultiArrayUDF taskName(String taskName) {
    
    this.taskName = taskName;
    return this;
  }

   /**
   * name of task, optional
   * @return taskName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "name of task, optional")

  public String getTaskName() {
    return taskName;
  }


  public void setTaskName(String taskName) {
    this.taskName = taskName;
  }


  public MultiArrayUDF argument(String argument) {
    
    this.argument = argument;
    return this;
  }

   /**
   * Deprecated: Prefer to use &#x60;argument_json&#x60; instead. Argument(s) to pass to UDF function, tuple or list of args/kwargs which can be in native or JSON format 
   * @return argument
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Deprecated: Prefer to use `argument_json` instead. Argument(s) to pass to UDF function, tuple or list of args/kwargs which can be in native or JSON format ")

  public String getArgument() {
    return argument;
  }


  public void setArgument(String argument) {
    this.argument = argument;
  }


  public MultiArrayUDF argumentsJson(List<TGUDFArgument> argumentsJson) {
    
    this.argumentsJson = argumentsJson;
    return this;
  }

  public MultiArrayUDF addArgumentsJsonItem(TGUDFArgument argumentsJsonItem) {
    if (this.argumentsJson == null) {
      this.argumentsJson = new ArrayList<>();
    }
    this.argumentsJson.add(argumentsJsonItem);
    return this;
  }

   /**
   * A series of key-value pairs to be passed as arguments into the UDF. See &#x60;TGUDFNodeData.arguments&#x60; for more information. If this format is used to pass arguments, arrays will be passed into the UDF as specified by the Node placeholders passed in here, rather than the classic method of putting all array arguments in the first parameter. Either this or &#x60;argument&#x60; should be set. 
   * @return argumentsJson
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A series of key-value pairs to be passed as arguments into the UDF. See `TGUDFNodeData.arguments` for more information. If this format is used to pass arguments, arrays will be passed into the UDF as specified by the Node placeholders passed in here, rather than the classic method of putting all array arguments in the first parameter. Either this or `argument` should be set. ")

  public List<TGUDFArgument> getArgumentsJson() {
    return argumentsJson;
  }


  public void setArgumentsJson(List<TGUDFArgument> argumentsJson) {
    this.argumentsJson = argumentsJson;
  }


  public MultiArrayUDF storedParamUuids(List<String> storedParamUuids) {
    
    this.storedParamUuids = storedParamUuids;
    return this;
  }

  public MultiArrayUDF addStoredParamUuidsItem(String storedParamUuidsItem) {
    if (this.storedParamUuids == null) {
      this.storedParamUuids = new ArrayList<>();
    }
    this.storedParamUuids.add(storedParamUuidsItem);
    return this;
  }

   /**
   * The UUIDs of stored input parameters (passed in a language-specific format within \&quot;argument\&quot;) to be retrieved from the server-side cache. Serialized in standard hex format with no {}.
   * @return storedParamUuids
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The UUIDs of stored input parameters (passed in a language-specific format within \"argument\") to be retrieved from the server-side cache. Serialized in standard hex format with no {}.")

  public List<String> getStoredParamUuids() {
    return storedParamUuids;
  }


  public void setStoredParamUuids(List<String> storedParamUuids) {
    this.storedParamUuids = storedParamUuids;
  }


  public MultiArrayUDF storeResults(Boolean storeResults) {
    
    this.storeResults = storeResults;
    return this;
  }

   /**
   * store results for later retrieval
   * @return storeResults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "store results for later retrieval")

  public Boolean getStoreResults() {
    return storeResults;
  }


  public void setStoreResults(Boolean storeResults) {
    this.storeResults = storeResults;
  }


  public MultiArrayUDF dontDownloadResults(Boolean dontDownloadResults) {
    
    this.dontDownloadResults = dontDownloadResults;
    return this;
  }

   /**
   * Set to true to avoid downloading the results of this UDF. Useful for intermediate nodes in a task graph where you will not be using the results of your function. Defaults to false (\&quot;yes download results\&quot;).
   * @return dontDownloadResults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Set to true to avoid downloading the results of this UDF. Useful for intermediate nodes in a task graph where you will not be using the results of your function. Defaults to false (\"yes download results\").")

  public Boolean getDontDownloadResults() {
    return dontDownloadResults;
  }


  public void setDontDownloadResults(Boolean dontDownloadResults) {
    this.dontDownloadResults = dontDownloadResults;
  }


  public MultiArrayUDF ranges(QueryRanges ranges) {
    
    this.ranges = ranges;
    return this;
  }

   /**
   * Get ranges
   * @return ranges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public QueryRanges getRanges() {
    return ranges;
  }


  public void setRanges(QueryRanges ranges) {
    this.ranges = ranges;
  }


  public MultiArrayUDF subarray(UDFSubarray subarray) {
    
    this.subarray = subarray;
    return this;
  }

   /**
   * Get subarray
   * @return subarray
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public UDFSubarray getSubarray() {
    return subarray;
  }


  public void setSubarray(UDFSubarray subarray) {
    this.subarray = subarray;
  }


  public MultiArrayUDF buffers(List<String> buffers) {
    
    this.buffers = buffers;
    return this;
  }

  public MultiArrayUDF addBuffersItem(String buffersItem) {
    if (this.buffers == null) {
      this.buffers = new ArrayList<>();
    }
    this.buffers.add(buffersItem);
    return this;
  }

   /**
   * List of buffers to fetch (attributes + dimensions). Deprecated; please set arrays with &#x60;UDFArrayDetails&#x60;.
   * @return buffers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of buffers to fetch (attributes + dimensions). Deprecated; please set arrays with `UDFArrayDetails`.")

  public List<String> getBuffers() {
    return buffers;
  }


  public void setBuffers(List<String> buffers) {
    this.buffers = buffers;
  }


  public MultiArrayUDF arrays(List<UDFArrayDetails> arrays) {
    
    this.arrays = arrays;
    return this;
  }

  public MultiArrayUDF addArraysItem(UDFArrayDetails arraysItem) {
    if (this.arrays == null) {
      this.arrays = new ArrayList<>();
    }
    this.arrays.add(arraysItem);
    return this;
  }

   /**
   * Array ranges/buffer into to run UDF on
   * @return arrays
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Array ranges/buffer into to run UDF on")

  public List<UDFArrayDetails> getArrays() {
    return arrays;
  }


  public void setArrays(List<UDFArrayDetails> arrays) {
    this.arrays = arrays;
  }


  public MultiArrayUDF timeout(Integer timeout) {
    
    this.timeout = timeout;
    return this;
  }

   /**
   * UDF-type timeout in seconds (default: 900)
   * @return timeout
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "UDF-type timeout in seconds (default: 900)")

  public Integer getTimeout() {
    return timeout;
  }


  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }


  public MultiArrayUDF taskGraphUuid(String taskGraphUuid) {
    
    this.taskGraphUuid = taskGraphUuid;
    return this;
  }

   /**
   * If set, the ID of the log for the task graph that this was part of. 
   * @return taskGraphUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the ID of the log for the task graph that this was part of. ")

  public String getTaskGraphUuid() {
    return taskGraphUuid;
  }


  public void setTaskGraphUuid(String taskGraphUuid) {
    this.taskGraphUuid = taskGraphUuid;
  }


  public MultiArrayUDF clientNodeUuid(String clientNodeUuid) {
    
    this.clientNodeUuid = clientNodeUuid;
    return this;
  }

   /**
   * If set, the client-defined ID of the node within this task&#39;s graph. 
   * @return clientNodeUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the client-defined ID of the node within this task's graph. ")

  public String getClientNodeUuid() {
    return clientNodeUuid;
  }


  public void setClientNodeUuid(String clientNodeUuid) {
    this.clientNodeUuid = clientNodeUuid;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultiArrayUDF multiArrayUDF = (MultiArrayUDF) o;
    return Objects.equals(this.udfInfoName, multiArrayUDF.udfInfoName) &&
        Objects.equals(this.language, multiArrayUDF.language) &&
        Objects.equals(this.version, multiArrayUDF.version) &&
        Objects.equals(this.imageName, multiArrayUDF.imageName) &&
        Objects.equals(this.resourceClass, multiArrayUDF.resourceClass) &&
        Objects.equals(this.exec, multiArrayUDF.exec) &&
        Objects.equals(this.execRaw, multiArrayUDF.execRaw) &&
        Objects.equals(this.resultFormat, multiArrayUDF.resultFormat) &&
        Objects.equals(this.taskName, multiArrayUDF.taskName) &&
        Objects.equals(this.argument, multiArrayUDF.argument) &&
        Objects.equals(this.argumentsJson, multiArrayUDF.argumentsJson) &&
        Objects.equals(this.storedParamUuids, multiArrayUDF.storedParamUuids) &&
        Objects.equals(this.storeResults, multiArrayUDF.storeResults) &&
        Objects.equals(this.dontDownloadResults, multiArrayUDF.dontDownloadResults) &&
        Objects.equals(this.ranges, multiArrayUDF.ranges) &&
        Objects.equals(this.subarray, multiArrayUDF.subarray) &&
        Objects.equals(this.buffers, multiArrayUDF.buffers) &&
        Objects.equals(this.arrays, multiArrayUDF.arrays) &&
        Objects.equals(this.timeout, multiArrayUDF.timeout) &&
        Objects.equals(this.taskGraphUuid, multiArrayUDF.taskGraphUuid) &&
        Objects.equals(this.clientNodeUuid, multiArrayUDF.clientNodeUuid);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(udfInfoName, language, version, imageName, resourceClass, exec, execRaw, resultFormat, taskName, argument, argumentsJson, storedParamUuids, storeResults, dontDownloadResults, ranges, subarray, buffers, arrays, timeout, taskGraphUuid, clientNodeUuid);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultiArrayUDF {\n");
    sb.append("    udfInfoName: ").append(toIndentedString(udfInfoName)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    imageName: ").append(toIndentedString(imageName)).append("\n");
    sb.append("    resourceClass: ").append(toIndentedString(resourceClass)).append("\n");
    sb.append("    exec: ").append(toIndentedString(exec)).append("\n");
    sb.append("    execRaw: ").append(toIndentedString(execRaw)).append("\n");
    sb.append("    resultFormat: ").append(toIndentedString(resultFormat)).append("\n");
    sb.append("    taskName: ").append(toIndentedString(taskName)).append("\n");
    sb.append("    argument: ").append(toIndentedString(argument)).append("\n");
    sb.append("    argumentsJson: ").append(toIndentedString(argumentsJson)).append("\n");
    sb.append("    storedParamUuids: ").append(toIndentedString(storedParamUuids)).append("\n");
    sb.append("    storeResults: ").append(toIndentedString(storeResults)).append("\n");
    sb.append("    dontDownloadResults: ").append(toIndentedString(dontDownloadResults)).append("\n");
    sb.append("    ranges: ").append(toIndentedString(ranges)).append("\n");
    sb.append("    subarray: ").append(toIndentedString(subarray)).append("\n");
    sb.append("    buffers: ").append(toIndentedString(buffers)).append("\n");
    sb.append("    arrays: ").append(toIndentedString(arrays)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    taskGraphUuid: ").append(toIndentedString(taskGraphUuid)).append("\n");
    sb.append("    clientNodeUuid: ").append(toIndentedString(clientNodeUuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("udf_info_name");
    openapiFields.add("language");
    openapiFields.add("version");
    openapiFields.add("image_name");
    openapiFields.add("resource_class");
    openapiFields.add("exec");
    openapiFields.add("exec_raw");
    openapiFields.add("result_format");
    openapiFields.add("task_name");
    openapiFields.add("argument");
    openapiFields.add("arguments_json");
    openapiFields.add("stored_param_uuids");
    openapiFields.add("store_results");
    openapiFields.add("dont_download_results");
    openapiFields.add("ranges");
    openapiFields.add("subarray");
    openapiFields.add("buffers");
    openapiFields.add("arrays");
    openapiFields.add("timeout");
    openapiFields.add("task_graph_uuid");
    openapiFields.add("client_node_uuid");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to MultiArrayUDF
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (MultiArrayUDF.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in MultiArrayUDF is not found in the empty JSON string", MultiArrayUDF.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!MultiArrayUDF.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `MultiArrayUDF` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("udf_info_name") != null && !jsonObj.get("udf_info_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `udf_info_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("udf_info_name").toString()));
      }
      if (jsonObj.get("version") != null && !jsonObj.get("version").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get("version").toString()));
      }
      if (jsonObj.get("image_name") != null && !jsonObj.get("image_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_name").toString()));
      }
      if (jsonObj.get("resource_class") != null && !jsonObj.get("resource_class").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `resource_class` to be a primitive type in the JSON string but got `%s`", jsonObj.get("resource_class").toString()));
      }
      if (jsonObj.get("exec") != null && !jsonObj.get("exec").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `exec` to be a primitive type in the JSON string but got `%s`", jsonObj.get("exec").toString()));
      }
      if (jsonObj.get("exec_raw") != null && !jsonObj.get("exec_raw").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `exec_raw` to be a primitive type in the JSON string but got `%s`", jsonObj.get("exec_raw").toString()));
      }
      if (jsonObj.get("task_name") != null && !jsonObj.get("task_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `task_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("task_name").toString()));
      }
      if (jsonObj.get("argument") != null && !jsonObj.get("argument").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `argument` to be a primitive type in the JSON string but got `%s`", jsonObj.get("argument").toString()));
      }
      JsonArray jsonArrayargumentsJson = jsonObj.getAsJsonArray("arguments_json");
      if (jsonArrayargumentsJson != null) {
        // ensure the json data is an array
        if (!jsonObj.get("arguments_json").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `arguments_json` to be an array in the JSON string but got `%s`", jsonObj.get("arguments_json").toString()));
        }

        // validate the optional field `arguments_json` (array)
        for (int i = 0; i < jsonArrayargumentsJson.size(); i++) {
          TGUDFArgument.validateJsonObject(jsonArrayargumentsJson.get(i).getAsJsonObject());
        };
      }
      // ensure the json data is an array
      if (jsonObj.get("stored_param_uuids") != null && !jsonObj.get("stored_param_uuids").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `stored_param_uuids` to be an array in the JSON string but got `%s`", jsonObj.get("stored_param_uuids").toString()));
      }
      // validate the optional field `ranges`
      if (jsonObj.getAsJsonObject("ranges") != null) {
        QueryRanges.validateJsonObject(jsonObj.getAsJsonObject("ranges"));
      }
      // validate the optional field `subarray`
      if (jsonObj.getAsJsonObject("subarray") != null) {
        UDFSubarray.validateJsonObject(jsonObj.getAsJsonObject("subarray"));
      }
      // ensure the json data is an array
      if (jsonObj.get("buffers") != null && !jsonObj.get("buffers").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `buffers` to be an array in the JSON string but got `%s`", jsonObj.get("buffers").toString()));
      }
      JsonArray jsonArrayarrays = jsonObj.getAsJsonArray("arrays");
      if (jsonArrayarrays != null) {
        // ensure the json data is an array
        if (!jsonObj.get("arrays").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `arrays` to be an array in the JSON string but got `%s`", jsonObj.get("arrays").toString()));
        }

        // validate the optional field `arrays` (array)
        for (int i = 0; i < jsonArrayarrays.size(); i++) {
          UDFArrayDetails.validateJsonObject(jsonArrayarrays.get(i).getAsJsonObject());
        };
      }
      if (jsonObj.get("task_graph_uuid") != null && !jsonObj.get("task_graph_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `task_graph_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("task_graph_uuid").toString()));
      }
      if (jsonObj.get("client_node_uuid") != null && !jsonObj.get("client_node_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `client_node_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("client_node_uuid").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!MultiArrayUDF.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'MultiArrayUDF' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<MultiArrayUDF> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(MultiArrayUDF.class));

       return (TypeAdapter<T>) new TypeAdapter<MultiArrayUDF>() {
           @Override
           public void write(JsonWriter out, MultiArrayUDF value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public MultiArrayUDF read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of MultiArrayUDF given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of MultiArrayUDF
  * @throws IOException if the JSON string is invalid with respect to MultiArrayUDF
  */
  public static MultiArrayUDF fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, MultiArrayUDF.class);
  }

 /**
  * Convert an instance of MultiArrayUDF to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

