/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Organization
 */
@ApiModel(description = "Organization")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class Organization {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_ROLE = "role";
  @SerializedName(SERIALIZED_NAME_ROLE)
  private OrganizationRoles role;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public static final String SERIALIZED_NAME_LOGO = "logo";
  @SerializedName(SERIALIZED_NAME_LOGO)
  private String logo;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_USERS = "users";
  @SerializedName(SERIALIZED_NAME_USERS)
  private List<OrganizationUser> users = null;

  public static final String SERIALIZED_NAME_ALLOWED_ACTIONS = "allowed_actions";
  @SerializedName(SERIALIZED_NAME_ALLOWED_ACTIONS)
  private List<NamespaceActions> allowedActions = null;

  public static final String SERIALIZED_NAME_NUM_OF_ARRAYS = "num_of_arrays";
  @SerializedName(SERIALIZED_NAME_NUM_OF_ARRAYS)
  private BigDecimal numOfArrays;

  public static final String SERIALIZED_NAME_ENABLED_FEATURES = "enabled_features";
  @SerializedName(SERIALIZED_NAME_ENABLED_FEATURES)
  private List<String> enabledFeatures = null;

  public static final String SERIALIZED_NAME_UNPAID_SUBSCRIPTION = "unpaid_subscription";
  @SerializedName(SERIALIZED_NAME_UNPAID_SUBSCRIPTION)
  private Boolean unpaidSubscription;

  public static final String SERIALIZED_NAME_DEFAULT_S3_PATH = "default_s3_path";
  @SerializedName(SERIALIZED_NAME_DEFAULT_S3_PATH)
  private String defaultS3Path;

  public static final String SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME = "default_s3_path_credentials_name";
  @SerializedName(SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME)
  private String defaultS3PathCredentialsName;

  public static final String SERIALIZED_NAME_STRIPE_CONNECT = "stripe_connect";
  @SerializedName(SERIALIZED_NAME_STRIPE_CONNECT)
  private Boolean stripeConnect;

  public Organization() { 
  }

  
  public Organization(
     List<String> enabledFeatures, 
     Boolean unpaidSubscription, 
     Boolean stripeConnect
  ) {
    this();
    this.enabledFeatures = enabledFeatures;
    this.unpaidSubscription = unpaidSubscription;
    this.stripeConnect = stripeConnect;
  }

  public Organization id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * unique ID of organization
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "00000000-0000-0000-0000-000000000000", value = "unique ID of organization")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public Organization role(OrganizationRoles role) {
    
    this.role = role;
    return this;
  }

   /**
   * Get role
   * @return role
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public OrganizationRoles getRole() {
    return role;
  }


  public void setRole(OrganizationRoles role) {
    this.role = role;
  }


  public Organization name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * organization name must be unique
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "organization name must be unique")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public Organization createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Datetime organization was created in UTC
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Datetime organization was created in UTC")

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Organization updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Datetime organization was updated in UTC
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Datetime organization was updated in UTC")

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public Organization logo(String logo) {
    
    this.logo = logo;
    return this;
  }

   /**
   * Organization logo
   * @return logo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Organization logo")

  public String getLogo() {
    return logo;
  }


  public void setLogo(String logo) {
    this.logo = logo;
  }


  public Organization description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Organization description
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Organization description")

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public Organization users(List<OrganizationUser> users) {
    
    this.users = users;
    return this;
  }

  public Organization addUsersItem(OrganizationUser usersItem) {
    if (this.users == null) {
      this.users = new ArrayList<>();
    }
    this.users.add(usersItem);
    return this;
  }

   /**
   * Get users
   * @return users
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<OrganizationUser> getUsers() {
    return users;
  }


  public void setUsers(List<OrganizationUser> users) {
    this.users = users;
  }


  public Organization allowedActions(List<NamespaceActions> allowedActions) {
    
    this.allowedActions = allowedActions;
    return this;
  }

  public Organization addAllowedActionsItem(NamespaceActions allowedActionsItem) {
    if (this.allowedActions == null) {
      this.allowedActions = new ArrayList<>();
    }
    this.allowedActions.add(allowedActionsItem);
    return this;
  }

   /**
   * list of actions user is allowed to do on this organization
   * @return allowedActions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "list of actions user is allowed to do on this organization")

  public List<NamespaceActions> getAllowedActions() {
    return allowedActions;
  }


  public void setAllowedActions(List<NamespaceActions> allowedActions) {
    this.allowedActions = allowedActions;
  }


  public Organization numOfArrays(BigDecimal numOfArrays) {
    
    this.numOfArrays = numOfArrays;
    return this;
  }

   /**
   * number of registered arrays for this organization
   * @return numOfArrays
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "number of registered arrays for this organization")

  public BigDecimal getNumOfArrays() {
    return numOfArrays;
  }


  public void setNumOfArrays(BigDecimal numOfArrays) {
    this.numOfArrays = numOfArrays;
  }


   /**
   * List of extra/optional/beta features to enable for namespace
   * @return enabledFeatures
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of extra/optional/beta features to enable for namespace")

  public List<String> getEnabledFeatures() {
    return enabledFeatures;
  }




   /**
   * A notice that the user has an unpaid subscription
   * @return unpaidSubscription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A notice that the user has an unpaid subscription")

  public Boolean getUnpaidSubscription() {
    return unpaidSubscription;
  }




  public Organization defaultS3Path(String defaultS3Path) {
    
    this.defaultS3Path = defaultS3Path;
    return this;
  }

   /**
   * default S3 path to store newly created notebooks
   * @return defaultS3Path
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "default S3 path to store newly created notebooks")

  public String getDefaultS3Path() {
    return defaultS3Path;
  }


  public void setDefaultS3Path(String defaultS3Path) {
    this.defaultS3Path = defaultS3Path;
  }


  public Organization defaultS3PathCredentialsName(String defaultS3PathCredentialsName) {
    
    this.defaultS3PathCredentialsName = defaultS3PathCredentialsName;
    return this;
  }

   /**
   * Default S3 path credentials name is the credentials name to use along with default_s3_path
   * @return defaultS3PathCredentialsName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Default S3 path credentials name is the credentials name to use along with default_s3_path")

  public String getDefaultS3PathCredentialsName() {
    return defaultS3PathCredentialsName;
  }


  public void setDefaultS3PathCredentialsName(String defaultS3PathCredentialsName) {
    this.defaultS3PathCredentialsName = defaultS3PathCredentialsName;
  }


   /**
   * Denotes that the organization is able to apply pricing to arrays by means of Stripe Connect
   * @return stripeConnect
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Denotes that the organization is able to apply pricing to arrays by means of Stripe Connect")

  public Boolean getStripeConnect() {
    return stripeConnect;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Organization organization = (Organization) o;
    return Objects.equals(this.id, organization.id) &&
        Objects.equals(this.role, organization.role) &&
        Objects.equals(this.name, organization.name) &&
        Objects.equals(this.createdAt, organization.createdAt) &&
        Objects.equals(this.updatedAt, organization.updatedAt) &&
        Objects.equals(this.logo, organization.logo) &&
        Objects.equals(this.description, organization.description) &&
        Objects.equals(this.users, organization.users) &&
        Objects.equals(this.allowedActions, organization.allowedActions) &&
        Objects.equals(this.numOfArrays, organization.numOfArrays) &&
        Objects.equals(this.enabledFeatures, organization.enabledFeatures) &&
        Objects.equals(this.unpaidSubscription, organization.unpaidSubscription) &&
        Objects.equals(this.defaultS3Path, organization.defaultS3Path) &&
        Objects.equals(this.defaultS3PathCredentialsName, organization.defaultS3PathCredentialsName) &&
        Objects.equals(this.stripeConnect, organization.stripeConnect);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, role, name, createdAt, updatedAt, logo, description, users, allowedActions, numOfArrays, enabledFeatures, unpaidSubscription, defaultS3Path, defaultS3PathCredentialsName, stripeConnect);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Organization {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    role: ").append(toIndentedString(role)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    users: ").append(toIndentedString(users)).append("\n");
    sb.append("    allowedActions: ").append(toIndentedString(allowedActions)).append("\n");
    sb.append("    numOfArrays: ").append(toIndentedString(numOfArrays)).append("\n");
    sb.append("    enabledFeatures: ").append(toIndentedString(enabledFeatures)).append("\n");
    sb.append("    unpaidSubscription: ").append(toIndentedString(unpaidSubscription)).append("\n");
    sb.append("    defaultS3Path: ").append(toIndentedString(defaultS3Path)).append("\n");
    sb.append("    defaultS3PathCredentialsName: ").append(toIndentedString(defaultS3PathCredentialsName)).append("\n");
    sb.append("    stripeConnect: ").append(toIndentedString(stripeConnect)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("role");
    openapiFields.add("name");
    openapiFields.add("created_at");
    openapiFields.add("updated_at");
    openapiFields.add("logo");
    openapiFields.add("description");
    openapiFields.add("users");
    openapiFields.add("allowed_actions");
    openapiFields.add("num_of_arrays");
    openapiFields.add("enabled_features");
    openapiFields.add("unpaid_subscription");
    openapiFields.add("default_s3_path");
    openapiFields.add("default_s3_path_credentials_name");
    openapiFields.add("stripe_connect");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("name");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Organization
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Organization.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Organization is not found in the empty JSON string", Organization.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!Organization.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Organization` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Organization.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (jsonObj.get("logo") != null && !jsonObj.get("logo").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `logo` to be a primitive type in the JSON string but got `%s`", jsonObj.get("logo").toString()));
      }
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      JsonArray jsonArrayusers = jsonObj.getAsJsonArray("users");
      if (jsonArrayusers != null) {
        // ensure the json data is an array
        if (!jsonObj.get("users").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `users` to be an array in the JSON string but got `%s`", jsonObj.get("users").toString()));
        }

        // validate the optional field `users` (array)
        for (int i = 0; i < jsonArrayusers.size(); i++) {
          OrganizationUser.validateJsonObject(jsonArrayusers.get(i).getAsJsonObject());
        };
      }
      // ensure the json data is an array
      if (jsonObj.get("allowed_actions") != null && !jsonObj.get("allowed_actions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `allowed_actions` to be an array in the JSON string but got `%s`", jsonObj.get("allowed_actions").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("enabled_features") != null && !jsonObj.get("enabled_features").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `enabled_features` to be an array in the JSON string but got `%s`", jsonObj.get("enabled_features").toString()));
      }
      if (jsonObj.get("default_s3_path") != null && !jsonObj.get("default_s3_path").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `default_s3_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get("default_s3_path").toString()));
      }
      if (jsonObj.get("default_s3_path_credentials_name") != null && !jsonObj.get("default_s3_path_credentials_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `default_s3_path_credentials_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("default_s3_path_credentials_name").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Organization.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Organization' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Organization> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Organization.class));

       return (TypeAdapter<T>) new TypeAdapter<Organization>() {
           @Override
           public void write(JsonWriter out, Organization value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Organization read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Organization given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Organization
  * @throws IOException if the JSON string is invalid with respect to Organization
  */
  public static Organization fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Organization.class);
  }

 /**
  * Convert an instance of Organization to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

