/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * A node specifying an SQL query to execute in TileDB Cloud. 
 */
@ApiModel(description = "A node specifying an SQL query to execute in TileDB Cloud. ")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class TGSQLNodeData {
  public static final String SERIALIZED_NAME_INIT_COMMANDS = "init_commands";
  @SerializedName(SERIALIZED_NAME_INIT_COMMANDS)
  private List<String> initCommands = null;

  public static final String SERIALIZED_NAME_QUERY = "query";
  @SerializedName(SERIALIZED_NAME_QUERY)
  private String query;

  public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
  @SerializedName(SERIALIZED_NAME_PARAMETERS)
  private List<Object> parameters = null;

  public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
  @SerializedName(SERIALIZED_NAME_RESULT_FORMAT)
  private ResultFormat resultFormat;

  public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
  @SerializedName(SERIALIZED_NAME_NAMESPACE)
  private String namespace;

  public TGSQLNodeData() { 
  }

  public TGSQLNodeData initCommands(List<String> initCommands) {
    
    this.initCommands = initCommands;
    return this;
  }

  public TGSQLNodeData addInitCommandsItem(String initCommandsItem) {
    if (this.initCommands == null) {
      this.initCommands = new ArrayList<>();
    }
    this.initCommands.add(initCommandsItem);
    return this;
  }

   /**
   * The commands to execute before running the query itself.
   * @return initCommands
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The commands to execute before running the query itself.")

  public List<String> getInitCommands() {
    return initCommands;
  }


  public void setInitCommands(List<String> initCommands) {
    this.initCommands = initCommands;
  }


  public TGSQLNodeData query(String query) {
    
    this.query = query;
    return this;
  }

   /**
   * The text of the SQL query to execute. Parameters are substituted in for &#x60;?&#x60;s, just as in a regular MariaDB query. 
   * @return query
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The text of the SQL query to execute. Parameters are substituted in for `?`s, just as in a regular MariaDB query. ")

  public String getQuery() {
    return query;
  }


  public void setQuery(String query) {
    this.query = query;
  }


  public TGSQLNodeData parameters(List<Object> parameters) {
    
    this.parameters = parameters;
    return this;
  }

  public TGSQLNodeData addParametersItem(Object parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

   /**
   * The parameters to substitute in for arguments in the &#x60;query&#x60;. Fixed-length. Arguments must be in JSON format. 
   * @return parameters
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The parameters to substitute in for arguments in the `query`. Fixed-length. Arguments must be in JSON format. ")

  public List<Object> getParameters() {
    return parameters;
  }


  public void setParameters(List<Object> parameters) {
    this.parameters = parameters;
  }


  public TGSQLNodeData resultFormat(ResultFormat resultFormat) {
    
    this.resultFormat = resultFormat;
    return this;
  }

   /**
   * Get resultFormat
   * @return resultFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ResultFormat getResultFormat() {
    return resultFormat;
  }


  public void setResultFormat(ResultFormat resultFormat) {
    this.resultFormat = resultFormat;
  }


  public TGSQLNodeData namespace(String namespace) {
    
    this.namespace = namespace;
    return this;
  }

   /**
   * If set, the non-default namespace to execute this SQL query under. 
   * @return namespace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the non-default namespace to execute this SQL query under. ")

  public String getNamespace() {
    return namespace;
  }


  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TGSQLNodeData tgSQLNodeData = (TGSQLNodeData) o;
    return Objects.equals(this.initCommands, tgSQLNodeData.initCommands) &&
        Objects.equals(this.query, tgSQLNodeData.query) &&
        Objects.equals(this.parameters, tgSQLNodeData.parameters) &&
        Objects.equals(this.resultFormat, tgSQLNodeData.resultFormat) &&
        Objects.equals(this.namespace, tgSQLNodeData.namespace);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(initCommands, query, parameters, resultFormat, namespace);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TGSQLNodeData {\n");
    sb.append("    initCommands: ").append(toIndentedString(initCommands)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    resultFormat: ").append(toIndentedString(resultFormat)).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("init_commands");
    openapiFields.add("query");
    openapiFields.add("parameters");
    openapiFields.add("result_format");
    openapiFields.add("namespace");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TGSQLNodeData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TGSQLNodeData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TGSQLNodeData is not found in the empty JSON string", TGSQLNodeData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!TGSQLNodeData.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TGSQLNodeData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      // ensure the json data is an array
      if (jsonObj.get("init_commands") != null && !jsonObj.get("init_commands").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `init_commands` to be an array in the JSON string but got `%s`", jsonObj.get("init_commands").toString()));
      }
      if (jsonObj.get("query") != null && !jsonObj.get("query").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `query` to be a primitive type in the JSON string but got `%s`", jsonObj.get("query").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("parameters") != null && !jsonObj.get("parameters").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `parameters` to be an array in the JSON string but got `%s`", jsonObj.get("parameters").toString()));
      }
      if (jsonObj.get("namespace") != null && !jsonObj.get("namespace").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get("namespace").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TGSQLNodeData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TGSQLNodeData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TGSQLNodeData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TGSQLNodeData.class));

       return (TypeAdapter<T>) new TypeAdapter<TGSQLNodeData>() {
           @Override
           public void write(JsonWriter out, TGSQLNodeData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TGSQLNodeData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TGSQLNodeData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TGSQLNodeData
  * @throws IOException if the JSON string is invalid with respect to TGSQLNodeData
  */
  public static TGSQLNodeData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TGSQLNodeData.class);
  }

 /**
  * Convert an instance of TGSQLNodeData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

