/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Response data for a task graph list, including pagination metadata.
 */
@ApiModel(description = "Response data for a task graph list, including pagination metadata.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class TaskGraphLogsData {
  public static final String SERIALIZED_NAME_TASK_GRAPH_LOGS = "task_graph_logs";
  @SerializedName(SERIALIZED_NAME_TASK_GRAPH_LOGS)
  private List<TaskGraphLog> taskGraphLogs = null;

  public static final String SERIALIZED_NAME_PAGINATION_METADATA = "pagination_metadata";
  @SerializedName(SERIALIZED_NAME_PAGINATION_METADATA)
  private PaginationMetadata paginationMetadata;

  public TaskGraphLogsData() { 
  }

  public TaskGraphLogsData taskGraphLogs(List<TaskGraphLog> taskGraphLogs) {
    
    this.taskGraphLogs = taskGraphLogs;
    return this;
  }

  public TaskGraphLogsData addTaskGraphLogsItem(TaskGraphLog taskGraphLogsItem) {
    if (this.taskGraphLogs == null) {
      this.taskGraphLogs = new ArrayList<>();
    }
    this.taskGraphLogs.add(taskGraphLogsItem);
    return this;
  }

   /**
   * The requested task graph logs.
   * @return taskGraphLogs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The requested task graph logs.")

  public List<TaskGraphLog> getTaskGraphLogs() {
    return taskGraphLogs;
  }


  public void setTaskGraphLogs(List<TaskGraphLog> taskGraphLogs) {
    this.taskGraphLogs = taskGraphLogs;
  }


  public TaskGraphLogsData paginationMetadata(PaginationMetadata paginationMetadata) {
    
    this.paginationMetadata = paginationMetadata;
    return this;
  }

   /**
   * Get paginationMetadata
   * @return paginationMetadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public PaginationMetadata getPaginationMetadata() {
    return paginationMetadata;
  }


  public void setPaginationMetadata(PaginationMetadata paginationMetadata) {
    this.paginationMetadata = paginationMetadata;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaskGraphLogsData taskGraphLogsData = (TaskGraphLogsData) o;
    return Objects.equals(this.taskGraphLogs, taskGraphLogsData.taskGraphLogs) &&
        Objects.equals(this.paginationMetadata, taskGraphLogsData.paginationMetadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taskGraphLogs, paginationMetadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaskGraphLogsData {\n");
    sb.append("    taskGraphLogs: ").append(toIndentedString(taskGraphLogs)).append("\n");
    sb.append("    paginationMetadata: ").append(toIndentedString(paginationMetadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("task_graph_logs");
    openapiFields.add("pagination_metadata");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TaskGraphLogsData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TaskGraphLogsData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TaskGraphLogsData is not found in the empty JSON string", TaskGraphLogsData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!TaskGraphLogsData.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TaskGraphLogsData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      JsonArray jsonArraytaskGraphLogs = jsonObj.getAsJsonArray("task_graph_logs");
      if (jsonArraytaskGraphLogs != null) {
        // ensure the json data is an array
        if (!jsonObj.get("task_graph_logs").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `task_graph_logs` to be an array in the JSON string but got `%s`", jsonObj.get("task_graph_logs").toString()));
        }

        // validate the optional field `task_graph_logs` (array)
        for (int i = 0; i < jsonArraytaskGraphLogs.size(); i++) {
          TaskGraphLog.validateJsonObject(jsonArraytaskGraphLogs.get(i).getAsJsonObject());
        };
      }
      // validate the optional field `pagination_metadata`
      if (jsonObj.getAsJsonObject("pagination_metadata") != null) {
        PaginationMetadata.validateJsonObject(jsonObj.getAsJsonObject("pagination_metadata"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TaskGraphLogsData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TaskGraphLogsData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TaskGraphLogsData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TaskGraphLogsData.class));

       return (TypeAdapter<T>) new TypeAdapter<TaskGraphLogsData>() {
           @Override
           public void write(JsonWriter out, TaskGraphLogsData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TaskGraphLogsData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TaskGraphLogsData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TaskGraphLogsData
  * @throws IOException if the JSON string is invalid with respect to TaskGraphLogsData
  */
  public static TaskGraphLogsData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TaskGraphLogsData.class);
  }

 /**
  * Convert an instance of TaskGraphLogsData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

