/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

import io.tiledb.cloud.rest_api.JSON;

/**
 * A request from a user for an api token
 */
@ApiModel(description = "A request from a user for an api token")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class TokenRequest {
  public static final String SERIALIZED_NAME_EXPIRES = "expires";
  @SerializedName(SERIALIZED_NAME_EXPIRES)
  private OffsetDateTime expires;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_SCOPE = "scope";
  @SerializedName(SERIALIZED_NAME_SCOPE)
  private String scope = "*";

  public TokenRequest() { 
  }

  public TokenRequest expires(OffsetDateTime expires) {
    
    this.expires = expires;
    return this;
  }

   /**
   * Expiration date for token, if empty token defaults to 30 minutes
   * @return expires
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2018-12-31T12:13:14Z", value = "Expiration date for token, if empty token defaults to 30 minutes")

  public OffsetDateTime getExpires() {
    return expires;
  }


  public void setExpires(OffsetDateTime expires) {
    this.expires = expires;
  }


  public TokenRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Optional name for token, if the name already exists for the user it will be auto incremented (i.e. myToken-1)
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "myToken", value = "Optional name for token, if the name already exists for the user it will be auto incremented (i.e. myToken-1)")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public TokenRequest scope(String scope) {
    
    this.scope = scope;
    return this;
  }

   /**
   * Optional scope to limit token, defaults to all permissions, current supported values are password_reset or *
   * @return scope
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "*", value = "Optional scope to limit token, defaults to all permissions, current supported values are password_reset or *")

  public String getScope() {
    return scope;
  }


  public void setScope(String scope) {
    this.scope = scope;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TokenRequest tokenRequest = (TokenRequest) o;
    return Objects.equals(this.expires, tokenRequest.expires) &&
        Objects.equals(this.name, tokenRequest.name) &&
        Objects.equals(this.scope, tokenRequest.scope);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expires, name, scope);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TokenRequest {\n");
    sb.append("    expires: ").append(toIndentedString(expires)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("expires");
    openapiFields.add("name");
    openapiFields.add("scope");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TokenRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TokenRequest.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TokenRequest is not found in the empty JSON string", TokenRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!TokenRequest.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TokenRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (jsonObj.get("scope") != null && !jsonObj.get("scope").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get("scope").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TokenRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TokenRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TokenRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TokenRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<TokenRequest>() {
           @Override
           public void write(JsonWriter out, TokenRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TokenRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TokenRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TokenRequest
  * @throws IOException if the JSON string is invalid with respect to TokenRequest
  */
  public static TokenRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TokenRequest.class);
  }

 /**
  * Convert an instance of TokenRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

