/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * User
 */
@ApiModel(description = "User")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class User {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_USERNAME = "username";
  @SerializedName(SERIALIZED_NAME_USERNAME)
  private String username;

  public static final String SERIALIZED_NAME_PASSWORD = "password";
  @SerializedName(SERIALIZED_NAME_PASSWORD)
  private String password;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_EMAIL = "email";
  @SerializedName(SERIALIZED_NAME_EMAIL)
  private String email;

  public static final String SERIALIZED_NAME_IS_VALID_EMAIL = "is_valid_email";
  @SerializedName(SERIALIZED_NAME_IS_VALID_EMAIL)
  private Boolean isValidEmail;

  public static final String SERIALIZED_NAME_STRIPE_CONNECT = "stripe_connect";
  @SerializedName(SERIALIZED_NAME_STRIPE_CONNECT)
  private Boolean stripeConnect;

  public static final String SERIALIZED_NAME_COMPANY = "company";
  @SerializedName(SERIALIZED_NAME_COMPANY)
  private String company;

  public static final String SERIALIZED_NAME_LOGO = "logo";
  @SerializedName(SERIALIZED_NAME_LOGO)
  private String logo;

  public static final String SERIALIZED_NAME_LAST_ACTIVITY_DATE = "last_activity_date";
  @SerializedName(SERIALIZED_NAME_LAST_ACTIVITY_DATE)
  private OffsetDateTime lastActivityDate;

  public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
  @SerializedName(SERIALIZED_NAME_TIMEZONE)
  private String timezone;

  public static final String SERIALIZED_NAME_ORGANIZATIONS = "organizations";
  @SerializedName(SERIALIZED_NAME_ORGANIZATIONS)
  private List<OrganizationUser> organizations = null;

  public static final String SERIALIZED_NAME_ALLOWED_ACTIONS = "allowed_actions";
  @SerializedName(SERIALIZED_NAME_ALLOWED_ACTIONS)
  private List<NamespaceActions> allowedActions = null;

  public static final String SERIALIZED_NAME_ENABLED_FEATURES = "enabled_features";
  @SerializedName(SERIALIZED_NAME_ENABLED_FEATURES)
  private List<String> enabledFeatures = null;

  public static final String SERIALIZED_NAME_UNPAID_SUBSCRIPTION = "unpaid_subscription";
  @SerializedName(SERIALIZED_NAME_UNPAID_SUBSCRIPTION)
  private Boolean unpaidSubscription;

  public static final String SERIALIZED_NAME_DEFAULT_S3_PATH = "default_s3_path";
  @SerializedName(SERIALIZED_NAME_DEFAULT_S3_PATH)
  private String defaultS3Path;

  public static final String SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME = "default_s3_path_credentials_name";
  @SerializedName(SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME)
  private String defaultS3PathCredentialsName;

  public static final String SERIALIZED_NAME_DEFAULT_NAMESPACE_CHARGED = "default_namespace_charged";
  @SerializedName(SERIALIZED_NAME_DEFAULT_NAMESPACE_CHARGED)
  private String defaultNamespaceCharged;

  public User() { 
  }

  
  public User(
     Boolean isValidEmail, 
     Boolean stripeConnect, 
     OffsetDateTime lastActivityDate, 
     List<OrganizationUser> organizations, 
     List<String> enabledFeatures, 
     Boolean unpaidSubscription
  ) {
    this();
    this.isValidEmail = isValidEmail;
    this.stripeConnect = stripeConnect;
    this.lastActivityDate = lastActivityDate;
    this.organizations = organizations;
    this.enabledFeatures = enabledFeatures;
    this.unpaidSubscription = unpaidSubscription;
  }

  public User id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * unique ID of user
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "00000000-0000-0000-0000-000000000000", value = "unique ID of user")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public User username(String username) {
    
    this.username = username;
    return this;
  }

   /**
   * username must be unique
   * @return username
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "username", required = true, value = "username must be unique")

  public String getUsername() {
    return username;
  }


  public void setUsername(String username) {
    this.username = username;
  }


  public User password(String password) {
    
    this.password = password;
    return this;
  }

   /**
   * password
   * @return password
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "password", value = "password")

  public String getPassword() {
    return password;
  }


  public void setPassword(String password) {
    this.password = password;
  }


  public User name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * the user&#39;s full, real name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Jane Doe", value = "the user's full, real name")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public User email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * the user&#39;s email
   * @return email
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "jane.doe@example.com", value = "the user's email")

  public String getEmail() {
    return email;
  }


  public void setEmail(String email) {
    this.email = email;
  }


   /**
   * user&#39;s email is validated to be correct
   * @return isValidEmail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "user's email is validated to be correct")

  public Boolean getIsValidEmail() {
    return isValidEmail;
  }




   /**
   * Denotes that the user is able to apply pricing to arrays by means of Stripe Connect
   * @return stripeConnect
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Denotes that the user is able to apply pricing to arrays by means of Stripe Connect")

  public Boolean getStripeConnect() {
    return stripeConnect;
  }




  public User company(String company) {
    
    this.company = company;
    return this;
  }

   /**
   * the user&#39;s company
   * @return company
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "TileDB", value = "the user's company")

  public String getCompany() {
    return company;
  }


  public void setCompany(String company) {
    this.company = company;
  }


  public User logo(String logo) {
    
    this.logo = logo;
    return this;
  }

   /**
   * the user&#39;s logo
   * @return logo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "the user's logo")

  public String getLogo() {
    return logo;
  }


  public void setLogo(String logo) {
    this.logo = logo;
  }


   /**
   * when the user last logged in (set by the server)
   * @return lastActivityDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "when the user last logged in (set by the server)")

  public OffsetDateTime getLastActivityDate() {
    return lastActivityDate;
  }




  public User timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Get timezone
   * @return timezone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Europe/Athens", value = "")

  public String getTimezone() {
    return timezone;
  }


  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


   /**
   * Array of organizations a user is part of and their roles
   * @return organizations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Array of organizations a user is part of and their roles")

  public List<OrganizationUser> getOrganizations() {
    return organizations;
  }




  public User allowedActions(List<NamespaceActions> allowedActions) {
    
    this.allowedActions = allowedActions;
    return this;
  }

  public User addAllowedActionsItem(NamespaceActions allowedActionsItem) {
    if (this.allowedActions == null) {
      this.allowedActions = new ArrayList<>();
    }
    this.allowedActions.add(allowedActionsItem);
    return this;
  }

   /**
   * list of actions user is allowed to do on this organization
   * @return allowedActions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "list of actions user is allowed to do on this organization")

  public List<NamespaceActions> getAllowedActions() {
    return allowedActions;
  }


  public void setAllowedActions(List<NamespaceActions> allowedActions) {
    this.allowedActions = allowedActions;
  }


   /**
   * List of extra/optional/beta features to enable for namespace
   * @return enabledFeatures
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of extra/optional/beta features to enable for namespace")

  public List<String> getEnabledFeatures() {
    return enabledFeatures;
  }




   /**
   * A notice that the user has an unpaid subscription
   * @return unpaidSubscription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A notice that the user has an unpaid subscription")

  public Boolean getUnpaidSubscription() {
    return unpaidSubscription;
  }




  public User defaultS3Path(String defaultS3Path) {
    
    this.defaultS3Path = defaultS3Path;
    return this;
  }

   /**
   * default S3 path to store newly created notebooks
   * @return defaultS3Path
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "default S3 path to store newly created notebooks")

  public String getDefaultS3Path() {
    return defaultS3Path;
  }


  public void setDefaultS3Path(String defaultS3Path) {
    this.defaultS3Path = defaultS3Path;
  }


  public User defaultS3PathCredentialsName(String defaultS3PathCredentialsName) {
    
    this.defaultS3PathCredentialsName = defaultS3PathCredentialsName;
    return this;
  }

   /**
   * Default S3 path credentials name is the credentials name to use along with default_s3_path
   * @return defaultS3PathCredentialsName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Default S3 path credentials name is the credentials name to use along with default_s3_path")

  public String getDefaultS3PathCredentialsName() {
    return defaultS3PathCredentialsName;
  }


  public void setDefaultS3PathCredentialsName(String defaultS3PathCredentialsName) {
    this.defaultS3PathCredentialsName = defaultS3PathCredentialsName;
  }


  public User defaultNamespaceCharged(String defaultNamespaceCharged) {
    
    this.defaultNamespaceCharged = defaultNamespaceCharged;
    return this;
  }

   /**
   * Override the default namespace charged for actions when no namespace is specified
   * @return defaultNamespaceCharged
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Override the default namespace charged for actions when no namespace is specified")

  public String getDefaultNamespaceCharged() {
    return defaultNamespaceCharged;
  }


  public void setDefaultNamespaceCharged(String defaultNamespaceCharged) {
    this.defaultNamespaceCharged = defaultNamespaceCharged;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    User user = (User) o;
    return Objects.equals(this.id, user.id) &&
        Objects.equals(this.username, user.username) &&
        Objects.equals(this.password, user.password) &&
        Objects.equals(this.name, user.name) &&
        Objects.equals(this.email, user.email) &&
        Objects.equals(this.isValidEmail, user.isValidEmail) &&
        Objects.equals(this.stripeConnect, user.stripeConnect) &&
        Objects.equals(this.company, user.company) &&
        Objects.equals(this.logo, user.logo) &&
        Objects.equals(this.lastActivityDate, user.lastActivityDate) &&
        Objects.equals(this.timezone, user.timezone) &&
        Objects.equals(this.organizations, user.organizations) &&
        Objects.equals(this.allowedActions, user.allowedActions) &&
        Objects.equals(this.enabledFeatures, user.enabledFeatures) &&
        Objects.equals(this.unpaidSubscription, user.unpaidSubscription) &&
        Objects.equals(this.defaultS3Path, user.defaultS3Path) &&
        Objects.equals(this.defaultS3PathCredentialsName, user.defaultS3PathCredentialsName) &&
        Objects.equals(this.defaultNamespaceCharged, user.defaultNamespaceCharged);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, username, password, name, email, isValidEmail, stripeConnect, company, logo, lastActivityDate, timezone, organizations, allowedActions, enabledFeatures, unpaidSubscription, defaultS3Path, defaultS3PathCredentialsName, defaultNamespaceCharged);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class User {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    isValidEmail: ").append(toIndentedString(isValidEmail)).append("\n");
    sb.append("    stripeConnect: ").append(toIndentedString(stripeConnect)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
    sb.append("    lastActivityDate: ").append(toIndentedString(lastActivityDate)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    organizations: ").append(toIndentedString(organizations)).append("\n");
    sb.append("    allowedActions: ").append(toIndentedString(allowedActions)).append("\n");
    sb.append("    enabledFeatures: ").append(toIndentedString(enabledFeatures)).append("\n");
    sb.append("    unpaidSubscription: ").append(toIndentedString(unpaidSubscription)).append("\n");
    sb.append("    defaultS3Path: ").append(toIndentedString(defaultS3Path)).append("\n");
    sb.append("    defaultS3PathCredentialsName: ").append(toIndentedString(defaultS3PathCredentialsName)).append("\n");
    sb.append("    defaultNamespaceCharged: ").append(toIndentedString(defaultNamespaceCharged)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("username");
    openapiFields.add("password");
    openapiFields.add("name");
    openapiFields.add("email");
    openapiFields.add("is_valid_email");
    openapiFields.add("stripe_connect");
    openapiFields.add("company");
    openapiFields.add("logo");
    openapiFields.add("last_activity_date");
    openapiFields.add("timezone");
    openapiFields.add("organizations");
    openapiFields.add("allowed_actions");
    openapiFields.add("enabled_features");
    openapiFields.add("unpaid_subscription");
    openapiFields.add("default_s3_path");
    openapiFields.add("default_s3_path_credentials_name");
    openapiFields.add("default_namespace_charged");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("username");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to User
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (User.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in User is not found in the empty JSON string", User.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!User.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `User` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : User.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (jsonObj.get("username") != null && !jsonObj.get("username").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get("username").toString()));
      }
      if (jsonObj.get("password") != null && !jsonObj.get("password").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get("password").toString()));
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (jsonObj.get("email") != null && !jsonObj.get("email").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get("email").toString()));
      }
      if (jsonObj.get("company") != null && !jsonObj.get("company").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `company` to be a primitive type in the JSON string but got `%s`", jsonObj.get("company").toString()));
      }
      if (jsonObj.get("logo") != null && !jsonObj.get("logo").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `logo` to be a primitive type in the JSON string but got `%s`", jsonObj.get("logo").toString()));
      }
      if (jsonObj.get("timezone") != null && !jsonObj.get("timezone").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `timezone` to be a primitive type in the JSON string but got `%s`", jsonObj.get("timezone").toString()));
      }
      JsonArray jsonArrayorganizations = jsonObj.getAsJsonArray("organizations");
      if (jsonArrayorganizations != null) {
        // ensure the json data is an array
        if (!jsonObj.get("organizations").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `organizations` to be an array in the JSON string but got `%s`", jsonObj.get("organizations").toString()));
        }

        // validate the optional field `organizations` (array)
        for (int i = 0; i < jsonArrayorganizations.size(); i++) {
          OrganizationUser.validateJsonObject(jsonArrayorganizations.get(i).getAsJsonObject());
        };
      }
      // ensure the json data is an array
      if (jsonObj.get("allowed_actions") != null && !jsonObj.get("allowed_actions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `allowed_actions` to be an array in the JSON string but got `%s`", jsonObj.get("allowed_actions").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("enabled_features") != null && !jsonObj.get("enabled_features").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `enabled_features` to be an array in the JSON string but got `%s`", jsonObj.get("enabled_features").toString()));
      }
      if (jsonObj.get("default_s3_path") != null && !jsonObj.get("default_s3_path").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `default_s3_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get("default_s3_path").toString()));
      }
      if (jsonObj.get("default_s3_path_credentials_name") != null && !jsonObj.get("default_s3_path_credentials_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `default_s3_path_credentials_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("default_s3_path_credentials_name").toString()));
      }
      if (jsonObj.get("default_namespace_charged") != null && !jsonObj.get("default_namespace_charged").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `default_namespace_charged` to be a primitive type in the JSON string but got `%s`", jsonObj.get("default_namespace_charged").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!User.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'User' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<User> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(User.class));

       return (TypeAdapter<T>) new TypeAdapter<User>() {
           @Override
           public void write(JsonWriter out, User value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public User read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of User given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of User
  * @throws IOException if the JSON string is invalid with respect to User
  */
  public static User fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, User.class);
  }

 /**
  * Convert an instance of User to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

