/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.ArraySchemaEvolution;
import io.tiledb.java.api.Config;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.Enumeration;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.TileDBObjectType;
import io.tiledb.java.api.Util;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_array_schema_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_array_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_config_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_enumeration_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_void;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_array_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_datatype_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_object_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.tiledb;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class Array
implements AutoCloseable {
    private Context ctx;
    private String uri;
    private ArraySchema schema;
    private Domain domain;
    private QueryType query_type;
    private SWIGTYPE_p_tiledb_array_t arrayp;
    private SWIGTYPE_p_p_tiledb_array_t arraypp;

    public Array(Context ctx, String uri) throws TileDBError {
        this(ctx, uri, QueryType.TILEDB_READ);
    }

    public Array(Context ctx, String uri, QueryType query_type, BigInteger timestamp_end) throws TileDBError {
        this.openArray(ctx, uri, query_type, null, timestamp_end);
    }

    public Array(Context ctx, String uri, QueryType query_type, BigInteger timestamp_start, BigInteger timestamp_end) throws TileDBError {
        this.openArray(ctx, uri, query_type, timestamp_start, timestamp_end);
    }

    public Array(Context ctx, String uri, QueryType query_type) throws TileDBError {
        this.openArray(ctx, uri, query_type, null, null);
    }

    private synchronized void openArray(Context ctx, String uri, QueryType query_type, BigInteger timestamp_start, BigInteger timestamp_end) throws TileDBError {
        SWIGTYPE_p_p_tiledb_array_t _arraypp = tiledb.new_tiledb_array_tpp();
        try {
            ctx.handleError(tiledb.tiledb_array_alloc(ctx.getCtxp(), uri, _arraypp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_tpp(_arraypp);
            throw err;
        }
        SWIGTYPE_p_tiledb_array_t _arrayp = tiledb.tiledb_array_tpp_value(_arraypp);
        if (timestamp_start != null) {
            Util.checkBigIntegerRange(timestamp_start);
            ctx.handleError(tiledb.tiledb_array_set_open_timestamp_start(ctx.getCtxp(), _arrayp, timestamp_start));
        }
        if (timestamp_end != null) {
            Util.checkBigIntegerRange(timestamp_end);
            ctx.handleError(tiledb.tiledb_array_set_open_timestamp_end(ctx.getCtxp(), _arrayp, timestamp_end));
        }
        try {
            ctx.handleError(tiledb.tiledb_array_open(ctx.getCtxp(), _arrayp, query_type.toSwigEnum()));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_tpp(_arraypp);
            throw err;
        }
        ArraySchema _schema = new ArraySchema(ctx, uri);
        this.ctx = ctx;
        this.uri = uri;
        this.query_type = query_type;
        this.schema = _schema;
        this.domain = this.schema.getDomain();
        this.arraypp = _arraypp;
        this.arrayp = _arrayp;
    }

    private void checkIsOpen() throws TileDBError {
        if (this.arrayp == null) {
            throw new TileDBError("TileDB Array " + this.uri + " is closed");
        }
    }

    public static void consolidate(Context ctx, String uri) throws TileDBError {
        Array.consolidate(ctx, uri, ctx.getConfig());
    }

    public static void consolidate(Context ctx, String uri, String[] fragURIs, int numFragments, Config config) throws TileDBError {
    }

    public static void consolidate(Context ctx, String uri, Config config) throws TileDBError {
        ctx.handleError(tiledb.tiledb_array_consolidate(ctx.getCtxp(), uri, config.getConfigp()));
    }

    public void evolve(Context ctx, ArraySchemaEvolution schemaEvolution) throws TileDBError {
        ctx.handleError(tiledb.tiledb_array_evolve(ctx.getCtxp(), this.uri, schemaEvolution.getEvolutionp()));
    }

    public void upgradeVersion(Context ctx, Config config) throws TileDBError {
        ctx.handleError(tiledb.tiledb_array_upgrade_version(ctx.getCtxp(), this.uri, config.getConfigp()));
    }

    public static void vacuum(Context ctx, String arrayURI) throws TileDBError {
        ctx.handleError(tiledb.tiledb_array_vacuum(ctx.getCtxp(), arrayURI, ctx.getConfig().getConfigp()));
    }

    public static void vacuum(Context ctx, String arrayURI, Config config) throws TileDBError {
        ctx.handleError(tiledb.tiledb_array_vacuum(ctx.getCtxp(), arrayURI, config.getConfigp()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(Context ctx, String uri) throws TileDBError {
        TileDBObjectType objtype;
        SWIGTYPE_p_tiledb_object_t objtypep = tiledb.new_tiledb_object_tp();
        try {
            ctx.handleError(tiledb.tiledb_object_type(ctx.getCtxp(), uri, objtypep));
            objtype = TileDBObjectType.fromSwigEnum(tiledb.tiledb_object_tp_value(objtypep));
        }
        finally {
            tiledb.delete_tiledb_object_tp(objtypep);
        }
        return objtype == TileDBObjectType.TILEDB_ARRAY;
    }

    public static void create(String uri, ArraySchema schema) throws TileDBError {
        Context ctx = schema.getCtx();
        ctx.handleError(tiledb.tiledb_array_schema_check(ctx.getCtxp(), schema.getSchemap()));
        ctx.handleError(tiledb.tiledb_array_create(ctx.getCtxp(), uri, schema.getSchemap()));
    }

    public void delete() throws TileDBError {
        this.close();
        this.ctx.handleError(tiledb.tiledb_array_delete(this.ctx.getCtxp(), this.uri));
    }

    public HashMap<String, Pair> nonEmptyDomain() throws TileDBError {
        this.checkIsOpen();
        HashMap<String, Pair> ret = new HashMap<String, Pair>();
        long numDims = this.domain.getNDim();
        for (long dimIdx = 0L; dimIdx < numDims; ++dimIdx) {
            Dimension dimension = this.domain.getDimension(dimIdx);
            Pair p = this.getNonEmptyDomainFromIndex(dimIdx);
            ret.put(dimension.getName(), p);
            dimension.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Pair getNonEmptyDomainFromIndex(long index) throws TileDBError {
        this.checkIsOpen();
        try (Dimension dim = this.domain.getDimension(index);){
            SWIGTYPE_p_int emptyp;
            NativeArray domainArray;
            block19: {
                block18: {
                    block17: {
                        domainArray = new NativeArray(this.ctx, 2, dim.getType());
                        try {
                            if (!dim.isVar()) break block17;
                            Pair<String, String> pair = this.getNonEmptyDomainVarFromIndex(index);
                            domainArray.close();
                            return pair;
                        }
                        catch (Throwable throwable) {
                            try {
                                domainArray.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    emptyp = tiledb.new_intp();
                    this.ctx.handleError(tiledb.tiledb_array_get_non_empty_domain_from_index(this.ctx.getCtxp(), this.arrayp, index, domainArray.toVoidPointer(), emptyp));
                    if (tiledb.intp_value(emptyp) != 1) break block18;
                    Pair pair = Pair.empty();
                    tiledb.delete_intp(emptyp);
                    domainArray.close();
                    return pair;
                }
                break block19;
                {
                    catch (Throwable throwable) {
                        tiledb.delete_intp(emptyp);
                        throw throwable;
                    }
                }
            }
            tiledb.delete_intp(emptyp);
            Pair<Object, Object> pair = new Pair<Object, Object>(domainArray.getItem(0), domainArray.getItem(1));
            domainArray.close();
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Pair getNonEmptyDomainFromName(String name) throws TileDBError {
        this.checkIsOpen();
        try (Dimension dim = this.domain.getDimension(name);){
            SWIGTYPE_p_int emptyp;
            NativeArray domainArray;
            block19: {
                block18: {
                    block17: {
                        domainArray = new NativeArray(this.ctx, 2, dim.getType());
                        try {
                            if (!dim.isVar()) break block17;
                            Pair<String, String> pair = this.getNonEmptyDomainVarFromName(name);
                            domainArray.close();
                            return pair;
                        }
                        catch (Throwable throwable) {
                            try {
                                domainArray.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    emptyp = tiledb.new_intp();
                    this.ctx.handleError(tiledb.tiledb_array_get_non_empty_domain_from_name(this.ctx.getCtxp(), this.arrayp, name, domainArray.toVoidPointer(), emptyp));
                    if (tiledb.intp_value(emptyp) != 1) break block18;
                    Pair pair = Pair.empty();
                    tiledb.delete_intp(emptyp);
                    domainArray.close();
                    return pair;
                }
                break block19;
                {
                    catch (Throwable throwable) {
                        tiledb.delete_intp(emptyp);
                        throw throwable;
                    }
                }
            }
            tiledb.delete_intp(emptyp);
            Pair<Object, Object> pair = new Pair<Object, Object>(domainArray.getItem(0), domainArray.getItem(1));
            domainArray.close();
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<BigInteger, BigInteger> getNonEmptyDomainVarSizeFromIndex(long index) throws TileDBError {
        SWIGTYPE_p_int emptyp = tiledb.new_intp();
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_get_non_empty_domain_var_size_from_index(this.ctx.getCtxp(), this.arrayp, index, startSize, endSize, emptyp));
            Pair<BigInteger, BigInteger> pair = new Pair<BigInteger, BigInteger>(tiledb.ullp_value(startSize), tiledb.ullp_value(endSize));
            return pair;
        }
        finally {
            tiledb.delete_ullp(startSize);
            tiledb.delete_ullp(endSize);
            tiledb.delete_intp(emptyp);
        }
    }

    public Enumeration getEnumeration(String name) throws TileDBError {
        Enumeration _enumeration;
        SWIGTYPE_p_p_tiledb_enumeration_t enumerationpp = tiledb.new_tiledb_enumeration_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_get_enumeration(this.ctx.getCtxp(), this.getArrayp(), name, enumerationpp));
            _enumeration = new Enumeration(this.ctx, enumerationpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_enumeration_tpp(enumerationpp);
            throw err;
        }
        return _enumeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<BigInteger, BigInteger> getNonEmptyDomainVarSizeFromName(String name) throws TileDBError {
        SWIGTYPE_p_int emptyp = tiledb.new_intp();
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_get_non_empty_domain_var_size_from_name(this.ctx.getCtxp(), this.arrayp, name, startSize, endSize, emptyp));
            Pair<BigInteger, BigInteger> pair = new Pair<BigInteger, BigInteger>(tiledb.ullp_value(startSize), tiledb.ullp_value(endSize));
            return pair;
        }
        finally {
            tiledb.delete_ullp(startSize);
            tiledb.delete_ullp(endSize);
            tiledb.delete_intp(emptyp);
        }
    }

    /*
     * Exception decompiling
     */
    public Pair<String, String> getNonEmptyDomainVarFromIndex(long index) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Pair<String, String> getNonEmptyDomainVarFromName(String name) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NativeArray getMetadata(String key) throws TileDBError {
        return this.getMetadata(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeArray getMetadata(String key, Datatype nativeType) throws TileDBError {
        this.checkIsOpen();
        SWIGTYPE_p_p_void resultArrpp = tiledb.new_voidpArray(0);
        SWIGTYPE_p_unsigned_int value_num = tiledb.new_uintp();
        SWIGTYPE_p_tiledb_datatype_t value_type = nativeType == null ? tiledb.new_tiledb_datatype_tp() : tiledb.copy_tiledb_datatype_tp(nativeType.toSwigEnum());
        try {
            NativeArray result;
            this.ctx.handleError(tiledb.tiledb_array_get_metadata(this.ctx.getCtxp(), this.arrayp, key, value_type, value_num, resultArrpp));
            Datatype derivedNativeType = Datatype.fromSwigEnum(tiledb.tiledb_datatype_tp_value(value_type));
            long value = tiledb.uintp_value(value_num);
            NativeArray nativeArray = result = new NativeArray(this.ctx, derivedNativeType, resultArrpp, (int)value);
            return nativeArray;
        }
        finally {
            tiledb.delete_uintp(value_num);
            tiledb.delete_tiledb_datatype_tp(value_type);
            tiledb.delete_voidpArray(resultArrpp);
        }
    }

    public void deleteMetadata(String key) throws TileDBError {
        this.checkIsOpen();
        this.ctx.handleError(tiledb.tiledb_array_delete_metadata(this.ctx.getCtxp(), this.arrayp, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getMetadataNum() throws TileDBError {
        this.checkIsOpen();
        SWIGTYPE_p_unsigned_long_long value_num = tiledb.new_ullp();
        try {
            BigInteger value;
            this.ctx.handleError(tiledb.tiledb_array_get_metadata_num(this.ctx.getCtxp(), this.arrayp, value_num));
            BigInteger bigInteger = value = tiledb.ullp_value(value_num);
            return bigInteger;
        }
        finally {
            tiledb.delete_ullp(value_num);
        }
    }

    public Pair<String, NativeArray> getMetadataFromIndex(long index) throws TileDBError {
        return this.getMetadataFromIndex(BigInteger.valueOf(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, NativeArray> getMetadataFromIndex(BigInteger index) throws TileDBError {
        this.checkIsOpen();
        Util.checkBigIntegerRange(index);
        SWIGTYPE_p_p_char key = tiledb.new_charpp();
        SWIGTYPE_p_unsigned_int key_len = tiledb.new_uintp();
        SWIGTYPE_p_tiledb_datatype_t value_type = tiledb.new_tiledb_datatype_tp();
        SWIGTYPE_p_unsigned_int value_num = tiledb.new_uintp();
        SWIGTYPE_p_p_void value = tiledb.new_voidpArray(0);
        try {
            this.ctx.handleError(tiledb.tiledb_array_get_metadata_from_index(this.ctx.getCtxp(), this.arrayp, index, key, key_len, value_type, value_num, value));
            String keyString = tiledb.charpp_value(key);
            long valueLength = tiledb.uintp_value(value_num);
            Datatype nativeType = Datatype.fromSwigEnum(tiledb.tiledb_datatype_tp_value(value_type));
            NativeArray result = new NativeArray(this.ctx, nativeType, value, (int)valueLength);
            Pair<String, NativeArray> pair = new Pair<String, NativeArray>(keyString, result);
            return pair;
        }
        finally {
            tiledb.delete_uintp(value_num);
            tiledb.delete_uintp(key_len);
            tiledb.delete_charpp(key);
            tiledb.delete_tiledb_datatype_tp(value_type);
            tiledb.delete_voidpArray(value);
        }
    }

    public void deleteFragments(BigInteger timestampStart, BigInteger timestampEnd) throws TileDBError {
        Util.checkBigIntegerRange(timestampStart);
        Util.checkBigIntegerRange(timestampEnd);
        this.ctx.handleError(tiledb.tiledb_array_delete_fragments(this.ctx.getCtxp(), this.getArrayp(), this.uri, timestampStart, timestampEnd));
    }

    public Map<String, Object> getMetadataMap() throws TileDBError {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < this.getMetadataNum().intValue(); ++i) {
            Pair<String, NativeArray> meta = this.getMetadataFromIndex(i);
            String key = meta.getFirst().toString();
            NativeArray value = meta.getSecond();
            if (value.getSize() == 1) {
                result.put(key, value.getItem(0));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hasMetadataKey(String key) throws TileDBError {
        this.checkIsOpen();
        SWIGTYPE_p_tiledb_datatype_t value_type = tiledb.new_tiledb_datatype_tp();
        SWIGTYPE_p_int has_key = tiledb.new_intp();
        try {
            Boolean result;
            this.ctx.handleError(tiledb.tiledb_array_has_metadata_key(this.ctx.getCtxp(), this.arrayp, key, value_type, has_key));
            Boolean bl = result = Boolean.valueOf(tiledb.intp_value(has_key) > 0);
            return bl;
        }
        finally {
            tiledb.delete_intp(has_key);
            tiledb.delete_tiledb_datatype_tp(value_type);
        }
    }

    public void putMetadata(String key, Object buffer) throws TileDBError {
        this.putMetadata(key, new NativeArray(this.ctx, buffer, buffer.getClass()));
    }

    public void putMetadata(String key, NativeArray value) throws TileDBError {
        this.checkIsOpen();
        this.ctx.handleError(tiledb.tiledb_array_put_metadata(this.ctx.getCtxp(), this.arrayp, key, value.getNativeType().toSwigEnum(), value.getSize(), value.toVoidPointer()));
    }

    public Context getCtx() {
        return this.ctx;
    }

    public String getUri() {
        return this.uri;
    }

    public ArraySchema getSchema() throws TileDBError {
        ArraySchema _schema;
        SWIGTYPE_p_p_tiledb_array_schema_t schemapp = tiledb.new_tiledb_array_schema_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_get_schema(this.ctx.getCtxp(), this.getArrayp(), schemapp));
            _schema = new ArraySchema(this.ctx, schemapp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_schema_tpp(schemapp);
            throw err;
        }
        return _schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOpenTimestampStart() throws TileDBError {
        SWIGTYPE_p_unsigned_long_long start_t = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_get_open_timestamp_start(this.ctx.getCtxp(), this.getArrayp(), start_t));
            long l = tiledb.ullp_value(start_t).longValue();
            return l;
        }
        finally {
            tiledb.delete_ullp(start_t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOpenTimestampEnd() throws TileDBError {
        SWIGTYPE_p_unsigned_long_long end_t = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_get_open_timestamp_end(this.ctx.getCtxp(), this.getArrayp(), end_t));
            long l = tiledb.ullp_value(end_t).longValue();
            return l;
        }
        finally {
            tiledb.delete_ullp(end_t);
        }
    }

    public void setConfig(Config config) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_set_config(this.ctx.getCtxp(), this.getArrayp(), config.getConfigp()));
    }

    public Config getConfig() throws TileDBError {
        SWIGTYPE_p_p_tiledb_config_t configpp = tiledb.new_tiledb_config_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_get_config(this.ctx.getCtxp(), this.getArrayp(), configpp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_config_tpp(configpp);
        }
        return new Config(configpp);
    }

    public void reopen() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_reopen(this.ctx.getCtxp(), this.getArrayp()));
    }

    public QueryType getQueryType() {
        return this.query_type;
    }

    protected SWIGTYPE_p_tiledb_array_t getArrayp() {
        return this.arrayp;
    }

    @Override
    public synchronized void close() {
        if (this.schema != null) {
            this.schema.close();
        }
        if (this.domain != null) {
            this.domain.close();
        }
        if (this.arrayp != null && this.arraypp != null) {
            tiledb.tiledb_array_close(this.ctx.getCtxp(), this.arrayp);
            tiledb.tiledb_array_free(this.arraypp);
            tiledb.delete_tiledb_array_tpp(this.arraypp);
            this.arrayp = null;
            this.arraypp = null;
        }
    }
}

