/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.TileDBError;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_config_iter_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_config_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_error_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_config_iter_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_config_t;
import io.tiledb.libtiledb.capi_return_t;
import io.tiledb.libtiledb.tiledb;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class Config
implements AutoCloseable {
    private SWIGTYPE_p_p_tiledb_config_t configpp;
    private SWIGTYPE_p_tiledb_config_t configp;

    protected Config(SWIGTYPE_p_p_tiledb_config_t configpp) {
        this.configpp = configpp;
        this.configp = tiledb.tiledb_config_tpp_value(configpp);
    }

    public Config() throws TileDBError {
        SWIGTYPE_p_p_tiledb_config_t _configpp = tiledb.new_tiledb_config_tpp();
        SWIGTYPE_p_p_tiledb_error_handle_t _errorpp = tiledb.new_tiledb_error_tpp();
        try {
            capi_return_t rc = tiledb.tiledb_config_alloc(_configpp, _errorpp);
            this.checkConfigError(rc, _errorpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_config_tpp(_configpp);
            tiledb.delete_tiledb_error_tpp(_errorpp);
            throw err;
        }
        tiledb.delete_tiledb_error_tpp(_errorpp);
        this.configpp = _configpp;
        this.configp = tiledb.tiledb_config_tpp_value(_configpp);
    }

    public Config(String filename) throws TileDBError {
        this.init(filename);
    }

    public Config(URI uri) throws TileDBError {
        String scheme = uri.getScheme();
        if (!scheme.equals("file")) {
            throw new TileDBError("Config can an only read from a local file scheme URI (file://), got: " + uri);
        }
        this.init(new File(uri).getAbsolutePath());
    }

    public Config(Map<String, String> config) throws TileDBError {
        this();
        for (Map.Entry<String, String> v : config.entrySet()) {
            this.set(v.getKey(), v.getValue());
        }
    }

    private void init(String filename) throws TileDBError {
        SWIGTYPE_p_p_tiledb_config_t _configpp = tiledb.new_tiledb_config_tpp();
        SWIGTYPE_p_p_tiledb_error_handle_t _errorpp = tiledb.new_tiledb_error_tpp();
        try {
            capi_return_t rc = tiledb.tiledb_config_alloc(_configpp, _errorpp);
            this.checkConfigError(rc, _errorpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_config_tpp(_configpp);
            tiledb.delete_tiledb_error_tpp(_errorpp);
            throw err;
        }
        SWIGTYPE_p_tiledb_config_t _configp = tiledb.tiledb_config_tpp_value(_configpp);
        try {
            capi_return_t rc = tiledb.tiledb_config_load_from_file(_configp, filename, _errorpp);
            this.checkConfigError(rc, _errorpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_config_tpp(_configpp);
            tiledb.delete_tiledb_error_tpp(_errorpp);
            throw err;
        }
        tiledb.delete_tiledb_error_tpp(_errorpp);
        this.configp = _configp;
        this.configpp = _configpp;
    }

    public String get(String parameter) throws TileDBError {
        SWIGTYPE_p_p_tiledb_error_handle_t errorpp = tiledb.new_tiledb_error_tpp();
        SWIGTYPE_p_p_char valuepp = tiledb.new_charpp();
        try {
            capi_return_t rc = tiledb.tiledb_config_get(this.configp, parameter, valuepp, errorpp);
            this.checkConfigError(rc, errorpp);
            tiledb.delete_tiledb_error_tpp(errorpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_error_tpp(errorpp);
            tiledb.delete_charpp(valuepp);
            throw err;
        }
        String value = tiledb.charpp_value(valuepp);
        tiledb.delete_charpp(valuepp);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String parameter, String value) throws TileDBError {
        SWIGTYPE_p_p_tiledb_error_handle_t errorpp = tiledb.new_tiledb_error_tpp();
        try {
            capi_return_t rc = tiledb.tiledb_config_set(this.configp, parameter, value, errorpp);
            this.checkConfigError(rc, errorpp);
        }
        finally {
            tiledb.delete_tiledb_error_tpp(errorpp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unset(String parameter) throws TileDBError {
        SWIGTYPE_p_p_tiledb_error_handle_t errorpp = tiledb.new_tiledb_error_tpp();
        try {
            capi_return_t rc = tiledb.tiledb_config_unset(this.configp, parameter, errorpp);
            this.checkConfigError(rc, errorpp);
        }
        finally {
            tiledb.delete_tiledb_error_tpp(errorpp);
        }
    }

    public HashMap<String, String> parameters() throws TileDBError {
        return this.parameters("");
    }

    public HashMap<String, String> parameters(String prefix) throws TileDBError {
        HashMap<String, String> result = new HashMap<String, String>();
        SWIGTYPE_p_p_tiledb_config_iter_handle_t iterpp = tiledb.new_tiledb_config_iter_tpp();
        SWIGTYPE_p_p_tiledb_error_handle_t errorpp = tiledb.new_tiledb_error_tpp();
        try {
            capi_return_t rc = tiledb.tiledb_config_iter_alloc(this.configp, prefix, iterpp, errorpp);
            this.checkConfigError(rc, errorpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_config_iter_tpp(iterpp);
            tiledb.delete_tiledb_error_tpp(errorpp);
            throw err;
        }
        SWIGTYPE_p_tiledb_config_iter_handle_t iterp = tiledb.tiledb_config_iter_tpp_value(iterpp);
        while (this.hasMoreParams(iterp)) {
            errorpp = tiledb.new_tiledb_error_tpp();
            SWIGTYPE_p_p_char parampp = tiledb.new_charpp();
            SWIGTYPE_p_p_char valuepp = tiledb.new_charpp();
            try {
                capi_return_t rc = tiledb.tiledb_config_iter_here(iterp, parampp, valuepp, errorpp);
                this.checkConfigError(rc, errorpp);
            }
            catch (TileDBError err) {
                tiledb.delete_charpp(parampp);
                tiledb.delete_charpp(valuepp);
                tiledb.delete_tiledb_error_tpp(errorpp);
                tiledb.delete_tiledb_config_iter_tpp(iterpp);
                throw err;
            }
            result.put(tiledb.charpp_value(parampp), tiledb.charpp_value(valuepp));
            this.next(iterp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(String filename) throws TileDBError {
        SWIGTYPE_p_p_tiledb_error_handle_t errorpp = tiledb.new_tiledb_error_tpp();
        try {
            capi_return_t rc = tiledb.tiledb_config_save_to_file(this.configp, filename, errorpp);
            this.checkConfigError(rc, errorpp);
        }
        finally {
            tiledb.delete_tiledb_error_tpp(errorpp);
        }
    }

    public void saveToFile(URI uri) throws TileDBError {
        String scheme = uri.getScheme();
        if (!scheme.equals("file")) {
            throw new TileDBError("Config can an only save to a local file scheme URI (file://), got: " + uri);
        }
        this.saveToFile(new File(uri).getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void next(SWIGTYPE_p_tiledb_config_iter_handle_t iterp) throws TileDBError {
        SWIGTYPE_p_p_tiledb_error_handle_t errorpp = tiledb.new_tiledb_error_tpp();
        try {
            capi_return_t rc = tiledb.tiledb_config_iter_next(iterp, errorpp);
            this.checkConfigError(rc, errorpp);
        }
        finally {
            tiledb.delete_tiledb_error_tpp(errorpp);
        }
    }

    private boolean hasMoreParams(SWIGTYPE_p_tiledb_config_iter_handle_t iterp) throws TileDBError {
        SWIGTYPE_p_int done = tiledb.new_intp();
        SWIGTYPE_p_p_tiledb_error_handle_t errorpp = tiledb.new_tiledb_error_tpp();
        try {
            capi_return_t rc = tiledb.tiledb_config_iter_done(iterp, done, errorpp);
            this.checkConfigError(rc, errorpp);
        }
        catch (TileDBError err) {
            tiledb.delete_intp(done);
            tiledb.delete_tiledb_error_tpp(errorpp);
            throw err;
        }
        boolean hasMore = tiledb.intp_value(done) == 0;
        tiledb.delete_intp(done);
        return hasMore;
    }

    private void checkConfigError(capi_return_t returnCode, SWIGTYPE_p_p_tiledb_error_handle_t error) throws TileDBError {
        if (tiledb.tiledb_status_code(returnCode) == -1) {
            SWIGTYPE_p_p_char msgpp = tiledb.new_charpp();
            int ret = tiledb.tiledb_status_code(tiledb.tiledb_error_message(tiledb.tiledb_error_tpp_value(error), msgpp));
            if (ret == -1) {
                tiledb.delete_charpp(msgpp);
                tiledb.tiledb_error_free(error);
                throw new TileDBError("Config Error: Unknown error, could not retrieve error message");
            }
            String msg = tiledb.charpp_value(msgpp);
            tiledb.delete_charpp(msgpp);
            tiledb.tiledb_error_free(error);
            throw new TileDBError("Config Error: " + msg);
        }
    }

    protected SWIGTYPE_p_tiledb_config_t getConfigp() {
        return this.configp;
    }

    @Override
    public void close() {
        if (this.configp != null) {
            tiledb.tiledb_config_free(this.configpp);
            tiledb.delete_tiledb_config_tpp(this.configpp);
            this.configp = null;
            this.configpp = null;
        }
    }
}

