/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.TileDBError;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_consolidation_plan_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_consolidation_plan_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.tiledb;
import java.math.BigInteger;

public class ConsolidationPlan
implements AutoCloseable {
    private SWIGTYPE_p_p_tiledb_consolidation_plan_t conspp;
    private SWIGTYPE_p_tiledb_consolidation_plan_t consp;
    private BigInteger fragmentSize;
    private Context ctx;
    private String arrayURI;

    public ConsolidationPlan(Context ctx, BigInteger fragmentSize, String arrayURI) throws TileDBError {
        this.fragmentSize = fragmentSize;
        this.ctx = ctx;
        this.arrayURI = arrayURI;
        SWIGTYPE_p_p_tiledb_consolidation_plan_t _consp = tiledb.new_tiledb_consolidation_plan_tpp();
        try (Array array = new Array(ctx, arrayURI);){
            ctx.handleError(tiledb.tiledb_consolidation_plan_create_with_mbr(ctx.getCtxp(), array.getArrayp(), fragmentSize, _consp));
        }
        catch (TileDBError e) {
            tiledb.delete_tiledb_consolidation_plan_tpp(_consp);
            throw e;
        }
        this.consp = tiledb.tiledb_consolidation_plan_tpp_value(_consp);
        this.conspp = _consp;
    }

    public ConsolidationPlan(Context ctx, BigInteger fragmentSize, Array array) throws TileDBError {
        this.fragmentSize = fragmentSize;
        this.ctx = ctx;
        this.arrayURI = array.getUri();
        SWIGTYPE_p_p_tiledb_consolidation_plan_t _consp = tiledb.new_tiledb_consolidation_plan_tpp();
        try {
            ctx.handleError(tiledb.tiledb_consolidation_plan_create_with_mbr(ctx.getCtxp(), array.getArrayp(), fragmentSize, _consp));
        }
        catch (TileDBError e) {
            tiledb.delete_tiledb_consolidation_plan_tpp(_consp);
            throw e;
        }
        this.consp = tiledb.tiledb_consolidation_plan_tpp_value(_consp);
        this.conspp = _consp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumFragments(BigInteger nodeIndex) throws TileDBError {
        long result;
        SWIGTYPE_p_unsigned_long_long longp = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_consolidation_plan_get_num_fragments(this.ctx.getCtxp(), this.consp, nodeIndex, longp));
            result = tiledb.ullp_value(longp).longValue();
        }
        finally {
            tiledb.delete_ullp(longp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFragmentURI(BigInteger nodeIndex, BigInteger fragmentIndex) throws TileDBError {
        String uri;
        SWIGTYPE_p_p_char uripp = tiledb.new_charpp();
        try {
            this.ctx.handleError(tiledb.tiledb_consolidation_plan_get_fragment_uri(this.ctx.getCtxp(), this.consp, nodeIndex, fragmentIndex, uripp));
            uri = tiledb.charpp_value(uripp);
        }
        finally {
            tiledb.delete_charpp(uripp);
        }
        return uri;
    }

    public String dumpJSONString() throws TileDBError {
        String result;
        SWIGTYPE_p_p_char dumpStrp = tiledb.new_charpp();
        try {
            this.ctx.handleError(tiledb.tiledb_consolidation_plan_dump_json_str(this.ctx.getCtxp(), this.consp, dumpStrp));
            result = tiledb.charpp_value(dumpStrp);
        }
        finally {
            tiledb.tiledb_consolidation_plan_free_json_str(dumpStrp);
            tiledb.delete_charpp(dumpStrp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumNodes() throws TileDBError {
        long result;
        SWIGTYPE_p_unsigned_long_long longp = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_consolidation_plan_get_num_nodes(this.ctx.getCtxp(), this.consp, longp));
            result = tiledb.ullp_value(longp).longValue();
        }
        finally {
            tiledb.delete_ullp(longp);
        }
        return result;
    }

    @Override
    public void close() throws Exception {
        if (this.consp != null) {
            tiledb.tiledb_consolidation_plan_free(this.conspp);
            tiledb.delete_tiledb_consolidation_plan_tpp(this.conspp);
            this.consp = null;
            this.conspp = null;
        }
    }
}

