/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.TileDBError;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_dimension_label_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_data_order_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_datatype_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_dimension_label_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.tiledb_data_order_t;
import io.tiledb.libtiledb.tiledb_datatype_t;
import jdk.jfr.Experimental;

@Experimental
public class DimensionLabel
implements AutoCloseable {
    private Context ctx;
    private SWIGTYPE_p_tiledb_dimension_label_handle_t dimlabelp;
    private SWIGTYPE_p_p_tiledb_dimension_label_handle_t dimlabelpp;
    private long dimIndex = -1L;
    private String name;
    private tiledb_data_order_t labelOrder;
    private tiledb_datatype_t labelType;

    public DimensionLabel(Context ctx, long dimIndex, String name, tiledb_data_order_t labelOrder, tiledb_datatype_t labelType) {
        this.ctx = ctx;
        this.dimIndex = dimIndex;
        this.name = name;
        this.labelOrder = labelOrder;
        this.labelType = labelType;
    }

    protected DimensionLabel(Context ctx, SWIGTYPE_p_p_tiledb_dimension_label_handle_t dimlabelpp) {
        this.ctx = ctx;
        this.dimlabelp = tiledb.tiledb_dimension_label_tpp_value(dimlabelpp);
        this.dimlabelpp = dimlabelpp;
    }

    protected SWIGTYPE_p_tiledb_dimension_label_handle_t getDimLabelp() {
        return this.dimlabelp;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDimensionIndex() throws TileDBError {
        long result;
        if (this.dimIndex != -1L) {
            return this.dimIndex;
        }
        SWIGTYPE_p_unsigned_int indexp = tiledb.new_uintp();
        try {
            this.ctx.handleError(tiledb.tiledb_dimension_label_get_dimension_index(this.ctx.getCtxp(), this.dimlabelp, indexp));
            result = tiledb.uintp_value(indexp);
        }
        finally {
            tiledb.delete_uintp(indexp);
        }
        return result;
    }

    public String getName() throws TileDBError {
        String name;
        if (this.name != null) {
            return this.name;
        }
        SWIGTYPE_p_p_char namepp = tiledb.new_charpp();
        try {
            this.ctx.handleError(tiledb.tiledb_dimension_label_get_name(this.ctx.getCtxp(), this.dimlabelp, namepp));
            name = tiledb.charpp_value(namepp);
        }
        finally {
            tiledb.delete_charpp(namepp);
        }
        return name;
    }

    public String getLabelAttrName() throws TileDBError {
        String name;
        SWIGTYPE_p_p_char namepp = tiledb.new_charpp();
        try {
            this.ctx.handleError(tiledb.tiledb_dimension_label_get_label_attr_name(this.ctx.getCtxp(), this.dimlabelp, namepp));
            name = tiledb.charpp_value(namepp);
        }
        finally {
            tiledb.delete_charpp(namepp);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLabelCellValNum() throws TileDBError {
        long result;
        SWIGTYPE_p_unsigned_int nump = tiledb.new_uintp();
        try {
            this.ctx.handleError(tiledb.tiledb_dimension_label_get_label_cell_val_num(this.ctx.getCtxp(), this.dimlabelp, nump));
            result = tiledb.uintp_value(nump);
        }
        finally {
            tiledb.delete_uintp(nump);
        }
        return result;
    }

    public String getURI() throws TileDBError {
        String name;
        SWIGTYPE_p_p_char uripp = tiledb.new_charpp();
        try {
            this.ctx.handleError(tiledb.tiledb_dimension_label_get_uri(this.ctx.getCtxp(), this.dimlabelp, uripp));
            name = tiledb.charpp_value(uripp);
        }
        finally {
            tiledb.delete_charpp(uripp);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public tiledb_data_order_t getLabelOrder() throws TileDBError {
        if (this.labelOrder != null) {
            return this.labelOrder;
        }
        SWIGTYPE_p_tiledb_data_order_t orderp = tiledb.new_tiledb_data_order_tp();
        try {
            tiledb_data_order_t type;
            this.ctx.handleError(tiledb.tiledb_dimension_label_get_label_order(this.ctx.getCtxp(), this.dimlabelp, orderp));
            tiledb_data_order_t tiledb_data_order_t2 = type = tiledb.tiledb_data_order_tp_value(orderp);
            return tiledb_data_order_t2;
        }
        finally {
            tiledb.delete_tiledb_data_order_tp(orderp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype getLabelType() throws TileDBError {
        if (this.labelType != null) {
            return Datatype.fromSwigEnum(this.labelType);
        }
        SWIGTYPE_p_tiledb_datatype_t typep = tiledb.new_tiledb_datatype_tp();
        try {
            this.ctx.handleError(tiledb.tiledb_dimension_label_get_label_type(this.ctx.getCtxp(), this.dimlabelp, typep));
            tiledb_datatype_t type = tiledb.tiledb_datatype_tp_value(typep);
            Datatype datatype = Datatype.fromSwigEnum(type);
            return datatype;
        }
        finally {
            tiledb.delete_tiledb_datatype_tp(typep);
        }
    }

    @Override
    public void close() {
        if (this.dimlabelp != null && this.dimlabelpp != null) {
            tiledb.tiledb_dimension_label_free(this.dimlabelpp);
            this.dimlabelpp = null;
            this.dimlabelp = null;
        }
    }
}

