/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.TileDBString;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_enumeration_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_string_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_void;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_datatype_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_enumeration_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.tiledb;
import java.math.BigInteger;

public class Enumeration
implements AutoCloseable {
    private Context ctx;
    private SWIGTYPE_p_tiledb_enumeration_t enumerationp;
    private SWIGTYPE_p_p_tiledb_enumeration_t enumerationpp;
    private String name;
    private long cellValNumber = -1L;
    private Datatype datatype;

    protected Enumeration(Context ctx, SWIGTYPE_p_p_tiledb_enumeration_t enumerationpp) {
        this.ctx = ctx;
        this.enumerationp = tiledb.tiledb_enumeration_tpp_value(enumerationpp);
        this.enumerationpp = enumerationpp;
    }

    protected Enumeration(Context ctx, String name, long cellValNum, Datatype datatype, boolean ordered, NativeArray data, BigInteger dataSize, NativeArray offsets, BigInteger offsetsSize) throws TileDBError {
        this.datatype = datatype;
        this.name = name;
        this.cellValNumber = cellValNum;
        int ord = 0;
        if (ordered) {
            ord = 1;
        }
        SWIGTYPE_p_p_tiledb_enumeration_t enumerationpp = tiledb.new_tiledb_enumeration_tpp();
        try {
            if (offsets == null) {
                ctx.handleError(tiledb.tiledb_enumeration_alloc(ctx.getCtxp(), name, datatype.toSwigEnum(), cellValNum, ord, data.toVoidPointer(), dataSize, null, offsetsSize, enumerationpp));
            } else {
                ctx.handleError(tiledb.tiledb_enumeration_alloc(ctx.getCtxp(), name, datatype.toSwigEnum(), cellValNum, ord, data.toVoidPointer(), dataSize, offsets.toVoidPointer(), offsetsSize, enumerationpp));
            }
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_enumeration_tpp(enumerationpp);
            throw err;
        }
        this.ctx = ctx;
        this.enumerationp = tiledb.tiledb_enumeration_tpp_value(enumerationpp);
        this.enumerationpp = enumerationpp;
    }

    public SWIGTYPE_p_tiledb_enumeration_t getEnumerationp() {
        return this.enumerationp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCellValNum() throws TileDBError {
        long cellValNumber;
        if (this.cellValNumber != -1L) {
            return this.cellValNumber;
        }
        SWIGTYPE_p_unsigned_int nump = tiledb.new_uintp();
        try {
            this.ctx.handleError(tiledb.tiledb_enumeration_get_cell_val_num(this.ctx.getCtxp(), this.getEnumerationp(), nump));
            cellValNumber = tiledb.uintp_value(nump);
        }
        finally {
            tiledb.delete_uintp(nump);
        }
        return cellValNumber;
    }

    public boolean getOrdered() throws TileDBError {
        SWIGTYPE_p_int isOrdered = tiledb.new_intp();
        try {
            this.ctx.handleError(tiledb.tiledb_enumeration_get_ordered(this.ctx.getCtxp(), this.getEnumerationp(), isOrdered));
            boolean bl = tiledb.intp_value(isOrdered) > 0;
            return bl;
        }
        finally {
            tiledb.delete_intp(isOrdered);
        }
    }

    public Enumeration extend(NativeArray data, BigInteger dataSize, NativeArray offsets, BigInteger offsetsSize) {
        SWIGTYPE_p_p_tiledb_enumeration_t enumeration_t = tiledb.new_tiledb_enumeration_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_enumeration_extend(this.ctx.getCtxp(), this.getEnumerationp(), data.toVoidPointer(), dataSize, offsets.toVoidPointer(), offsetsSize, enumeration_t));
        }
        catch (TileDBError e) {
            tiledb.delete_tiledb_enumeration_tpp(enumeration_t);
        }
        return new Enumeration(this.ctx, enumeration_t);
    }

    public Datatype getType() throws TileDBError {
        if (this.datatype != null) {
            return this.datatype;
        }
        SWIGTYPE_p_tiledb_datatype_t typep = tiledb.new_tiledb_datatype_tp();
        try {
            this.ctx.handleError(tiledb.tiledb_enumeration_get_type(this.ctx.getCtxp(), this.getEnumerationp(), typep));
            Datatype datatype = Datatype.fromSwigEnum(tiledb.tiledb_datatype_tp_value(typep));
            return datatype;
        }
        finally {
            tiledb.delete_tiledb_datatype_tp(typep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws TileDBError {
        if (this.name != null) {
            return this.name;
        }
        SWIGTYPE_p_p_tiledb_string_handle_t name = tiledb.new_tiledb_string_handle_tpp();
        try (TileDBString ts = null;){
            this.ctx.handleError(tiledb.tiledb_enumeration_get_name(this.ctx.getCtxp(), this.enumerationp, name));
            ts = new TileDBString(this.ctx, name);
            String string = ts.getView().getFirst();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData() throws TileDBError {
        SWIGTYPE_p_p_void datapp = tiledb.new_voidpArray(0);
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_enumeration_get_data(this.ctx.getCtxp(), this.getEnumerationp(), datapp, size));
            int byteSize = tiledb.ullp_value(size).intValue();
            Datatype type = this.getType();
            int numElements = byteSize / type.getNativeSize();
            Object object = new NativeArray(this.ctx, type, datapp, numElements).toJavaArray();
            return object;
        }
        finally {
            tiledb.delete_ullp(size);
            tiledb.delete_voidpArray(datapp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOffsets() throws TileDBError {
        SWIGTYPE_p_p_void datapp = tiledb.new_voidpArray(0);
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_enumeration_get_offsets(this.ctx.getCtxp(), this.getEnumerationp(), datapp, size));
            int byteSize = tiledb.ullp_value(size).intValue();
            Datatype type = this.getType();
            int numElements = byteSize / type.getNativeSize();
            Object object = new NativeArray(this.ctx, type, datapp, numElements).toJavaArray();
            return object;
        }
        finally {
            tiledb.delete_voidpArray(datapp);
            tiledb.delete_ullp(size);
        }
    }

    @Override
    public void close() {
        if (this.enumerationp != null && this.enumerationpp != null) {
            tiledb.tiledb_enumeration_free(this.enumerationpp);
            tiledb.delete_tiledb_enumeration_tpp(this.enumerationpp);
            this.enumerationpp = null;
            this.enumerationp = null;
        }
    }
}

