/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Types;
import io.tiledb.libtiledb.PointerUtils;
import io.tiledb.libtiledb.SWIGTYPE_p_p_void;
import io.tiledb.libtiledb.SWIGTYPE_p_void;
import io.tiledb.libtiledb.Utils;
import io.tiledb.libtiledb.doubleArray;
import io.tiledb.libtiledb.floatArray;
import io.tiledb.libtiledb.int16_tArray;
import io.tiledb.libtiledb.int32_tArray;
import io.tiledb.libtiledb.int64_tArray;
import io.tiledb.libtiledb.int8_tArray;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.uint16_tArray;
import io.tiledb.libtiledb.uint32_tArray;
import io.tiledb.libtiledb.uint8_tArray;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class NativeArray
implements AutoCloseable {
    private Class javaType;
    private Datatype nativeType;
    private int nativeTypeSize;
    private floatArray floatArray;
    private doubleArray doubleArray;
    private int8_tArray int8_tArray;
    private int16_tArray int16_tArray;
    private int32_tArray int32_tArray;
    private int64_tArray int64_tArray;
    private uint8_tArray uint8_tArray;
    private uint16_tArray uint16_tArray;
    private uint32_tArray uint32_tArray;
    private int64_tArray uint64_tArray;
    private int size;

    public NativeArray(Context ctx, int size, Datatype nativeType) throws TileDBError {
        this.size = size;
        this.javaType = Types.getJavaType(nativeType);
        this.nativeType = nativeType;
        this.nativeTypeSize = tiledb.tiledb_datatype_size(nativeType.toSwigEnum()).intValue();
        this.allocateEmptyArray();
    }

    public NativeArray(Context ctx, int size, Class javaType) throws TileDBError {
        this.size = size;
        this.javaType = javaType;
        this.nativeType = Types.getNativeType(javaType);
        this.nativeTypeSize = tiledb.tiledb_datatype_size(this.nativeType.toSwigEnum()).intValue();
        this.allocateEmptyArray();
    }

    public NativeArray(Context ctx, Object buffer, Class javaType) throws TileDBError {
        this.javaType = javaType;
        this.nativeType = Types.getNativeType(javaType);
        this.nativeTypeSize = tiledb.tiledb_datatype_size(this.nativeType.toSwigEnum()).intValue();
        this.size = this.getSize(buffer);
        this.createNativeArrayFromBuffer(buffer);
    }

    public NativeArray(Context ctx, Object buffer, Datatype nativeType, int size) throws TileDBError {
        this.javaType = Types.getJavaType(nativeType);
        this.nativeType = nativeType;
        this.nativeTypeSize = tiledb.tiledb_datatype_size(this.nativeType.toSwigEnum()).intValue();
        this.size = size;
        this.createNativeArrayFromBuffer(buffer);
    }

    public NativeArray(Context ctx, Object buffer, Datatype nativeType) throws TileDBError {
        this.javaType = Types.getJavaType(nativeType);
        this.nativeType = nativeType;
        this.nativeTypeSize = tiledb.tiledb_datatype_size(this.nativeType.toSwigEnum()).intValue();
        this.size = this.getSize(buffer);
        this.createNativeArrayFromBuffer(buffer);
    }

    protected NativeArray(Context ctx, Datatype nativeType, SWIGTYPE_p_p_void pointer, int nelements) throws TileDBError {
        this.javaType = Types.getJavaType(nativeType);
        this.nativeType = nativeType;
        this.nativeTypeSize = tiledb.tiledb_datatype_size(this.nativeType.toSwigEnum()).intValue();
        this.size = nelements;
        this.createNativeArrayFromVoidPointer(pointer);
    }

    protected NativeArray(Context ctx, Datatype nativeType, SWIGTYPE_p_void pointer, int nelements) throws TileDBError {
        this.javaType = Types.getJavaType(nativeType);
        this.nativeType = nativeType;
        this.nativeTypeSize = tiledb.tiledb_datatype_size(this.nativeType.toSwigEnum()).intValue();
        this.size = nelements;
        this.createNativeArrayFromVoidPointer(pointer);
    }

    private int getSize(Object buffer) throws TileDBError {
        switch (this.nativeType) {
            case TILEDB_FLOAT32: {
                return ((float[])buffer).length;
            }
            case TILEDB_FLOAT64: {
                return ((double[])buffer).length;
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                return ((byte[])buffer).length;
            }
            case TILEDB_INT16: 
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                return ((short[])buffer).length;
            }
            case TILEDB_INT32: 
            case TILEDB_UINT16: {
                return ((int[])buffer).length;
            }
            case TILEDB_INT64: 
            case TILEDB_UINT64: 
            case TILEDB_UINT32: {
                return ((long[])buffer).length;
            }
            case TILEDB_CHAR: 
            case TILEDB_STRING_ASCII: {
                Charset charset = StandardCharsets.ISO_8859_1;
                return this.stringToBytes((String)buffer, charset).length;
            }
            case TILEDB_STRING_UTF8: {
                Charset charset = StandardCharsets.UTF_8;
                return this.stringToBytes((String)buffer, charset).length;
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_DATETIME_AS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                return ((long[])buffer).length;
            }
        }
        throw new TileDBError("Unsupported TileDB NativeArray Datatype enum: " + (Object)((Object)this.nativeType));
    }

    private void createNativeArrayFromBuffer(Object buffer) throws TileDBError {
        switch (this.nativeType) {
            case TILEDB_FLOAT32: {
                this.floatArray = Utils.newFloatArray((float[])buffer);
                break;
            }
            case TILEDB_FLOAT64: {
                this.doubleArray = Utils.newDoubleArray((double[])buffer);
                break;
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                this.int8_tArray = Utils.newInt8_tArray((byte[])buffer);
                break;
            }
            case TILEDB_INT16: {
                this.int16_tArray = Utils.newInt16_tArray((short[])buffer);
                break;
            }
            case TILEDB_INT32: {
                this.int32_tArray = Utils.newInt32_tArray((int[])buffer);
                break;
            }
            case TILEDB_INT64: {
                this.int64_tArray = Utils.newInt64_tArray((long[])buffer);
                break;
            }
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                this.uint8_tArray = Utils.newUint8_tArray((short[])buffer);
                break;
            }
            case TILEDB_UINT16: {
                this.uint16_tArray = Utils.newUint16_tArray((int[])buffer);
                break;
            }
            case TILEDB_UINT32: {
                this.uint32_tArray = Utils.newUint32_tArray((long[])buffer);
                break;
            }
            case TILEDB_UINT64: {
                this.uint64_tArray = Utils.newInt64_tArray((long[])buffer);
                break;
            }
            case TILEDB_CHAR: 
            case TILEDB_STRING_ASCII: {
                Charset charset = StandardCharsets.ISO_8859_1;
                this.int8_tArray = Utils.newInt8_tArray(this.stringToBytes((String)buffer, charset));
                break;
            }
            case TILEDB_STRING_UTF8: {
                Charset charset = StandardCharsets.UTF_8;
                this.int8_tArray = Utils.newInt8_tArray(this.stringToBytes((String)buffer, charset));
                break;
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_DATETIME_AS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                this.int64_tArray = Utils.newInt64_tArray((long[])buffer);
                break;
            }
            default: {
                throw new TileDBError("Unsupported TileDB NativeArray Datatype enum: " + (Object)((Object)this.nativeType));
            }
        }
    }

    private void allocateEmptyArray() throws TileDBError {
        switch (this.nativeType) {
            case TILEDB_FLOAT32: {
                this.floatArray = new floatArray(this.size);
                break;
            }
            case TILEDB_FLOAT64: {
                this.doubleArray = new doubleArray(this.size);
                break;
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                this.int8_tArray = new int8_tArray(this.size);
                break;
            }
            case TILEDB_INT16: {
                this.int16_tArray = new int16_tArray(this.size);
                break;
            }
            case TILEDB_INT32: {
                this.int32_tArray = new int32_tArray(this.size);
                break;
            }
            case TILEDB_INT64: {
                this.int64_tArray = new int64_tArray(this.size);
                break;
            }
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                this.uint8_tArray = new uint8_tArray(this.size);
                break;
            }
            case TILEDB_UINT16: {
                this.uint16_tArray = new uint16_tArray(this.size);
                break;
            }
            case TILEDB_UINT32: {
                this.uint32_tArray = new uint32_tArray(this.size);
                break;
            }
            case TILEDB_UINT64: {
                this.uint64_tArray = new int64_tArray(this.size);
                break;
            }
            case TILEDB_CHAR: 
            case TILEDB_STRING_ASCII: {
                this.int8_tArray = new int8_tArray(this.size);
                break;
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_DATETIME_AS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                this.int64_tArray = new int64_tArray(this.size);
                break;
            }
            default: {
                throw new TileDBError("Unsupported TileDB NativeArray Datatype enum: " + (Object)((Object)this.nativeType));
            }
        }
    }

    public Object getItem(int index) throws ArrayIndexOutOfBoundsException, TileDBError {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        switch (this.nativeType) {
            case TILEDB_FLOAT32: {
                return Float.valueOf(this.floatArray.getitem(index));
            }
            case TILEDB_FLOAT64: {
                return this.doubleArray.getitem(index);
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                return this.int8_tArray.getitem(index);
            }
            case TILEDB_INT16: {
                return this.int16_tArray.getitem(index);
            }
            case TILEDB_INT32: {
                return this.int32_tArray.getitem(index);
            }
            case TILEDB_INT64: {
                return this.int64_tArray.getitem(index);
            }
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                return this.uint8_tArray.getitem(index);
            }
            case TILEDB_UINT16: {
                return this.uint16_tArray.getitem(index);
            }
            case TILEDB_UINT32: {
                return this.uint32_tArray.getitem(index);
            }
            case TILEDB_UINT64: {
                return this.uint64_tArray.getitem(index);
            }
            case TILEDB_CHAR: 
            case TILEDB_STRING_ASCII: {
                return this.int8_tArray.getitem(index);
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_DATETIME_AS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                return this.int64_tArray.getitem(index);
            }
        }
        throw new TileDBError("Unsupported TileDB NativeArray Datatype enum: " + (Object)((Object)this.nativeType));
    }

    public void setItem(int index, Object value) throws ArrayIndexOutOfBoundsException, TileDBError {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        switch (this.nativeType) {
            case TILEDB_FLOAT32: {
                this.floatArray.setitem(index, ((Float)value).floatValue());
                break;
            }
            case TILEDB_FLOAT64: {
                this.doubleArray.setitem(index, (Double)value);
                break;
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                this.int8_tArray.setitem(index, (Byte)value);
                break;
            }
            case TILEDB_INT16: {
                this.int16_tArray.setitem(index, (Short)value);
                break;
            }
            case TILEDB_INT32: {
                this.int32_tArray.setitem(index, (Integer)value);
                break;
            }
            case TILEDB_INT64: {
                this.int64_tArray.setitem(index, (Long)value);
                break;
            }
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                this.uint8_tArray.setitem(index, (Short)value);
                break;
            }
            case TILEDB_UINT16: {
                this.uint16_tArray.setitem(index, (Integer)value);
                break;
            }
            case TILEDB_UINT32: {
                this.uint32_tArray.setitem(index, (Long)value);
                break;
            }
            case TILEDB_UINT64: {
                this.uint64_tArray.setitem(index, (Long)value);
                break;
            }
            case TILEDB_CHAR: 
            case TILEDB_STRING_ASCII: {
                Charset charset = StandardCharsets.ISO_8859_1;
                for (byte b : this.stringToBytes((String)value, charset)) {
                    this.int8_tArray.setitem(index, b);
                    ++index;
                }
                break;
            }
            case TILEDB_STRING_UTF8: {
                Charset charset = StandardCharsets.UTF_8;
                for (byte b : this.stringToBytes((String)value, charset)) {
                    this.int8_tArray.setitem(index, b);
                    ++index;
                }
                break;
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_DATETIME_AS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                this.int64_tArray.setitem(index, (Long)value);
                break;
            }
            default: {
                throw new TileDBError("Unsupported TileDB NativeArray Datatype enum: " + (Object)((Object)this.nativeType));
            }
        }
    }

    public SWIGTYPE_p_void toVoidPointer() throws TileDBError {
        switch (this.nativeType) {
            case TILEDB_FLOAT32: {
                return PointerUtils.toVoid(this.floatArray);
            }
            case TILEDB_FLOAT64: {
                return PointerUtils.toVoid(this.doubleArray);
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                return PointerUtils.toVoid(this.int8_tArray);
            }
            case TILEDB_INT16: {
                return PointerUtils.toVoid(this.int16_tArray);
            }
            case TILEDB_INT32: {
                return PointerUtils.toVoid(this.int32_tArray);
            }
            case TILEDB_INT64: {
                return PointerUtils.toVoid(this.int64_tArray);
            }
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                return PointerUtils.toVoid(this.uint8_tArray);
            }
            case TILEDB_UINT16: {
                return PointerUtils.toVoid(this.uint16_tArray);
            }
            case TILEDB_UINT32: {
                return PointerUtils.toVoid(this.uint32_tArray);
            }
            case TILEDB_UINT64: {
                return PointerUtils.toVoid(this.uint64_tArray);
            }
            case TILEDB_CHAR: 
            case TILEDB_STRING_ASCII: 
            case TILEDB_STRING_UTF8: {
                return PointerUtils.toVoid(this.int8_tArray);
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                return PointerUtils.toVoid(this.int64_tArray);
            }
        }
        throw new TileDBError("Unsupported TileDB NativeArray Datatype enum: " + (Object)((Object)this.nativeType));
    }

    public long toCPointer() throws TileDBError {
        switch (this.nativeType) {
            case TILEDB_FLOAT32: {
                return PointerUtils.toCPtr(this.floatArray);
            }
            case TILEDB_FLOAT64: {
                return PointerUtils.toCPtr(this.doubleArray);
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                return PointerUtils.toCPtr(this.int8_tArray);
            }
            case TILEDB_INT16: {
                return PointerUtils.toCPtr(this.int16_tArray);
            }
            case TILEDB_INT32: {
                return PointerUtils.toCPtr(this.int32_tArray);
            }
            case TILEDB_INT64: {
                return PointerUtils.toCPtr(this.int64_tArray);
            }
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                return PointerUtils.toCPtr(this.uint8_tArray);
            }
            case TILEDB_UINT16: {
                return PointerUtils.toCPtr(this.uint16_tArray);
            }
            case TILEDB_UINT32: {
                return PointerUtils.toCPtr(this.uint32_tArray);
            }
            case TILEDB_UINT64: {
                return PointerUtils.toCPtr(this.uint64_tArray);
            }
            case TILEDB_CHAR: {
                return PointerUtils.toCPtr(this.int8_tArray);
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                return PointerUtils.toCPtr(this.int64_tArray);
            }
        }
        throw new TileDBError("Unsupported TileDB NativeArray Datatype enum: " + (Object)((Object)this.nativeType));
    }

    public Object toJavaArray() throws TileDBError {
        return this.toJavaArray(0, this.size);
    }

    public Object toJavaArray(int elements) throws TileDBError {
        return this.toJavaArray(0, elements);
    }

    public Object toJavaArray(int position, int elements) throws TileDBError {
        if (position + elements > this.size || position < 0 || elements < 0) {
            throw new ArrayIndexOutOfBoundsException(position + elements);
        }
        switch (this.nativeType) {
            case TILEDB_FLOAT32: {
                return Utils.floatArrayGet(this.floatArray, position, elements);
            }
            case TILEDB_FLOAT64: {
                return Utils.doubleArrayGet(this.doubleArray, position, elements);
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                return Utils.int8ArrayGet(this.int8_tArray, position, elements);
            }
            case TILEDB_INT16: {
                return Utils.int16ArrayGet(this.int16_tArray, position, elements);
            }
            case TILEDB_INT32: {
                return Utils.int32ArrayGet(this.int32_tArray, position, elements);
            }
            case TILEDB_INT64: {
                return Utils.int64ArrayGet(this.int64_tArray, position, elements);
            }
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                return Utils.uint8ArrayGet(this.uint8_tArray, position, elements);
            }
            case TILEDB_UINT16: {
                return Utils.uint16ArrayGet(this.uint16_tArray, position, elements);
            }
            case TILEDB_UINT32: {
                return Utils.uint32ArrayGet(this.uint32_tArray, position, elements);
            }
            case TILEDB_UINT64: {
                return Utils.int64ArrayGet(this.uint64_tArray, position, elements);
            }
            case TILEDB_CHAR: 
            case TILEDB_STRING_ASCII: 
            case TILEDB_STRING_UTF8: {
                return Utils.int8ArrayGet(this.int8_tArray, position, elements);
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                return Utils.int64ArrayGet(this.int64_tArray, position, elements);
            }
        }
        throw new TileDBError("Unsupported TileDB NativeArray Datatype enum: " + (Object)((Object)this.nativeType));
    }

    private void createNativeArrayFromVoidPointer(SWIGTYPE_p_p_void pointer) throws TileDBError {
        switch (this.nativeType) {
            case TILEDB_FLOAT32: {
                this.floatArray = PointerUtils.floatArrayFromVoid(pointer);
                break;
            }
            case TILEDB_FLOAT64: {
                this.doubleArray = PointerUtils.doubleArrayFromVoid(pointer);
                break;
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                this.int8_tArray = PointerUtils.int8_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_INT16: {
                this.int16_tArray = PointerUtils.int16_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_INT32: {
                this.int32_tArray = PointerUtils.int32_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_INT64: {
                this.int64_tArray = PointerUtils.int64_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                this.uint8_tArray = PointerUtils.uint8_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_UINT16: {
                this.uint16_tArray = PointerUtils.uint16_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_UINT32: {
                this.uint32_tArray = PointerUtils.uint32_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_UINT64: {
                this.uint64_tArray = PointerUtils.int64_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                this.int64_tArray = PointerUtils.int64_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_CHAR: 
            case TILEDB_STRING_ASCII: 
            case TILEDB_STRING_UTF8: {
                this.int8_tArray = PointerUtils.int8_tArrayFromVoid(pointer);
                break;
            }
            default: {
                throw new TileDBError("Unsupported TileDB NativeArray Datatype enum: " + (Object)((Object)this.nativeType));
            }
        }
    }

    private void createNativeArrayFromVoidPointer(SWIGTYPE_p_void pointer) throws TileDBError {
        switch (this.nativeType) {
            case TILEDB_FLOAT32: {
                this.floatArray = PointerUtils.floatArrayFromVoid(pointer);
                break;
            }
            case TILEDB_FLOAT64: {
                this.doubleArray = PointerUtils.doubleArrayFromVoid(pointer);
                break;
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                this.int8_tArray = PointerUtils.int8_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_INT16: {
                this.int16_tArray = PointerUtils.int16_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_INT32: {
                this.int32_tArray = PointerUtils.int32_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_INT64: {
                this.int64_tArray = PointerUtils.int64_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                this.uint8_tArray = PointerUtils.uint8_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_UINT16: {
                this.uint16_tArray = PointerUtils.uint16_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_UINT32: {
                this.uint32_tArray = PointerUtils.uint32_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_UINT64: {
                this.uint64_tArray = PointerUtils.int64_tArrayFromVoid(pointer);
                break;
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                this.int64_tArray = PointerUtils.int64_tArrayFromVoid(pointer);
                break;
            }
            default: {
                throw new TileDBError("Unsupported TileDB NativeArray Datatype enum: " + (Object)((Object)this.nativeType));
            }
        }
    }

    private byte[] stringToBytes(String buffer, Charset charset) {
        return buffer.getBytes(charset);
    }

    protected Datatype getNativeType() {
        return this.nativeType;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public int getSize() {
        return this.size;
    }

    public int getNativeTypeSize() {
        return this.nativeTypeSize;
    }

    public long getNBytes() {
        return (long)this.size * (long)this.nativeTypeSize;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            if (this.floatArray != null) {
                result.append(this.floatArray.getitem(i)).append(", ");
                continue;
            }
            if (this.doubleArray != null) {
                result.append(this.doubleArray.getitem(i)).append(", ");
                continue;
            }
            if (this.int8_tArray != null) {
                result.append(this.int8_tArray.getitem(i)).append(", ");
                continue;
            }
            if (this.int16_tArray != null) {
                result.append(this.int16_tArray.getitem(i)).append(", ");
                continue;
            }
            if (this.int32_tArray != null) {
                result.append(this.int32_tArray.getitem(i)).append(", ");
                continue;
            }
            if (this.int64_tArray != null) {
                result.append(this.int64_tArray.getitem(i)).append(", ");
                continue;
            }
            if (this.uint8_tArray != null) {
                result.append(this.uint8_tArray.getitem(i)).append(", ");
                continue;
            }
            if (this.uint16_tArray != null) {
                result.append(this.uint16_tArray.getitem(i)).append(", ");
                continue;
            }
            if (this.uint32_tArray != null) {
                result.append(this.uint32_tArray.getitem(i)).append(", ");
                continue;
            }
            if (this.uint64_tArray == null) continue;
            result.append(this.uint64_tArray.getitem(i)).append(", ");
        }
        result = new StringBuilder(result.substring(0, result.length() - 2));
        return result + "]";
    }

    @Override
    public void close() {
        if (this.floatArray != null) {
            this.floatArray.delete();
        }
        if (this.doubleArray != null) {
            this.doubleArray.delete();
        }
        if (this.int8_tArray != null) {
            this.int8_tArray.delete();
        }
        if (this.int16_tArray != null) {
            this.int16_tArray.delete();
        }
        if (this.int32_tArray != null) {
            this.int32_tArray.delete();
        }
        if (this.int64_tArray != null) {
            this.int64_tArray.delete();
        }
        if (this.uint8_tArray != null) {
            this.uint8_tArray.delete();
        }
        if (this.uint16_tArray != null) {
            this.uint16_tArray.delete();
        }
        if (this.uint32_tArray != null) {
            this.uint32_tArray.delete();
        }
        if (this.uint64_tArray != null) {
            this.uint64_tArray.delete();
        }
    }

    public floatArray getFloatArray() {
        return this.floatArray;
    }

    public doubleArray getDoubleArray() {
        return this.doubleArray;
    }

    public int8_tArray getInt8_tArray() {
        return this.int8_tArray;
    }

    public int16_tArray getInt16_tArray() {
        return this.int16_tArray;
    }

    public int32_tArray getInt32_tArray() {
        return this.int32_tArray;
    }

    public int64_tArray getInt64_tArray() {
        return this.int64_tArray;
    }

    public uint8_tArray getUint8_tArray() {
        return this.uint8_tArray;
    }

    public uint16_tArray getUint16_tArray() {
        return this.uint16_tArray;
    }

    public uint32_tArray getUint32_tArray() {
        return this.uint32_tArray;
    }

    public int64_tArray getUint64_tArray() {
        return this.uint64_tArray;
    }
}

