/*
 * Decompiled with CFR 0.152.
 */
package examples.io.tiledb.java.api;

import io.tiledb.java.api.Context;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.TileDBObject;
import io.tiledb.java.api.TileDBObjectIterator;
import io.tiledb.java.api.WalkOrder;

public class ObjectLsWalk {
    public static void main(String[] args) throws TileDBError {
        Context ctx = new Context();
        System.out.println("List children: ");
        TileDBObjectIterator obj_iter = new TileDBObjectIterator(ctx, "my_group");
        for (TileDBObject object : obj_iter.getAllObjects()) {
            System.out.println(object);
        }
        System.out.println("\nPreorder traversal: ");
        obj_iter.setRecursive();
        for (TileDBObject object : obj_iter.getAllObjects()) {
            System.out.println(object);
        }
        System.out.println("\nPostorder traversal: ");
        obj_iter.setRecursive(WalkOrder.TILEDB_POSTORDER);
        for (TileDBObject object : obj_iter.getAllObjects()) {
            System.out.println(object);
        }
        System.out.println("\nOnly groups: ");
        obj_iter.setRecursive();
        obj_iter.setIteratorPolicy(true, false, false);
        for (TileDBObject object : obj_iter.getAllObjects()) {
            System.out.println(object);
        }
        System.out.println("\nOnly arrays: ");
        obj_iter.setRecursive();
        obj_iter.setIteratorPolicy(false, true, false);
        for (TileDBObject object : obj_iter.getAllObjects()) {
            System.out.println(object);
        }
        System.out.println("\nOnly groups and arrays: ");
        obj_iter.setRecursive();
        obj_iter.setIteratorPolicy(true, true, false);
        for (TileDBObject object : obj_iter.getAllObjects()) {
            System.out.println(object);
        }
    }
}

