/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Callback;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.QueryStatus;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Types;
import io.tiledb.libtiledb.PointerUtils;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_query_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_query_status_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_query_t;
import io.tiledb.libtiledb.Utils;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.uint64_tArray;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Query
implements AutoCloseable {
    private Context ctx;
    private Array array;
    private QueryType type;
    private SWIGTYPE_p_p_tiledb_query_t querypp;
    private SWIGTYPE_p_tiledb_query_t queryp;
    private NativeArray subarray;
    private Map<String, NativeArray> buffers_;
    private Map<String, Pair<NativeArray, NativeArray>> var_buffers_;
    private Map<String, Pair<uint64_tArray, uint64_tArray>> buffer_sizes_;

    public Query(Array array, QueryType type) throws TileDBError {
        Context _ctx = array.getCtx();
        SWIGTYPE_p_p_tiledb_query_t _querypp = tiledb.new_tiledb_query_tpp();
        try {
            _ctx.handleError(tiledb.tiledb_query_alloc(_ctx.getCtxp(), array.getArrayp(), type.toSwigEnum(), _querypp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_query_tpp(_querypp);
            throw err;
        }
        this.ctx = _ctx;
        this.type = type;
        this.array = array;
        this.querypp = _querypp;
        this.queryp = tiledb.tiledb_query_tpp_value(_querypp);
        this.buffers_ = Collections.synchronizedMap(new HashMap());
        this.var_buffers_ = Collections.synchronizedMap(new HashMap());
        this.buffer_sizes_ = Collections.synchronizedMap(new HashMap());
    }

    public Query(Array array) throws TileDBError {
        this(array, array.getQueryType());
    }

    public synchronized Query setLayout(Layout layout) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_set_layout(this.ctx.getCtxp(), this.queryp, layout.toSwigEnum()));
        return this;
    }

    public QueryStatus getQueryStatus() throws TileDBError {
        QueryStatus status;
        SWIGTYPE_p_tiledb_query_status_t statusp = tiledb.new_tiledb_query_status_tp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_status(this.ctx.getCtxp(), this.queryp, statusp));
            status = QueryStatus.fromSwigEnum(tiledb.tiledb_query_status_tp_value(statusp));
        }
        finally {
            tiledb.delete_tiledb_query_status_tp(statusp);
        }
        return status;
    }

    public QueryStatus submit() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_submit(this.ctx.getCtxp(), this.queryp));
        return this.getQueryStatus();
    }

    public void submitAsync() throws TileDBError {
        this.submitAsync(new DefaultCallback());
    }

    public void submitAsync(Callback callback) throws TileDBError {
        this.ctx.handleError(Utils.tiledb_query_submit_async(this.ctx.getCtxp(), this.queryp, callback));
    }

    public synchronized Query setSubarray(NativeArray subarray) throws TileDBError {
        Types.typeCheck(subarray.getNativeType(), this.array.getSchema().getDomain().getType());
        this.ctx.handleError(tiledb.tiledb_query_set_subarray(this.ctx.getCtxp(), this.queryp, subarray.toVoidPointer()));
        if (this.subarray != null) {
            this.subarray.close();
        }
        this.subarray = subarray;
        return this;
    }

    public synchronized Query addRange(int dimIdx, Object start, Object end) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_query_add_range(this.ctx.getCtxp(), this.queryp, dimIdx, startArr.toVoidPointer(), endArr.toVoidPointer(), null));
        }
        return this;
    }

    public long getRangeNum(int dimIdx) throws TileDBError {
        uint64_tArray resultArr = new uint64_tArray(1);
        this.ctx.handleError(tiledb.tiledb_query_get_range_num(this.ctx.getCtxp(), this.queryp, dimIdx, resultArr.cast()));
        return resultArr.getitem(0).longValue();
    }

    /*
     * Exception decompiling
     */
    public Pair<Object, Object> getRange(int dimIdx, long rangeIdx) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized Query setBuffer(String attr, NativeArray buffer) throws TileDBError {
        block20: {
            try (ArraySchema schema = this.array.getSchema();){
                if (attr.equals(tiledb.tiledb_coords())) {
                    try (Domain domain = schema.getDomain();){
                        Types.typeCheck(domain.getType(), buffer.getNativeType());
                        break block20;
                    }
                }
                try (Attribute attribute = schema.getAttribute(attr);){
                    Types.typeCheck(attribute.getType(), buffer.getNativeType());
                }
            }
        }
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(0L));
        values_array_size.setitem(0, BigInteger.valueOf(buffer.getNBytes()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.buffers_.containsKey(attr)) {
            this.buffers_.get(attr).close();
        }
        this.buffers_.put(attr, buffer);
        this.buffer_sizes_.put(attr, buffer_sizes);
        uint64_tArray buffer_size = buffer_sizes.getSecond();
        this.ctx.handleError(tiledb.tiledb_query_set_buffer(this.ctx.getCtxp(), this.queryp, attr, buffer.toVoidPointer(), buffer_size.cast()));
        return this;
    }

    public synchronized Query setBuffer(String attr, NativeArray buffer, long bufferElements) throws TileDBError {
        block22: {
            if (bufferElements <= 0L) {
                throw new TileDBError("Number of buffer elements must be >= 1");
            }
            if (bufferElements > (long)buffer.getSize()) {
                throw new TileDBError("Number of elements requested exceeds the number of elements in allocated buffer: " + bufferElements + " > " + buffer.getSize());
            }
            try (ArraySchema schema = this.array.getSchema();){
                if (attr.equals(tiledb.tiledb_coords())) {
                    try (Domain domain = schema.getDomain();){
                        Types.typeCheck(domain.getType(), buffer.getNativeType());
                        break block22;
                    }
                }
                try (Attribute attribute = schema.getAttribute(attr);){
                    Types.typeCheck(attribute.getType(), buffer.getNativeType());
                }
            }
        }
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(0L));
        values_array_size.setitem(0, BigInteger.valueOf(bufferElements * (long)buffer.getNativeTypeSize()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.buffers_.containsKey(attr)) {
            this.buffers_.get(attr).close();
        }
        this.buffers_.put(attr, buffer);
        this.buffer_sizes_.put(attr, buffer_sizes);
        uint64_tArray buffer_size = buffer_sizes.getSecond();
        this.ctx.handleError(tiledb.tiledb_query_set_buffer(this.ctx.getCtxp(), this.queryp, attr, buffer.toVoidPointer(), buffer_size.cast()));
        return this;
    }

    public synchronized Query setBuffer(String attr, NativeArray offsets, NativeArray buffer) throws TileDBError {
        if (attr.equals(tiledb.tiledb_coords())) {
            throw new TileDBError("Cannot set coordinate buffer as variable sized.");
        }
        if (!offsets.getNativeType().equals((Object)Datatype.TILEDB_UINT64)) {
            throw new TileDBError("Buffer offsets should be of getType TILEDB_UINT64 or Long. Found getType: " + (Object)((Object)offsets.getNativeType()));
        }
        try (ArraySchema schema = this.array.getSchema();
             Attribute attribute = schema.getAttribute(attr);){
            Types.typeCheck(attribute.getType(), buffer.getNativeType());
        }
        uint64_tArray offsets_array = PointerUtils.uint64_tArrayFromVoid(offsets.toVoidPointer());
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(offsets.getNBytes()));
        values_array_size.setitem(0, BigInteger.valueOf(buffer.getNBytes()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.var_buffers_.containsKey(attr)) {
            Pair<NativeArray, NativeArray> prev_buffers = this.var_buffers_.get(attr);
            prev_buffers.getFirst().close();
            prev_buffers.getSecond().close();
        }
        this.var_buffers_.put(attr, new Pair<NativeArray, NativeArray>(offsets, buffer));
        this.buffer_sizes_.put(attr, buffer_sizes);
        this.ctx.handleError(tiledb.tiledb_query_set_buffer_var(this.ctx.getCtxp(), this.queryp, attr, offsets_array.cast(), offsets_array_size.cast(), buffer.toVoidPointer(), values_array_size.cast()));
        return this;
    }

    public synchronized Query setBuffer(String attr, NativeArray offsets, NativeArray buffer, long offsetElements, long bufferElements) throws TileDBError {
        Integer offsetSize = buffer.getSize();
        Integer bufferSize = buffer.getSize();
        if (offsetElements > (long)offsetSize.intValue()) {
            throw new TileDBError("Number of offset elements requested exceeds the number of elements in allocated offset buffer: " + offsetElements + " > " + offsetSize);
        }
        if (bufferElements > (long)bufferSize.intValue()) {
            throw new TileDBError("Number of buffer elements requested exceeds the number of elements in allocated buffer" + bufferElements + " > " + bufferSize);
        }
        if (attr.equals(tiledb.tiledb_coords())) {
            throw new TileDBError("Cannot set coordinate buffer as variable sized.");
        }
        if (!offsets.getNativeType().equals((Object)Datatype.TILEDB_UINT64)) {
            throw new TileDBError("Buffer offsets should be of getType TILEDB_UINT64 or Long. Found getType: " + (Object)((Object)offsets.getNativeType()));
        }
        if (offsetElements <= 0L || bufferElements <= 0L) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        try (ArraySchema schema = this.array.getSchema();
             Attribute attribute = schema.getAttribute(attr);){
            Types.typeCheck(attribute.getType(), buffer.getNativeType());
        }
        uint64_tArray offsets_array = PointerUtils.uint64_tArrayFromVoid(offsets.toVoidPointer());
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(offsetElements * (long)offsets.getNativeTypeSize()));
        values_array_size.setitem(0, BigInteger.valueOf(bufferElements * (long)buffer.getNativeTypeSize()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.var_buffers_.containsKey(attr)) {
            Pair<NativeArray, NativeArray> prev_buffers = this.var_buffers_.get(attr);
            prev_buffers.getFirst().close();
            prev_buffers.getSecond().close();
        }
        this.var_buffers_.put(attr, new Pair<NativeArray, NativeArray>(offsets, buffer));
        this.buffer_sizes_.put(attr, buffer_sizes);
        this.ctx.handleError(tiledb.tiledb_query_set_buffer_var(this.ctx.getCtxp(), this.queryp, attr, offsets_array.cast(), offsets_array_size.cast(), buffer.toVoidPointer(), values_array_size.cast()));
        return this;
    }

    private Query setBufferSizeUnsafe(String attribute, long offsetSize, long bufferSize) {
        this.buffer_sizes_.get(attribute).getFirst().setitem(0, BigInteger.valueOf(offsetSize));
        this.buffer_sizes_.get(attribute).getSecond().setitem(0, BigInteger.valueOf(bufferSize));
        return this;
    }

    public synchronized Query setBufferByteSize(String attribute, Long offsetSize, Long bufferSize) throws TileDBError {
        if (!this.var_buffers_.containsKey(attribute)) {
            throw new TileDBError("Query var attribute buffer does not exist: " + attribute);
        }
        if (offsetSize <= 0L || bufferSize <= 0L) {
            throw new TileDBError("Number of buffer bytes must be >= 1");
        }
        Pair<NativeArray, NativeArray> varBuffers = this.var_buffers_.get(attribute);
        NativeArray offsetBuffer = varBuffers.getFirst();
        Long offsetNBytes = offsetBuffer.getNBytes();
        NativeArray buffer = varBuffers.getSecond();
        Long bufferNBytes = buffer.getNBytes();
        if (offsetSize > offsetNBytes) {
            throw new TileDBError("Number of offset bytes requested exceeds the number bytes of in allocated offset buffer: " + offsetNBytes + " > " + offsetSize);
        }
        if (bufferSize > bufferNBytes) {
            throw new TileDBError("Number of buffer bytes requested exceeds the number of bytes in allocated buffer" + bufferNBytes + " > " + bufferSize);
        }
        return this.setBufferSizeUnsafe(attribute, offsetSize, bufferSize);
    }

    public synchronized Query setBufferByteSize(String attribute, Long bufferSize) throws TileDBError {
        if (!this.buffers_.containsKey(attribute)) {
            throw new TileDBError("Query attrbute buffer does not exist: " + attribute);
        }
        if (bufferSize <= 0L) {
            throw new TileDBError("Number of buffer bytes must be >= 1");
        }
        NativeArray buffer = this.buffers_.get(attribute);
        Long bufferNBytes = buffer.getNBytes();
        if (bufferSize > bufferNBytes) {
            throw new TileDBError("Number of bytes requested exceeds the number of bytes in allocated buffer: " + bufferSize + " > " + bufferNBytes);
        }
        return this.setBufferSizeUnsafe(attribute, 0L, bufferSize);
    }

    public synchronized Query setBufferElements(String attribute, Integer bufferElements) throws TileDBError {
        if (!this.buffers_.containsKey(attribute)) {
            throw new TileDBError("Query attribute buffer does not exist: " + attribute);
        }
        if (bufferElements <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        NativeArray buffer = this.buffers_.get(attribute);
        Integer bufferSize = buffer.getSize();
        if (bufferElements > bufferSize) {
            throw new TileDBError("Number of elements requested exceeds the number of elements in allocated buffer: " + bufferElements + " > " + bufferSize);
        }
        return this.setBufferSizeUnsafe(attribute, 0L, bufferElements * buffer.getNativeTypeSize());
    }

    public synchronized Query setBufferElements(String attribute, Integer offsetElements, Integer bufferElements) throws TileDBError {
        if (!this.var_buffers_.containsKey(attribute)) {
            throw new TileDBError("Query var attribute buffer does not exist: " + attribute);
        }
        if (offsetElements <= 0 || bufferElements <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        Pair<NativeArray, NativeArray> varBuffers = this.var_buffers_.get(attribute);
        NativeArray offsetBuffer = varBuffers.getFirst();
        Integer offsetSize = offsetBuffer.getSize();
        NativeArray buffer = varBuffers.getSecond();
        Integer bufferSize = buffer.getSize();
        if (offsetElements > offsetSize) {
            throw new TileDBError("Number of offset elements requested exceeds the number of elements in allocated offset buffer: " + offsetElements + " > " + offsetSize);
        }
        if (bufferElements > bufferSize) {
            throw new TileDBError("Number of buffer elements requested exceeds the number of elements in allocated buffer" + bufferElements + " > " + bufferSize);
        }
        return this.setBufferSizeUnsafe(attribute, offsetElements * offsetBuffer.getNativeTypeSize(), bufferElements * buffer.getNativeTypeSize());
    }

    public Query setCoordinates(NativeArray buffer) throws TileDBError {
        this.setBuffer(tiledb.tiledb_coords(), buffer);
        return this;
    }

    public Object getCoordinates() throws TileDBError {
        return this.getBuffer(tiledb.tiledb_coords());
    }

    public HashMap<String, Pair<Long, Long>> resultBufferElements() throws TileDBError {
        String name;
        HashMap<String, Pair<Long, Long>> result = new HashMap<String, Pair<Long, Long>>();
        for (Map.Entry<String, NativeArray> entry : this.buffers_.entrySet()) {
            name = entry.getKey();
            NativeArray val_buffer = entry.getValue();
            BigInteger val_nbytes = this.buffer_sizes_.get(name).getSecond().getitem(0);
            Long nelements = val_nbytes.divide(BigInteger.valueOf(val_buffer.getNativeTypeSize())).longValue();
            result.put(name, new Pair<Long, Long>(0L, nelements));
        }
        for (Map.Entry<String, Object> entry : this.var_buffers_.entrySet()) {
            name = entry.getKey();
            Pair<uint64_tArray, uint64_tArray> buffer_size = this.buffer_sizes_.get(name);
            NativeArray off_buffer = (NativeArray)((Pair)entry.getValue()).getFirst();
            BigInteger off_nbytes = buffer_size.getFirst().getitem(0);
            Long off_nelements = off_nbytes.divide(BigInteger.valueOf(off_buffer.getNativeTypeSize())).longValue();
            NativeArray val_buffer = (NativeArray)((Pair)entry.getValue()).getSecond();
            BigInteger val_nbytes = buffer_size.getSecond().getitem(0);
            Long val_nelements = val_nbytes.divide(BigInteger.valueOf(val_buffer.getNativeTypeSize())).longValue();
            result.put(name, new Pair<Long, Long>(off_nelements, val_nelements));
        }
        return result;
    }

    public HashMap<String, Pair<Long, Long>> resultBufferSizes() throws TileDBError {
        String name;
        HashMap<String, Pair<Long, Long>> result = new HashMap<String, Pair<Long, Long>>();
        for (Map.Entry<String, NativeArray> entry : this.buffers_.entrySet()) {
            name = entry.getKey();
            BigInteger val_nbytes = this.buffer_sizes_.get(name).getSecond().getitem(0);
            result.put(name, new Pair<Long, Long>(0L, val_nbytes.longValue()));
        }
        for (Map.Entry<String, Object> entry : this.var_buffers_.entrySet()) {
            name = entry.getKey();
            Pair<uint64_tArray, uint64_tArray> buffer_size = this.buffer_sizes_.get(name);
            BigInteger off_nbytes = buffer_size.getFirst().getitem(0);
            BigInteger val_nbytes = buffer_size.getSecond().getitem(0);
            result.put(name, new Pair<Long, Long>(off_nbytes.longValue(), val_nbytes.longValue()));
        }
        return result;
    }

    public synchronized void resetBuffers() {
        for (NativeArray nativeArray : this.buffers_.values()) {
            nativeArray.close();
        }
        this.buffers_.clear();
        for (Pair pair : this.var_buffers_.values()) {
            ((NativeArray)pair.getFirst()).close();
            ((NativeArray)pair.getSecond()).close();
        }
        this.var_buffers_.clear();
        for (Pair pair : this.buffer_sizes_.values()) {
            ((uint64_tArray)pair.getFirst()).delete();
            ((uint64_tArray)pair.getSecond()).delete();
        }
        this.buffer_sizes_.clear();
    }

    public synchronized Query resetBufferSizes(Long val) {
        BigInteger sizeVal = BigInteger.valueOf(val);
        for (Pair<uint64_tArray, uint64_tArray> size_pair : this.buffer_sizes_.values()) {
            size_pair.getFirst().setitem(0, sizeVal);
            size_pair.getSecond().setitem(0, sizeVal);
        }
        return this;
    }

    public Query resetBufferSizes() {
        return this.resetBufferSizes(0L);
    }

    public Object getBuffer(String attr) throws TileDBError {
        if (this.buffers_.containsKey(attr)) {
            NativeArray buffer = this.buffers_.get(attr);
            Integer nelements = this.buffer_sizes_.get(attr).getSecond().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
            return buffer.toJavaArray(nelements);
        }
        if (this.var_buffers_.containsKey(attr)) {
            NativeArray buffer = this.var_buffers_.get(attr).getSecond();
            Integer nelements = this.buffer_sizes_.get(attr).getSecond().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
            return buffer.toJavaArray(nelements);
        }
        throw new TileDBError("Query attribute buffer does not exist: " + attr);
    }

    public long[] getVarBuffer(String attr) throws TileDBError {
        if (!this.var_buffers_.containsKey(attr)) {
            throw new TileDBError("Query variable attribute buffer does not exist: " + attr);
        }
        NativeArray buffer = this.var_buffers_.get(attr).getFirst();
        Integer nelements = this.buffer_sizes_.get(attr).getFirst().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
        return (long[])buffer.toJavaArray(nelements);
    }

    public Query finalizeQuery() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_finalize(this.ctx.getCtxp(), this.queryp));
        return this;
    }

    public String toString() {
        switch (this.type) {
            case TILEDB_READ: {
                return "READ";
            }
            case TILEDB_WRITE: {
                return "WRITE";
            }
        }
        return "";
    }

    @Override
    public synchronized void close() {
        if (this.queryp != null) {
            for (Pair<uint64_tArray, uint64_tArray> pair : this.buffer_sizes_.values()) {
                pair.getFirst().delete();
                pair.getSecond().delete();
            }
            for (NativeArray nativeArray : this.buffers_.values()) {
                nativeArray.close();
            }
            for (Pair pair : this.var_buffers_.values()) {
                ((NativeArray)pair.getFirst()).close();
                ((NativeArray)pair.getSecond()).close();
            }
            if (this.subarray != null) {
                this.subarray.close();
            }
            tiledb.tiledb_query_free(this.querypp);
            this.queryp = null;
        }
    }

    private static class DefaultCallback
    implements Callback {
        @Override
        public void call() {
        }
    }
}

