/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.libtiledb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;

public class NativeLibLoader {
    private static final String UNKNOWN = "unknown";
    private static final String LIB_RESOURCE_DIR = "/lib";

    static void loadNativeTileDB() {
        try {
            NativeLibLoader.loadNativeLib("tiledb", true);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    static void loadNativeTileDBJNI() {
        try {
            NativeLibLoader.loadNativeLib("tiledbjni", true);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private static boolean contentsEquals(InputStream in1, InputStream in2) throws IOException {
        int ch2;
        if (!(in1 instanceof BufferedInputStream)) {
            in1 = new BufferedInputStream(in1);
        }
        if (!(in2 instanceof BufferedInputStream)) {
            in2 = new BufferedInputStream(in2);
        }
        int ch = in1.read();
        while (ch != -1) {
            ch2 = in2.read();
            if (ch != ch2) {
                return false;
            }
            ch = in1.read();
        }
        ch2 = in2.read();
        return ch2 == -1;
    }

    private static String normalizeOs(String value) {
        if ((value = NativeLibLoader.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("os400") && (value.length() <= 5 || !Character.isDigit(value.charAt(5)))) {
            return "os400";
        }
        if (value.startsWith("linux")) {
            return "linux";
        }
        if (value.startsWith("macosx") || value.startsWith("osx")) {
            return "osx";
        }
        if (value.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("solaris") || value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        return UNKNOWN;
    }

    private static String normalizeArch(String value) {
        if ((value = NativeLibLoader.normalize(value)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value.matches("^(ia64w?|itanium64)$")) {
            return "itanium_64";
        }
        if ("ia64n".equals(value)) {
            return "itanium_32";
        }
        if (value.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(value)) {
            return "aarch_64";
        }
        if (value.matches("^(mips|mips32)$")) {
            return "mips_32";
        }
        if (value.matches("^(mipsel|mips32el)$")) {
            return "mipsel_32";
        }
        if ("mips64".equals(value)) {
            return "mips_64";
        }
        if ("mips64el".equals(value)) {
            return "mipsel_64";
        }
        if (value.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if (value.matches("^(ppcle|ppc32le)$")) {
            return "ppcle_32";
        }
        if ("ppc64".equals(value)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(value)) {
            return "ppcle_64";
        }
        if ("s390".equals(value)) {
            return "s390_32";
        }
        if ("s390x".equals(value)) {
            return "s390_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static String getOSClassifier() {
        Properties allProps = new Properties(System.getProperties());
        String osName = allProps.getProperty("os.name");
        String osArch = allProps.getProperty("os.arch");
        String detectedName = NativeLibLoader.normalizeOs(osName);
        String detectedArch = NativeLibLoader.normalizeArch(osArch);
        return detectedName + "-" + detectedArch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractLibraryFile(String libraryDir, String libraryName, String targetDir, boolean mapLibraryName) {
        String libraryFileName = mapLibraryName ? System.mapLibraryName(libraryName) : libraryName;
        String nativeLibraryFilePath = new File(libraryDir, libraryFileName).getAbsolutePath();
        String uuid = UUID.randomUUID().toString();
        String extractedLibFileName = String.format("%s-%s-%s", libraryName, uuid, libraryFileName);
        File extractedLibFile = new File(targetDir, extractedLibFileName);
        try {
            boolean success;
            InputStream reader = null;
            FileOutputStream writer = null;
            try {
                reader = NativeLibLoader.class.getResourceAsStream(nativeLibraryFilePath);
                try {
                    writer = new FileOutputStream(extractedLibFile);
                    byte[] buffer = new byte[8192];
                    int bytesRead = 0;
                    while ((bytesRead = reader.read(buffer)) != -1) {
                        writer.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                extractedLibFile.deleteOnExit();
            }
            boolean bl = success = extractedLibFile.setReadable(true) && extractedLibFile.setWritable(true, true) && extractedLibFile.setExecutable(true);
            if (!success) {
                // empty if block
            }
            InputStream nativeIn = null;
            InputStream extractedLibIn = null;
            try {
                nativeIn = NativeLibLoader.class.getResourceAsStream(nativeLibraryFilePath);
                extractedLibIn = new FileInputStream(extractedLibFile);
                if (!NativeLibLoader.contentsEquals(nativeIn, extractedLibIn)) {
                    throw new IOException(String.format("Failed to write a native library file at %s", extractedLibFile));
                }
            }
            finally {
                if (nativeIn != null) {
                    nativeIn.close();
                }
                if (extractedLibIn != null) {
                    extractedLibIn.close();
                }
            }
            return new File(targetDir, extractedLibFileName);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static File findNativeLibrary(String libraryName, boolean mapLibraryName) {
        boolean created;
        String mappedLibraryName = mapLibraryName ? System.mapLibraryName(libraryName) : libraryName;
        String libDir = new File(LIB_RESOURCE_DIR, NativeLibLoader.getOSClassifier()).getAbsolutePath();
        File libPath = new File(libDir, mappedLibraryName);
        boolean hasNativeLib = NativeLibLoader.hasResource(libPath.getAbsolutePath());
        if (!hasNativeLib) {
            return null;
        }
        File tempFolder = new File(System.getProperty("java.io.tmpdir"));
        if (tempFolder.exists() || !(created = tempFolder.mkdirs())) {
            // empty if block
        }
        return NativeLibLoader.extractLibraryFile(libDir, libraryName, tempFolder.getAbsolutePath(), mapLibraryName);
    }

    private static void loadNativeLib(String libraryName, boolean mapLibraryName) {
        File nativeLibFile = NativeLibLoader.findNativeLibrary(libraryName, mapLibraryName);
        if (nativeLibFile != null) {
            System.load(nativeLibFile.getAbsolutePath());
        } else {
            System.loadLibrary(libraryName);
        }
    }

    private static boolean hasResource(String path) {
        return NativeLibLoader.class.getResource(path) != null;
    }
}

