/*
 * Decompiled with CFR 0.152.
 */
package examples.io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.Query;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.SubArray;
import java.util.Arrays;
import java.util.HashMap;

public class DenseReadOrderedSubarray {
    public static void main(String[] args) throws Exception {
        Context ctx = new Context();
        Array my_dense_array = new Array(ctx, "my_dense_array");
        SubArray subArray = new SubArray(ctx, my_dense_array);
        subArray.addRange(0, 3L, 4L, null);
        subArray.addRange(1, 2L, 4L, null);
        Query query = new Query(my_dense_array, QueryType.TILEDB_READ);
        query.setLayout(Layout.TILEDB_ROW_MAJOR);
        query.setSubarray(subArray);
        int bufferSize = 1024;
        query.setBuffer("a1", new NativeArray(ctx, bufferSize, Integer.class));
        query.setBuffer("a2", new NativeArray(ctx, bufferSize, Datatype.TILEDB_UINT64), new NativeArray(ctx, bufferSize, String.class));
        query.setBuffer("a3", new NativeArray(ctx, bufferSize, Float.class));
        System.out.println("Query submitted: " + (Object)((Object)query.submit()));
        HashMap<String, Pair<Long, Long>> result_el = query.resultBufferElements();
        int[] a1_buff = (int[])query.getBuffer("a1");
        long[] a2_offsets = query.getVarBuffer("a2");
        byte[] a2_data = (byte[])query.getBuffer("a2");
        float[] a3_buff = (float[])query.getBuffer("a3");
        System.out.println("Result num: " + a1_buff.length);
        System.out.println(String.format("%9s", "a1") + String.format("%11s", "a2") + String.format("%11s", "a3[0]") + String.format("%10s", "a3[1]"));
        for (int i = 0; i < a1_buff.length; ++i) {
            int end = i == a1_buff.length - 1 ? a2_data.length : (int)a2_offsets[i + 1];
            System.out.println(String.format("%9s", a1_buff[i]) + String.format("%11s", new String(Arrays.copyOfRange(a2_data, (int)a2_offsets[i], end))) + String.format("%11s", Float.valueOf(a3_buff[2 * i])) + String.format("%10s", Float.valueOf(a3_buff[2 * i + 1])));
        }
    }
}

