/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Enumeration;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Util;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_array_schema_evolution_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_array_schema_evolution_t;
import io.tiledb.libtiledb.tiledb;
import java.math.BigInteger;

public class ArraySchemaEvolution
implements AutoCloseable {
    private Context ctx;
    private SWIGTYPE_p_tiledb_array_schema_evolution_t evolutionp;
    private SWIGTYPE_p_p_tiledb_array_schema_evolution_t evolutionpp;

    public ArraySchemaEvolution(Context ctx, SWIGTYPE_p_p_tiledb_array_schema_evolution_t evolutionpp) {
        this.ctx = ctx;
        this.evolutionp = tiledb.tiledb_array_schema_evolution_tpp_value(evolutionpp);
        this.evolutionpp = evolutionpp;
    }

    public ArraySchemaEvolution(Context ctx) throws TileDBError {
        this.evolutionpp = tiledb.new_tiledb_array_schema_evolution_tpp();
        try {
            ctx.handleError(tiledb.tiledb_array_schema_evolution_alloc(ctx.getCtxp(), this.evolutionpp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_schema_evolution_tpp(this.evolutionpp);
            throw err;
        }
        this.evolutionp = tiledb.tiledb_array_schema_evolution_tpp_value(this.evolutionpp);
        this.ctx = ctx;
    }

    public SWIGTYPE_p_tiledb_array_schema_evolution_t getEvolutionp() {
        return this.evolutionp;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    @Override
    public void close() {
        if (this.evolutionp != null && this.evolutionpp != null) {
            tiledb.tiledb_array_schema_evolution_free(this.evolutionpp);
            tiledb.delete_tiledb_array_schema_evolution_tpp(this.evolutionpp);
            this.evolutionpp = null;
            this.evolutionp = null;
        }
    }

    public void addAttribute(Attribute att) throws TileDBError {
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_evolution_add_attribute(this.ctx.getCtxp(), this.evolutionp, att.getAttributep()));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_schema_evolution_tpp(this.evolutionpp);
            throw err;
        }
    }

    public void dropAttribute(String attName) throws TileDBError {
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_evolution_drop_attribute(this.ctx.getCtxp(), this.evolutionp, attName));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_schema_evolution_tpp(this.evolutionpp);
            throw err;
        }
    }

    public void dropAttribute(Attribute att) throws TileDBError {
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_evolution_drop_attribute(this.ctx.getCtxp(), this.evolutionp, att.getName()));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_schema_evolution_tpp(this.evolutionpp);
            throw err;
        }
    }

    public void setTimeStampRange(BigInteger high, BigInteger low) throws TileDBError {
        Util.checkBigIntegerRange(high);
        Util.checkBigIntegerRange(low);
        this.ctx.handleError(tiledb.tiledb_array_schema_evolution_set_timestamp_range(this.ctx.getCtxp(), this.evolutionp, low, high));
    }

    public void addEnumeration(Enumeration e) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_evolution_add_enumeration(this.ctx.getCtxp(), this.getEvolutionp(), e.getEnumerationp()));
    }

    public void dropEnumeration(String name) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_evolution_drop_enumeration(this.ctx.getCtxp(), this.getEvolutionp(), name));
    }

    public void extendEnumeration(Enumeration enumeration) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_evolution_extend_enumeration(this.ctx.getCtxp(), this.getEvolutionp(), enumeration.getEnumerationp()));
    }

    public void evolveArray(String uri) throws TileDBError {
        try {
            this.ctx.handleError(tiledb.tiledb_array_evolve(this.ctx.getCtxp(), uri, this.evolutionp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_schema_evolution_tpp(this.evolutionpp);
            throw err;
        }
    }
}

