/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Constants;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.FilterList;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.TileDBString;
import io.tiledb.java.api.Types;
import io.tiledb.java.api.Util;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_attribute_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_filter_list_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_string_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_void;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_attribute_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_datatype_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_char;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.tiledb;
import java.lang.reflect.Array;
import java.math.BigInteger;

public class Attribute
implements AutoCloseable {
    private Context ctx;
    private String name;
    private Datatype type;
    private SWIGTYPE_p_tiledb_attribute_t attributep;
    private SWIGTYPE_p_p_tiledb_attribute_t attributepp;

    public Attribute(Context ctx, String name, Class attrType) throws TileDBError {
        Datatype _type;
        SWIGTYPE_p_p_tiledb_attribute_t _attributepp = tiledb.new_tiledb_attribute_tpp();
        try {
            _type = Types.getNativeType(attrType);
            ctx.handleError(tiledb.tiledb_attribute_alloc(ctx.getCtxp(), name, _type.toSwigEnum(), _attributepp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_attribute_tpp(_attributepp);
            throw err;
        }
        this.ctx = ctx;
        this.name = name;
        this.type = _type;
        this.attributep = tiledb.tiledb_attribute_tpp_value(_attributepp);
        this.attributepp = _attributepp;
    }

    public Attribute(Context ctx, String name, Datatype attrType) throws TileDBError {
        SWIGTYPE_p_p_tiledb_attribute_t _attributepp = tiledb.new_tiledb_attribute_tpp();
        try {
            ctx.handleError(tiledb.tiledb_attribute_alloc(ctx.getCtxp(), name, attrType.toSwigEnum(), _attributepp));
        }
        catch (TileDBError error) {
            tiledb.delete_tiledb_attribute_tpp(_attributepp);
        }
        this.ctx = ctx;
        this.name = name;
        this.type = attrType;
        this.attributep = tiledb.tiledb_attribute_tpp_value(_attributepp);
        this.attributepp = _attributepp;
    }

    protected Attribute(Context ctx, SWIGTYPE_p_p_tiledb_attribute_t attributepp) throws TileDBError {
        this.ctx = ctx;
        this.attributep = tiledb.tiledb_attribute_tpp_value(attributepp);
        this.attributepp = attributepp;
    }

    protected SWIGTYPE_p_tiledb_attribute_t getAttributep() {
        return this.attributep;
    }

    public String getName() throws TileDBError {
        if (this.name == null) {
            SWIGTYPE_p_p_char namepp = tiledb.new_charpp();
            try {
                this.ctx.handleError(tiledb.tiledb_attribute_get_name(this.ctx.getCtxp(), this.getAttributep(), namepp));
                this.name = tiledb.charpp_value(namepp);
            }
            finally {
                tiledb.delete_charpp(namepp);
            }
        }
        return this.name;
    }

    public Datatype getType() throws TileDBError {
        if (this.type == null) {
            SWIGTYPE_p_tiledb_datatype_t typep = tiledb.new_tiledb_datatype_tp();
            try {
                this.ctx.handleError(tiledb.tiledb_attribute_get_type(this.ctx.getCtxp(), this.getAttributep(), typep));
                this.type = Datatype.fromSwigEnum(tiledb.tiledb_datatype_tp_value(typep));
            }
            finally {
                tiledb.delete_tiledb_datatype_tp(typep);
            }
        }
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCellSize() throws TileDBError {
        long cellSize;
        SWIGTYPE_p_unsigned_long_long sizep = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_attribute_get_cell_size(this.ctx.getCtxp(), this.getAttributep(), sizep));
            cellSize = tiledb.ullp_value(sizep).longValue();
        }
        finally {
            tiledb.delete_ullp(sizep);
        }
        return cellSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCellValNum() throws TileDBError {
        long cellValNum;
        SWIGTYPE_p_unsigned_int nump = tiledb.new_uintp();
        try {
            this.ctx.handleError(tiledb.tiledb_attribute_get_cell_val_num(this.ctx.getCtxp(), this.getAttributep(), nump));
            cellValNum = tiledb.uintp_value(nump);
        }
        finally {
            tiledb.delete_uintp(nump);
        }
        return cellValNum;
    }

    public boolean isVar() throws TileDBError {
        return this.getCellValNum() == Constants.TILEDB_VAR_NUM;
    }

    public Attribute setCellValNum(long size) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_attribute_set_cell_val_num(this.ctx.getCtxp(), this.attributep, size));
        return this;
    }

    public Attribute setCellVar() throws TileDBError {
        return this.setCellValNum(Constants.TILEDB_VAR_NUM);
    }

    public Attribute setFilterList(FilterList filters) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_attribute_set_filter_list(this.ctx.getCtxp(), this.attributep, filters.getFilterListp()));
        return this;
    }

    public FilterList getFilterList() throws TileDBError {
        FilterList filterlist;
        SWIGTYPE_p_p_tiledb_filter_list_handle_t filterlistpp = tiledb.new_tiledb_filter_list_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_attribute_get_filter_list(this.ctx.getCtxp(), this.attributep, filterlistpp));
            filterlist = new FilterList(this.ctx, filterlistpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_filter_list_tpp(filterlistpp);
            throw err;
        }
        return filterlist;
    }

    public void setFillValue(NativeArray value, BigInteger size) throws TileDBError {
        Util.checkBigIntegerRange(size);
        this.ctx.handleError(tiledb.tiledb_attribute_set_fill_value(this.ctx.getCtxp(), this.attributep, value.toVoidPointer(), size));
    }

    public void setFillValue(Object value) throws TileDBError {
        NativeArray array;
        int byteSize;
        if (value.getClass().isArray()) {
            byteSize = Array.getLength(value) * this.type.getNativeSize();
            array = new NativeArray(this.ctx, value, this.type.javaClass());
        } else {
            byteSize = value instanceof String ? ((String)value).length() : this.type.getNativeSize();
            array = new NativeArray(this.ctx, byteSize, this.type.javaClass());
            array.setItem(0, value);
        }
        this.ctx.handleError(tiledb.tiledb_attribute_set_fill_value(this.ctx.getCtxp(), this.attributep, array.toVoidPointer(), BigInteger.valueOf(byteSize)));
        array.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Object, Integer> getFillValue() throws TileDBError {
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        SWIGTYPE_p_p_void v = tiledb.new_voidpArray(1);
        try {
            this.ctx.handleError(tiledb.tiledb_attribute_get_fill_value(this.ctx.getCtxp(), this.attributep, v, size));
            int byteSize = tiledb.ullp_value(size).intValue();
            int numElements = byteSize / this.type.getNativeSize();
            NativeArray fillValueArray = new NativeArray(this.ctx, this.getType(), v, numElements);
            Object fillValue = this.isVar() || this.getCellValNum() > 1L ? fillValueArray.toJavaArray(numElements) : fillValueArray.getItem(0);
            fillValueArray.close();
            Pair<Object, Integer> pair = new Pair<Object, Integer>(fillValue, byteSize);
            return pair;
        }
        finally {
            tiledb.delete_ullp(size);
            tiledb.delete_voidpArray(v);
        }
    }

    public void setFillValueNullable(NativeArray value, BigInteger size, boolean valid) throws TileDBError {
        Util.checkBigIntegerRange(size);
        this.ctx.handleError(tiledb.tiledb_attribute_set_fill_value_nullable(this.ctx.getCtxp(), this.attributep, value.toVoidPointer(), size, valid ? (short)1 : 0));
    }

    public void setEnumerationName(String name) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_attribute_set_enumeration_name(this.ctx.getCtxp(), this.getAttributep(), name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEnumerationName() throws TileDBError {
        if (this.name != null) {
            return this.name;
        }
        SWIGTYPE_p_p_tiledb_string_handle_t name = tiledb.new_tiledb_string_handle_tpp();
        try (TileDBString ts = null;){
            this.ctx.handleError(tiledb.tiledb_attribute_get_enumeration_name(this.ctx.getCtxp(), this.getAttributep(), name));
            ts = new TileDBString(this.ctx, name);
            String string = ts.getView().getFirst();
            return string;
        }
    }

    public void setFillValueNullable(Object value, boolean valid) throws TileDBError {
        NativeArray array;
        int byteSize;
        if (value.getClass().isArray()) {
            byteSize = Array.getLength(value) * this.type.getNativeSize();
            array = new NativeArray(this.ctx, value, this.type.javaClass());
        } else {
            byteSize = value instanceof String ? ((String)value).length() : this.type.getNativeSize();
            array = new NativeArray(this.ctx, byteSize, this.type.javaClass());
            array.setItem(0, value);
        }
        this.ctx.handleError(tiledb.tiledb_attribute_set_fill_value_nullable(this.ctx.getCtxp(), this.attributep, array.toVoidPointer(), BigInteger.valueOf(byteSize), valid ? (short)1 : 0));
        array.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Object, Pair<Integer, Boolean>> getFillValueNullable() throws TileDBError {
        NativeArray validArr = new NativeArray(this.ctx, 1, Datatype.TILEDB_UINT8);
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        SWIGTYPE_p_p_void v = tiledb.new_voidpArray(1);
        SWIGTYPE_p_unsigned_char valid = validArr.getUint8_tArray().cast();
        try {
            this.ctx.handleError(tiledb.tiledb_attribute_get_fill_value_nullable(this.ctx.getCtxp(), this.attributep, v, size, valid));
            int byteSize = tiledb.ullp_value(size).intValue();
            int numElements = byteSize / this.type.getNativeSize();
            NativeArray fillValueArray = new NativeArray(this.ctx, this.getType(), v, numElements);
            Object fillValue = this.isVar() || this.getCellValNum() > 1L ? fillValueArray.toJavaArray(numElements) : fillValueArray.getItem(0);
            fillValueArray.close();
            boolean validBoolean = validArr.getUint8_tArray().getitem(0) != 0;
            Pair<Object, Pair<Integer, Boolean>> pair = new Pair<Object, Pair<Integer, Boolean>>(fillValue, new Pair<Integer, Boolean>(byteSize, validBoolean));
            return pair;
        }
        finally {
            tiledb.delete_ullp(size);
            tiledb.delete_voidpArray(v);
            validArr.close();
        }
    }

    public void setNullable(boolean isNullable) throws TileDBError {
        short nullable = isNullable ? (short)1 : 0;
        this.ctx.handleError(tiledb.tiledb_attribute_set_nullable(this.ctx.getCtxp(), this.attributep, nullable));
    }

    public boolean getNullable() throws TileDBError {
        NativeArray arr = new NativeArray(this.ctx, 1, Datatype.TILEDB_UINT8);
        SWIGTYPE_p_unsigned_char nullable = arr.getUint8_tArray().cast();
        this.ctx.handleError(tiledb.tiledb_attribute_get_nullable(this.ctx.getCtxp(), this.attributep, nullable));
        boolean result = (Short)arr.getItem(0) == 1;
        arr.close();
        return result;
    }

    public String toString() {
        try {
            return "Attr<" + this.getName() + ',' + (Object)((Object)this.getType()) + ',' + (this.getCellValNum() == Constants.TILEDB_VAR_NUM ? "VAR" : Long.valueOf(this.getCellValNum())) + '>';
        }
        catch (TileDBError err) {
            err.printStackTrace();
            return "";
        }
    }

    @Override
    public void close() {
        if (this.attributep != null) {
            tiledb.tiledb_attribute_free(this.attributepp);
            tiledb.delete_tiledb_attribute_tpp(this.attributepp);
            this.attributep = null;
            this.attributepp = null;
        }
    }
}

