/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Constants;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.FilterList;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Types;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_dimension_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_filter_list_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_void;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_datatype_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_dimension_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.tiledb;

public class Dimension<T>
implements AutoCloseable {
    private Context ctx;
    private Datatype type;
    private String name;
    private Pair<T, T> domain;
    private T tileExtent;
    private SWIGTYPE_p_tiledb_dimension_t dimensionp;
    private SWIGTYPE_p_p_tiledb_dimension_t dimensionpp;

    protected Dimension(Context ctx, SWIGTYPE_p_p_tiledb_dimension_t dimensionpp) {
        this.ctx = ctx;
        this.dimensionpp = dimensionpp;
        this.dimensionp = tiledb.tiledb_dimension_tpp_value(dimensionpp);
    }

    public Dimension(Context ctx, String name, Class<T> type, Pair<T, T> domain, T extent) throws TileDBError {
        this.createImpl(ctx, name, Types.getNativeType(type), domain, extent);
    }

    public Dimension(Context ctx, String name, Datatype type, Pair<T, T> domain, T extent) throws TileDBError {
        this.createImpl(ctx, name, type, domain, extent);
    }

    private void createImpl(Context ctx, String name, Datatype dimType, Pair<T, T> domain, T extent) throws TileDBError {
        SWIGTYPE_p_p_tiledb_dimension_t dimensionpp = tiledb.new_tiledb_dimension_tpp();
        if (dimType.equals((Object)Datatype.TILEDB_STRING_ASCII)) {
            ctx.handleError(tiledb.tiledb_dimension_alloc(ctx.getCtxp(), name, dimType.toSwigEnum(), null, null, dimensionpp));
        } else {
            try (NativeArray domainBuffer = new NativeArray(ctx, 2, dimType);
                 NativeArray tileExtent = new NativeArray(ctx, 1, dimType);){
                domainBuffer.setItem(0, domain.getFirst());
                domainBuffer.setItem(1, domain.getSecond());
                tileExtent.setItem(0, extent);
                ctx.handleError(tiledb.tiledb_dimension_alloc(ctx.getCtxp(), name, dimType.toSwigEnum(), domainBuffer.toVoidPointer(), tileExtent.toVoidPointer(), dimensionpp));
            }
            catch (Exception err) {
                tiledb.delete_tiledb_dimension_tpp(dimensionpp);
                throw err;
            }
        }
        this.ctx = ctx;
        this.name = name;
        this.domain = domain;
        this.tileExtent = extent;
        this.type = dimType;
        this.dimensionp = tiledb.tiledb_dimension_tpp_value(dimensionpp);
        this.dimensionpp = dimensionpp;
    }

    protected SWIGTYPE_p_tiledb_dimension_t getDimensionp() {
        return this.dimensionp;
    }

    public String getName() throws TileDBError {
        if (this.name != null) {
            return this.name;
        }
        SWIGTYPE_p_p_char namepp = tiledb.new_charpp();
        try {
            this.ctx.handleError(tiledb.tiledb_dimension_get_name(this.ctx.getCtxp(), this.dimensionp, namepp));
            String string = this.name = tiledb.charpp_value(namepp);
            return string;
        }
        finally {
            tiledb.delete_charpp(namepp);
        }
    }

    public Datatype getType() throws TileDBError {
        if (this.type != null) {
            return this.type;
        }
        SWIGTYPE_p_tiledb_datatype_t typep = tiledb.new_tiledb_datatype_tp();
        try {
            this.ctx.handleError(tiledb.tiledb_dimension_get_type(this.ctx.getCtxp(), this.dimensionp, typep));
            Datatype datatype = this.type = Datatype.fromSwigEnum(tiledb.tiledb_datatype_tp_value(typep));
            return datatype;
        }
        finally {
            tiledb.delete_tiledb_datatype_tp(typep);
        }
    }

    public Pair<T, T> getDomain() throws TileDBError {
        if (this.domain == null) {
            SWIGTYPE_p_p_void domainArraypp = tiledb.new_voidpArray(1);
            try {
                this.ctx.handleError(tiledb.tiledb_dimension_get_domain(this.ctx.getCtxp(), this.dimensionp, domainArraypp));
            }
            catch (TileDBError err) {
                tiledb.delete_voidpArray(domainArraypp);
                throw err;
            }
            try (NativeArray domainBuffer = new NativeArray(this.ctx, this.getType(), domainArraypp, 2);){
                this.domain = new Pair<Object, Object>(domainBuffer.getItem(0), domainBuffer.getItem(1));
            }
        }
        return this.domain;
    }

    public String domainToStr() throws TileDBError {
        Pair<T, T> d = this.getDomain();
        return "(" + d.getFirst() + ", " + d.getSecond() + ")";
    }

    public T getTileExtent() throws TileDBError {
        if (this.tileExtent == null) {
            SWIGTYPE_p_p_void tileExtentpp = tiledb.new_voidpArray(1);
            try {
                this.ctx.handleError(tiledb.tiledb_dimension_get_tile_extent(this.ctx.getCtxp(), this.dimensionp, tileExtentpp));
            }
            catch (TileDBError err) {
                tiledb.delete_voidpArray(tileExtentpp);
                throw err;
            }
            try (NativeArray tileExtentArray = new NativeArray(this.ctx, this.getType(), tileExtentpp, 1);){
                this.tileExtent = tileExtentArray.getItem(0);
            }
        }
        return this.tileExtent;
    }

    public FilterList getFilterList() throws TileDBError {
        FilterList filterlist;
        SWIGTYPE_p_p_tiledb_filter_list_handle_t filterlistpp = tiledb.new_tiledb_filter_list_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_dimension_get_filter_list(this.ctx.getCtxp(), this.dimensionp, filterlistpp));
            filterlist = new FilterList(this.ctx, filterlistpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_filter_list_tpp(filterlistpp);
            throw err;
        }
        return filterlist;
    }

    public Dimension<T> setFilterList(FilterList filters) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_dimension_set_filter_list(this.ctx.getCtxp(), this.dimensionp, filters.getFilterListp()));
        return this;
    }

    public void setCellValNum(long cellValNum) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_dimension_set_cell_val_num(this.ctx.getCtxp(), this.dimensionp, cellValNum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCellValNum() throws TileDBError {
        SWIGTYPE_p_unsigned_int uint = tiledb.new_uintp();
        try {
            this.ctx.handleError(tiledb.tiledb_dimension_get_cell_val_num(this.ctx.getCtxp(), this.dimensionp, uint));
            long l = tiledb.uintp_value(uint);
            return l;
        }
        finally {
            tiledb.delete_uintp(uint);
        }
    }

    public boolean isVar() throws TileDBError {
        return this.getCellValNum() == Constants.TILEDB_VAR_NUM;
    }

    public String tileExtentToStr() throws TileDBError {
        return this.getTileExtent().toString();
    }

    @Override
    public void close() {
        if (this.dimensionp != null) {
            tiledb.tiledb_dimension_free(this.dimensionpp);
            tiledb.delete_tiledb_dimension_tpp(this.dimensionpp);
            this.dimensionp = null;
            this.dimensionpp = null;
        }
    }
}

