/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.TileDBError;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_dimension_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_domain_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_datatype_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_domain_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.tiledb_datatype_t;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Domain
implements AutoCloseable {
    private Context ctx;
    private List<Dimension> dimensions;
    private SWIGTYPE_p_p_tiledb_domain_t domainpp;
    private SWIGTYPE_p_tiledb_domain_t domainp;

    protected Domain(Context ctx, SWIGTYPE_p_p_tiledb_domain_t domainpp) {
        this.ctx = ctx;
        this.domainpp = domainpp;
        this.domainp = tiledb.tiledb_domain_tpp_value(domainpp);
    }

    public Domain(Context ctx) throws TileDBError {
        SWIGTYPE_p_p_tiledb_domain_t _domainpp = tiledb.new_tiledb_domain_tpp();
        try {
            ctx.handleError(tiledb.tiledb_domain_alloc(ctx.getCtxp(), _domainpp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_domain_tpp(_domainpp);
            throw err;
        }
        this.ctx = ctx;
        this.domainp = tiledb.tiledb_domain_tpp_value(_domainpp);
        this.domainpp = _domainpp;
    }

    protected SWIGTYPE_p_tiledb_domain_t getDomainp() {
        return this.domainp;
    }

    public void dump() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_domain_dump_stdout(this.ctx.getCtxp(), this.domainp));
    }

    public void dump(String filename) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_domain_dump_file(this.ctx.getCtxp(), this.domainp, filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype getType() throws TileDBError {
        SWIGTYPE_p_tiledb_datatype_t typep = tiledb.new_tiledb_datatype_tp();
        try {
            this.ctx.handleError(tiledb.tiledb_domain_get_type(this.ctx.getCtxp(), this.domainp, typep));
            tiledb_datatype_t type = tiledb.tiledb_datatype_tp_value(typep);
            Datatype datatype = Datatype.fromSwigEnum(type);
            return datatype;
        }
        finally {
            tiledb.delete_tiledb_datatype_tp(typep);
        }
    }

    @Deprecated
    public long getRank() throws TileDBError {
        SWIGTYPE_p_unsigned_int np = tiledb.new_uintp();
        try {
            this.ctx.handleError(tiledb.tiledb_domain_get_ndim(this.ctx.getCtxp(), this.domainp, np));
        }
        catch (TileDBError err) {
            tiledb.delete_uintp(np);
            throw err;
        }
        long rank = tiledb.uintp_value(np);
        tiledb.delete_uintp(np);
        return rank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNDim() throws TileDBError {
        SWIGTYPE_p_unsigned_int np = tiledb.new_uintp();
        try {
            this.ctx.handleError(tiledb.tiledb_domain_get_ndim(this.ctx.getCtxp(), this.domainp, np));
            long l = tiledb.uintp_value(np);
            return l;
        }
        finally {
            tiledb.delete_uintp(np);
        }
    }

    public List<Dimension> getDimensions() throws TileDBError {
        if (this.dimensions == null) {
            long rank = this.getNDim();
            this.dimensions = new ArrayList<Dimension>();
            for (long i = 0L; i < rank; ++i) {
                SWIGTYPE_p_p_tiledb_dimension_t dimpp = tiledb.new_tiledb_dimension_tpp();
                try {
                    this.ctx.handleError(tiledb.tiledb_domain_get_dimension_from_index(this.ctx.getCtxp(), this.domainp, i, dimpp));
                }
                catch (TileDBError err) {
                    tiledb.delete_tiledb_dimension_tpp(dimpp);
                    throw err;
                }
                Dimension dim = new Dimension(this.ctx, dimpp);
                this.dimensions.add(dim);
            }
        }
        return new ArrayList<Dimension>(this.dimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDimension(String name) throws TileDBError {
        SWIGTYPE_p_int hasDimension = tiledb.new_intp();
        try {
            this.ctx.handleError(tiledb.tiledb_domain_has_dimension(this.ctx.getCtxp(), this.getDomainp(), name, hasDimension));
            boolean bl = tiledb.intp_value(hasDimension) > 0;
            return bl;
        }
        finally {
            tiledb.delete_intp(hasDimension);
        }
    }

    public Dimension getDimension(String name) throws TileDBError {
        Dimension dim;
        SWIGTYPE_p_p_tiledb_dimension_t dimpp = tiledb.new_tiledb_dimension_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_domain_get_dimension_from_name(this.ctx.getCtxp(), this.getDomainp(), name, dimpp));
            dim = new Dimension(this.ctx, dimpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_dimension_tpp(dimpp);
            throw err;
        }
        return dim;
    }

    public Dimension getDimension(Long idx) throws TileDBError {
        Dimension dim;
        SWIGTYPE_p_p_tiledb_dimension_t dimpp = tiledb.new_tiledb_dimension_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_domain_get_dimension_from_index(this.ctx.getCtxp(), this.getDomainp(), idx, dimpp));
            dim = new Dimension(this.ctx, dimpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_dimension_tpp(dimpp);
            throw err;
        }
        return dim;
    }

    public Dimension getDimension(Integer idx) throws TileDBError {
        return this.getDimension(idx.longValue());
    }

    public Domain addDimension(Dimension dimension) throws TileDBError {
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<Dimension>();
        }
        this.dimensions.add(dimension);
        this.ctx.handleError(tiledb.tiledb_domain_add_dimension(this.ctx.getCtxp(), this.domainp, dimension.getDimensionp()));
        return this;
    }

    public void addDimensions(Collection<Dimension> dims) throws TileDBError {
        for (Dimension d : dims) {
            this.addDimension(d);
        }
    }

    @Override
    public void close() {
        if (this.domainp != null) {
            tiledb.tiledb_domain_free(this.domainpp);
            tiledb.delete_tiledb_domain_tpp(this.domainpp);
            this.domainpp = null;
            this.domainp = null;
        }
    }
}

