/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.MimeType;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.TileDBError;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_array_schema_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long;
import io.tiledb.libtiledb.tiledb;

public class FileStore {
    public static ArraySchema schemaCreate(Context ctx, String uri) throws TileDBError {
        SWIGTYPE_p_p_tiledb_array_schema_t array_schema_pp = tiledb.new_tiledb_array_schema_tpp();
        try {
            ctx.handleError(tiledb.tiledb_filestore_schema_create(ctx.getCtxp(), uri, array_schema_pp));
            return new ArraySchema(ctx, array_schema_pp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_schema_tpp(array_schema_pp);
            throw err;
        }
    }

    public static void uriImport(Context ctx, String filestoreArrayURI, String fileURI, MimeType mimeType) throws TileDBError {
        ctx.handleError(tiledb.tiledb_filestore_uri_import(ctx.getCtxp(), filestoreArrayURI, fileURI, mimeType.toSwigEnum()));
    }

    public static void uriExport(Context ctx, String filestoreArrayURI, String fileURI) throws TileDBError {
        ctx.handleError(tiledb.tiledb_filestore_uri_export(ctx.getCtxp(), fileURI, filestoreArrayURI));
    }

    public static void bufferImport(Context ctx, String arrayUri, NativeArray buffer, long bufferSize, MimeType mimeType) throws TileDBError {
        ctx.handleError(tiledb.tiledb_filestore_buffer_import(ctx.getCtxp(), arrayUri, buffer.toVoidPointer(), bufferSize, mimeType.toSwigEnum()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object bufferExport(Context ctx, String filestoreArrayURI, long offset, int bufferLength) throws TileDBError {
        try (NativeArray buffer = new NativeArray(ctx, bufferLength, Datatype.TILEDB_BLOB);){
            ctx.handleError(tiledb.tiledb_filestore_buffer_export(ctx.getCtxp(), filestoreArrayURI, offset, buffer.toVoidPointer(), bufferLength));
            Object object = buffer.toJavaArray();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSize(Context ctx, String filestoreURI) throws TileDBError {
        SWIGTYPE_p_unsigned_long sizep = tiledb.new_ulp();
        try {
            ctx.handleError(tiledb.tiledb_filestore_size(ctx.getCtxp(), filestoreURI, sizep));
            long l = tiledb.ulp_value(sizep);
            return l;
        }
        finally {
            tiledb.delete_ulp(sizep);
        }
    }
}

