/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Context;
import io.tiledb.java.api.Filter;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.TileDBError;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_filter_t;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.tiledb_filter_option_t;
import io.tiledb.libtiledb.tiledb_filter_type_t;

public class FloatScalingFilter
extends Filter {
    public FloatScalingFilter(Context ctx) throws TileDBError {
        super(ctx, tiledb_filter_type_t.TILEDB_FILTER_SCALE_FLOAT);
    }

    public FloatScalingFilter(Context ctx, double offset, double factor, long byteWidth) throws TileDBError {
        super(ctx, tiledb_filter_type_t.TILEDB_FILTER_SCALE_FLOAT);
        try (NativeArray offsetArray = new NativeArray(ctx, (Object)new double[]{offset}, Double.class);
             NativeArray factorArray = new NativeArray(ctx, (Object)new double[]{factor}, Double.class);
             NativeArray byteWidthArray = new NativeArray(ctx, (Object)new long[]{byteWidth}, Long.class);){
            ctx.handleError(tiledb.tiledb_filter_set_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_SCALE_FLOAT_OFFSET, offsetArray.toVoidPointer()));
            ctx.handleError(tiledb.tiledb_filter_set_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_SCALE_FLOAT_FACTOR, factorArray.toVoidPointer()));
            ctx.handleError(tiledb.tiledb_filter_set_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_SCALE_FLOAT_BYTEWIDTH, byteWidthArray.toVoidPointer()));
        }
        catch (TileDBError err) {
            super.close();
            throw err;
        }
    }

    public void setOffset(Context ctx, double offset) throws TileDBError {
        try (NativeArray offsetArray = new NativeArray(ctx, (Object)new double[]{offset}, Double.class);){
            ctx.handleError(tiledb.tiledb_filter_set_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_SCALE_FLOAT_OFFSET, offsetArray.toVoidPointer()));
        }
        catch (TileDBError err) {
            super.close();
            throw err;
        }
    }

    public void setFactor(Context ctx, double factor) throws TileDBError {
        try (NativeArray offsetArray = new NativeArray(ctx, (Object)new double[]{factor}, Double.class);){
            ctx.handleError(tiledb.tiledb_filter_set_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_SCALE_FLOAT_FACTOR, offsetArray.toVoidPointer()));
        }
        catch (TileDBError err) {
            super.close();
            throw err;
        }
    }

    public void setByteWidth(Context ctx, long byteWidth) throws TileDBError {
        try (NativeArray offsetArray = new NativeArray(ctx, (Object)new long[]{byteWidth}, Long.class);){
            ctx.handleError(tiledb.tiledb_filter_set_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_SCALE_FLOAT_BYTEWIDTH, offsetArray.toVoidPointer()));
        }
        catch (TileDBError err) {
            super.close();
            throw err;
        }
    }

    protected FloatScalingFilter(Context ctx, SWIGTYPE_p_p_tiledb_filter_t filterpp) {
        super(ctx, filterpp);
    }

    public long getByteWidth() throws TileDBError {
        long window;
        Context ctx = this.getCtx();
        try (NativeArray byteWidthArray = new NativeArray(ctx, 1, Long.class);){
            ctx.handleError(tiledb.tiledb_filter_get_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_SCALE_FLOAT_BYTEWIDTH, byteWidthArray.toVoidPointer()));
            window = (Long)byteWidthArray.getItem(0);
        }
        return window;
    }

    public double getFactor() throws TileDBError {
        double window;
        Context ctx = this.getCtx();
        try (NativeArray factorArray = new NativeArray(ctx, 1, Double.class);){
            ctx.handleError(tiledb.tiledb_filter_get_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_SCALE_FLOAT_FACTOR, factorArray.toVoidPointer()));
            window = (Double)factorArray.getItem(0);
        }
        return window;
    }

    public double getOffset() throws TileDBError {
        double window;
        Context ctx = this.getCtx();
        try (NativeArray offsetArray = new NativeArray(ctx, 1, Double.class);){
            ctx.handleError(tiledb.tiledb_filter_get_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_SCALE_FLOAT_OFFSET, offsetArray.toVoidPointer()));
            window = (Double)offsetArray.getItem(0);
        }
        return window;
    }
}

