/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Config;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.QueryChannel;
import io.tiledb.java.api.QueryCondition;
import io.tiledb.java.api.QueryStatus;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.SubArray;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.TileDBString;
import io.tiledb.java.api.Types;
import io.tiledb.java.api.Util;
import io.tiledb.libtiledb.PointerUtils;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_config_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_query_channel_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_query_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_string_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_query_status_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_query_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.Utils;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.uint64_tArray;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Query
implements AutoCloseable {
    private Context ctx;
    private Array array;
    private QueryType type;
    private SWIGTYPE_p_p_tiledb_query_t querypp;
    private SWIGTYPE_p_tiledb_query_t queryp;
    private NativeArray subarray;
    private Map<String, Pair<ByteBuffer, ByteBuffer>> byteBuffers_;
    private Map<String, Pair<NativeArray, NativeArray>> buffers_;
    private Map<String, Pair<uint64_tArray, uint64_tArray>> buffer_sizes_;
    private Map<String, NativeArray> validityByteMaps_;
    private Map<String, ByteBuffer> validityByteMapsByteBuffers_;
    private Map<String, uint64_tArray> validityByteMapSizes_;

    public Query(Array array, QueryType type) throws TileDBError {
        Context _ctx = array.getCtx();
        SWIGTYPE_p_p_tiledb_query_t _querypp = tiledb.new_tiledb_query_tpp();
        try {
            _ctx.handleError(tiledb.tiledb_query_alloc(_ctx.getCtxp(), array.getArrayp(), type.toSwigEnum(), _querypp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_query_tpp(_querypp);
            throw err;
        }
        this.ctx = _ctx;
        this.type = type;
        this.array = array;
        this.querypp = _querypp;
        this.queryp = tiledb.tiledb_query_tpp_value(_querypp);
        this.buffers_ = Collections.synchronizedMap(new HashMap());
        this.byteBuffers_ = Collections.synchronizedMap(new HashMap());
        this.buffer_sizes_ = Collections.synchronizedMap(new HashMap());
        this.validityByteMaps_ = Collections.synchronizedMap(new HashMap());
        this.validityByteMapsByteBuffers_ = Collections.synchronizedMap(new HashMap());
        this.validityByteMapSizes_ = Collections.synchronizedMap(new HashMap());
    }

    public Query(Array array) throws TileDBError {
        this(array, array.getQueryType());
    }

    public synchronized Query setLayout(Layout layout) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_set_layout(this.ctx.getCtxp(), this.queryp, layout.toSwigEnum()));
        return this;
    }

    public QueryStatus getQueryStatus() throws TileDBError {
        QueryStatus status;
        SWIGTYPE_p_tiledb_query_status_t statusp = tiledb.new_tiledb_query_status_tp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_status(this.ctx.getCtxp(), this.queryp, statusp));
            status = QueryStatus.fromSwigEnum(tiledb.tiledb_query_status_tp_value(statusp));
        }
        finally {
            tiledb.delete_tiledb_query_status_tp(statusp);
        }
        return status;
    }

    public QueryStatus submit() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_submit(this.ctx.getCtxp(), this.queryp));
        if (this.type == QueryType.TILEDB_WRITE) {
            return this.getQueryStatus();
        }
        for (String attribute : this.byteBuffers_.keySet()) {
            Datatype datatype;
            boolean isVar;
            boolean isNullable;
            block22: {
                isNullable = false;
                try (ArraySchema arraySchema = this.array.getSchema();){
                    if (arraySchema.hasAttribute(attribute)) {
                        try (Attribute attr = arraySchema.getAttribute(attribute);){
                            isVar = attr.isVar();
                            isNullable = attr.getNullable();
                            datatype = attr.getType();
                            break block22;
                        }
                    }
                    try (Dimension dim = arraySchema.getDomain().getDimension(attribute);){
                        isVar = dim.isVar();
                        datatype = dim.getType();
                    }
                }
            }
            int nbytes = this.buffer_sizes_.get(attribute).getSecond().getitem(0).intValue();
            this.byteBuffers_.get(attribute).getSecond().limit(nbytes);
            if (isVar) {
                int offset_nbytes = this.buffer_sizes_.get(attribute).getFirst().getitem(0).intValue();
                this.byteBuffers_.get(attribute).getFirst().limit(offset_nbytes);
            }
            if (!isNullable) continue;
            int validity_nbytes = nbytes / datatype.getNativeSize();
            this.validityByteMapsByteBuffers_.get(attribute).limit(validity_nbytes);
        }
        return this.getQueryStatus();
    }

    public QueryStatus submitAndFinalize() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_submit_and_finalize(this.ctx.getCtxp(), this.queryp));
        for (String attribute : this.byteBuffers_.keySet()) {
            Datatype datatype;
            boolean isVar;
            boolean isNullable;
            block21: {
                isNullable = false;
                try (ArraySchema arraySchema = this.array.getSchema();){
                    if (arraySchema.hasAttribute(attribute)) {
                        try (Attribute attr = arraySchema.getAttribute(attribute);){
                            isVar = attr.isVar();
                            isNullable = attr.getNullable();
                            datatype = attr.getType();
                            break block21;
                        }
                    }
                    try (Dimension dim = arraySchema.getDomain().getDimension(attribute);){
                        isVar = dim.isVar();
                        datatype = dim.getType();
                    }
                }
            }
            int nbytes = this.buffer_sizes_.get(attribute).getSecond().getitem(0).intValue();
            this.byteBuffers_.get(attribute).getSecond().limit(nbytes);
            if (isVar) {
                int offset_nbytes = this.buffer_sizes_.get(attribute).getFirst().getitem(0).intValue();
                this.byteBuffers_.get(attribute).getFirst().limit(offset_nbytes);
            }
            if (!isNullable) continue;
            int validity_nbytes = nbytes / datatype.getNativeSize();
            this.validityByteMapsByteBuffers_.get(attribute).limit(validity_nbytes);
        }
        return this.getQueryStatus();
    }

    public synchronized Query setSubarray(SubArray subarray) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_set_subarray_t(this.ctx.getCtxp(), this.queryp, subarray.getSubArrayp()));
        return this;
    }

    public synchronized Query setSubarray(ByteBuffer subarray) throws TileDBError {
        this.ctx.handleError(Utils.tiledb_query_set_subarray_nio(this.ctx.getCtxp(), this.queryp, subarray));
        return this;
    }

    public void addUpdateValue(String column, NativeArray value, BigInteger updateValueSize) throws TileDBError {
        Util.checkBigIntegerRange(updateValueSize);
        this.ctx.handleError(tiledb.tiledb_query_add_update_value(this.ctx.getCtxp(), this.queryp, column, value.toVoidPointer(), updateValueSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getEstResultSize(Context ctx, String column) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        try {
            ctx.handleError(tiledb.tiledb_query_get_est_result_size(ctx.getCtxp(), this.queryp, column, size));
            long l = tiledb.ullp_value(size).longValue();
            return l;
        }
        finally {
            tiledb.delete_ullp(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRelevantFragmentNum() throws TileDBError {
        SWIGTYPE_p_unsigned_long_long num = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_relevant_fragment_num(this.ctx.getCtxp(), this.queryp, num));
            long l = tiledb.ullp_value(num).longValue();
            return l;
        }
        finally {
            tiledb.delete_ullp(num);
        }
    }

    public QueryChannel getDefaultChannel() throws TileDBError {
        SWIGTYPE_p_p_tiledb_query_channel_t queryChannelpp = tiledb.new_tiledb_query_channel_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_default_channel(this.ctx.getCtxp(), this.queryp, queryChannelpp));
            return new QueryChannel(this.ctx, queryChannelpp);
        }
        catch (TileDBError error) {
            tiledb.delete_tiledb_query_channel_tpp(queryChannelpp);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Pair<Long, Long> getEstResultSizeVar(Context ctx, String column) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long offsetsSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long dataSize = tiledb.new_ullp();
        try {
            ctx.handleError(tiledb.tiledb_query_get_est_result_size_var(ctx.getCtxp(), this.queryp, column, offsetsSize, dataSize));
            Pair<Long, Long> pair = new Pair<Long, Long>(tiledb.ullp_value(offsetsSize).longValue(), tiledb.ullp_value(dataSize).longValue());
            return pair;
        }
        finally {
            tiledb.delete_ullp(offsetsSize);
            tiledb.delete_ullp(dataSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Pair<Pair<Long, Long>, Long> getEstResultSizeVarNullable(Context ctx, String column) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long offsets = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long validity = tiledb.new_ullp();
        try {
            ctx.handleError(tiledb.tiledb_query_get_est_result_size_var_nullable(ctx.getCtxp(), this.queryp, column, offsets, size, validity));
            Pair<Pair<Long, Long>, Long> pair = new Pair<Pair<Long, Long>, Long>(new Pair<Long, Long>(tiledb.ullp_value(offsets).longValue(), tiledb.ullp_value(size).longValue()), tiledb.ullp_value(validity).longValue());
            return pair;
        }
        finally {
            tiledb.delete_ullp(size);
            tiledb.delete_ullp(offsets);
            tiledb.delete_ullp(validity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Pair<Long, Long> getEstResultSizeNullable(Context ctx, String column) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long validity = tiledb.new_ullp();
        try {
            ctx.handleError(tiledb.tiledb_query_get_est_result_size_nullable(ctx.getCtxp(), this.queryp, column, size, validity));
            Pair<Long, Long> pair = new Pair<Long, Long>(tiledb.ullp_value(size).longValue(), tiledb.ullp_value(validity).longValue());
            return pair;
        }
        finally {
            tiledb.delete_ullp(size);
            tiledb.delete_ullp(validity);
        }
    }

    @Deprecated
    public synchronized Query setBuffer(String attr, NativeArray data) throws TileDBError {
        this.setDataBuffer(attr, data);
        return this;
    }

    @Deprecated
    public synchronized Query setBuffer(String attr, NativeArray offsets, NativeArray data) throws TileDBError {
        this.setDataBuffer(attr, data);
        this.setOffsetsBuffer(attr, offsets);
        return this;
    }

    @Deprecated
    public synchronized Query setBufferNullable(String attr, NativeArray data, NativeArray bytemap) throws TileDBError {
        this.setDataBuffer(attr, data);
        this.setValidityBuffer(attr, bytemap);
        return this;
    }

    @Deprecated
    public synchronized Query setBufferNullable(String attr, NativeArray offsets, NativeArray data, NativeArray bytemap) throws TileDBError {
        this.setDataBuffer(attr, data);
        this.setOffsetsBuffer(attr, offsets);
        this.setValidityBuffer(attr, bytemap);
        return this;
    }

    @Deprecated
    public synchronized Query setBuffer(String attr, long bufferElements) throws TileDBError {
        this.setDataBuffer(attr, bufferElements);
        return this;
    }

    public synchronized Query setDataBuffer(String attr, NativeArray buffer) throws TileDBError {
        block24: {
            try (ArraySchema schema = this.array.getSchema();
                 Domain domain = schema.getDomain();){
                if (domain.hasDimension(attr)) {
                    Dimension dim = domain.getDimension(attr);
                    Types.typeCheck(dim.getType(), buffer.getNativeType());
                    dim.close();
                    break block24;
                }
                try (Attribute attribute = schema.getAttribute(attr);){
                    Types.typeCheck(attribute.getType(), buffer.getNativeType());
                }
            }
        }
        uint64_tArray values_array_size = new uint64_tArray(1);
        values_array_size.setitem(0, BigInteger.valueOf(buffer.getNBytes()));
        if (this.buffers_.containsKey(attr)) {
            this.buffers_.get(attr).getSecond().close();
            Pair<NativeArray, NativeArray> prev_buffers = this.buffers_.get(attr);
            if (prev_buffers.getSecond() != null) {
                prev_buffers.getSecond().close();
            }
            prev_buffers.setSecond(buffer);
        } else {
            this.buffers_.put(attr, new Pair<Object, NativeArray>(null, buffer));
        }
        if (this.buffer_sizes_.containsKey(attr)) {
            Pair<uint64_tArray, uint64_tArray> prev_buffer_sizes = this.buffer_sizes_.get(attr);
            prev_buffer_sizes.setSecond(values_array_size);
        } else {
            this.buffer_sizes_.put(attr, new Pair<Object, uint64_tArray>(null, values_array_size));
        }
        this.ctx.handleError(tiledb.tiledb_query_set_data_buffer(this.ctx.getCtxp(), this.queryp, attr, buffer.toVoidPointer(), values_array_size.cast()));
        return this;
    }

    public synchronized Query setDataBuffer(String attr, NativeArray buffer, long bufferElements) throws TileDBError {
        block26: {
            if (bufferElements <= 0L) {
                throw new TileDBError("Number of buffer elements must be >= 1");
            }
            if (bufferElements > (long)buffer.getSize()) {
                throw new TileDBError("Number of elements requested exceeds the number of elements in allocated buffer: " + bufferElements + " > " + buffer.getSize());
            }
            try (ArraySchema schema = this.array.getSchema();
                 Domain domain = schema.getDomain();){
                if (domain.hasDimension(attr)) {
                    Dimension dim = domain.getDimension(attr);
                    Types.typeCheck(dim.getType(), buffer.getNativeType());
                    dim.close();
                    break block26;
                }
                try (Attribute attribute = schema.getAttribute(attr);){
                    Types.typeCheck(attribute.getType(), buffer.getNativeType());
                }
            }
        }
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(0L));
        values_array_size.setitem(0, BigInteger.valueOf(bufferElements * (long)buffer.getNativeTypeSize()));
        if (this.buffers_.containsKey(attr)) {
            this.buffers_.get(attr).getSecond().close();
            Pair<NativeArray, NativeArray> prev_buffers = this.buffers_.get(attr);
            if (prev_buffers.getSecond() != null) {
                prev_buffers.getSecond().close();
            }
            prev_buffers.setSecond(buffer);
        } else {
            this.buffers_.put(attr, new Pair<Object, NativeArray>(null, buffer));
        }
        if (this.buffer_sizes_.containsKey(attr)) {
            Pair<uint64_tArray, uint64_tArray> prev_buffer_sizes = this.buffer_sizes_.get(attr);
            prev_buffer_sizes.setSecond(values_array_size);
        } else {
            this.buffer_sizes_.put(attr, new Pair<Object, uint64_tArray>(null, values_array_size));
        }
        this.ctx.handleError(tiledb.tiledb_query_set_data_buffer(this.ctx.getCtxp(), this.queryp, attr, buffer.toVoidPointer(), values_array_size.cast()));
        return this;
    }

    public synchronized Query setValidityBuffer(String attr, NativeArray bytemap) throws TileDBError {
        uint64_tArray buffer_validity_bytemap_size = new uint64_tArray(1);
        buffer_validity_bytemap_size.setitem(0, BigInteger.valueOf(bytemap.getNBytes()));
        if (this.validityByteMaps_.containsKey(attr)) {
            NativeArray byteMap = this.validityByteMaps_.get(attr);
            if (byteMap != null) {
                byteMap.close();
            }
            this.validityByteMaps_.put(attr, bytemap);
        } else {
            this.validityByteMaps_.put(attr, bytemap);
        }
        this.validityByteMapSizes_.put(attr, buffer_validity_bytemap_size);
        this.ctx.handleError(tiledb.tiledb_query_set_validity_buffer(this.ctx.getCtxp(), this.queryp, attr, bytemap.getUint8_tArray().cast(), buffer_validity_bytemap_size.cast()));
        return this;
    }

    public synchronized Query setValidityBuffer(String attr, ByteBuffer buffer) throws TileDBError {
        if (buffer.capacity() <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        if (!buffer.isDirect()) {
            throw new TileDBError("The ByteBuffer provided is not direct. Please provide a direct buffer (ByteBuffer.allocateDirect(...))");
        }
        if (!buffer.order().equals(ByteOrder.nativeOrder())) {
            throw new TileDBError("The order of the data ByteBuffer should be the same as the native order (ByteOrder.nativeOrder()).");
        }
        uint64_tArray buffer_validity_bytemap_size = new uint64_tArray(1);
        buffer_validity_bytemap_size.setitem(0, BigInteger.valueOf(buffer.capacity()));
        if (this.validityByteMaps_.containsKey(attr)) {
            NativeArray prevBuff = this.validityByteMaps_.get(attr);
            prevBuff.close();
        }
        this.validityByteMapsByteBuffers_.put(attr, buffer);
        this.validityByteMapSizes_.put(attr, buffer_validity_bytemap_size);
        this.ctx.handleError(Utils.tiledb_query_set_validity_buffer_nio(this.ctx.getCtxp(), this.queryp, attr, buffer, buffer_validity_bytemap_size.cast()));
        return this;
    }

    public synchronized Query setOffsetsBuffer(String attr, ByteBuffer buffer) throws TileDBError {
        Pair<Object, Object> prev_buffers;
        if (buffer.capacity() <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        if (!buffer.isDirect()) {
            throw new TileDBError("The ByteBuffer provided is not direct. Please provide a direct buffer (ByteBuffer.allocateDirect(...))");
        }
        if (!buffer.order().equals(ByteOrder.nativeOrder())) {
            throw new TileDBError("The order of the data ByteBuffer should be the same as the native order (ByteOrder.nativeOrder()).");
        }
        uint64_tArray offsets_buffer_size = new uint64_tArray(1);
        offsets_buffer_size.setitem(0, BigInteger.valueOf(buffer.capacity()));
        if (this.buffers_.containsKey(attr)) {
            prev_buffers = this.buffers_.get(attr);
            prev_buffers.getFirst().close();
            prev_buffers.getSecond().close();
        }
        if (this.byteBuffers_.containsKey(attr)) {
            prev_buffers = this.byteBuffers_.get(attr);
            prev_buffers.setFirst((NativeArray)((Object)buffer));
        } else {
            this.byteBuffers_.put(attr, new Pair<ByteBuffer, Object>(buffer, null));
        }
        if (this.buffer_sizes_.containsKey(attr)) {
            Pair<uint64_tArray, uint64_tArray> prev_buffer_sizes = this.buffer_sizes_.get(attr);
            prev_buffer_sizes.setFirst(offsets_buffer_size);
        } else {
            this.buffer_sizes_.put(attr, new Pair<uint64_tArray, Object>(offsets_buffer_size, null));
        }
        this.ctx.handleError(Utils.tiledb_query_set_offsets_buffer_nio(this.ctx.getCtxp(), this.queryp, attr, buffer, offsets_buffer_size.cast()));
        return this;
    }

    public synchronized Query setDataBuffer(String attr, long bufferElements) throws TileDBError {
        if (bufferElements <= 0L) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        Datatype dt = Util.getFieldDatatype(this.array, attr);
        int size = Util.castLongToInt(bufferElements * (long)dt.getNativeSize());
        ByteBuffer buffer = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        this.setDataBuffer(attr, buffer);
        return this;
    }

    public synchronized Query setDataBuffer(String attr, ByteBuffer buffer) throws TileDBError {
        if (buffer.capacity() <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        if (!buffer.isDirect()) {
            throw new TileDBError("The ByteBuffer provided is not direct. Please provide a direct buffer (ByteBuffer.allocateDirect(...))");
        }
        if (!buffer.order().equals(ByteOrder.nativeOrder())) {
            throw new TileDBError("The order of the data ByteBuffer should be the same as the native order (ByteOrder.nativeOrder()).");
        }
        uint64_tArray values_array_size = new uint64_tArray(1);
        values_array_size.setitem(0, BigInteger.valueOf(buffer.capacity()));
        if (this.byteBuffers_.containsKey(attr)) {
            Pair<ByteBuffer, ByteBuffer> prev_buffers = this.byteBuffers_.get(attr);
            prev_buffers.setSecond(buffer);
        } else {
            this.byteBuffers_.put(attr, new Pair<Object, ByteBuffer>(null, buffer));
        }
        if (this.buffer_sizes_.containsKey(attr)) {
            Pair<uint64_tArray, uint64_tArray> prev_buffer_sizes = this.buffer_sizes_.get(attr);
            prev_buffer_sizes.setSecond(values_array_size);
        } else {
            this.buffer_sizes_.put(attr, new Pair<Object, uint64_tArray>(null, values_array_size));
        }
        this.ctx.handleError(Utils.tiledb_query_set_data_buffer_nio(this.ctx.getCtxp(), this.queryp, attr, buffer, values_array_size.cast()));
        return this;
    }

    public synchronized Query setOffsetsBuffer(String attr, NativeArray offsets) throws TileDBError {
        if (!offsets.getNativeType().equals((Object)Datatype.TILEDB_UINT64)) {
            throw new TileDBError("Buffer offsets should be of getType TILEDB_UINT64. Found getType: " + (Object)((Object)offsets.getNativeType()));
        }
        uint64_tArray offsets_array = PointerUtils.uint64_tArrayFromVoid(offsets.toVoidPointer());
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(offsets.getNBytes()));
        if (this.buffers_.containsKey(attr)) {
            Pair<NativeArray, NativeArray> prev_buffers = this.buffers_.get(attr);
            if (prev_buffers.getFirst() != null) {
                prev_buffers.getFirst().close();
            }
            prev_buffers.setFirst(offsets);
        } else {
            this.buffers_.put(attr, new Pair<NativeArray, Object>(offsets, null));
        }
        if (this.buffer_sizes_.containsKey(attr)) {
            Pair<uint64_tArray, uint64_tArray> prev_buffer_sizes = this.buffer_sizes_.get(attr);
            prev_buffer_sizes.setFirst(offsets_array_size);
        } else {
            this.buffer_sizes_.put(attr, new Pair<uint64_tArray, Object>(offsets_array_size, null));
        }
        this.ctx.handleError(tiledb.tiledb_query_set_offsets_buffer(this.ctx.getCtxp(), this.queryp, attr, offsets_array.cast(), offsets_array_size.cast()));
        return this;
    }

    private Query setBufferSizeUnsafe(String attribute, long offsetSize, long bufferSize) {
        this.buffer_sizes_.get(attribute).getFirst().setitem(0, BigInteger.valueOf(offsetSize));
        this.buffer_sizes_.get(attribute).getSecond().setitem(0, BigInteger.valueOf(bufferSize));
        return this;
    }

    public synchronized Query setBufferByteSize(String attribute, Long offsetSize, Long bufferSize) throws TileDBError {
        if (!this.buffers_.containsKey(attribute)) {
            throw new TileDBError("Query var attribute buffer does not exist: " + attribute);
        }
        if (offsetSize <= 0L || bufferSize <= 0L) {
            throw new TileDBError("Number of buffer bytes must be >= 1");
        }
        Pair<NativeArray, NativeArray> varBuffers = this.buffers_.get(attribute);
        NativeArray offsetBuffer = varBuffers.getFirst();
        Long offsetNBytes = offsetBuffer.getNBytes();
        NativeArray buffer = varBuffers.getSecond();
        Long bufferNBytes = buffer.getNBytes();
        if (offsetSize > offsetNBytes) {
            throw new TileDBError("Number of offset bytes requested exceeds the number bytes of in allocated offset buffer: " + offsetNBytes + " > " + offsetSize);
        }
        if (bufferSize > bufferNBytes) {
            throw new TileDBError("Number of buffer bytes requested exceeds the number of bytes in allocated buffer" + bufferNBytes + " > " + bufferSize);
        }
        return this.setBufferSizeUnsafe(attribute, offsetSize, bufferSize);
    }

    public synchronized Query setBufferByteSize(String attribute, Long bufferSize) throws TileDBError {
        if (!this.buffers_.containsKey(attribute)) {
            throw new TileDBError("Query attrbute buffer does not exist: " + attribute);
        }
        if (bufferSize <= 0L) {
            throw new TileDBError("Number of buffer bytes must be >= 1");
        }
        NativeArray buffer = this.buffers_.get(attribute).getSecond();
        Long bufferNBytes = buffer.getNBytes();
        if (bufferSize > bufferNBytes) {
            throw new TileDBError("Number of bytes requested exceeds the number of bytes in allocated buffer: " + bufferSize + " > " + bufferNBytes);
        }
        return this.setBufferSizeUnsafe(attribute, 0L, bufferSize);
    }

    public synchronized Query setBufferElements(String attribute, Integer bufferElements) throws TileDBError {
        if (!this.buffers_.containsKey(attribute)) {
            throw new TileDBError("Query attribute buffer does not exist: " + attribute);
        }
        if (bufferElements <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        NativeArray buffer = this.buffers_.get(attribute).getSecond();
        Integer bufferSize = buffer.getSize();
        if (bufferElements > bufferSize) {
            throw new TileDBError("Number of elements requested exceeds the number of elements in allocated buffer: " + bufferElements + " > " + bufferSize);
        }
        return this.setBufferSizeUnsafe(attribute, 0L, bufferElements * buffer.getNativeTypeSize());
    }

    public synchronized Query setBufferElements(String attribute, Integer offsetElements, Integer bufferElements) throws TileDBError {
        if (!this.buffers_.containsKey(attribute)) {
            throw new TileDBError("Query var attribute buffer does not exist: " + attribute);
        }
        if (offsetElements <= 0 || bufferElements <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        Pair<NativeArray, NativeArray> varBuffers = this.buffers_.get(attribute);
        NativeArray offsetBuffer = varBuffers.getFirst();
        Integer offsetSize = offsetBuffer.getSize();
        NativeArray buffer = varBuffers.getSecond();
        Integer bufferSize = buffer.getSize();
        if (offsetElements > offsetSize) {
            throw new TileDBError("Number of offset elements requested exceeds the number of elements in allocated offset buffer: " + offsetElements + " > " + offsetSize);
        }
        if (bufferElements > bufferSize) {
            throw new TileDBError("Number of buffer elements requested exceeds the number of elements in allocated buffer" + bufferElements + " > " + bufferSize);
        }
        return this.setBufferSizeUnsafe(attribute, offsetElements * offsetBuffer.getNativeTypeSize(), bufferElements * buffer.getNativeTypeSize());
    }

    public Pair<Long, Long> resultBufferElementsNIO(String name, int typeSize) throws TileDBError {
        Pair<ByteBuffer, ByteBuffer> entry = this.byteBuffers_.get(name);
        if (entry.getFirst() == null) {
            BigInteger val_nbytes = this.buffer_sizes_.get(name).getSecond().getitem(0);
            Long nelements = val_nbytes.divide(BigInteger.valueOf(typeSize)).longValue();
            return new Pair<Long, Long>(0L, nelements);
        }
        Pair<uint64_tArray, uint64_tArray> buffer_size = this.buffer_sizes_.get(name);
        BigInteger off_nbytes = buffer_size.getFirst().getitem(0);
        int divisor = 8;
        if (Integer.parseInt(this.getConfig().get("sm.var_offsets.bitsize")) == 32) {
            divisor = 4;
        }
        Long off_nelements = off_nbytes.divide(BigInteger.valueOf(divisor)).longValue();
        BigInteger val_nbytes = buffer_size.getSecond().getitem(0);
        Long val_nelements = val_nbytes.divide(BigInteger.valueOf(typeSize)).longValue();
        return new Pair<Long, Long>(off_nelements, val_nelements);
    }

    public HashMap<String, Pair<Long, Long>> resultBufferElements() throws TileDBError {
        HashMap<String, Pair<Long, Long>> result = new HashMap<String, Pair<Long, Long>>();
        for (Map.Entry<String, Pair<NativeArray, NativeArray>> entry : this.buffers_.entrySet()) {
            String name = entry.getKey();
            if (entry.getValue().getFirst() == null) {
                NativeArray val_buffer = entry.getValue().getSecond();
                BigInteger val_nbytes = this.buffer_sizes_.get(name).getSecond().getitem(0);
                Long nelements = val_nbytes.divide(BigInteger.valueOf(val_buffer.getNativeTypeSize())).longValue();
                result.put(name, new Pair<Long, Long>(0L, nelements));
                continue;
            }
            Pair<uint64_tArray, uint64_tArray> buffer_size = this.buffer_sizes_.get(name);
            NativeArray off_buffer = entry.getValue().getFirst();
            BigInteger off_nbytes = buffer_size.getFirst().getitem(0);
            Long off_nelements = off_nbytes.divide(BigInteger.valueOf(off_buffer.getNativeTypeSize())).longValue();
            NativeArray val_buffer = entry.getValue().getSecond();
            BigInteger val_nbytes = buffer_size.getSecond().getitem(0);
            Long val_nelements = val_nbytes.divide(BigInteger.valueOf(val_buffer.getNativeTypeSize())).longValue();
            result.put(name, new Pair<Long, Long>(off_nelements, val_nelements));
        }
        return result;
    }

    public HashMap<String, Pair<Long, Long>> resultBufferSizes() throws TileDBError {
        HashMap<String, Pair<Long, Long>> result = new HashMap<String, Pair<Long, Long>>();
        for (String string : this.buffers_.keySet()) {
            BigInteger val_nbytes = this.buffer_sizes_.get(string).getSecond().getitem(0);
            result.put(string, new Pair<Long, Long>(0L, val_nbytes.longValue()));
        }
        for (Map.Entry entry : this.buffers_.entrySet()) {
            String name = (String)entry.getKey();
            Pair<uint64_tArray, uint64_tArray> buffer_size = this.buffer_sizes_.get(name);
            BigInteger off_nbytes = buffer_size.getFirst().getitem(0);
            BigInteger val_nbytes = buffer_size.getSecond().getitem(0);
            result.put(name, new Pair<Long, Long>(off_nbytes.longValue(), val_nbytes.longValue()));
        }
        return result;
    }

    public synchronized void resetBuffers() {
        for (Pair<NativeArray, NativeArray> pair : this.buffers_.values()) {
            if (pair.getFirst() != null) {
                pair.getFirst().close();
            }
            if (pair.getSecond() == null) continue;
            pair.getSecond().close();
        }
        for (Pair<Object, Object> pair : this.byteBuffers_.values()) {
            if (pair.getFirst() != null) {
                ((ByteBuffer)pair.getFirst()).clear();
            }
            if (pair.getSecond() == null) continue;
            ((ByteBuffer)pair.getSecond()).clear();
        }
        for (NativeArray nativeArray : this.validityByteMaps_.values()) {
            if (nativeArray == null) continue;
            nativeArray.close();
        }
        for (ByteBuffer byteBuffer : this.validityByteMapsByteBuffers_.values()) {
            if (byteBuffer == null) continue;
            byteBuffer.clear();
        }
        this.byteBuffers_.clear();
        this.buffers_.clear();
        this.validityByteMapsByteBuffers_.clear();
        this.validityByteMaps_.clear();
        for (Pair pair : this.buffer_sizes_.values()) {
            if (pair.getFirst() != null) {
                ((uint64_tArray)pair.getFirst()).delete();
            }
            if (pair.getSecond() == null) continue;
            ((uint64_tArray)pair.getSecond()).delete();
        }
        this.buffer_sizes_.clear();
        for (uint64_tArray uint64_tArray2 : this.validityByteMapSizes_.values()) {
            if (uint64_tArray2 == null) continue;
            uint64_tArray2.delete();
        }
        this.validityByteMapSizes_.clear();
    }

    public synchronized Query resetBufferSizes(Long val) {
        BigInteger sizeVal = BigInteger.valueOf(val);
        for (Pair<uint64_tArray, uint64_tArray> size_pair : this.buffer_sizes_.values()) {
            size_pair.getFirst().setitem(0, sizeVal);
            size_pair.getSecond().setitem(0, sizeVal);
        }
        return this;
    }

    public Query resetBufferSizes() {
        return this.resetBufferSizes(0L);
    }

    public Object getBuffer(String bufferName) throws TileDBError {
        if (this.buffers_.containsKey(bufferName)) {
            NativeArray buffer = this.buffers_.get(bufferName).getSecond();
            Integer nelements = this.buffer_sizes_.get(bufferName).getSecond().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
            return buffer.toJavaArray(nelements);
        }
        throw new TileDBError("Query attribute buffer does not exist: " + bufferName);
    }

    public Pair<ByteBuffer, ByteBuffer> getBufferNIO(String attr) throws TileDBError {
        if (this.byteBuffers_.containsKey(attr)) {
            return this.byteBuffers_.get(attr);
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + attr);
    }

    @Deprecated
    public Pair<ByteBuffer, ByteBuffer> getByteBuffer(String attr) throws TileDBError {
        return this.getBufferNIO(attr);
    }

    @Deprecated
    public long[] getVarBuffer(String bufferName) throws TileDBError {
        return this.getOffsetsBuffer(bufferName);
    }

    public long[] getOffsetsBuffer(String bufferName) throws TileDBError {
        if (!this.buffers_.containsKey(bufferName)) {
            throw new TileDBError("Query variable attribute buffer does not exist: " + bufferName);
        }
        NativeArray buffer = this.buffers_.get(bufferName).getFirst();
        Integer nelements = this.buffer_sizes_.get(bufferName).getFirst().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
        return (long[])buffer.toJavaArray(nelements);
    }

    public Pair<LongBuffer, IntBuffer> getIntBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Integer.class) {
            throw new TileDBError("IntBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
            }
            return new Pair<LongBuffer, IntBuffer>(offsets, buffer.getSecond().asIntBuffer());
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public Pair<LongBuffer, LongBuffer> getLongBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Long.class) {
            throw new TileDBError("LongBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            return new Pair<LongBuffer, LongBuffer>(buffer.getFirst().asLongBuffer(), buffer.getSecond().asLongBuffer());
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public Pair<LongBuffer, ShortBuffer> getShortBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Short.class) {
            throw new TileDBError("ShortBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
            }
            return new Pair<LongBuffer, ShortBuffer>(offsets, buffer.getSecond().asShortBuffer());
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public Pair<LongBuffer, CharBuffer> getCharBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Byte.class) {
            throw new TileDBError("CharBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
            }
            Charset charset = StandardCharsets.US_ASCII;
            CharBuffer charBuffer = charset.decode(buffer.getSecond());
            return new Pair<LongBuffer, CharBuffer>(offsets, charBuffer);
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public Pair<LongBuffer, FloatBuffer> getFloatBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Float.class) {
            throw new TileDBError("FloatBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
            }
            return new Pair<LongBuffer, FloatBuffer>(offsets, buffer.getSecond().asFloatBuffer());
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public Pair<LongBuffer, DoubleBuffer> getDoubleBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Double.class) {
            throw new TileDBError("DoubleBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
            }
            return new Pair<LongBuffer, DoubleBuffer>(offsets, buffer.getSecond().asDoubleBuffer());
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public byte[] getByteArray(String bufferName) throws TileDBError {
        ByteBuffer buffer = this.byteBuffers_.get(bufferName).getSecond();
        if (this.byteBuffers_.containsKey(bufferName)) {
            byte[] bytes = new byte[buffer.limit()];
            int idx = 0;
            while (buffer.hasRemaining()) {
                bytes[idx++] = buffer.get();
            }
            buffer.flip();
            return bytes;
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public long[] getOffsetsBufferNIO(String bufferName) throws TileDBError {
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
                long[] offsetArr = new long[offsets.limit()];
                int idx = 0;
                while (offsets.hasRemaining()) {
                    offsetArr[idx++] = offsets.get();
                }
                return offsetArr;
            }
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    @Deprecated
    public long[] getOffsetArray(String bufferName) throws TileDBError {
        return this.getOffsetsBufferNIO(bufferName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlan() throws TileDBError {
        SWIGTYPE_p_p_tiledb_string_handle_t plan = tiledb.new_tiledb_string_handle_tpp();
        try (TileDBString ts = null;){
            this.ctx.handleError(tiledb.tiledb_query_get_plan(this.ctx.getCtxp(), this.queryp, plan));
            ts = new TileDBString(this.ctx, plan);
            String string = ts.getView().getFirst();
            return string;
        }
    }

    public short[] getValidityBuffer(String attribute) throws TileDBError {
        if (this.validityByteMaps_.containsKey(attribute)) {
            int nelements = this.validityByteMapSizes_.get(attribute).getitem(0).divide(BigInteger.valueOf(Datatype.TILEDB_UINT8.getNativeSize())).intValue();
            return (short[])this.validityByteMaps_.get(attribute).toJavaArray(nelements);
        }
        throw new TileDBError("Attribute " + attribute + " is not nullable");
    }

    @Deprecated
    public short[] getValidityByteMap(String attribute) throws TileDBError {
        return this.getValidityBuffer(attribute);
    }

    public HashMap<String, Pair<Long, Long>> getResultEstimations() throws TileDBError {
        HashMap<String, Pair<Long, Long>> estimations = new HashMap<String, Pair<Long, Long>>();
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            String name;
            for (Dimension dimension : domain.getDimensions()) {
                name = dimension.getName();
                if (dimension.isVar()) {
                    estimations.put(name, this.getEstResultSizeVar(this.ctx, name));
                } else {
                    estimations.put(name, new Pair<Object, Long>(null, this.getEstResultSize(this.ctx, name)));
                }
                dimension.close();
            }
            for (Attribute attribute : schema.getAttributes().values()) {
                name = attribute.getName();
                if (attribute.isVar()) {
                    estimations.put(name, this.getEstResultSizeVar(this.ctx, name));
                    continue;
                }
                estimations.put(name, new Pair<Object, Long>(null, this.getEstResultSize(this.ctx, name)));
            }
        }
        return estimations;
    }

    public Query finalizeQuery() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_finalize(this.ctx.getCtxp(), this.queryp));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFragmentNum() throws TileDBError {
        SWIGTYPE_p_unsigned_int fragmentNum = tiledb.new_uintp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_fragment_num(this.ctx.getCtxp(), this.queryp, fragmentNum));
            long l = tiledb.uintp_value(fragmentNum);
            return l;
        }
        finally {
            tiledb.delete_uintp(fragmentNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFragmentURI(BigInteger idx) throws TileDBError {
        SWIGTYPE_p_p_char uri = tiledb.new_charpp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_fragment_uri(this.ctx.getCtxp(), this.queryp, idx, uri));
            String string = tiledb.charpp_value(uri);
            return string;
        }
        finally {
            tiledb.delete_charpp(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Long, Long> getFragmentTimestampRange(BigInteger idx) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long t1 = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long t2 = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_fragment_timestamp_range(this.ctx.getCtxp(), this.queryp, idx, t1, t2));
            Pair<BigInteger, BigInteger> pair = new Pair<BigInteger, BigInteger>(tiledb.ullp_value(t1), tiledb.ullp_value(t2));
            return pair;
        }
        finally {
            tiledb.delete_ullp(t1);
            tiledb.delete_ullp(t2);
        }
    }

    public String toString() {
        switch (this.type) {
            case TILEDB_READ: {
                return "READ";
            }
            case TILEDB_WRITE: {
                return "WRITE";
            }
        }
        return "";
    }

    protected SWIGTYPE_p_tiledb_query_t getQueryp() {
        return this.queryp;
    }

    public String getStats() throws TileDBError {
        String stats;
        SWIGTYPE_p_p_char statspp = tiledb.new_charpp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_stats(this.ctx.getCtxp(), this.getQueryp(), statspp));
            stats = tiledb.charpp_value(statspp);
        }
        finally {
            tiledb.delete_charpp(statspp);
        }
        return stats;
    }

    public void setCondition(QueryCondition queryCondition) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_set_condition(this.ctx.getCtxp(), this.getQueryp(), queryCondition.getConditionp()));
    }

    public Config getConfig() throws TileDBError {
        SWIGTYPE_p_p_tiledb_config_t configpp = tiledb.new_tiledb_config_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_config(this.ctx.getCtxp(), this.queryp, configpp));
            return new Config(configpp);
        }
        catch (TileDBError e) {
            tiledb.delete_tiledb_config_tpp(configpp);
            throw e;
        }
    }

    @Override
    public synchronized void close() {
        if (this.queryp != null) {
            this.resetBuffers();
            if (this.subarray != null) {
                this.subarray.close();
            }
            tiledb.tiledb_query_free(this.querypp);
            tiledb.delete_tiledb_query_tpp(this.querypp);
            this.queryp = null;
        }
    }
}

