/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Config;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.DimensionLabel;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Types;
import io.tiledb.java.api.Util;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_subarray_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_subarray_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.uint64_tArray;
import java.math.BigInteger;

public class SubArray
implements AutoCloseable {
    private SWIGTYPE_p_tiledb_subarray_t subArrayp;
    private SWIGTYPE_p_p_tiledb_subarray_t subArraypp;
    private Context ctx;
    private Array array;

    public SubArray(Context ctx, Array array) throws TileDBError {
        this.ctx = ctx;
        this.array = array;
        this.subArraypp = tiledb.new_tiledb_subarray_tpp();
        try {
            ctx.handleError(tiledb.tiledb_subarray_alloc(ctx.getCtxp(), array.getArrayp(), this.subArraypp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_subarray_tpp(this.subArraypp);
            throw err;
        }
        this.subArrayp = tiledb.tiledb_subarray_tpp_value(this.subArraypp);
    }

    public SWIGTYPE_p_tiledb_subarray_t getSubArrayp() {
        return this.subArrayp;
    }

    public synchronized void setConfig(Config config) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_subarray_set_config(this.ctx.getCtxp(), this.subArrayp, config.getConfigp()));
    }

    public synchronized SubArray addRange(int dimIdx, Object start, Object end, Object stride) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(dimIdx).getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_subarray_add_range(this.ctx.getCtxp(), this.subArrayp, dimIdx, startArr.toVoidPointer(), endArr.toVoidPointer(), null));
        }
        return this;
    }

    public synchronized SubArray addPointRanges(int dimIdx, Object start, BigInteger count) throws TileDBError {
        int[] values;
        Datatype dimType;
        Util.checkBigIntegerRange(count);
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(dimIdx).getType();
            values = (int[])start;
        }
        try (NativeArray arr = new NativeArray(this.ctx, values.length, dimType);){
            int i = 0;
            for (int value : values) {
                arr.setItem(i, value);
                ++i;
            }
            this.ctx.handleError(tiledb.tiledb_subarray_add_point_ranges(this.ctx.getCtxp(), this.subArrayp, dimIdx, arr.toVoidPointer(), count));
        }
        return this;
    }

    public synchronized SubArray addRangeByName(String name, Object start, Object end, Object stride) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();
             Dimension dim = domain.getDimension(name);){
            dimType = dim.getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_subarray_add_range_by_name(this.ctx.getCtxp(), this.subArrayp, name, startArr.toVoidPointer(), endArr.toVoidPointer(), null));
        }
        return this;
    }

    public synchronized SubArray addRangeVar(int dimIdx, String start, String end) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();
             Dimension dim = domain.getDimension(dimIdx);){
            dimType = dim.getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_subarray_add_range_var(this.ctx.getCtxp(), this.subArrayp, dimIdx, startArr.toVoidPointer(), BigInteger.valueOf(start.length()), endArr.toVoidPointer(), BigInteger.valueOf(end.length())));
        }
        return this;
    }

    public synchronized SubArray addRangeVarByName(String name, String start, String end) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();
             Dimension dim = domain.getDimension(name);){
            dimType = dim.getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_subarray_add_range_var_by_name(this.ctx.getCtxp(), this.subArrayp, name, startArr.toVoidPointer(), BigInteger.valueOf(start.length()), endArr.toVoidPointer(), BigInteger.valueOf(end.length())));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getRangeNum(int dimIdx) throws TileDBError {
        uint64_tArray resultArr = new uint64_tArray(1);
        try {
            this.ctx.handleError(tiledb.tiledb_subarray_get_range_num(this.ctx.getCtxp(), this.subArrayp, dimIdx, resultArr.cast()));
            long l = resultArr.getitem(0).longValue();
            return l;
        }
        finally {
            resultArr.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getRangeNumFromName(String name) throws TileDBError {
        uint64_tArray resultArr = new uint64_tArray(1);
        try {
            this.ctx.handleError(tiledb.tiledb_subarray_get_range_num_from_name(this.ctx.getCtxp(), this.subArrayp, name, resultArr.cast()));
            long l = resultArr.getitem(0).longValue();
            return l;
        }
        finally {
            resultArr.delete();
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized Pair<Object, Object> getRange(int dimIdx, long rangeIdx) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public synchronized Pair<Object, Object> getRangeFromName(String name, long rangeIdx) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Pair<Long, Long> getRangeVarSize(int dimIdx, long rangeIdx) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_subarray_get_range_var_size(this.ctx.getCtxp(), this.subArrayp, dimIdx, BigInteger.valueOf(rangeIdx), startSize, endSize));
            Pair<Long, Long> pair = new Pair<Long, Long>(tiledb.ullp_value(startSize).longValue(), tiledb.ullp_value(endSize).longValue());
            return pair;
        }
        finally {
            tiledb.delete_ullp(startSize);
            tiledb.delete_ullp(endSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Pair<Long, Long> getRangeVarSizeByName(String name, BigInteger rangeIdx) throws TileDBError {
        Util.checkBigIntegerRange(rangeIdx);
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_subarray_get_range_var_size_from_name(this.ctx.getCtxp(), this.subArrayp, name, rangeIdx, startSize, endSize));
            Pair<Long, Long> pair = new Pair<Long, Long>(tiledb.ullp_value(startSize).longValue(), tiledb.ullp_value(endSize).longValue());
            return pair;
        }
        finally {
            tiledb.delete_ullp(startSize);
            tiledb.delete_ullp(endSize);
        }
    }

    public synchronized Pair<String, String> getRangeVar(int dimIdx, long rangeIdx) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();
             Dimension dim = domain.getDimension(dimIdx);){
            dimType = dim.getType();
        }
        Pair<Long, Long> size = this.getRangeVarSize(dimIdx, rangeIdx);
        try (NativeArray startArr = new NativeArray(this.ctx, size.getFirst().intValue(), dimType);){
            NativeArray endArr = new NativeArray(this.ctx, size.getSecond().intValue(), dimType);
            try {
                this.ctx.handleError(tiledb.tiledb_subarray_get_range_var(this.ctx.getCtxp(), this.subArrayp, dimIdx, BigInteger.valueOf(rangeIdx), startArr.toVoidPointer(), endArr.toVoidPointer()));
                String start = new String((byte[])startArr.toJavaArray());
                String end = new String((byte[])endArr.toJavaArray());
                Pair<String, String> pair = new Pair<String, String>(start, end);
                endArr.close();
                return pair;
            }
            catch (Throwable throwable) {
                try {
                    endArr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public synchronized Pair<String, String> getRangeVarByName(String name, BigInteger rangeIdx) throws TileDBError {
        Datatype dimType;
        Util.checkBigIntegerRange(rangeIdx);
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();
             Dimension dim = domain.getDimension(name);){
            dimType = dim.getType();
        }
        Pair<Long, Long> size = this.getRangeVarSizeByName(name, rangeIdx);
        try (NativeArray startArr = new NativeArray(this.ctx, size.getFirst().intValue(), dimType);){
            NativeArray endArr = new NativeArray(this.ctx, size.getSecond().intValue(), dimType);
            try {
                this.ctx.handleError(tiledb.tiledb_subarray_get_range_var_from_name(this.ctx.getCtxp(), this.subArrayp, name, rangeIdx, startArr.toVoidPointer(), endArr.toVoidPointer()));
                String start = new String((byte[])startArr.toJavaArray());
                String end = new String((byte[])endArr.toJavaArray());
                Pair<String, String> pair = new Pair<String, String>(start, end);
                endArr.close();
                return pair;
            }
            catch (Throwable throwable) {
                try {
                    endArr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public synchronized void setCoalesceRanges(boolean flag) throws TileDBError {
        int coalesce = flag ? 1 : 0;
        this.ctx.handleError(tiledb.tiledb_subarray_set_coalesce_ranges(this.ctx.getCtxp(), this.subArrayp, coalesce));
    }

    public synchronized SubArray setSubarray(NativeArray subarray) throws TileDBError {
        try (ArraySchema schema = this.array.getSchema();){
            Domain domain = schema.getDomain();
            try {
                Types.typeCheck(subarray.getNativeType(), domain.getType());
                this.ctx.handleError(tiledb.tiledb_subarray_set_subarray(this.ctx.getCtxp(), this.subArrayp, subarray.toVoidPointer()));
                SubArray subArray = this;
                if (domain != null) {
                    domain.close();
                }
                return subArray;
            }
            catch (Throwable throwable) {
                if (domain != null) {
                    try {
                        domain.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized Pair<Object, Object> getLabelRange(String name, long rangeIndex) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getLabelName(long dimIndex) throws TileDBError {
        SWIGTYPE_p_p_char namepp = tiledb.new_charpp();
        try {
            this.ctx.handleError(tiledb.tiledb_subarray_get_label_name(this.ctx.getCtxp(), this.subArrayp, dimIndex, namepp));
            String string = tiledb.charpp_value(namepp);
            return string;
        }
        finally {
            tiledb.delete_charpp(namepp);
        }
    }

    public synchronized void addLabelRange(String name, Object start, Object end, Object stride) throws TileDBError {
        Datatype type;
        try (ArraySchema schema = this.array.getSchema();
             DimensionLabel dimensionLabel = schema.getDimensionLabelFromName(name);){
            type = dimensionLabel.getLabelType();
        }
        Types.javaTypeCheck(start.getClass(), type.javaClass());
        Types.javaTypeCheck(end.getClass(), type.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, type);
             NativeArray endArr = new NativeArray(this.ctx, 1, type);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_subarray_add_label_range(this.ctx.getCtxp(), this.subArrayp, name, startArr.toVoidPointer(), endArr.toVoidPointer(), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getLabelRangeNum(String name) throws TileDBError {
        uint64_tArray resultArr = new uint64_tArray(1);
        try {
            this.ctx.handleError(tiledb.tiledb_subarray_get_label_range_num(this.ctx.getCtxp(), this.subArrayp, name, resultArr.cast()));
            long l = resultArr.getitem(0).longValue();
            return l;
        }
        finally {
            resultArr.delete();
        }
    }

    public synchronized void addLabelRangeVar(String name, String start, long startSize, String end, long endSize) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             DimensionLabel dimensionLabel = schema.getDimensionLabelFromName(name);){
            dimType = dimensionLabel.getLabelType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_subarray_add_label_range_var(this.ctx.getCtxp(), this.subArrayp, name, startArr.toVoidPointer(), BigInteger.valueOf(start.length()), endArr.toVoidPointer(), BigInteger.valueOf(end.length())));
        }
    }

    public synchronized Pair<String, String> getLabelRangeVar(String name, long rangeIdx) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             DimensionLabel dimensionLabel = schema.getDimensionLabelFromName(name);){
            dimType = dimensionLabel.getLabelType();
        }
        Pair<Long, Long> size = this.getLabelRangeVarSize(name, rangeIdx);
        try (NativeArray startArr = new NativeArray(this.ctx, size.getFirst().intValue(), dimType);){
            NativeArray endArr = new NativeArray(this.ctx, size.getSecond().intValue(), dimType);
            try {
                this.ctx.handleError(tiledb.tiledb_subarray_get_label_range_var(this.ctx.getCtxp(), this.subArrayp, name, BigInteger.valueOf(rangeIdx), startArr.toVoidPointer(), endArr.toVoidPointer()));
                String start = new String((byte[])startArr.toJavaArray());
                String end = new String((byte[])endArr.toJavaArray());
                Pair<String, String> pair = new Pair<String, String>(start, end);
                endArr.close();
                return pair;
            }
            catch (Throwable throwable) {
                try {
                    endArr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Pair<Long, Long> getLabelRangeVarSize(String name, long rangeIdx) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_subarray_get_label_range_var_size(this.ctx.getCtxp(), this.subArrayp, name, BigInteger.valueOf(rangeIdx), startSize, endSize));
            Pair<Long, Long> pair = new Pair<Long, Long>(tiledb.ullp_value(startSize).longValue(), tiledb.ullp_value(endSize).longValue());
            return pair;
        }
        finally {
            tiledb.delete_ullp(startSize);
            tiledb.delete_ullp(endSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasLabelRanges(long index) throws TileDBError {
        SWIGTYPE_p_int hasLabelRanges = tiledb.new_intp();
        try {
            this.ctx.handleError(tiledb.tiledb_subarray_has_label_ranges(this.ctx.getCtxp(), this.getSubArrayp(), index, hasLabelRanges));
            boolean bl = tiledb.intp_value(hasLabelRanges) > 0;
            return bl;
        }
        finally {
            tiledb.delete_intp(hasLabelRanges);
        }
    }

    @Override
    public void close() {
        if (this.subArrayp != null && this.subArraypp != null) {
            tiledb.tiledb_subarray_free(this.subArraypp);
            tiledb.delete_tiledb_subarray_tpp(this.subArraypp);
            this.subArrayp = null;
            this.subArraypp = null;
        }
    }
}

