/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.TileDBError;

public class Types {
    public static Datatype getNativeType(Class atrrType) throws TileDBError {
        if (atrrType.equals(int[].class)) {
            return Datatype.TILEDB_INT32;
        }
        if (atrrType.equals(long[].class)) {
            return Datatype.TILEDB_INT64;
        }
        if (atrrType.equals(char[].class)) {
            return Datatype.TILEDB_CHAR;
        }
        if (atrrType.equals(float[].class)) {
            return Datatype.TILEDB_FLOAT32;
        }
        if (atrrType.equals(double[].class)) {
            return Datatype.TILEDB_FLOAT64;
        }
        if (atrrType.equals(byte[].class)) {
            return Datatype.TILEDB_INT8;
        }
        if (atrrType.equals(short[].class)) {
            return Datatype.TILEDB_INT16;
        }
        if (atrrType.equals(boolean[].class)) {
            return Datatype.TILEDB_INT8;
        }
        if (atrrType.equals(Integer.class)) {
            return Datatype.TILEDB_INT32;
        }
        if (atrrType.equals(Long.class)) {
            return Datatype.TILEDB_INT64;
        }
        if (atrrType.equals(Character.class)) {
            return Datatype.TILEDB_CHAR;
        }
        if (atrrType.equals(String.class)) {
            return Datatype.TILEDB_STRING_ASCII;
        }
        if (atrrType.equals(Float.class)) {
            return Datatype.TILEDB_FLOAT32;
        }
        if (atrrType.equals(Double.class)) {
            return Datatype.TILEDB_FLOAT64;
        }
        if (atrrType.equals(Byte.class)) {
            return Datatype.TILEDB_INT8;
        }
        if (atrrType.equals(Short.class)) {
            return Datatype.TILEDB_INT16;
        }
        if (atrrType.equals(Boolean.class)) {
            return Datatype.TILEDB_BOOL;
        }
        throw new TileDBError("Not supported getType: " + atrrType);
    }

    public static Class getJavaType(Datatype type) throws TileDBError {
        switch (type) {
            case TILEDB_FLOAT32: {
                return Float.class;
            }
            case TILEDB_FLOAT64: {
                return Double.class;
            }
            case TILEDB_INT8: 
            case TILEDB_BLOB: {
                return Byte.class;
            }
            case TILEDB_INT16: {
                return Short.class;
            }
            case TILEDB_INT32: {
                return Integer.class;
            }
            case TILEDB_INT64: {
                return Long.class;
            }
            case TILEDB_UINT8: 
            case TILEDB_BOOL: {
                return Short.class;
            }
            case TILEDB_UINT16: {
                return Integer.class;
            }
            case TILEDB_UINT32: {
                return Long.class;
            }
            case TILEDB_UINT64: {
                return Long.class;
            }
            case TILEDB_STRING_UTF8: 
            case TILEDB_STRING_ASCII: 
            case TILEDB_CHAR: {
                return String.class;
            }
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_HR: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_DATETIME_AS: 
            case TILEDB_TIME_HR: 
            case TILEDB_TIME_MIN: 
            case TILEDB_TIME_SEC: 
            case TILEDB_TIME_MS: 
            case TILEDB_TIME_US: 
            case TILEDB_TIME_NS: 
            case TILEDB_TIME_PS: 
            case TILEDB_TIME_FS: 
            case TILEDB_TIME_AS: {
                return Long.class;
            }
        }
        throw new TileDBError("Not supported getDomain getType " + (Object)((Object)type));
    }

    public static boolean typeCheck(Datatype first, Datatype second) throws TileDBError {
        if (!first.equals((Object)second)) {
            throw new TileDBError("Type " + (Object)((Object)first) + " is not equal to the default getType: " + (Object)((Object)second));
        }
        return true;
    }

    public static boolean javaTypeCheck(Class first, Class second) throws TileDBError {
        if (!first.equals(second)) {
            throw new TileDBError("Type " + first.getName() + " is not equal to the default getType: " + second.getName());
        }
        return true;
    }
}

