/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Config;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Filesystem;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.VFSMode;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_config_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_vfs_fh_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_vfs_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_vfs_fh_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_vfs_handle_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.tiledb;
import java.math.BigInteger;
import java.net.URI;

public class VFS
implements AutoCloseable {
    private Context ctx;
    private SWIGTYPE_p_tiledb_vfs_handle_t vfsp;
    private SWIGTYPE_p_p_tiledb_vfs_handle_t vfspp;

    public VFS(Context ctx, Config config) throws TileDBError {
        SWIGTYPE_p_p_tiledb_vfs_handle_t vfspp = tiledb.new_tiledb_vfs_tpp();
        try {
            ctx.handleError(tiledb.tiledb_vfs_alloc(ctx.getCtxp(), config.getConfigp(), vfspp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_vfs_tpp(vfspp);
            throw err;
        }
        this.ctx = ctx;
        this.vfsp = tiledb.tiledb_vfs_tpp_value(vfspp);
        this.vfspp = vfspp;
    }

    public VFS(Context ctx) throws TileDBError {
        this(ctx, new Config());
    }

    protected SWIGTYPE_p_tiledb_vfs_handle_t getVFSp() {
        return this.vfsp;
    }

    public Config getConfig() throws TileDBError {
        Config config;
        SWIGTYPE_p_p_tiledb_config_t configpp = tiledb.new_tiledb_config_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_vfs_get_config(this.ctx.getCtxp(), this.vfsp, configpp));
            config = new Config(configpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_config_tpp(configpp);
            throw err;
        }
        return config;
    }

    public Context getContext() {
        return this.ctx;
    }

    public boolean isSupportedFs(Filesystem fs) throws TileDBError {
        return this.ctx.isSupportedFs(fs);
    }

    public boolean isSupportedFs(String fs) throws TileDBError {
        if (fs.equalsIgnoreCase("file") || fs.equalsIgnoreCase("file://")) {
            return true;
        }
        if (fs.equalsIgnoreCase("hdfs") || fs.equalsIgnoreCase("hdfs://")) {
            return this.ctx.isSupportedFs(Filesystem.TILEDB_HDFS);
        }
        if (fs.equalsIgnoreCase("s3") || fs.equalsIgnoreCase("s3://")) {
            return this.ctx.isSupportedFs(Filesystem.TILEDB_S3);
        }
        return false;
    }

    public boolean isSupportedFs(URI uri) throws TileDBError {
        return this.isSupportedFs(uri.getScheme());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBucket(String path) throws TileDBError {
        boolean isBucket;
        SWIGTYPE_p_int retp = tiledb.new_intp();
        try {
            this.ctx.handleError(tiledb.tiledb_vfs_is_bucket(this.ctx.getCtxp(), this.vfsp, path, retp));
            isBucket = tiledb.intp_value(retp) != 0;
        }
        finally {
            tiledb.delete_intp(retp);
        }
        return isBucket;
    }

    public boolean isBucket(URI uri) throws TileDBError {
        return this.isBucket(uri.toString());
    }

    public String createBucket(String path) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_vfs_create_bucket(this.ctx.getCtxp(), this.vfsp, path));
        return path;
    }

    public URI createBucket(URI uri) throws TileDBError {
        this.createBucket(uri.toString());
        return uri;
    }

    public String removeBucket(String path) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_vfs_remove_bucket(this.ctx.getCtxp(), this.vfsp, path));
        return path;
    }

    public URI removeBucket(URI uri) throws TileDBError {
        this.removeBucket(uri.toString());
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmptyBucket(String path) throws TileDBError {
        boolean isEmpty;
        SWIGTYPE_p_int retp = tiledb.new_intp();
        try {
            this.ctx.handleError(tiledb.tiledb_vfs_is_empty_bucket(this.ctx.getCtxp(), this.vfsp, path, retp));
            isEmpty = tiledb.intp_value(retp) != 0;
        }
        finally {
            tiledb.delete_intp(retp);
        }
        return isEmpty;
    }

    public boolean isEmtpyBucket(URI uri) throws TileDBError {
        return this.isEmptyBucket(uri.toString());
    }

    public String emptyBucket(String path) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_vfs_empty_bucket(this.ctx.getCtxp(), this.vfsp, path));
        return path;
    }

    public URI emptyBucket(URI uri) throws TileDBError {
        this.emptyBucket(uri.toString());
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFile(String path) throws TileDBError {
        boolean isFile;
        SWIGTYPE_p_int ret = tiledb.new_intp();
        try {
            this.ctx.handleError(tiledb.tiledb_vfs_is_file(this.ctx.getCtxp(), this.vfsp, path, ret));
            isFile = tiledb.intp_value(ret) != 0;
        }
        finally {
            tiledb.delete_intp(ret);
        }
        return isFile;
    }

    public boolean isFile(URI uri) throws TileDBError {
        return this.isFile(uri.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(String path) throws TileDBError {
        boolean isDir;
        SWIGTYPE_p_int ret = tiledb.new_intp();
        try {
            this.ctx.handleError(tiledb.tiledb_vfs_is_dir(this.ctx.getCtxp(), this.vfsp, path, ret));
            isDir = tiledb.intp_value(ret) != 0;
        }
        finally {
            tiledb.delete_intp(ret);
        }
        return isDir;
    }

    public boolean isDirectory(URI uri) throws TileDBError {
        return this.isDirectory(uri.toString());
    }

    public String createDirectory(String path) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_vfs_create_dir(this.ctx.getCtxp(), this.vfsp, path));
        return path;
    }

    public URI createDirectory(URI uri) throws TileDBError {
        this.createDirectory(uri.toString());
        return uri;
    }

    public String createFile(String path) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_vfs_touch(this.ctx.getCtxp(), this.vfsp, path));
        return path;
    }

    public URI createFile(URI uri) throws TileDBError {
        this.createFile(uri.toString());
        return uri;
    }

    public String removeDirectory(String path) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_vfs_remove_dir(this.ctx.getCtxp(), this.vfsp, path));
        return path;
    }

    public URI removeDirectory(URI uri) throws TileDBError {
        this.removeDirectory(uri.toString());
        return uri;
    }

    public String removeFile(String path) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_vfs_remove_file(this.ctx.getCtxp(), this.vfsp, path));
        return path;
    }

    public URI removeFile(URI uri) throws TileDBError {
        this.removeFile(uri.toString());
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fileSize(String path) throws TileDBError {
        BigInteger byteSize;
        SWIGTYPE_p_unsigned_long_long sizep = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_vfs_file_size(this.ctx.getCtxp(), this.vfsp, path, sizep));
            byteSize = tiledb.ullp_value(sizep);
        }
        finally {
            tiledb.delete_ullp(sizep);
        }
        return byteSize.longValue();
    }

    public long fileSize(URI uri) throws TileDBError {
        return this.fileSize(uri.toString());
    }

    public String moveDirectory(String source, String dest) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_vfs_move_dir(this.ctx.getCtxp(), this.vfsp, source, dest));
        return dest;
    }

    public URI moveDirectory(URI source, URI dest) throws TileDBError {
        this.moveDirectory(source.toString(), dest.toString());
        return dest;
    }

    public String moveFile(String source, String dest) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_vfs_move_file(this.ctx.getCtxp(), this.vfsp, source, dest));
        return dest;
    }

    public URI moveFile(URI source, URI dest) throws TileDBError {
        this.moveFile(source.toString(), dest.toString());
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readAllBytes(String path) throws TileDBError {
        byte[] resultBuffer;
        Long nbytes = this.fileSize(path);
        SWIGTYPE_p_p_tiledb_vfs_fh_handle_t vfsFHpp = tiledb.new_tiledb_vfs_fh_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_vfs_open(this.ctx.getCtxp(), this.vfsp, path, VFSMode.TILEDB_VFS_READ.toSwigEnum(), vfsFHpp));
        }
        catch (TileDBError err) {
            tiledb.tiledb_vfs_fh_free(vfsFHpp);
            throw err;
        }
        SWIGTYPE_p_tiledb_vfs_fh_handle_t vfsFHp = tiledb.tiledb_vfs_fh_tpp_value(vfsFHpp);
        try (NativeArray byteBuffer = new NativeArray(this.ctx, nbytes.intValue(), Datatype.TILEDB_INT8);){
            this.ctx.handleError(tiledb.tiledb_vfs_read(this.ctx.getCtxp(), vfsFHp, BigInteger.valueOf(0L), byteBuffer.toVoidPointer(), BigInteger.valueOf(nbytes)));
            resultBuffer = (byte[])byteBuffer.toJavaArray();
        }
        finally {
            tiledb.tiledb_vfs_close(this.ctx.getCtxp(), vfsFHp);
            tiledb.tiledb_vfs_fh_free(vfsFHpp);
        }
        return resultBuffer;
    }

    public byte[] readAllBytes(URI path) throws TileDBError {
        return this.readAllBytes(path.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String write(String path, byte[] bytes, VFSMode ... mode) throws TileDBError {
        if (mode.length == 0) {
            mode = new VFSMode[]{VFSMode.TILEDB_VFS_WRITE};
        }
        if (mode[0] == VFSMode.TILEDB_VFS_READ) {
            throw new TileDBError("VFSMode for write must be TILEDB_VFS_WRITE or TILEDB_VFS_APPEND");
        }
        SWIGTYPE_p_p_tiledb_vfs_fh_handle_t vfsFHpp = tiledb.new_tiledb_vfs_fh_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_vfs_open(this.ctx.getCtxp(), this.vfsp, path, mode[0].toSwigEnum(), vfsFHpp));
        }
        catch (TileDBError err) {
            tiledb.tiledb_vfs_fh_free(vfsFHpp);
            throw err;
        }
        SWIGTYPE_p_tiledb_vfs_fh_handle_t vfsFHp = tiledb.tiledb_vfs_fh_tpp_value(vfsFHpp);
        try (NativeArray byteBuffer = new NativeArray(this.ctx, (Object)bytes, Byte.class);){
            this.ctx.handleError(tiledb.tiledb_vfs_write(this.ctx.getCtxp(), vfsFHp, byteBuffer.toVoidPointer(), BigInteger.valueOf(bytes.length)));
        }
        finally {
            tiledb.tiledb_vfs_close(this.ctx.getCtxp(), vfsFHp);
            tiledb.tiledb_vfs_fh_free(vfsFHpp);
        }
        return path;
    }

    public URI write(URI uri, byte[] bytes, VFSMode ... mode) throws TileDBError {
        this.write(uri.toString(), bytes, mode);
        return uri;
    }

    @Override
    public void close() {
        if (this.vfsp != null) {
            tiledb.tiledb_vfs_free(this.vfspp);
            tiledb.delete_tiledb_vfs_tpp(this.vfspp);
            this.vfsp = null;
            this.vfspp = null;
        }
    }
}

