/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Context;
import io.tiledb.java.api.Filter;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.TileDBError;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_filter_t;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.tiledb_filter_option_t;
import io.tiledb.libtiledb.tiledb_filter_type_t;
import io.tiledb.libtiledb.tiledb_filter_webp_format_t;

public class WebPFilter
extends Filter {
    public WebPFilter(Context ctx) throws TileDBError {
        super(ctx, tiledb_filter_type_t.TILEDB_FILTER_WEBP);
    }

    public WebPFilter(Context ctx, float quality, tiledb_filter_webp_format_t inputFormat, short lossless) throws TileDBError {
        super(ctx, tiledb_filter_type_t.TILEDB_FILTER_WEBP);
        try (NativeArray qualityArray = new NativeArray(ctx, (Object)new float[]{quality}, Float.class);
             NativeArray inputFormatArray = new NativeArray(ctx, (Object)new int[]{inputFormat.swigValue()}, Integer.class);
             NativeArray losslessArray = new NativeArray(ctx, (Object)new short[]{lossless}, Long.class);){
            ctx.handleError(tiledb.tiledb_filter_set_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_WEBP_INPUT_FORMAT, inputFormatArray.toVoidPointer()));
            ctx.handleError(tiledb.tiledb_filter_set_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_WEBP_LOSSLESS, losslessArray.toVoidPointer()));
            ctx.handleError(tiledb.tiledb_filter_set_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_WEBP_QUALITY, qualityArray.toVoidPointer()));
        }
        catch (TileDBError err) {
            super.close();
            throw err;
        }
    }

    protected WebPFilter(Context ctx, SWIGTYPE_p_p_tiledb_filter_t filterpp) {
        super(ctx, filterpp);
    }

    public float getQuality() throws TileDBError {
        float quality;
        Context ctx = this.getCtx();
        try (NativeArray qualityArray = new NativeArray(ctx, 1, Float.class);){
            ctx.handleError(tiledb.tiledb_filter_get_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_WEBP_QUALITY, qualityArray.toVoidPointer()));
            quality = ((Float)qualityArray.getItem(0)).floatValue();
        }
        return quality;
    }

    public short getLossless() throws TileDBError {
        short lossless;
        Context ctx = this.getCtx();
        try (NativeArray losslessArray = new NativeArray(ctx, 1, Short.class);){
            ctx.handleError(tiledb.tiledb_filter_get_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_WEBP_LOSSLESS, losslessArray.toVoidPointer()));
            lossless = (Short)losslessArray.getItem(0);
        }
        return lossless;
    }

    public tiledb_filter_webp_format_t getInputFormat() throws TileDBError {
        int format;
        Context ctx = this.getCtx();
        try (NativeArray inputFormatArray = new NativeArray(ctx, 1, Integer.class);){
            ctx.handleError(tiledb.tiledb_filter_get_option(ctx.getCtxp(), this.getFilterp(), tiledb_filter_option_t.TILEDB_WEBP_INPUT_FORMAT, inputFormatArray.toVoidPointer()));
            format = (Integer)inputFormatArray.getItem(0);
        }
        return tiledb_filter_webp_format_t.swigToEnum(format);
    }
}

