/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.libtiledb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class NativeLibLoader {
    private static final Logger LOGGER = Logger.getLogger(NativeLibLoader.class.getName());
    private static final String UNKNOWN = "unknown";
    private static final String LIB_RESOURCE_DIR = "/lib";
    private static Path tempDir;

    static void loadNativeTileDB() {
        try {
            NativeLibLoader.loadNativeLib("tiledb", true);
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warning("Could not load Native TIleDB");
        }
    }

    static void loadNativeTileDBJNI() {
        try {
            NativeLibLoader.loadNativeLib("tiledbjni", true);
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warning("Could not load Native TileDB JNI");
        }
    }

    private static boolean contentsEquals(InputStream in1, InputStream in2) throws IOException {
        int ch2;
        if (!(in1 instanceof BufferedInputStream)) {
            in1 = new BufferedInputStream(in1);
        }
        if (!(in2 instanceof BufferedInputStream)) {
            in2 = new BufferedInputStream(in2);
        }
        int ch = in1.read();
        while (ch != -1) {
            ch2 = in2.read();
            if (ch != ch2) {
                return false;
            }
            ch = in1.read();
        }
        ch2 = in2.read();
        return ch2 == -1;
    }

    private static String normalizeOs(String value) {
        if ((value = NativeLibLoader.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("os400") && (value.length() <= 5 || !Character.isDigit(value.charAt(5)))) {
            return "os400";
        }
        if (value.startsWith("linux")) {
            return "linux";
        }
        if (value.startsWith("macosx") || value.startsWith("osx")) {
            return "osx";
        }
        if (value.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("solaris") || value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        return UNKNOWN;
    }

    private static String normalizeArch(String value) {
        if ((value = NativeLibLoader.normalize(value)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value.matches("^(ia64w?|itanium64)$")) {
            return "itanium_64";
        }
        if ("ia64n".equals(value)) {
            return "itanium_32";
        }
        if (value.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(value)) {
            return "aarch_64";
        }
        if (value.matches("^(mips|mips32)$")) {
            return "mips_32";
        }
        if (value.matches("^(mipsel|mips32el)$")) {
            return "mipsel_32";
        }
        if ("mips64".equals(value)) {
            return "mips_64";
        }
        if ("mips64el".equals(value)) {
            return "mipsel_64";
        }
        if (value.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if (value.matches("^(ppcle|ppc32le)$")) {
            return "ppcle_32";
        }
        if ("ppc64".equals(value)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(value)) {
            return "ppcle_64";
        }
        if ("s390".equals(value)) {
            return "s390_32";
        }
        if ("s390x".equals(value)) {
            return "s390_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static String getOSClassifier() {
        Properties allProps = new Properties(System.getProperties());
        String osName = allProps.getProperty("os.name");
        String osArch = allProps.getProperty("os.arch");
        String detectedName = NativeLibLoader.normalizeOs(osName);
        String detectedArch = NativeLibLoader.normalizeArch(osArch);
        return detectedName + "-" + detectedArch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path extractLibraryFile(String libraryDir, String libraryName, boolean mapLibraryName) {
        String libraryFileName = mapLibraryName ? System.mapLibraryName(libraryName) : libraryName;
        String nativeLibraryFilePath = libraryDir + "/" + libraryFileName;
        Path extractedLibFile = tempDir.resolve(libraryFileName);
        try {
            try (InputStream reader = NativeLibLoader.class.getResourceAsStream(nativeLibraryFilePath);
                 FileOutputStream writer = new FileOutputStream(extractedLibFile.toFile());){
                byte[] buffer = new byte[8192];
                int bytesRead = 0;
                while ((bytesRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, bytesRead);
                }
            }
            PosixFileAttributeView view = Files.getFileAttributeView(extractedLibFile, PosixFileAttributeView.class, new LinkOption[0]);
            if (view != null) {
                Set<PosixFilePermission> permissions = view.readAttributes().permissions();
                permissions.add(PosixFilePermission.OWNER_READ);
                permissions.add(PosixFilePermission.OWNER_WRITE);
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
                view.setPermissions(permissions);
            }
            InputStream nativeIn = null;
            InputStream extractedLibIn = null;
            try {
                nativeIn = NativeLibLoader.class.getResourceAsStream(nativeLibraryFilePath);
                extractedLibIn = new FileInputStream(extractedLibFile.toFile());
                if (!NativeLibLoader.contentsEquals(nativeIn, extractedLibIn)) {
                    throw new IOException(String.format("Failed to write a native library file at %s", extractedLibFile));
                }
            }
            finally {
                if (nativeIn != null) {
                    nativeIn.close();
                }
                if (extractedLibIn != null) {
                    extractedLibIn.close();
                }
            }
            return extractedLibFile;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static Path findNativeLibrary(String libraryName, boolean mapLibraryName) {
        String libPath;
        boolean hasNativeLib;
        String mappedLibraryName = mapLibraryName ? System.mapLibraryName(libraryName) : libraryName;
        String libDir = LIB_RESOURCE_DIR;
        if (System.getProperty("os.name").contains("Mac") && System.getProperty("os.arch").equals("aarch64")) {
            libDir = "/arm" + libDir;
        }
        if (!(hasNativeLib = NativeLibLoader.hasResource(libPath = libDir + "/" + mappedLibraryName))) {
            return null;
        }
        return NativeLibLoader.extractLibraryFile(libDir, libraryName, mapLibraryName);
    }

    private static void loadNativeLib(String libraryName, boolean mapLibraryName) {
        Path nativeLibFile = NativeLibLoader.findNativeLibrary(libraryName, mapLibraryName);
        if (nativeLibFile != null) {
            System.load(nativeLibFile.toString());
        } else {
            System.loadLibrary(libraryName);
        }
    }

    private static boolean hasResource(String path) {
        return NativeLibLoader.class.getResource(path) != null;
    }

    static {
        try {
            tempDir = Files.createTempDirectory("tileDbNativeLibLoader", new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try (Stream<Path> walk = Files.walk(tempDir, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }));
    }
}

