/*
 * Decompiled with CFR 0.152.
 */
package examples.io.tiledb.java.api;

import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.ArrayType;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.FilterList;
import io.tiledb.java.api.GzipFilter;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.ZstdFilter;
import java.util.Map;

public class ArraySchemaExample {
    public static void main(String[] args) throws Exception {
        Context ctx = new Context();
        ArraySchema schema = new ArraySchema(ctx, ArrayType.TILEDB_SPARSE);
        schema.setCapacity(10L);
        schema.setTileOrder(Layout.TILEDB_ROW_MAJOR);
        schema.setCellOrder(Layout.TILEDB_COL_MAJOR);
        schema.setCoodsFilterList(new FilterList(ctx).addFilter(new ZstdFilter(ctx, 4)));
        schema.setOffsetsFilterList(new FilterList(ctx).addFilter(new GzipFilter(ctx, 5)));
        Dimension<Integer> d1 = new Dimension<Integer>(ctx, "d1", Integer.class, new Pair<Integer, Integer>(1, 1000), Integer.valueOf(10));
        Dimension<Integer> d2 = new Dimension<Integer>(ctx, "d2", Integer.class, new Pair<Integer, Integer>(101, 10000), Integer.valueOf(100));
        Domain domain = new Domain(ctx);
        domain.addDimension(d1);
        domain.addDimension(d2);
        schema.setDomain(domain);
        Attribute a1 = new Attribute(ctx, "a1", Integer.class);
        a1.setCellValNum(3L);
        Attribute a2 = new Attribute(ctx, "a2", Float.class);
        a2.setFilterList(new FilterList(ctx).addFilter(new GzipFilter(ctx)));
        schema.addAttribute(a1);
        schema.addAttribute(a2);
        try {
            schema.check();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        schema.dump();
        System.out.println("\nFrom getters:\n- Array getType: " + (schema.getArrayType() == ArrayType.TILEDB_DENSE ? "dense" : "sparse") + "\n- Cell order: " + (schema.getCellOrder() == Layout.TILEDB_ROW_MAJOR ? "row-major" : "col-major") + "\n- Tile order: " + (schema.getTileOrder() == Layout.TILEDB_ROW_MAJOR ? "row-major" : "col-major") + "\n- Capacity: " + schema.getCapacity() + "\n- Coordinates compressor: " + schema.getCoordsFilterList() + "\n- Offsets compressor: " + schema.getOffsetsFilterList());
        System.out.println("\n\nArray schema attribute names: ");
        for (Map.Entry<String, Attribute> a : schema.getAttributes().entrySet()) {
            System.out.println("* " + a.getKey());
        }
        schema.getDomain().dump();
        System.out.println("\nArray schema dimension names: ");
        for (Dimension d : schema.getDomain().getDimensions()) {
            System.out.println("* " + d.getName() + " domain: " + d.domainToStr() + " extent: " + d.tileExtentToStr());
        }
    }
}

