/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Context;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.TileDBObject;
import io.tiledb.java.api.TileDBObjectType;
import io.tiledb.java.api.WalkOrder;
import io.tiledb.libtiledb.PathCallback;
import io.tiledb.libtiledb.Utils;
import io.tiledb.libtiledb.tiledb_object_t;
import java.util.ArrayList;
import java.util.List;

public class TileDBObjectIterator {
    private final Context ctx;
    private boolean group = true;
    private boolean array = true;
    private boolean kv = true;
    private boolean recursive = false;
    private WalkOrder walkOrder = WalkOrder.TILEDB_PREORDER;
    private String root = ".";

    public TileDBObjectIterator(Context ctx, String root) {
        this.ctx = ctx;
        this.root = root;
    }

    public TileDBObjectIterator(Context ctx, boolean group, boolean array, boolean kv, boolean recursive, WalkOrder walkOrder, String root) {
        this.ctx = ctx;
        this.group = group;
        this.array = array;
        this.kv = kv;
        this.recursive = recursive;
        this.walkOrder = walkOrder;
        this.root = root;
    }

    public void setIteratorPolicy(boolean group, boolean array, boolean kv) {
        this.group = group;
        this.array = array;
        this.kv = kv;
    }

    public void setRecursive(WalkOrder walkOrder) {
        this.recursive = true;
        this.setWalkOrder(walkOrder);
    }

    public void setRecursive() {
        this.recursive = true;
        this.setWalkOrder(WalkOrder.TILEDB_PREORDER);
    }

    public void setNonRecursive() {
        this.recursive = false;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public boolean isKv() {
        return this.kv;
    }

    public void setKv(boolean kv) {
        this.kv = kv;
    }

    public WalkOrder getWalkOrder() {
        return this.walkOrder;
    }

    public List<TileDBObject> getAllObjects() throws TileDBError {
        ObjectGetter objectGetter = new ObjectGetter();
        if (this.recursive) {
            this.ctx.handleError(Utils.tiledb_object_walk(this.ctx.getCtxp(), this.root, this.walkOrder.toSwigEnum(), objectGetter));
        } else {
            this.ctx.handleError(Utils.tiledb_object_ls(this.ctx.getCtxp(), this.root, objectGetter));
        }
        return objectGetter.getObjects();
    }

    public void setWalkOrder(WalkOrder walkOrder) {
        this.walkOrder = walkOrder;
    }

    private class ObjectGetter
    extends PathCallback {
        List<TileDBObject> objects = new ArrayList<TileDBObject>();

        public List<TileDBObject> getObjects() {
            return this.objects;
        }

        public void setObjects(List<TileDBObject> objects) {
            this.objects = objects;
        }

        @Override
        public int call(String path, tiledb_object_t type) {
            if (type == tiledb_object_t.TILEDB_ARRAY && TileDBObjectIterator.this.array || type == tiledb_object_t.TILEDB_GROUP && TileDBObjectIterator.this.group) {
                TileDBObject object = null;
                try {
                    object = new TileDBObject(TileDBObjectIterator.this.ctx, path, TileDBObjectType.fromSwigEnum(type));
                }
                catch (TileDBError tileDBError) {
                    tileDBError.printStackTrace();
                }
                this.objects.add(object);
            }
            return 1;
        }
    }
}

