/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.QueryCondition;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.TileDBError;
import io.tiledb.libtiledb.tiledb_query_condition_combination_op_t;
import io.tiledb.libtiledb.tiledb_query_condition_op_t;
import io.tiledb.spark.Range;
import io.tiledb.spark.SubArrayRanges;
import io.tiledb.spark.TileDBDataInputPartition;
import io.tiledb.spark.TileDBDataSourceOptions;
import io.tiledb.spark.TileDBPartitionReaderFactory;
import io.tiledb.spark.TileDBReadSchema;
import io.tiledb.spark.util;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.log4j.Logger;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.TileDBReadMetricsUpdater;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;

public class TileDBBatch
implements Batch {
    private final TileDBReadSchema tileDBReadSchema;
    private final TileDBDataSourceOptions tileDBDataSourceOptions;
    private final TileDBReadMetricsUpdater metricsUpdater;
    private final Filter[] pushedFilters;
    private final Context ctx;
    private Array array;
    private ArraySchema arraySchema;
    static Logger log = Logger.getLogger((String)TileDBBatch.class.getName());
    public static QueryCondition finalQueryCondition;

    public TileDBBatch(TileDBReadSchema tileDBReadSchema, TileDBDataSourceOptions options, Filter[] pushedFilters) throws TileDBError, URISyntaxException {
        this.tileDBReadSchema = tileDBReadSchema;
        this.tileDBDataSourceOptions = options;
        this.metricsUpdater = new TileDBReadMetricsUpdater(TaskContext.get());
        this.pushedFilters = pushedFilters;
        this.ctx = new Context(this.tileDBDataSourceOptions.getTileDBConfigMap(true));
        this.array = new Array(this.ctx, options.getArrayURI().get(), QueryType.TILEDB_READ);
        this.arraySchema = this.array.getSchema();
        finalQueryCondition = null;
    }

    public InputPartition[] planInputPartitions() {
        this.metricsUpdater.startTimer("data-source-plan-batch-input-partitions");
        ArrayList<TileDBDataInputPartition> readerPartitions = new ArrayList<TileDBDataInputPartition>();
        try {
            Array array = new Array(this.ctx, util.tryGetArrayURI(this.tileDBDataSourceOptions));
            HashMap nonEmptyDomain = array.nonEmptyDomain();
            Domain domain = array.getSchema().getDomain();
            ArrayList<List<Object>> ranges = new ArrayList<List<Object>>();
            int i = 0;
            while ((long)i < domain.getNDim()) {
                ranges.add(new ArrayList());
                ++i;
            }
            i = 0;
            while ((long)i < array.getSchema().getAttributeNum()) {
                ranges.add(new ArrayList());
                ++i;
            }
            if (this.pushedFilters != null) {
                for (Filter filter : this.pushedFilters) {
                    Pair<Pair<List<List<Range>>, Class>, QueryCondition> appliedConditions = this.buildRangeFromFilter(filter, nonEmptyDomain);
                    List allRanges = (List)((Pair)appliedConditions.getFirst()).getFirst();
                    QueryCondition currentQueryCondition = (QueryCondition)appliedConditions.getSecond();
                    if (finalQueryCondition == null) {
                        finalQueryCondition = currentQueryCondition;
                    } else if (currentQueryCondition != null) {
                        finalQueryCondition = currentQueryCondition.combine(finalQueryCondition, tiledb_query_condition_combination_op_t.TILEDB_AND);
                        currentQueryCondition.close();
                    }
                    for (int i2 = 0; i2 < allRanges.size(); ++i2) {
                        ((List)ranges.get(i2)).addAll((Collection)allRanges.get(i2));
                    }
                }
            }
            i = 0;
            while ((long)i < domain.getNDim() + array.getSchema().getAttributeNum()) {
                List range = (List)ranges.get(i);
                if (range.isEmpty()) {
                    String columnName = this.tileDBReadSchema.getColumnName(i).get();
                    if (this.tileDBReadSchema.hasDimension(columnName)) {
                        range.add(new Range((Pair)nonEmptyDomain.get(columnName)));
                    } else {
                        range.add(new Range(true, new Pair(null, null)));
                    }
                } else {
                    List<Range> mergedRanges = this.checkAndMergeRanges(range);
                    ranges.set(i, mergedRanges);
                }
                ++i;
            }
            List<SubArrayRanges> subarrays = new ArrayList<SubArrayRanges>();
            util.generateAllSubarrays(ranges.subList(0, (int)domain.getNDim()), subarrays, 0, new ArrayList<Range>());
            int availablePartitions = this.tileDBDataSourceOptions.getPartitionCount();
            if (availablePartitions > 1) {
                if (subarrays.size() == 1 && ((SubArrayRanges)subarrays.get(0)).splittable()) {
                    subarrays = ((SubArrayRanges)subarrays.get(0)).splitToPartitions(availablePartitions);
                } else {
                    subarrays.sort(Collections.reverseOrder());
                    SubArrayRanges medianSubarray = (SubArrayRanges)subarrays.get(subarrays.size() / 2);
                    Object medianVolume = medianSubarray.getVolume();
                    List<Integer> neededSplitsToReduceToMedianVolume = this.computeNeededSplitsToReduceToMedianVolume(subarrays.subList(0, subarrays.size() / 2), (Number)medianVolume, medianSubarray.getDatatype());
                    int sumOfNeededSplitsForEvenDistributed = neededSplitsToReduceToMedianVolume.stream().mapToInt(Integer::intValue).sum();
                    for (int i3 = 0; i3 < neededSplitsToReduceToMedianVolume.size(); ++i3) {
                        SubArrayRanges subarray = subarrays.get(i3);
                        if (!subarray.splittable()) continue;
                        int numberOfWeightedSplits = (int)Math.ceil(neededSplitsToReduceToMedianVolume.get(i3).doubleValue() / (double)sumOfNeededSplitsForEvenDistributed * (double)availablePartitions);
                        List<SubArrayRanges> splitSubarray = subarray.split(numberOfWeightedSplits);
                        subarrays.remove(i3);
                        subarrays.addAll(splitSubarray);
                    }
                }
            }
            ArrayList<List<Range>> attributeRanges = new ArrayList<List<Range>>();
            int i4 = (int)domain.getNDim();
            while ((long)i4 < domain.getNDim() + array.getSchema().getAttributeNum()) {
                attributeRanges.add((List)ranges.get(i4));
                ++i4;
            }
            for (SubArrayRanges subarray : subarrays) {
                ArrayList<List<Range>> subarrayRanges = new ArrayList<List<Range>>();
                subarrayRanges.add(subarray.getRanges());
                readerPartitions.add(new TileDBDataInputPartition(util.tryGetArrayURI(this.tileDBDataSourceOptions), this.tileDBReadSchema, this.tileDBDataSourceOptions, subarrayRanges, attributeRanges));
            }
            this.metricsUpdater.finish("data-source-plan-batch-input-partitions");
            InputPartition[] partitionsArray = new InputPartition[readerPartitions.size()];
            partitionsArray = readerPartitions.toArray(partitionsArray);
            array.close();
            this.ctx.close();
            domain.close();
            return partitionsArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.metricsUpdater.finish("data-source-plan-batch-input-partitions");
            return null;
        }
    }

    private Pair<Pair<List<List<Range>>, Class>, QueryCondition> buildRangeFromFilter(Filter filter, HashMap<String, Pair> nonEmptyDomain) throws TileDBError {
        EqualNullSafe f;
        int i;
        this.metricsUpdater.startTimer("data-source-build-range-from-filter");
        String[] filterReferences = filter.references();
        QueryCondition finalQc = null;
        Class<?> filterType = filter.getClass();
        ArrayList ranges = new ArrayList();
        for (i = 0; i < this.tileDBReadSchema.dimensionIndex.size(); ++i) {
            ranges.add(new ArrayList());
        }
        for (i = 0; i < this.tileDBReadSchema.attributeIndex.size(); ++i) {
            ranges.add(new ArrayList());
        }
        if (filter instanceof And) {
            Pair<Pair<List<List<Range>>, Class>, QueryCondition> left = this.buildRangeFromFilter(((And)filter).left(), nonEmptyDomain);
            Pair<Pair<List<List<Range>>, Class>, QueryCondition> right = this.buildRangeFromFilter(((And)filter).right(), nonEmptyDomain);
            QueryCondition leftQc = (QueryCondition)left.getSecond();
            QueryCondition rightQc = (QueryCondition)right.getSecond();
            if (leftQc != null && rightQc != null) {
                finalQc = leftQc.combine(rightQc, tiledb_query_condition_combination_op_t.TILEDB_AND);
                leftQc.close();
                rightQc.close();
            }
            int leftIndex = IntStream.range(0, ((List)((Pair)left.getFirst()).getFirst()).size()).filter(e -> ((List)((List)((Pair)left.getFirst()).getFirst()).get(e)).size() > 0).findFirst().getAsInt();
            int rightIndex = IntStream.range(0, ((List)((Pair)right.getFirst()).getFirst()).size()).filter(e -> ((List)((List)((Pair)right.getFirst()).getFirst()).get(e)).size() > 0).findFirst().getAsInt();
            ArrayList constructedRanges = new ArrayList();
            for (int i2 = 0; i2 < Math.max(((List)((Pair)left.getFirst()).getFirst()).size(), ((List)((Pair)right.getFirst()).getFirst()).size()); ++i2) {
                constructedRanges.add(new ArrayList());
            }
            Pair newPair = new Pair(null, null);
            if (((Pair)left.getFirst()).getSecond() == GreaterThan.class || ((Pair)left.getFirst()).getSecond() == GreaterThanOrEqual.class) {
                newPair.setFirst(((Range)((List)((List)((Pair)left.getFirst()).getFirst()).get(leftIndex)).get(0)).getFirst());
            } else if (((Pair)left.getFirst()).getSecond() == LessThan.class || ((Pair)left.getFirst()).getSecond() == LessThanOrEqual.class) {
                newPair.setSecond(((Range)((List)((List)((Pair)left.getFirst()).getFirst()).get(leftIndex)).get(0)).getSecond());
            }
            if (((Pair)right.getFirst()).getSecond() == GreaterThan.class || ((Pair)right.getFirst()).getSecond() == GreaterThanOrEqual.class) {
                newPair.setFirst(((Range)((List)((List)((Pair)right.getFirst()).getFirst()).get(rightIndex)).get(0)).getFirst());
            } else if (((Pair)right.getFirst()).getSecond() == LessThan.class || ((Pair)right.getFirst()).getSecond() == LessThanOrEqual.class) {
                newPair.setSecond(((Range)((List)((List)((Pair)right.getFirst()).getFirst()).get(rightIndex)).get(0)).getSecond());
            }
            ArrayList<Range> constructedRange = new ArrayList<Range>();
            constructedRange.add(new Range(newPair));
            constructedRanges.set(leftIndex, constructedRange);
            Pair pair = new Pair(ranges, filterType);
            return new Pair((Object)pair, (Object)finalQc);
        }
        if (filter instanceof Or) {
            Pair<Pair<List<List<Range>>, Class>, QueryCondition> left = this.buildRangeFromFilter(((Or)filter).left(), nonEmptyDomain);
            Pair<Pair<List<List<Range>>, Class>, QueryCondition> right = this.buildRangeFromFilter(((Or)filter).right(), nonEmptyDomain);
            QueryCondition leftQc = (QueryCondition)left.getSecond();
            QueryCondition rightQc = (QueryCondition)right.getSecond();
            if (leftQc != null && rightQc != null) {
                finalQc = leftQc.combine(rightQc, tiledb_query_condition_combination_op_t.TILEDB_OR);
                leftQc.close();
                rightQc.close();
            }
            for (int i3 = 0; i3 < ((List)((Pair)left.getFirst()).getFirst()).size(); ++i3) {
                while (((List)((Pair)right.getFirst()).getFirst()).size() < i3) {
                    ((List)((Pair)right.getFirst()).getFirst()).add(new ArrayList());
                }
                ((List)((List)((Pair)right.getFirst()).getFirst()).get(i3)).addAll((Collection)((List)((Pair)left.getFirst()).getFirst()).get(i3));
            }
            right.setSecond((Object)finalQc);
            return right;
        }
        if (filter instanceof EqualNullSafe) {
            f = (EqualNullSafe)filter;
            int columnIndex = this.tileDBReadSchema.getColumnId(f.attribute()).get();
            ((List)ranges.get(columnIndex)).add(new Range(new Pair(f.value(), f.value())));
            finalQc = this.createBaseQueryCondition(filterReferences[0], f.value(), tiledb_query_condition_op_t.TILEDB_EQ);
        } else if (filter instanceof EqualTo) {
            f = (EqualTo)filter;
            int columnIndex = this.tileDBReadSchema.getColumnId(f.attribute()).get();
            ((List)ranges.get(columnIndex)).add(new Range(new Pair(f.value(), f.value())));
            finalQc = this.createBaseQueryCondition(filterReferences[0], f.value(), tiledb_query_condition_op_t.TILEDB_EQ);
        } else if (filter instanceof GreaterThan) {
            f = (GreaterThan)filter;
            Object second = nonEmptyDomain.get(f.attribute()) != null ? nonEmptyDomain.get(f.attribute()).getSecond() : this.getMaxValue(f.value().getClass());
            int columnIndex = this.tileDBReadSchema.getColumnId(f.attribute()).get();
            Number lowerBound = util.addEpsilon((Number)f.value(), this.tileDBReadSchema.columnTypes.get(columnIndex));
            ((List)ranges.get(columnIndex)).add(new Range(new Pair((Object)lowerBound, second)));
            finalQc = this.createBaseQueryCondition(filterReferences[0], f.value(), tiledb_query_condition_op_t.TILEDB_GT);
        } else if (filter instanceof GreaterThanOrEqual) {
            f = (GreaterThanOrEqual)filter;
            Object second = nonEmptyDomain.get(f.attribute()) != null ? nonEmptyDomain.get(f.attribute()).getSecond() : this.getMaxValue(f.value().getClass());
            int columnIndex = this.tileDBReadSchema.getColumnId(f.attribute()).get();
            ((List)ranges.get(columnIndex)).add(new Range(new Pair(f.value(), second)));
            finalQc = this.createBaseQueryCondition(filterReferences[0], f.value(), tiledb_query_condition_op_t.TILEDB_GE);
        } else if (filter instanceof In) {
            f = (In)filter;
            for (Object value : f.values()) {
                int dimIndex = this.tileDBReadSchema.getColumnId(f.attribute()).get();
                ((List)ranges.get(dimIndex)).add(new Range(new Pair(value, value)));
            }
        } else if (filter instanceof LessThan) {
            f = (LessThan)filter;
            Object first = nonEmptyDomain.get(f.attribute()) != null ? nonEmptyDomain.get(f.attribute()).getSecond() : this.getMinValue(f.value().getClass());
            int columnIndex = this.tileDBReadSchema.getColumnId(f.attribute()).get();
            ((List)ranges.get(columnIndex)).add(new Range(new Pair(first, (Object)util.subtractEpsilon((Number)f.value(), this.tileDBReadSchema.columnTypes.get(columnIndex)))));
            finalQc = this.createBaseQueryCondition(filterReferences[0], f.value(), tiledb_query_condition_op_t.TILEDB_LT);
        } else if (filter instanceof LessThanOrEqual) {
            f = (LessThanOrEqual)filter;
            Object first = nonEmptyDomain.get(f.attribute()) != null ? nonEmptyDomain.get(f.attribute()).getSecond() : this.getMinValue(f.value().getClass());
            int columnIndex = this.tileDBReadSchema.getColumnId(f.attribute()).get();
            ((List)ranges.get(columnIndex)).add(new Range(new Pair(first, f.value())));
            finalQc = this.createBaseQueryCondition(filterReferences[0], f.value(), tiledb_query_condition_op_t.TILEDB_LE);
        } else {
            throw new TileDBError("Unsupported filter type");
        }
        this.metricsUpdater.finish("data-source-build-range-from-filter");
        Pair pair = new Pair(ranges, filterType);
        return new Pair((Object)pair, (Object)finalQc);
    }

    public QueryCondition createBaseQueryCondition(String attributeName, Object filterValue, tiledb_query_condition_op_t OP) throws TileDBError {
        try {
            if (this.arraySchema.hasAttribute(attributeName)) {
                Attribute att = this.arraySchema.getAttribute(attributeName);
                QueryCondition finalQc = new QueryCondition(this.ctx, att.getName(), filterValue, att.getType().javaClass(), OP);
                att.close();
                return finalQc;
            }
        }
        catch (TileDBError e) {
            throw new RuntimeException(e);
        }
        if (!this.arraySchema.getDomain().hasDimension(attributeName)) {
            throw new TileDBError("You are applying a filter in a non existing attribute: " + attributeName);
        }
        return null;
    }

    private Object getMinValue(Class datatype) {
        if (datatype == Byte.class) {
            return (byte)-128;
        }
        if (datatype == Short.class) {
            return (short)Short.MIN_VALUE;
        }
        if (datatype == Integer.class) {
            return Integer.MIN_VALUE;
        }
        if (datatype == Long.class) {
            return Long.MIN_VALUE;
        }
        if (datatype == Float.class) {
            return Float.valueOf(Float.MIN_VALUE);
        }
        return null;
    }

    private Object getMaxValue(Class datatype) {
        if (datatype == Byte.class) {
            return (byte)127;
        }
        if (datatype == Short.class) {
            return (short)Short.MAX_VALUE;
        }
        if (datatype == Integer.class) {
            return Integer.MAX_VALUE;
        }
        if (datatype == Long.class) {
            return Long.MAX_VALUE;
        }
        if (datatype == Float.class) {
            return Float.valueOf(Float.MAX_VALUE);
        }
        return null;
    }

    private List<Range> checkAndMergeRanges(List<Range> range) throws TileDBError {
        this.metricsUpdater.startTimer("data-source-check-and-merge-ranges");
        ArrayList<Range> rangesToBeMerged = new ArrayList<Range>(range);
        Collections.sort(rangesToBeMerged);
        boolean mergeable = true;
        while (mergeable) {
            ArrayList<Range> mergedRange = new ArrayList<Range>();
            for (int i = 0; i < rangesToBeMerged.size(); ++i) {
                Range right;
                if (i == rangesToBeMerged.size() - 1) {
                    mergedRange.add((Range)rangesToBeMerged.get(i));
                    break;
                }
                Range left = (Range)rangesToBeMerged.get(i);
                if (left.canMerge(right = (Range)rangesToBeMerged.get(i + 1))) {
                    mergedRange.add(left.merge(right));
                    ++i;
                    continue;
                }
                mergedRange.add(left);
            }
            if (mergedRange.size() == rangesToBeMerged.size()) {
                mergeable = false;
            }
            rangesToBeMerged = new ArrayList(mergedRange);
        }
        this.metricsUpdater.finish("data-source-check-and-merge-ranges");
        return rangesToBeMerged;
    }

    private List<Integer> computeNeededSplitsToReduceToMedianVolume(List<SubArrayRanges> subArrayRanges, Number medianVolume, Class datatype) {
        this.metricsUpdater.startTimer("data-source-computer-needed-splits");
        ArrayList<Integer> neededSplits = new ArrayList<Integer>();
        for (SubArrayRanges subArrayRange : subArrayRanges) {
            Object volume = subArrayRange.getVolume();
            if (datatype == Byte.class) {
                neededSplits.add(((Number)volume).byteValue() / medianVolume.byteValue());
                continue;
            }
            if (datatype == Short.class) {
                neededSplits.add(((Number)volume).shortValue() / medianVolume.shortValue());
                continue;
            }
            if (datatype == Integer.class) {
                neededSplits.add(((Number)volume).intValue() / medianVolume.intValue());
                continue;
            }
            if (datatype == Long.class) {
                neededSplits.add(Long.valueOf(((Number)volume).longValue() / medianVolume.longValue()).intValue());
                continue;
            }
            if (datatype == Float.class) {
                neededSplits.add(Float.valueOf(((Number)volume).floatValue() / medianVolume.floatValue()).intValue());
                continue;
            }
            if (datatype != Double.class) continue;
            neededSplits.add(Double.valueOf(((Number)volume).doubleValue() / medianVolume.doubleValue()).intValue());
        }
        this.metricsUpdater.finish("data-source-computer-needed-splits");
        return neededSplits;
    }

    public PartitionReaderFactory createReaderFactory() {
        this.closeResources();
        return new TileDBPartitionReaderFactory();
    }

    private void closeResources() {
        this.array.close();
        this.arraySchema.close();
        this.ctx.close();
    }
}

