/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.TileDBError;
import io.tiledb.spark.TileDBDataSourceOptions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class TileDBReadSchema
implements Serializable {
    private String uri;
    private TileDBDataSourceOptions options;
    private StructType pushDownSparkSchema;
    private StructType tiledbSparkSchema;
    public HashMap<String, Integer> dimensionIndex;
    public HashMap<String, Integer> attributeIndex;
    public HashMap<Integer, String> dimensionName;
    public HashMap<Integer, String> attributeName;
    public HashMap<Integer, Datatype> columnTypes;

    public TileDBReadSchema(String uri, TileDBDataSourceOptions options) {
        this.uri = uri;
        this.options = options;
        this.dimensionIndex = new HashMap();
        this.attributeIndex = new HashMap();
        this.dimensionName = new HashMap();
        this.attributeName = new HashMap();
        this.columnTypes = new HashMap();
        this.tiledbSparkSchema = this.getSparkSchema();
        if (this.tiledbSparkSchema == null) {
            throw new RuntimeException("Unable to create Spark Schema");
        }
    }

    public TileDBReadSchema setPushDownSchema(StructType pushDownSchema) {
        this.pushDownSparkSchema = pushDownSchema;
        return this;
    }

    public StructType getSparkSchema() {
        if (this.pushDownSparkSchema != null) {
            return this.pushDownSparkSchema;
        }
        if (this.tiledbSparkSchema != null) {
            return this.tiledbSparkSchema;
        }
        try {
            this.tiledbSparkSchema = this.getTileDBSchema(this.options);
        }
        catch (TileDBError err) {
            throw new RuntimeException("Error  converting TileDB schema for '" + this.uri + "': " + err.getMessage());
        }
        return this.tiledbSparkSchema;
    }

    private StructType getTileDBSchema(TileDBDataSourceOptions options) throws TileDBError {
        StructType sparkSchema = new StructType();
        try (Context ctx = new Context(options.getTileDBConfigMap(true));
             ArraySchema arraySchema = new ArraySchema(ctx, this.uri.toString());
             Domain arrayDomain = arraySchema.getDomain();){
            int i = 0;
            while ((long)i < arrayDomain.getNDim()) {
                try (Dimension dim = arrayDomain.getDimension(Integer.valueOf(i));){
                    String dimName = dim.getName();
                    this.dimensionIndex.put(dimName, i);
                    this.dimensionName.put(i, dimName);
                    this.columnTypes.put(i, dim.getType());
                    sparkSchema = sparkSchema.add(this.toStructField(dimName, true, dim.getType(), 1L, false));
                }
                ++i;
            }
            int j = 0;
            while ((long)j < arraySchema.getAttributeNum()) {
                try (Attribute attr = arraySchema.getAttribute((long)j);){
                    this.attributeIndex.put(attr.getName(), j + i);
                    this.columnTypes.put(i + j, attr.getType());
                    this.attributeName.put(j + i, attr.getName());
                    String attrName = attr.getName();
                    sparkSchema = sparkSchema.add(this.toStructField(attrName, false, attr.getType(), attr.getCellValNum(), attr.getNullable()));
                }
                ++j;
            }
        }
        return sparkSchema;
    }

    public Optional<Integer> getColumnId(String columnName) {
        if (this.dimensionIndex.containsKey(columnName)) {
            return Optional.of(this.dimensionIndex.get(columnName));
        }
        if (this.attributeIndex.containsKey(columnName)) {
            return Optional.of(this.attributeIndex.get(columnName));
        }
        return Optional.empty();
    }

    public boolean hasDimension(String dimName) {
        return this.dimensionName.containsValue(dimName);
    }

    public Optional<String> getColumnName(Integer id) {
        if (this.dimensionName.containsKey(id)) {
            return Optional.of(this.dimensionName.get(id));
        }
        if (this.attributeName.containsKey(id)) {
            return Optional.of(this.attributeName.get(id));
        }
        return Optional.empty();
    }

    private StructField toStructField(String name, boolean isDim, Datatype tiledbType, long cellValNum, boolean isNullable) throws TileDBError {
        StructField field;
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        if (isDim) {
            metadataBuilder.putBoolean("tiledb.dimension", true);
        } else {
            metadataBuilder.putBoolean("tiledb.attribute", true);
        }
        Metadata metadata = metadataBuilder.build();
        switch (tiledbType) {
            case TILEDB_FLOAT32: {
                if (cellValNum > 1L) {
                    field = new StructField(name, (DataType)DataTypes.createArrayType((DataType)DataTypes.FloatType), isNullable, metadata);
                    break;
                }
                field = new StructField(name, DataTypes.FloatType, isNullable, metadata);
                break;
            }
            case TILEDB_FLOAT64: {
                if (cellValNum > 1L) {
                    field = new StructField(name, (DataType)DataTypes.createArrayType((DataType)DataTypes.DoubleType), isNullable, metadata);
                    break;
                }
                field = new StructField(name, DataTypes.DoubleType, isNullable, metadata);
                break;
            }
            case TILEDB_INT8: {
                if (cellValNum > 1L) {
                    field = new StructField(name, (DataType)DataTypes.createArrayType((DataType)DataTypes.ByteType), isNullable, metadata);
                    break;
                }
                field = new StructField(name, DataTypes.ByteType, isNullable, metadata);
                break;
            }
            case TILEDB_UINT8: 
            case TILEDB_INT16: {
                if (cellValNum > 1L) {
                    field = new StructField(name, (DataType)DataTypes.createArrayType((DataType)DataTypes.ShortType), isNullable, metadata);
                    break;
                }
                field = new StructField(name, DataTypes.ShortType, isNullable, metadata);
                break;
            }
            case TILEDB_UINT16: 
            case TILEDB_INT32: {
                if (cellValNum > 1L) {
                    field = new StructField(name, (DataType)DataTypes.createArrayType((DataType)DataTypes.IntegerType), isNullable, metadata);
                    break;
                }
                field = new StructField(name, DataTypes.IntegerType, isNullable, metadata);
                break;
            }
            case TILEDB_UINT32: 
            case TILEDB_INT64: {
                if (cellValNum > 1L) {
                    field = new StructField(name, (DataType)DataTypes.createArrayType((DataType)DataTypes.LongType), isNullable, metadata);
                    break;
                }
                field = new StructField(name, DataTypes.LongType, isNullable, metadata);
                break;
            }
            case TILEDB_CHAR: 
            case TILEDB_STRING_ASCII: 
            case TILEDB_STRING_UTF8: {
                field = new StructField(name, DataTypes.StringType, isNullable, metadata);
                break;
            }
            case TILEDB_DATETIME_DAY: 
            case TILEDB_DATETIME_WEEK: 
            case TILEDB_DATETIME_MONTH: 
            case TILEDB_DATETIME_YEAR: 
            case TILEDB_DATETIME_MS: 
            case TILEDB_DATETIME_AS: 
            case TILEDB_DATETIME_FS: 
            case TILEDB_DATETIME_PS: 
            case TILEDB_DATETIME_NS: 
            case TILEDB_DATETIME_US: 
            case TILEDB_DATETIME_SEC: 
            case TILEDB_DATETIME_MIN: 
            case TILEDB_DATETIME_HR: {
                field = new StructField(name, DataTypes.TimestampType, isNullable, metadata);
                break;
            }
            default: {
                throw new TileDBError("Unsupported TileDB to Spark DataFrame type mapping for schema column '" + name + "': " + tiledbType.name());
            }
        }
        return field;
    }
}

