/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.TileDBError;
import io.tiledb.spark.StringPartitioner;
import io.tiledb.spark.util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;

public class Range
implements Serializable,
Comparable<Range> {
    private Pair range;
    private Class dataClassType;

    Range(Pair range) {
        this.range = range;
        if (range.getFirst() != null) {
            this.dataClassType = range.getFirst().getClass();
        } else if (range.getSecond() != null) {
            this.dataClassType = range.getSecond().getClass();
        }
    }

    Range(boolean empty, Pair range) {
        this.range = range;
    }

    public <T extends Number> T width() {
        try {
            if (this.range.getFirst() instanceof Byte) {
                return (T)this.widthByte();
            }
            if (this.range.getFirst() instanceof Short) {
                return (T)this.widthShort();
            }
            if (this.range.getFirst() instanceof Integer) {
                return (T)this.widthInteger();
            }
            if (this.range.getFirst() instanceof Long) {
                return (T)this.widthLong();
            }
            if (this.range.getFirst() instanceof Float) {
                return (T)this.widthFloat();
            }
            if (this.range.getFirst() instanceof Double) {
                return (T)this.widthDouble();
            }
        }
        catch (TileDBError tileDBError) {
            tileDBError.printStackTrace();
        }
        return (T)Integer.valueOf(0);
    }

    private Integer widthByte() throws TileDBError {
        Pair tmp = this.range;
        return util.addEpsilon(Math.abs((Byte)tmp.getSecond() - (Byte)tmp.getFirst()), Datatype.TILEDB_INT8).intValue();
    }

    private Integer widthShort() throws TileDBError {
        Pair tmp = this.range;
        return util.addEpsilon(Math.abs((Short)tmp.getSecond() - (Short)tmp.getFirst()), Datatype.TILEDB_INT16).intValue();
    }

    private Integer widthInteger() throws TileDBError {
        Pair tmp = this.range;
        return (Integer)util.addEpsilon(Math.abs((Integer)tmp.getSecond() - (Integer)tmp.getFirst()), Datatype.TILEDB_INT32);
    }

    private Long widthLong() throws TileDBError {
        Pair tmp = this.range;
        return (Long)util.addEpsilon(Math.abs((Long)tmp.getSecond() - (Long)tmp.getFirst()), Datatype.TILEDB_INT64);
    }

    private Float widthFloat() throws TileDBError {
        Pair tmp = this.range;
        return (Float)util.addEpsilon(Float.valueOf(Math.abs(((Float)tmp.getSecond()).floatValue() - ((Float)tmp.getFirst()).floatValue())), Datatype.TILEDB_FLOAT32);
    }

    private Double widthDouble() throws TileDBError {
        Pair tmp = this.range;
        return (Double)util.addEpsilon(Math.abs((Double)tmp.getSecond() - (Double)tmp.getFirst()), Datatype.TILEDB_FLOAT64);
    }

    public Class dataClassType() {
        return this.dataClassType;
    }

    public Object getFirst() {
        return this.range.getFirst();
    }

    public Object getSecond() {
        return this.range.getSecond();
    }

    public Pair getRange() {
        return this.range;
    }

    public Range merge(Range other) {
        if (other.dataClassType != this.dataClassType) {
            return null;
        }
        if (this.dataClassType == Byte.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            return new Range(new Pair((Object)Math.max(((Byte)range.getFirst()).byteValue(), ((Byte)otherRange.getFirst()).byteValue()), (Object)Math.min(((Byte)range.getSecond()).byteValue(), ((Byte)otherRange.getSecond()).byteValue())));
        }
        if (this.dataClassType == Short.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            return new Range(new Pair((Object)Math.max(((Short)range.getFirst()).shortValue(), ((Short)otherRange.getFirst()).shortValue()), (Object)Math.min(((Short)range.getSecond()).shortValue(), ((Short)otherRange.getSecond()).shortValue())));
        }
        if (this.dataClassType == Integer.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            return new Range(new Pair((Object)Math.max((Integer)range.getFirst(), (Integer)otherRange.getFirst()), (Object)Math.min((Integer)range.getSecond(), (Integer)otherRange.getSecond())));
        }
        if (this.dataClassType == Long.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            return new Range(new Pair((Object)Math.max((Long)range.getFirst(), (Long)otherRange.getFirst()), (Object)Math.min((Long)range.getSecond(), (Long)otherRange.getSecond())));
        }
        if (this.dataClassType == Float.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            return new Range(new Pair((Object)Float.valueOf(Math.max(((Float)range.getFirst()).floatValue(), ((Float)otherRange.getFirst()).floatValue())), (Object)Float.valueOf(Math.min(((Float)range.getSecond()).floatValue(), ((Float)otherRange.getSecond()).floatValue()))));
        }
        if (this.dataClassType == Double.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            return new Range(new Pair((Object)Math.max((Double)range.getFirst(), (Double)otherRange.getFirst()), (Object)Math.min((Double)range.getSecond(), (Double)otherRange.getSecond())));
        }
        return null;
    }

    @Override
    public int compareTo(Range other) {
        if (this.dataClassType == Byte.class) {
            Pair rangeByte = this.range;
            Pair t1Byte = other.getRange();
            return Byte.compare((Byte)rangeByte.getFirst(), (Byte)t1Byte.getFirst());
        }
        if (this.dataClassType == Short.class) {
            Pair rangeShort = this.range;
            Pair t1Short = other.getRange();
            return Short.compare((Short)rangeShort.getFirst(), (Short)t1Short.getFirst());
        }
        if (this.dataClassType == Integer.class) {
            Pair rangeInteger = this.range;
            Pair t1Integer = other.getRange();
            return Integer.compare((Integer)rangeInteger.getFirst(), (Integer)t1Integer.getFirst());
        }
        if (this.dataClassType == Long.class) {
            Pair rangeLong = this.range;
            Pair t1Long = other.getRange();
            return Long.compare((Long)rangeLong.getFirst(), (Long)t1Long.getFirst());
        }
        if (this.dataClassType == Float.class) {
            Pair rangeFloat = this.range;
            Pair t1Float = other.getRange();
            return Float.compare(((Float)rangeFloat.getFirst()).floatValue(), ((Float)t1Float.getFirst()).floatValue());
        }
        if (this.dataClassType == Range.class) {
            Pair rangeDouble = this.range;
            Pair t1Double = other.getRange();
            return Double.compare((Double)rangeDouble.getFirst(), (Double)t1Double.getFirst());
        }
        return 0;
    }

    public boolean canMerge(Range other) throws TileDBError {
        if (other.dataClassType != this.dataClassType) {
            return false;
        }
        if (this.dataClassType == Byte.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            if ((Byte)range.getFirst() <= (Byte)otherRange.getFirst() && (Byte)range.getSecond() >= (Byte)otherRange.getSecond()) {
                return true;
            }
            if ((Byte)otherRange.getFirst() <= (Byte)range.getFirst() && (Byte)otherRange.getSecond() >= (Byte)range.getSecond()) {
                return true;
            }
            if ((Byte)range.getFirst() <= (Byte)otherRange.getFirst() && (Byte)range.getSecond() <= (Byte)otherRange.getSecond() && (Byte)range.getSecond() >= (Byte)otherRange.getFirst()) {
                return true;
            }
            if ((Byte)otherRange.getFirst() <= (Byte)range.getFirst() && (Byte)otherRange.getSecond() <= (Byte)range.getSecond() && (Byte)otherRange.getSecond() >= (Byte)range.getFirst()) {
                return true;
            }
            if ((Byte)range.getFirst() >= (Byte)otherRange.getFirst() && (Byte)range.getFirst() <= (Byte)otherRange.getSecond() && (Byte)range.getSecond() >= (Byte)otherRange.getSecond()) {
                return true;
            }
            if (range.getFirst() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_INT8) || range.getFirst() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_INT8)) {
                return true;
            }
            if (range.getSecond() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_INT8) || range.getSecond() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_INT8)) {
                return true;
            }
        } else if (this.dataClassType == Short.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            if ((Short)range.getFirst() <= (Short)otherRange.getFirst() && (Short)range.getSecond() >= (Short)otherRange.getSecond()) {
                return true;
            }
            if ((Short)otherRange.getFirst() <= (Short)range.getFirst() && (Short)otherRange.getSecond() >= (Short)range.getSecond()) {
                return true;
            }
            if ((Short)range.getFirst() <= (Short)otherRange.getFirst() && (Short)range.getSecond() <= (Short)otherRange.getSecond() && (Short)range.getSecond() >= (Short)otherRange.getFirst()) {
                return true;
            }
            if ((Short)otherRange.getFirst() <= (Short)range.getFirst() && (Short)otherRange.getSecond() <= (Short)range.getSecond() && (Short)otherRange.getSecond() >= (Short)range.getFirst()) {
                return true;
            }
            if ((Short)range.getFirst() >= (Short)otherRange.getFirst() && (Short)range.getFirst() <= (Short)otherRange.getSecond() && (Short)range.getSecond() >= (Short)otherRange.getSecond()) {
                return true;
            }
            if (range.getFirst() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_INT16) || range.getFirst() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_INT16)) {
                return true;
            }
            if (range.getSecond() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_INT16) || range.getSecond() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_INT16)) {
                return true;
            }
        } else if (this.dataClassType == Integer.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            if ((Integer)range.getFirst() <= (Integer)otherRange.getFirst() && (Integer)range.getSecond() >= (Integer)otherRange.getSecond()) {
                return true;
            }
            if ((Integer)otherRange.getFirst() <= (Integer)range.getFirst() && (Integer)otherRange.getSecond() >= (Integer)range.getSecond()) {
                return true;
            }
            if ((Integer)range.getFirst() <= (Integer)otherRange.getFirst() && (Integer)range.getSecond() <= (Integer)otherRange.getSecond() && (Integer)range.getSecond() >= (Integer)otherRange.getFirst()) {
                return true;
            }
            if ((Integer)otherRange.getFirst() <= (Integer)range.getFirst() && (Integer)otherRange.getSecond() <= (Integer)range.getSecond() && (Integer)otherRange.getSecond() >= (Integer)range.getFirst()) {
                return true;
            }
            if ((Integer)range.getFirst() >= (Integer)otherRange.getFirst() && (Integer)range.getFirst() <= (Integer)otherRange.getSecond() && (Integer)range.getSecond() >= (Integer)otherRange.getSecond()) {
                return true;
            }
            if (range.getFirst() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_INT32) || range.getFirst() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_INT32)) {
                return true;
            }
            if (range.getSecond() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_INT32) || range.getSecond() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_INT32)) {
                return true;
            }
        } else if (this.dataClassType == Long.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            if ((Long)range.getFirst() <= (Long)otherRange.getFirst() && (Long)range.getSecond() >= (Long)otherRange.getSecond()) {
                return true;
            }
            if ((Long)otherRange.getFirst() <= (Long)range.getFirst() && (Long)otherRange.getSecond() >= (Long)range.getSecond()) {
                return true;
            }
            if ((Long)range.getFirst() <= (Long)otherRange.getFirst() && (Long)range.getSecond() <= (Long)otherRange.getSecond() && (Long)range.getSecond() >= (Long)otherRange.getFirst()) {
                return true;
            }
            if ((Long)otherRange.getFirst() <= (Long)range.getFirst() && (Long)otherRange.getSecond() <= (Long)range.getSecond() && (Long)otherRange.getSecond() >= (Long)range.getFirst()) {
                return true;
            }
            if ((Long)range.getFirst() >= (Long)otherRange.getFirst() && (Long)range.getFirst() <= (Long)otherRange.getSecond() && (Long)range.getSecond() >= (Long)otherRange.getSecond()) {
                return true;
            }
            if (range.getFirst() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_INT64) || range.getFirst() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_INT64)) {
                return true;
            }
            if (range.getSecond() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_INT64) || range.getSecond() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_INT64)) {
                return true;
            }
        } else if (this.dataClassType == Float.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            if (((Float)range.getFirst()).floatValue() <= ((Float)otherRange.getFirst()).floatValue() && ((Float)range.getSecond()).floatValue() >= ((Float)otherRange.getSecond()).floatValue()) {
                return true;
            }
            if (((Float)otherRange.getFirst()).floatValue() <= ((Float)range.getFirst()).floatValue() && ((Float)otherRange.getSecond()).floatValue() >= ((Float)range.getSecond()).floatValue()) {
                return true;
            }
            if (((Float)range.getFirst()).floatValue() <= ((Float)otherRange.getFirst()).floatValue() && ((Float)range.getSecond()).floatValue() <= ((Float)otherRange.getSecond()).floatValue() && ((Float)range.getSecond()).floatValue() >= ((Float)otherRange.getFirst()).floatValue()) {
                return true;
            }
            if (((Float)otherRange.getFirst()).floatValue() <= ((Float)range.getFirst()).floatValue() && ((Float)otherRange.getSecond()).floatValue() <= ((Float)range.getSecond()).floatValue() && ((Float)otherRange.getSecond()).floatValue() >= ((Float)range.getFirst()).floatValue()) {
                return true;
            }
            if (((Float)range.getFirst()).floatValue() >= ((Float)otherRange.getFirst()).floatValue() && ((Float)range.getFirst()).floatValue() <= ((Float)otherRange.getSecond()).floatValue() && ((Float)range.getSecond()).floatValue() >= ((Float)otherRange.getSecond()).floatValue()) {
                return true;
            }
            if (range.getFirst() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_FLOAT32) || range.getFirst() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_FLOAT32)) {
                return true;
            }
            if (range.getSecond() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_FLOAT32) || range.getSecond() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_FLOAT32)) {
                return true;
            }
        } else if (this.dataClassType == Double.class) {
            Pair range = this.range;
            Pair otherRange = other.range;
            if ((Double)range.getFirst() <= (Double)otherRange.getFirst() && (Double)range.getSecond() >= (Double)otherRange.getSecond()) {
                return true;
            }
            if ((Double)otherRange.getFirst() <= (Double)range.getFirst() && (Double)otherRange.getSecond() >= (Double)range.getSecond()) {
                return true;
            }
            if ((Double)range.getFirst() <= (Double)otherRange.getFirst() && (Double)range.getSecond() <= (Double)otherRange.getSecond() && (Double)range.getSecond() >= (Double)otherRange.getFirst()) {
                return true;
            }
            if ((Double)otherRange.getFirst() <= (Double)range.getFirst() && (Double)otherRange.getSecond() <= (Double)range.getSecond() && (Double)otherRange.getSecond() >= (Double)range.getFirst()) {
                return true;
            }
            if ((Double)range.getFirst() >= (Double)otherRange.getFirst() && (Double)range.getFirst() <= (Double)otherRange.getSecond() && (Double)range.getSecond() >= (Double)otherRange.getSecond()) {
                return true;
            }
            if (range.getFirst() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_FLOAT64) || range.getFirst() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_FLOAT64)) {
                return true;
            }
            if (range.getSecond() == util.addEpsilon((Number)otherRange.getFirst(), Datatype.TILEDB_FLOAT64) || range.getSecond() == util.addEpsilon((Number)otherRange.getSecond(), Datatype.TILEDB_FLOAT64)) {
                return true;
            }
        }
        return false;
    }

    public Datatype tileDBDatatype() {
        if (this.dataClassType == Byte.class) {
            return Datatype.TILEDB_INT8;
        }
        if (this.dataClassType == Short.class) {
            return Datatype.TILEDB_INT16;
        }
        if (this.dataClassType == Integer.class) {
            return Datatype.TILEDB_INT32;
        }
        if (this.dataClassType == Long.class) {
            return Datatype.TILEDB_INT64;
        }
        if (this.dataClassType == Float.class) {
            return Datatype.TILEDB_FLOAT32;
        }
        if (this.dataClassType == Double.class) {
            return Datatype.TILEDB_FLOAT64;
        }
        return Datatype.TILEDB_ANY;
    }

    public boolean splittable() {
        return this.range.getFirst() != this.range.getSecond();
    }

    public List<Range> splitRange(int buckets) throws TileDBError {
        Number max;
        ArrayList<Range> ranges = new ArrayList<Range>();
        Number min = (Number)this.range.getFirst();
        if (min == (max = (Number)this.range.getSecond())) {
            ranges.add(new Range(this.range));
            return ranges;
        }
        Number rangeLength = util.divideObjects(util.subtractObjects(max, min, this.dataClassType), (Number)ConvertUtils.convert((Object)buckets, (Class)this.dataClassType), this.dataClassType);
        Long leftOvers = (Long)ConvertUtils.convert((Object)util.moduloObjects(util.subtractObjects(max, min, this.dataClassType), (Number)ConvertUtils.convert((Object)buckets, (Class)this.dataClassType), this.dataClassType), Long.class);
        Number low = min;
        for (int i = 0; i < buckets; ++i) {
            Number high = util.subtractEpsilon(util.addObjects(low, rangeLength, this.dataClassType), this.tileDBDatatype());
            if (i == buckets - 1 || util.greaterThanOrEqual(util.addObjects(low, rangeLength, this.dataClassType), max, this.dataClassType)) {
                high = max;
            } else if (leftOvers > 0L) {
                high = util.addEpsilon(high, this.tileDBDatatype());
                Long l = leftOvers;
                Long l2 = leftOvers = Long.valueOf(leftOvers - 1L);
            }
            ranges.add(new Range(new Pair((Object)low, (Object)high)));
            low = util.addEpsilon(high, this.tileDBDatatype());
            if (high == max) break;
        }
        return ranges;
    }

    public List<Range> splitRangeToPartitions(int partitions, double partitionWidth) throws TileDBError {
        Number pWidth;
        ArrayList<Range> ranges = new ArrayList<Range>();
        Number min = (Number)this.range.getFirst();
        Number max = (Number)this.range.getSecond();
        if (this.dataClassType == Float.class || this.dataClassType == Double.class) {
            pWidth = partitionWidth;
        } else {
            if (partitionWidth < 1.0) {
                long actualWidth = ((Number)this.width()).longValue();
                partitions = (int)actualWidth;
                partitionWidth = 1.0;
            }
            pWidth = (Number)util.castLong((long)partitionWidth, this.dataClassType);
        }
        if (!this.splittable()) {
            ranges.add(new Range(this.range));
            return ranges;
        }
        Number currentMin = min;
        Number currentMax = util.subtractEpsilon(util.addObjects(currentMin, pWidth, this.dataClassType), this.tileDBDatatype());
        ranges.add(new Range(new Pair((Object)currentMin, (Object)currentMax)));
        for (int i = 1; i < partitions; ++i) {
            currentMin = util.addEpsilon(currentMax, this.tileDBDatatype());
            if (util.greaterThanOrEqual(currentMax = util.subtractEpsilon(util.addObjects(currentMin, pWidth, this.dataClassType), this.tileDBDatatype()), max, this.dataClassType) || i == partitions - 1) {
                currentMax = max;
                ranges.add(new Range(new Pair((Object)currentMin, (Object)currentMax)));
                break;
            }
            ranges.add(new Range(new Pair((Object)currentMin, (Object)currentMax)));
        }
        return ranges;
    }

    public List<Range> splitStringRangeToPartitions(int partitions) throws TileDBError {
        StringPartitioner partitioner = new StringPartitioner();
        List<Pair<String, String>> stringRanges = partitioner.split(this.range.getFirst().toString(), this.range.getSecond().toString(), partitions);
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Pair<String, String> range : stringRanges) {
            ranges.add(new Range(range));
        }
        return ranges;
    }
}

