/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Constants;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.JavaArray;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Query;
import io.tiledb.java.api.QueryStatus;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.TileDBError;
import io.tiledb.spark.TileDBDataSourceOptions;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.TileDBWriteMetricsUpdater;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class TileDBDataWriter
implements DataWriter<InternalRow> {
    static Logger log = Logger.getLogger((String)TileDBDataWriter.class.getName());
    private final TileDBWriteMetricsUpdater metricsUpdater;
    private final TaskContext task;
    private String uri;
    private StructType sparkSchema;
    private Context ctx;
    private Array array;
    private Query query;
    private final int nDims;
    private final int[] bufferIndex;
    private final String[] bufferNames;
    private final Datatype[] bufferDatatypes;
    private final long[] bufferValNum;
    private boolean[] bufferNullable;
    private short[][] nativeArrayValidityByteMap;
    private long[][] javaArrayOffsetBuffers;
    private JavaArray[] javaArrayBuffers;
    private int[] bufferSizes;
    private int[] nativeArrayOffsetElements;
    private int[] nativeArrayBufferElements;
    private long writeBufferSize;
    private int nRecordsBuffered;
    private static final OffsetDateTime zeroDateTime = new Timestamp(0L).toLocalDateTime().atOffset(ZoneOffset.UTC);

    public TileDBDataWriter(String uri, StructType schema, TileDBDataSourceOptions options) {
        this.uri = uri;
        this.sparkSchema = schema;
        this.writeBufferSize = options.getWriteBufferSize();
        this.metricsUpdater = new TileDBWriteMetricsUpdater(TaskContext.get());
        this.metricsUpdater.startTimer("query-write-start-to-close");
        this.metricsUpdater.startTimer("query-write-task");
        this.task = TaskContext.get();
        this.task.addTaskCompletionListener(context -> {
            double duration = (double)this.metricsUpdater.finish("query-write-task").longValue() / 1.0E9;
            log.debug((Object)("duration of write task " + this.task.toString() + " : " + duration + "s"));
        });
        StructField[] sparkSchemaFields = schema.fields();
        int nFields = sparkSchemaFields.length;
        this.bufferIndex = new int[nFields];
        this.bufferNullable = new boolean[nFields];
        this.bufferNames = new String[nFields];
        this.bufferValNum = new long[nFields];
        this.bufferDatatypes = new Datatype[nFields];
        this.nativeArrayValidityByteMap = new short[nFields][];
        this.javaArrayOffsetBuffers = new long[nFields][];
        this.nativeArrayOffsetElements = new int[nFields];
        this.javaArrayBuffers = new JavaArray[nFields];
        this.nativeArrayBufferElements = new int[nFields];
        try {
            this.ctx = new Context(options.getTileDBConfigMap(false));
            this.array = new Array(this.ctx, uri.toString(), QueryType.TILEDB_WRITE);
            try (ArraySchema arraySchema = this.array.getSchema();){
                try (Domain domain = arraySchema.getDomain();){
                    this.nDims = Math.toIntExact(domain.getNDim());
                    int i = 0;
                    while ((long)i < domain.getRank()) {
                        try (Dimension dim = domain.getDimension(Integer.valueOf(i));){
                            String dimName = dim.getName();
                            for (int di = 0; di < this.bufferIndex.length; ++di) {
                                if (!sparkSchemaFields[di].name().equals(dimName)) continue;
                                this.bufferIndex[di] = i;
                                this.bufferNames[i] = dimName;
                                this.bufferDatatypes[i] = dim.getType();
                                this.bufferValNum[i] = dim.getCellValNum();
                                this.bufferNullable[i] = false;
                                break;
                            }
                        }
                        ++i;
                    }
                }
                int i = 0;
                while ((long)i < arraySchema.getAttributeNum()) {
                    try (Attribute attribute = arraySchema.getAttribute((long)i);){
                        String attrName = attribute.getName();
                        for (int ai = 0; ai < this.bufferIndex.length; ++ai) {
                            int bufferIdx;
                            if (!sparkSchemaFields[ai].name().equals(attrName)) continue;
                            this.bufferIndex[ai] = bufferIdx = this.nDims + i;
                            this.bufferNames[bufferIdx] = attrName;
                            this.bufferDatatypes[bufferIdx] = attribute.getType();
                            this.bufferValNum[bufferIdx] = attribute.getCellValNum();
                            this.bufferNullable[bufferIdx] = attribute.getNullable();
                        }
                    }
                    ++i;
                }
            }
            this.resetWriteQueryAndBuffers();
        }
        catch (TileDBError err) {
            err.printStackTrace();
            throw new RuntimeException(err.getMessage());
        }
    }

    private void resetWriteQueryAndBuffers() throws TileDBError {
        this.metricsUpdater.startTimer("query-write-reset-query-and-buffer");
        if (this.query != null) {
            this.query.close();
        }
        this.query = new Query(this.array, QueryType.TILEDB_WRITE);
        this.query.setLayout(Layout.TILEDB_UNORDERED);
        int bufferIdx = 0;
        try (ArraySchema arraySchema = this.array.getSchema();){
            ArrayList<String> columnNames = new ArrayList<String>();
            int i = 0;
            while ((long)i < arraySchema.getDomain().getNDim()) {
                columnNames.add(arraySchema.getDomain().getDimension(Integer.valueOf(i)).getName());
                ++i;
            }
            i = 0;
            while ((long)i < arraySchema.getAttributeNum()) {
                columnNames.add(arraySchema.getAttribute((long)i).getName());
                ++i;
            }
            this.bufferSizes = new int[columnNames.size()];
            for (String attributeName : columnNames) {
                Datatype datatype;
                boolean isVar;
                boolean nullable = false;
                if (arraySchema.hasAttribute(attributeName)) {
                    try (Attribute attr = arraySchema.getAttribute(attributeName);){
                        nullable = attr.getNullable();
                        isVar = attr.isVar();
                        datatype = attr.getType();
                    }
                } else {
                    Dimension dimension = arraySchema.getDomain().getDimension(attributeName);
                    isVar = dimension.isVar();
                    datatype = dimension.getType();
                }
                if (isVar) {
                    int numOffsets = Math.toIntExact(this.writeBufferSize / (long)Datatype.TILEDB_UINT64.getNativeSize());
                    this.javaArrayOffsetBuffers[bufferIdx] = new long[numOffsets];
                    this.nativeArrayOffsetElements[bufferIdx] = 0;
                    int numElements = Math.toIntExact(this.writeBufferSize / (long)datatype.getNativeSize());
                    this.javaArrayBuffers[bufferIdx] = new JavaArray(datatype, numElements);
                    this.bufferSizes[bufferIdx] = numElements;
                    this.nativeArrayBufferElements[bufferIdx] = 0;
                    if (nullable) {
                        this.nativeArrayValidityByteMap[bufferIdx] = new short[numElements];
                        Arrays.fill(this.nativeArrayValidityByteMap[bufferIdx], (short)1);
                    }
                } else {
                    int numElements = Math.toIntExact(this.writeBufferSize / (long)datatype.getNativeSize());
                    this.javaArrayBuffers[bufferIdx] = new JavaArray(datatype, numElements);
                    this.bufferSizes[bufferIdx] = numElements;
                    this.nativeArrayBufferElements[bufferIdx] = 0;
                    if (nullable) {
                        this.nativeArrayValidityByteMap[bufferIdx] = new short[numElements];
                        Arrays.fill(this.nativeArrayValidityByteMap[bufferIdx], (short)1);
                    }
                }
                ++bufferIdx;
            }
        }
        this.nRecordsBuffered = 0;
        this.metricsUpdater.finish("query-write-reset-query-and-buffer");
    }

    private boolean bufferDimensionValue(int dimIdx, InternalRow record, int ordinal) throws TileDBError {
        int bufferIdx = 0;
        int bufferElements = this.nRecordsBuffered * this.nDims + dimIdx;
        return this.writeRecordToBuffer(bufferIdx, bufferElements, record, ordinal);
    }

    private boolean bufferAttributeValue(int attrIdx, InternalRow record, int ordinal) throws TileDBError {
        int bufferElements = this.nRecordsBuffered;
        return this.writeRecordToBuffer(attrIdx, bufferElements, record, ordinal);
    }

    private boolean writeRecordToBuffer(int bufferIdx, int bufferElement, InternalRow record, int ordinal) throws TileDBError {
        int maxOffsetElements;
        boolean isNull = false;
        this.metricsUpdater.startTimer("query-write-record-to-buffer");
        Datatype dtype = this.bufferDatatypes[bufferIdx];
        JavaArray buffer = this.javaArrayBuffers[bufferIdx];
        long[] offsets = this.javaArrayOffsetBuffers[bufferIdx];
        short[] validityByteMap = this.nativeArrayValidityByteMap[bufferIdx];
        boolean isArray = this.bufferValNum[bufferIdx] > 1L;
        int maxBufferElements = this.bufferSizes[bufferIdx];
        if (bufferElement >= maxBufferElements) {
            this.metricsUpdater.finish("query-write-record-to-buffer");
            return true;
        }
        if (isArray && bufferElement >= (maxOffsetElements = offsets.length)) {
            this.metricsUpdater.finish("query-write-record-to-buffer");
            return true;
        }
        if (record.isNullAt(ordinal)) {
            validityByteMap[bufferElement] = 0;
            isNull = true;
        }
        switch (dtype) {
            case TILEDB_INT8: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    byte[] array = record.getArray(ordinal).toByteArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i]);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n2 = bufferIdx;
                    this.nativeArrayBufferElements[n2] = this.nativeArrayBufferElements[n2] + array.length;
                    break;
                }
                if (bufferElement + 1 > maxBufferElements) {
                    // empty if block
                }
                buffer.set(bufferElement, record.getByte(ordinal));
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_UINT8: 
            case TILEDB_INT16: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    short[] array = record.getArray(ordinal).toShortArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i]);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n3 = bufferIdx;
                    this.nativeArrayBufferElements[n3] = this.nativeArrayBufferElements[n3] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getShort(ordinal));
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_UINT16: 
            case TILEDB_INT32: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    int[] array = record.getArray(ordinal).toIntArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i]);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n4 = bufferIdx;
                    this.nativeArrayBufferElements[n4] = this.nativeArrayBufferElements[n4] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getInt(ordinal));
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_UINT32: 
            case TILEDB_UINT64: 
            case TILEDB_INT64: 
            case TILEDB_DATETIME_US: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    long[] array = record.getArray(ordinal).toLongArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i]);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n5 = bufferIdx;
                    this.nativeArrayBufferElements[n5] = this.nativeArrayBufferElements[n5] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getLong(ordinal));
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_FLOAT32: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    float[] array = record.getArray(ordinal).toFloatArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i]);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n6 = bufferIdx;
                    this.nativeArrayBufferElements[n6] = this.nativeArrayBufferElements[n6] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getFloat(ordinal));
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_FLOAT64: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    double[] array = record.getArray(ordinal).toDoubleArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i]);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n7 = bufferIdx;
                    this.nativeArrayBufferElements[n7] = this.nativeArrayBufferElements[n7] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getDouble(ordinal));
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_CHAR: 
            case TILEDB_STRING_ASCII: 
            case TILEDB_STRING_UTF8: {
                int bytesLen;
                int bufferOffset;
                String val = " ";
                if (!isNull) {
                    val = record.getString(ordinal);
                }
                if ((bufferOffset = this.nativeArrayBufferElements[bufferIdx]) + (bytesLen = val.getBytes().length) > maxBufferElements) {
                    this.metricsUpdater.finish("query-write-record-to-buffer");
                    return true;
                }
                buffer.set(bufferOffset, val.getBytes());
                offsets[bufferElement] = bufferOffset;
                int n = bufferIdx;
                this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                int n8 = bufferIdx;
                this.nativeArrayBufferElements[n8] = this.nativeArrayBufferElements[n8] + bytesLen;
                break;
            }
            case TILEDB_DATETIME_DAY: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    int[] array = record.getArray(ordinal).toIntArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, Integer.valueOf(array[i]).longValue());
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n9 = bufferIdx;
                    this.nativeArrayBufferElements[n9] = this.nativeArrayBufferElements[n9] + array.length;
                    break;
                }
                buffer.set(bufferElement, Integer.valueOf(record.getInt(ordinal)).longValue());
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_AS: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    long[] array = record.getArray(ordinal).toLongArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i] * 1000000000000L);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n10 = bufferIdx;
                    this.nativeArrayBufferElements[n10] = this.nativeArrayBufferElements[n10] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getLong(ordinal) * 1000000000000L);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_FS: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    long[] array = record.getArray(ordinal).toLongArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i] * 1000000000L);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n11 = bufferIdx;
                    this.nativeArrayBufferElements[n11] = this.nativeArrayBufferElements[n11] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getLong(ordinal) * 1000000000L);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_PS: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    long[] array = record.getArray(ordinal).toLongArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i] * 1000000L);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n12 = bufferIdx;
                    this.nativeArrayBufferElements[n12] = this.nativeArrayBufferElements[n12] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getLong(ordinal) * 1000000L);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_NS: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    long[] array = record.getArray(ordinal).toLongArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i] * 1000L);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n13 = bufferIdx;
                    this.nativeArrayBufferElements[n13] = this.nativeArrayBufferElements[n13] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getLong(ordinal) * 1000L);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_MS: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    long[] array = record.getArray(ordinal).toLongArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i] / 1000L);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n14 = bufferIdx;
                    this.nativeArrayBufferElements[n14] = this.nativeArrayBufferElements[n14] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getLong(ordinal) / 1000L);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_SEC: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    long[] array = record.getArray(ordinal).toLongArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i] / 1000000L);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n15 = bufferIdx;
                    this.nativeArrayBufferElements[n15] = this.nativeArrayBufferElements[n15] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getLong(ordinal) / 1000000L);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_MIN: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    long[] array = record.getArray(ordinal).toLongArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i] / 60000000L);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n16 = bufferIdx;
                    this.nativeArrayBufferElements[n16] = this.nativeArrayBufferElements[n16] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getLong(ordinal) / 60000000L);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_HR: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    long[] array = record.getArray(ordinal).toLongArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        buffer.set(bufferOffset + i, array[i] / 3600000000L);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n17 = bufferIdx;
                    this.nativeArrayBufferElements[n17] = this.nativeArrayBufferElements[n17] + array.length;
                    break;
                }
                buffer.set(bufferElement, record.getLong(ordinal) / 3600000000L);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_WEEK: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    int[] array = record.getArray(ordinal).toIntArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        OffsetDateTime dt = new Timestamp(record.getLong(ordinal) / 1000L).toLocalDateTime().atOffset(ZoneOffset.UTC);
                        long value = ChronoUnit.WEEKS.between(zeroDateTime, dt);
                        buffer.set(bufferOffset + i, value);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n18 = bufferIdx;
                    this.nativeArrayBufferElements[n18] = this.nativeArrayBufferElements[n18] + array.length;
                    break;
                }
                OffsetDateTime dt = new Timestamp(record.getLong(ordinal) / 1000L).toLocalDateTime().atOffset(ZoneOffset.UTC);
                long value = ChronoUnit.WEEKS.between(zeroDateTime, dt);
                buffer.set(bufferElement, value);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_MONTH: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    int[] array = record.getArray(ordinal).toIntArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        OffsetDateTime dt = new Timestamp(record.getLong(ordinal) / 1000L).toLocalDateTime().atOffset(ZoneOffset.UTC);
                        long value = ChronoUnit.MONTHS.between(zeroDateTime, dt);
                        buffer.set(bufferOffset + i, value);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n19 = bufferIdx;
                    this.nativeArrayBufferElements[n19] = this.nativeArrayBufferElements[n19] + array.length;
                    break;
                }
                OffsetDateTime dt = new Timestamp(record.getLong(ordinal) / 1000L).toLocalDateTime().atOffset(ZoneOffset.UTC);
                long value = ChronoUnit.MONTHS.between(zeroDateTime, dt);
                buffer.set(bufferElement, value);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            case TILEDB_DATETIME_YEAR: {
                if (isArray) {
                    int bufferOffset = this.nativeArrayBufferElements[bufferElement];
                    int[] array = record.getArray(ordinal).toIntArray();
                    if (bufferOffset + array.length > maxBufferElements) {
                        this.metricsUpdater.finish("query-write-record-to-buffer");
                        return true;
                    }
                    for (int i = 0; i < array.length; ++i) {
                        OffsetDateTime dt = new Timestamp(record.getLong(ordinal) / 1000L).toLocalDateTime().atOffset(ZoneOffset.UTC);
                        long value = ChronoUnit.YEARS.between(zeroDateTime, dt);
                        buffer.set(bufferOffset + i, value);
                    }
                    offsets[bufferElement] = bufferOffset;
                    int n = bufferIdx;
                    this.nativeArrayOffsetElements[n] = this.nativeArrayOffsetElements[n] + 1;
                    int n20 = bufferIdx;
                    this.nativeArrayBufferElements[n20] = this.nativeArrayBufferElements[n20] + array.length;
                    break;
                }
                OffsetDateTime dt = new Timestamp(record.getLong(ordinal) / 1000L).toLocalDateTime().atOffset(ZoneOffset.UTC);
                long value = ChronoUnit.YEARS.between(zeroDateTime, dt);
                buffer.set(bufferElement, value);
                int n = bufferIdx;
                this.nativeArrayBufferElements[n] = this.nativeArrayBufferElements[n] + 1;
                break;
            }
            default: {
                this.metricsUpdater.finish("query-write-record-to-buffer");
                throw new TileDBError("Unimplemented attribute type for Spark writes: " + dtype);
            }
        }
        this.metricsUpdater.finish("query-write-record-to-buffer");
        return false;
    }

    public void write(InternalRow record) throws IOException {
        this.metricsUpdater.startTimer("query-write-row");
        try {
            for (int flushAttempts = 0; flushAttempts < 2; ++flushAttempts) {
                int buffIdx;
                boolean retryAfterFlush = false;
                for (int ordinal = 0; ordinal < record.numFields() && !(retryAfterFlush = this.bufferAttributeValue(buffIdx = this.bufferIndex[ordinal], record, ordinal)); ++ordinal) {
                }
                if (!retryAfterFlush) break;
                if (this.nRecordsBuffered == 0 || flushAttempts == 1) {
                    throw new TileDBError("Allocated buffer sizes are too small to write Spark varlen data, increase max buffer size");
                }
                if (this.nRecordsBuffered <= 0 || flushAttempts != 0) continue;
                this.flushBuffers();
                this.resetWriteQueryAndBuffers();
            }
            ++this.nRecordsBuffered;
        }
        catch (TileDBError err) {
            this.metricsUpdater.finish("query-write-row");
            throw new IOException(err.getMessage());
        }
        this.metricsUpdater.finish("query-write-row");
    }

    private void flushBuffers() throws TileDBError {
        this.metricsUpdater.startTimer("query-write-flush-buffers");
        long buffersInBytes = 0L;
        int dimSizes = 0;
        for (Dimension dimension : this.array.getSchema().getDomain().getDimensions()) {
            dimSizes += dimension.getType().getNativeSize();
        }
        buffersInBytes += (long)(this.nRecordsBuffered * this.nDims * dimSizes);
        for (int i = 0; i < this.bufferNames.length; ++i) {
            String name = this.bufferNames[i];
            buffersInBytes += (long)(this.nRecordsBuffered * this.nDims * this.bufferDatatypes[i].getNativeSize());
            boolean isVar = this.bufferValNum[i] == Constants.TILEDB_VAR_NUM;
            boolean nullable = this.bufferNullable[i];
            Datatype bufferDataType = this.javaArrayBuffers[i].getDataType();
            String bufferData = this.javaArrayBuffers[i].getDataType() == Datatype.TILEDB_CHAR || this.javaArrayBuffers[i].getDataType() == Datatype.TILEDB_STRING_ASCII ? new String((byte[])this.javaArrayBuffers[i].get()) : this.javaArrayBuffers[i].get();
            this.query.setDataBuffer(name, new NativeArray(this.ctx, (Object)bufferData, bufferDataType, this.nativeArrayBufferElements[i]));
            if (isVar) {
                this.query.setOffsetsBuffer(name, new NativeArray(this.ctx, (Object)this.javaArrayOffsetBuffers[i], Datatype.TILEDB_UINT64, this.nativeArrayOffsetElements[i]));
            }
            if (!nullable) continue;
            this.query.setValidityBuffer(name, new NativeArray(this.ctx, (Object)this.nativeArrayValidityByteMap[i], Datatype.TILEDB_UINT8, this.nativeArrayBufferElements[i]));
        }
        QueryStatus status = this.query.submit();
        if (status != QueryStatus.TILEDB_COMPLETED) {
            this.metricsUpdater.finish("query-write-flush-buffers");
            throw new TileDBError("Query write error: " + status);
        }
        this.metricsUpdater.appendTaskMetrics(this.nRecordsBuffered, buffersInBytes);
        this.metricsUpdater.finish("query-write-flush-buffers");
    }

    private void closeTileDBResources() {
        this.metricsUpdater.startTimer("query-write-close");
        this.query.close();
        this.array.close();
        this.ctx.close();
        this.metricsUpdater.finish("query-write-close");
    }

    public WriterCommitMessage commit() throws IOException {
        this.metricsUpdater.startTimer("query-write-commit");
        try {
            if (this.nRecordsBuffered >= 1) {
                this.flushBuffers();
            }
        }
        catch (TileDBError err) {
            this.metricsUpdater.finish("query-write-commit");
            this.metricsUpdater.finish("query-write-start-to-close");
            throw new IOException(err.getMessage());
        }
        this.closeTileDBResources();
        this.metricsUpdater.finish("query-write-commit");
        double duration = (double)this.metricsUpdater.finish("query-write-start-to-close").longValue() / 1.0E9;
        log.debug((Object)("duration of write-to-commit " + this.task.toString() + " : " + duration + "s"));
        return null;
    }

    public void abort() throws IOException {
        this.closeTileDBResources();
        this.metricsUpdater.finish("query-write-start-to-close");
    }

    public void close() throws IOException {
        this.closeTileDBResources();
    }
}

