/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.spark.TileDBDataSourceOptions;
import io.tiledb.spark.TileDBReadSchema;
import io.tiledb.spark.TileDBScan;
import io.tiledb.spark.util;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.TileDBReadMetricsUpdater;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.types.StructType;

public class TileDBScanBuilder
implements ScanBuilder,
SupportsPushDownFilters,
SupportsPushDownRequiredColumns {
    private final TileDBDataSourceOptions options;
    private final TileDBReadMetricsUpdater metricsUpdater;
    private final TileDBReadSchema tileDBReadSchema;
    private Filter[] pushedFilters;
    private String uri;
    static Logger log = Logger.getLogger((String)TileDBScanBuilder.class.getName());

    public TileDBScanBuilder(Map<String, String> properties, TileDBDataSourceOptions tileDBDataSourceOptions) throws URISyntaxException {
        this.options = tileDBDataSourceOptions;
        this.metricsUpdater = new TileDBReadMetricsUpdater(TaskContext.get());
        this.uri = util.tryGetArrayURI(tileDBDataSourceOptions);
        this.tileDBReadSchema = new TileDBReadSchema(this.uri, this.options);
    }

    public Filter[] pushFilters(Filter[] filters) {
        this.metricsUpdater.startTimer("data-source-push-filters");
        log.trace((Object)("size of filters " + filters.length));
        ArrayList<Filter> pushedFiltersList = new ArrayList<Filter>();
        ArrayList<Filter> leftOverFilters = new ArrayList<Filter>();
        for (Filter filter : filters) {
            if (this.filterCanBePushedDown(filter)) {
                pushedFiltersList.add(filter);
                continue;
            }
            leftOverFilters.add(filter);
        }
        this.pushedFilters = new Filter[pushedFiltersList.size()];
        this.pushedFilters = pushedFiltersList.toArray(this.pushedFilters);
        Filter[] leftOvers = new Filter[leftOverFilters.size()];
        leftOvers = leftOverFilters.toArray(leftOvers);
        this.metricsUpdater.finish("data-source-push-filters");
        return leftOvers;
    }

    public Filter[] pushedFilters() {
        return this.pushedFilters;
    }

    public void pruneColumns(StructType pushDownSchema) {
        this.metricsUpdater.startTimer("data-source-prune-columns");
        log.trace((Object)("Set pushdown columns for " + this.uri + ": " + pushDownSchema));
        this.tileDBReadSchema.setPushDownSchema(pushDownSchema);
        this.metricsUpdater.finish("data-source-prune-columns");
    }

    public Scan build() {
        return new TileDBScan(this.tileDBReadSchema, this.options, this.pushedFilters);
    }

    private boolean filterCanBePushedDown(Filter filter) {
        if (!this.options.getTileDBFiltering()) {
            return false;
        }
        if (filter instanceof And) {
            And f = (And)filter;
            return this.filterCanBePushedDown(f.left()) && this.filterCanBePushedDown(f.right());
        }
        if (filter instanceof EqualNullSafe) {
            return true;
        }
        if (filter instanceof EqualTo) {
            return true;
        }
        if (filter instanceof GreaterThan) {
            return true;
        }
        if (filter instanceof GreaterThanOrEqual) {
            return true;
        }
        if (filter instanceof LessThan) {
            return true;
        }
        if (filter instanceof LessThanOrEqual) {
            return true;
        }
        if (filter instanceof Or) {
            Or f = (Or)filter;
            return this.filterCanBePushedDown(f.left()) && this.filterCanBePushedDown(f.right());
        }
        return false;
    }
}

