/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.BitShuffleFilter;
import io.tiledb.java.api.BitWidthReductionFilter;
import io.tiledb.java.api.ByteShuffleFilter;
import io.tiledb.java.api.Bzip2Filter;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.DoubleDeltaFilter;
import io.tiledb.java.api.Filter;
import io.tiledb.java.api.FilterList;
import io.tiledb.java.api.FloatScalingFilter;
import io.tiledb.java.api.GzipFilter;
import io.tiledb.java.api.LZ4Filter;
import io.tiledb.java.api.NoneFilter;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.ZstdFilter;
import io.tiledb.spark.TileDBDataSourceOptions;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;

public class TileDBWriteSchema {
    static String[] getSchemaDimensionOptions(StructType sparkSchema, TileDBDataSourceOptions options) throws TileDBError {
        Optional<List<Pair<String, Integer>>> schemaDimsOpt = options.getSchemaDimensionNames();
        if (!schemaDimsOpt.isPresent()) {
            throw new TileDBError("must specify one or more dimension columns when writing a TileDB array");
        }
        List<StructField> fields = Arrays.asList(sparkSchema.fields());
        List<Pair<String, Integer>> schemaDims = schemaDimsOpt.get();
        for (int i = 0; i < schemaDims.size(); ++i) {
            Pair<String, Integer> schemaDim = schemaDims.get(i);
            if ((Integer)schemaDim.getSecond() != i) {
                throw new TileDBError("array schema dimension 'schema.dim." + i + "' not specified");
            }
            String dimName = (String)schemaDim.getFirst();
            Optional<StructField> sparkDimField = fields.stream().filter(f -> f.name().equals(dimName)).findAny();
            if (sparkDimField.isPresent()) continue;
            throw new TileDBError("specified write dimension 'schema.dim." + i + " = " + dimName + "' does not exist in spark dataframe schema");
        }
        return (String[])schemaDims.stream().map(Pair::getFirst).toArray(String[]::new);
    }

    static Dimension toDimension(Context ctx, String dimName, int dimIdx, DataType dataType, TileDBDataSourceOptions options) throws TileDBError {
        if (dataType instanceof FloatType || dataType instanceof DoubleType) {
            Optional<Double> realMin = options.getSchemaDimensionMinDomainDouble(dimIdx);
            Optional<Double> realMax = options.getSchemaDimensionMaxDomainDouble(dimIdx);
            Optional<Double> realExtent = options.getSchemaDimensionExtentDouble(dimIdx);
            if (dataType instanceof FloatType) {
                Float min = Float.valueOf(Float.MIN_VALUE);
                if (realMin.isPresent()) {
                    min = Float.valueOf(BigDecimal.valueOf(realMin.get()).floatValue());
                }
                Float max = Float.valueOf(Float.MAX_VALUE);
                max = Float.valueOf(max.floatValue() - 1.0f);
                if (realMax.isPresent()) {
                    max = Float.valueOf(BigDecimal.valueOf(realMax.get()).floatValue());
                }
                Float extent = realExtent.isPresent() ? Float.valueOf(BigDecimal.valueOf(realExtent.get()).floatValue()) : Float.valueOf(max.floatValue() - min.floatValue());
                return new Dimension(ctx, dimName, Datatype.TILEDB_FLOAT32, new Pair((Object)min, (Object)max), (Object)extent);
            }
            if (dataType instanceof DoubleType) {
                Double min = Double.MIN_VALUE;
                if (realMin.isPresent()) {
                    min = realMin.get();
                }
                Double max = Double.MAX_VALUE;
                max = max - 1.0;
                if (realMax.isPresent()) {
                    max = realMax.get();
                }
                Double extent = realExtent.isPresent() ? realExtent.get() : Double.valueOf(max - min);
                return new Dimension(ctx, dimName, Datatype.TILEDB_FLOAT64, new Pair((Object)min, (Object)max), (Object)extent);
            }
        } else {
            Optional<Long> longMin = options.getSchemaDimensionMinDomainLong(dimIdx);
            Optional<Long> longMax = options.getSchemaDimensionMaxDomainLong(dimIdx);
            Optional<Long> longExtent = options.getSchemaDimensionExtentLong(dimIdx);
            if (dataType instanceof IntegerType) {
                Integer extent = longExtent.isPresent() ? Integer.valueOf(Math.toIntExact(longExtent.get())) : Integer.valueOf(100);
                Integer min = Integer.MIN_VALUE;
                if (longMin.isPresent()) {
                    min = Math.toIntExact(longMin.get());
                }
                Integer max = Integer.MAX_VALUE - extent;
                if (longMax.isPresent()) {
                    max = Math.toIntExact(longMax.get());
                }
                return new Dimension(ctx, dimName, Datatype.TILEDB_INT32, new Pair((Object)min, (Object)max), (Object)extent);
            }
            if (dataType instanceof LongType) {
                Long extent = longExtent.isPresent() ? longExtent.get() : Long.valueOf(100L);
                Long min = Long.MIN_VALUE;
                if (longMin.isPresent()) {
                    min = longMin.get();
                }
                Long max = Long.MAX_VALUE - extent;
                if (longMax.isPresent()) {
                    max = longMax.get();
                }
                return new Dimension(ctx, dimName, Datatype.TILEDB_INT64, new Pair((Object)min, (Object)max), (Object)extent);
            }
            if (dataType instanceof ShortType) {
                short extent = longExtent.isPresent() ? (short)Short.valueOf(longExtent.get().toString()) : (short)Short.MAX_VALUE;
                Short min = Short.MIN_VALUE;
                if (longMin.isPresent()) {
                    min = (short)longMin.get().longValue();
                }
                Short max = Short.MAX_VALUE;
                max = (short)(max - 1);
                if (longMax.isPresent()) {
                    max = (short)(longMax.get() - (long)extent);
                }
                return new Dimension(ctx, dimName, Datatype.TILEDB_INT16, new Pair((Object)min, (Object)max), (Object)extent);
            }
            if (dataType instanceof ByteType) {
                Byte min = -128;
                if (longMin.isPresent()) {
                    min = Byte.valueOf(longMin.get().toString());
                }
                Byte max = 127;
                max = (byte)(max - 1);
                if (longMax.isPresent()) {
                    max = Byte.valueOf(longMin.get().toString());
                }
                Byte extent = longExtent.isPresent() ? Byte.valueOf(longExtent.get().toString()) : Byte.valueOf((byte)127);
                return new Dimension(ctx, dimName, Datatype.TILEDB_INT8, new Pair((Object)min, (Object)max), (Object)extent);
            }
            if (dataType instanceof DateType) {
                Long extent = longExtent.isPresent() ? longExtent.get() : Long.valueOf(100L);
                Long min = Long.MIN_VALUE;
                if (longMin.isPresent()) {
                    min = longMin.get();
                }
                Long max = Long.MAX_VALUE - extent;
                if (longMax.isPresent()) {
                    max = longMax.get();
                }
                return new Dimension(ctx, dimName, Datatype.TILEDB_DATETIME_DAY, new Pair((Object)min, (Object)max), (Object)extent);
            }
            if (dataType instanceof TimestampType) {
                Long min = -9223372036854775807L;
                if (longMin.isPresent()) {
                    min = longMin.get();
                }
                Long max = 0x7FFFFFFFFFFFFFFEL;
                if (longMax.isPresent()) {
                    max = longMax.get();
                }
                Long extent = longExtent.isPresent() ? longExtent.get() : Long.valueOf(max - min);
                return new Dimension(ctx, dimName, Datatype.TILEDB_DATETIME_US, new Pair((Object)min, (Object)max), (Object)extent);
            }
            if (dataType instanceof StringType) {
                return new Dimension(ctx, dimName, Datatype.TILEDB_STRING_ASCII, null, null);
            }
        }
        throw new TileDBError("Datatype not supported for TileDB spark write schema dimension: " + dataType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Attribute toAttribute(Context ctx, StructField field, TileDBDataSourceOptions options) throws TileDBError {
        Attribute attribute;
        boolean nullable;
        block36: {
            nullable = field.nullable();
            DataType dataType = field.dataType();
            if (dataType instanceof IntegerType) {
                attribute = new Attribute(ctx, field.name(), Integer.class);
            } else if (dataType instanceof ShortType) {
                attribute = new Attribute(ctx, field.name(), Short.class);
            } else if (dataType instanceof ByteType) {
                attribute = new Attribute(ctx, field.name(), Byte.class);
            } else if (dataType instanceof LongType) {
                attribute = new Attribute(ctx, field.name(), Long.class);
            } else if (dataType instanceof FloatType) {
                attribute = new Attribute(ctx, field.name(), Float.class);
            } else if (dataType instanceof DoubleType) {
                attribute = new Attribute(ctx, field.name(), Double.class);
            } else if (dataType instanceof DateType) {
                attribute = new Attribute(ctx, field.name(), Datatype.TILEDB_DATETIME_DAY);
            } else if (dataType instanceof TimestampType) {
                attribute = new Attribute(ctx, field.name(), Datatype.TILEDB_DATETIME_US);
            } else if (dataType instanceof StringType) {
                attribute = new Attribute(ctx, field.name(), String.class).setCellVar();
            } else {
                if (!(dataType instanceof ArrayType)) throw new TileDBError("Spark DataType not supported for TileDB schema conversion: " + dataType.toString());
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                if (elementType instanceof IntegerType) {
                    attribute = new Attribute(ctx, field.name(), Integer.class).setCellVar();
                } else if (elementType instanceof ShortType) {
                    attribute = new Attribute(ctx, field.name(), Short.class).setCellVar();
                } else if (elementType instanceof ByteType) {
                    attribute = new Attribute(ctx, field.name(), Byte.class).setCellVar();
                } else if (elementType instanceof LongType) {
                    attribute = new Attribute(ctx, field.name(), Long.class).setCellVar();
                } else if (elementType instanceof FloatType) {
                    attribute = new Attribute(ctx, field.name(), Float.class).setCellVar();
                } else {
                    if (!(elementType instanceof DoubleType)) throw new TileDBError("Spark Array DataType not supported for TileDB schema conversion: " + arrayType.toString());
                    attribute = new Attribute(ctx, field.name(), Double.class).setCellVar();
                }
            }
            Optional<List<Pair<String, Object[]>>> filterListDesc = options.getAttributeFilterList(field.name());
            try {
                if (!filterListDesc.isPresent()) break block36;
                try (FilterList filterList = TileDBWriteSchema.createTileDBFilterList(ctx, filterListDesc.get());){
                    attribute.setFilterList(filterList);
                }
            }
            catch (TileDBError err) {
                attribute.close();
                throw err;
            }
        }
        attribute.setNullable(nullable);
        return attribute;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilterList createTileDBFilterList(Context ctx, List<Pair<String, Object[]>> filterListDesc) throws TileDBError {
        FilterList filterList = new FilterList(ctx);
        try {
            for (Pair<String, Object[]> filterDesc : filterListDesc) {
                String filterName = (String)filterDesc.getFirst();
                Object[] filterOptions = (Object[])filterDesc.getSecond();
                try {
                    NoneFilter filter;
                    if (filterName.equalsIgnoreCase("NONE")) {
                        filter = new NoneFilter(ctx);
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (filterName.equalsIgnoreCase("GZIP")) {
                        TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 1);
                        filter = new GzipFilter(ctx, Integer.parseInt((String)filterOptions[0]));
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (filterName.equalsIgnoreCase("ZSTD")) {
                        TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 1);
                        filter = new ZstdFilter(ctx, Integer.parseInt((String)filterOptions[0]));
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (filterName.equalsIgnoreCase("LZ4")) {
                        TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 1);
                        filter = new LZ4Filter(ctx, Integer.parseInt((String)filterOptions[0]));
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (filterName.equalsIgnoreCase("RLE")) {
                        TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 1);
                        filter = new LZ4Filter(ctx, Integer.parseInt((String)filterOptions[0]));
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (filterName.equalsIgnoreCase("BZIP2")) {
                        TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 1);
                        filter = new Bzip2Filter(ctx, Integer.parseInt((String)filterOptions[0]));
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (filterName.equalsIgnoreCase("DOUBLE_DELTA")) {
                        TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 1);
                        filter = new DoubleDeltaFilter(ctx, Integer.parseInt((String)filterOptions[0]));
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (filterName.equalsIgnoreCase("BIT_WIDTH_REDUCTION")) {
                        TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 1);
                        filter = new BitWidthReductionFilter(ctx, Integer.parseInt((String)filterOptions[0]));
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (filterName.equalsIgnoreCase("BITSHUFFLE")) {
                        TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 1);
                        filter = new BitShuffleFilter(ctx);
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (filterName.equalsIgnoreCase("BYTESHUFFLE")) {
                        TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 1);
                        filter = new ByteShuffleFilter(ctx);
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (filterName.equalsIgnoreCase("POSITIVE_DELTA")) {
                        TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 1);
                        filter = new ByteShuffleFilter(ctx);
                        try {
                            filterList.addFilter((Filter)filter);
                            continue;
                        }
                        finally {
                            filter.close();
                            continue;
                        }
                    }
                    if (!filterName.equalsIgnoreCase("SCALE_FLOAT")) continue;
                    TileDBWriteSchema.checkOptionsNumber(filterName, filterOptions, 3);
                    filter = new FloatScalingFilter(ctx, Double.parseDouble((String)filterOptions[0]), Double.parseDouble((String)filterOptions[1]), Long.parseLong((String)filterOptions[2]));
                    try {
                        filterList.addFilter((Filter)filter);
                    }
                    finally {
                        filter.close();
                    }
                }
                catch (ClassCastException exception) {
                    throw new TileDBError("There was an datatype error in the options given for filter: " + filterName + ". Please see the README file for a detailed breakdown of all filters and their options.");
                    return filterList;
                }
            }
        }
        catch (TileDBError err) {
            filterList.close();
            throw err;
        }
    }

    private static void checkOptionsNumber(String filterName, Object[] filterOptions, int expectedNumberOfOptions) throws TileDBError {
        if (filterOptions.length != expectedNumberOfOptions) {
            throw new TileDBError("Wrong number of options given for filter " + filterName + ". Please see the README file.");
        }
    }
}

