/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Util;
import io.tiledb.spark.Range;
import io.tiledb.spark.SubArrayRanges;
import io.tiledb.spark.TileDBDataSourceOptions;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.arrow.vector.BaseValueVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.log4j.Logger;

public class util {
    private static Logger logger = Logger.getLogger(Util.class);

    public static Number addEpsilon(Number value, Datatype type) throws TileDBError {
        switch (type) {
            case TILEDB_CHAR: 
            case TILEDB_INT8: {
                return value.byteValue() < 127 ? (byte)(value.byteValue() + 1) : value.byteValue();
            }
            case TILEDB_INT16: {
                return value.shortValue() < Short.MAX_VALUE ? (short)(value.shortValue() + 1) : (short)value.byteValue();
            }
            case TILEDB_INT32: {
                return value.intValue() < Integer.MAX_VALUE ? value.intValue() + 1 : value.intValue();
            }
            case TILEDB_INT64: {
                return value.longValue() < Long.MAX_VALUE ? (Number)(value.longValue() + 1L) : (Number)value;
            }
            case TILEDB_UINT8: {
                return value.shortValue() < 128 ? (short)(value.shortValue() + 1) : value.shortValue();
            }
            case TILEDB_UINT16: {
                return value.intValue() < 32768 ? value.intValue() + 1 : value.intValue();
            }
            case TILEDB_UINT32: 
            case TILEDB_UINT64: {
                return value.longValue() < 0x80000000L ? value.longValue() + 1L : value.longValue();
            }
            case TILEDB_FLOAT32: {
                return Float.valueOf(value.floatValue() < Float.MAX_VALUE ? Math.nextUp(value.floatValue()) : value.floatValue());
            }
            case TILEDB_FLOAT64: {
                return value.doubleValue() < Double.MAX_VALUE ? Math.nextUp(value.doubleValue()) : value.doubleValue();
            }
        }
        throw new TileDBError("Unsupported TileDB Datatype enum: " + type);
    }

    public static String tryGetArrayURI(TileDBDataSourceOptions tiledbOptions) {
        Optional<String> arrayURI;
        try {
            arrayURI = tiledbOptions.getArrayURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Error parsing array URI option: " + ex.getMessage());
        }
        if (!arrayURI.isPresent()) {
            throw new RuntimeException("TileDB URI required");
        }
        return arrayURI.get();
    }

    public static long getDefaultRecordByteCount(Class<? extends ValueVector> clazz) {
        if (BaseVariableWidthVector.class.isAssignableFrom(clazz)) {
            return 8L;
        }
        if (BaseValueVector.class.isAssignableFrom(clazz)) {
            return 8L;
        }
        logger.warn((Object)("Did not found size of the class with name: " + clazz.getCanonicalName() + " returning 8 as the record size"));
        return 8L;
    }

    public static int longToInt(long num) throws ArithmeticException {
        if (num > Integer.MAX_VALUE) {
            throw new ArithmeticException(String.format("Value %d exceeds the maximum integer value.", num));
        }
        return (int)num;
    }

    public static Number subtractEpsilon(Number value, Datatype type) throws TileDBError {
        switch (type) {
            case TILEDB_CHAR: 
            case TILEDB_INT8: {
                return value.byteValue() > -128 ? (byte)(value.byteValue() - 1) : value.byteValue();
            }
            case TILEDB_INT16: {
                return value.shortValue() > Short.MIN_VALUE ? (short)(value.shortValue() - 1) : value.shortValue();
            }
            case TILEDB_INT32: {
                return value.intValue() > Integer.MIN_VALUE ? value.intValue() - 1 : value.intValue();
            }
            case TILEDB_INT64: {
                return value.longValue() > Long.MIN_VALUE ? value.longValue() - 1L : value.longValue();
            }
            case TILEDB_UINT8: {
                return value.shortValue() > -129 ? (short)(value.shortValue() - 1) : value.shortValue();
            }
            case TILEDB_UINT16: {
                return value.intValue() > -32769 ? value.intValue() - 1 : value.intValue();
            }
            case TILEDB_UINT32: 
            case TILEDB_UINT64: {
                return value.longValue() > -2147483649L ? value.longValue() - 1L : value.longValue();
            }
            case TILEDB_FLOAT32: {
                return Float.valueOf(value.floatValue() > Float.MIN_VALUE ? Math.nextDown(value.floatValue()) : value.floatValue());
            }
            case TILEDB_FLOAT64: {
                return value.doubleValue() > Double.MIN_VALUE ? Math.nextDown(value.doubleValue()) : value.doubleValue();
            }
        }
        throw new TileDBError("Unsupported TileDB Datatype enum: " + type);
    }

    public static Number addObjects(Number a, Number b, Class dataClassType) {
        if (dataClassType == Byte.class) {
            return a.byteValue() + b.byteValue();
        }
        if (dataClassType == Short.class) {
            return a.shortValue() + b.shortValue();
        }
        if (dataClassType == Integer.class) {
            return a.intValue() + b.intValue();
        }
        if (dataClassType == Long.class) {
            return a.longValue() + b.longValue();
        }
        if (dataClassType == Float.class) {
            return Float.valueOf(a.floatValue() + b.floatValue());
        }
        return a.doubleValue() + b.doubleValue();
    }

    public static Number subtractObjects(Number a, Number b, Class dataClassType) {
        if (dataClassType == Byte.class) {
            return a.byteValue() - b.byteValue();
        }
        if (dataClassType == Short.class) {
            return a.shortValue() - b.shortValue();
        }
        if (dataClassType == Integer.class) {
            return a.intValue() - b.intValue();
        }
        if (dataClassType == Long.class) {
            return (Long)a - (Long)b;
        }
        if (dataClassType == Float.class) {
            return Float.valueOf(a.floatValue() - b.floatValue());
        }
        return (Double)a - (Double)b;
    }

    public static Number divideObjects(Number a, Number b, Class dataClassType) {
        if (dataClassType == Byte.class) {
            return a.byteValue() / b.byteValue();
        }
        if (dataClassType == Short.class) {
            return a.shortValue() / b.shortValue();
        }
        if (dataClassType == Integer.class) {
            return a.intValue() / b.intValue();
        }
        if (dataClassType == Long.class) {
            return (Long)a / (Long)b;
        }
        if (dataClassType == Float.class) {
            return Float.valueOf(a.floatValue() / b.floatValue());
        }
        return (Double)a / (Double)b;
    }

    public static Object divideCeilingObjects(Number a, Number b, Class dataClassType) {
        if (dataClassType == Byte.class) {
            return a.byteValue() / b.byteValue();
        }
        if (dataClassType == Short.class) {
            return a.shortValue() / b.shortValue();
        }
        if (dataClassType == Integer.class) {
            return (int)Math.ceil((double)a.intValue() * 1.0 / (double)b.intValue());
        }
        if (dataClassType == Long.class) {
            return (long)Math.ceil((double)((Long)a).longValue() * 1.0 / (double)((Long)b).longValue());
        }
        if (dataClassType == Float.class) {
            return Float.valueOf(a.floatValue() / b.floatValue());
        }
        return (Double)a / (Double)b;
    }

    public static Object moduloObjects(Number a, Number b, Class dataClassType) {
        if (dataClassType == Byte.class) {
            return a.byteValue() % b.byteValue();
        }
        if (dataClassType == Short.class) {
            return a.shortValue() % b.shortValue();
        }
        if (dataClassType == Integer.class) {
            return a.intValue() % b.intValue();
        }
        if (dataClassType == Long.class) {
            return (Long)a % (Long)b;
        }
        if (dataClassType == Float.class) {
            return Float.valueOf(a.floatValue() % b.floatValue());
        }
        return (Double)a % (Double)b;
    }

    public static Object castInt(Integer srcNum, Class dataClassType) {
        if (dataClassType == Byte.class) {
            return srcNum.byteValue();
        }
        if (dataClassType == Short.class) {
            return srcNum.shortValue();
        }
        if (dataClassType == Long.class) {
            return srcNum.longValue();
        }
        if (dataClassType == Float.class) {
            return Float.valueOf(srcNum.floatValue());
        }
        if (dataClassType == Double.class) {
            return srcNum.doubleValue();
        }
        return srcNum;
    }

    public static Object castLong(long srcNum, Class dataClassType) {
        if (dataClassType == Byte.class) {
            return (byte)srcNum;
        }
        if (dataClassType == Short.class) {
            return (short)srcNum;
        }
        if (dataClassType == Integer.class) {
            return (int)srcNum;
        }
        if (dataClassType == Float.class) {
            return Float.valueOf(srcNum);
        }
        if (dataClassType == Double.class) {
            return (double)srcNum;
        }
        return srcNum;
    }

    public static void generateAllSubarrays(List<List<Range>> ranges, List<SubArrayRanges> results, int index, List<Range> current) {
        if (index == ranges.size()) {
            results.add(new SubArrayRanges(current, current.get(0).dataClassType()));
            return;
        }
        for (Range rangeForSingleDimension : ranges.get(index)) {
            ArrayList<Range> currentCopy = new ArrayList<Range>(current);
            currentCopy.add(rangeForSingleDimension);
            util.generateAllSubarrays(ranges, results, index + 1, currentCopy);
        }
    }

    public static boolean greaterThanOrEqual(Number a, Number b, Class dataClassType) {
        if (dataClassType == Byte.class) {
            return a.byteValue() >= b.byteValue();
        }
        if (dataClassType == Short.class) {
            return a.shortValue() >= b.shortValue();
        }
        if (dataClassType == Integer.class) {
            return a.intValue() >= b.intValue();
        }
        if (dataClassType == Long.class) {
            return (Long)a >= (Long)b;
        }
        if (dataClassType == Float.class) {
            return a.floatValue() >= b.floatValue();
        }
        return (Double)a >= (Double)b;
    }

    public static boolean lessThan(Number a, Number b, Class dataClassType) {
        if (dataClassType == Byte.class) {
            return a.byteValue() < b.byteValue();
        }
        if (dataClassType == Short.class) {
            return a.shortValue() < b.shortValue();
        }
        if (dataClassType == Integer.class) {
            return a.intValue() < b.intValue();
        }
        if (dataClassType == Long.class) {
            return (Long)a < (Long)b;
        }
        if (dataClassType == Float.class) {
            return a.floatValue() < b.floatValue();
        }
        return (Double)a < (Double)b;
    }

    public static Object findClosestMultiple(Number a, Number b, Class dataClassType) {
        if (dataClassType == Byte.class) {
            return null;
        }
        if (dataClassType == Short.class) {
            short initN = a.shortValue();
            short n = a.shortValue();
            short x = b.shortValue();
            if (x > n) {
                return x;
            }
            n = (short)(n + x / 2);
            if ((n = (short)(n - n % x)) < initN) {
                return n + x;
            }
            return n;
        }
        if (dataClassType == Integer.class) {
            int initN = (Integer)a;
            int n = (Integer)a;
            int x = (Integer)b;
            if (x > n) {
                return x;
            }
            n += x / 2;
            if ((n -= n % x) < initN) {
                return n + x;
            }
            return n;
        }
        if (dataClassType == Long.class) {
            long initN = (Long)a;
            long n = (Long)a;
            long x = (Long)b;
            if (x > n) {
                return x;
            }
            n += x / 2L;
            if ((n -= n % x) < initN) {
                return n + x;
            }
            return n;
        }
        if (dataClassType == Double.class) {
            double initN = (Double)a;
            double n = (Double)a;
            double x = (Double)b;
            if (x > n) {
                return x;
            }
            n += x / 2.0;
            if ((n -= n % x) < initN) {
                return n + x;
            }
            return n;
        }
        if (dataClassType == Float.class) {
            float initN = ((Float)a).floatValue();
            float n = ((Float)a).floatValue();
            float x = ((Float)b).floatValue();
            if (x > n) {
                return Float.valueOf(x);
            }
            n += x / 2.0f;
            if ((n -= n % x) < initN) {
                return Float.valueOf(n + x);
            }
            return Float.valueOf(n);
        }
        return null;
    }
}

