/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import java.util.Optional;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.MetricsUpdate;
import org.apache.spark.metrics.TileDBMetricsSource;
import scala.Option;
import scala.collection.Seq;

public abstract class MetricsUpdater
implements MetricsUpdate {
    Optional<TileDBMetricsSource> getSource(TaskContext task) {
        if (task != null) {
            Option source = task.getMetricsSources("tiledb").headOption();
            if (source.isDefined()) {
                return Optional.of((TileDBMetricsSource)source.get());
            }
        } else {
            SparkEnv env = SparkEnv.get();
            Seq sources = env.metricsSystem().getSourcesByName("tiledb");
            if (sources.length() > 0) {
                return Optional.of((TileDBMetricsSource)sources.head());
            }
        }
        return Optional.empty();
    }

    @Override
    public Long finish(String timerName) {
        return null;
    }
}

