/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.apache.log4j.Logger;
import org.apache.spark.metrics.source.Source;

public class TileDBMetricsSource
implements Source {
    public static final String sourceName = "tiledb";
    public static final String queryReadTimerTaskName = "query-read-task";
    public static final String queryReadTimerName = "query-read-start-to-close";
    public static final String tileDBReadQuerySubmitTimerName = "tiledb-read-query-submit";
    public static final String queryInitTimerName = "query-init";
    public static final String queryAllocBufferTimerName = "query-alloc-buffers";
    public static final String queryGetScalarAttributeTimerName = "query-get-scalar-attribute";
    public static final String queryGetVariableLengthAttributeTimerName = "query-get-variable-length-attribute";
    public static final String queryGetDimensionTimerName = "query-get-dimension";
    public static final String queryCloseNativeArraysTimerName = "query-close-native-arrays";
    public static final String queryNextTimerName = "query-next";
    public static final String queryGetTimerName = "query-get";
    public static final String dataSourceReadSchemaTimerName = "data-source-read-schema";
    public static final String dataSourcePruneColumnsTimerName = "data-source-prune-columns";
    public static final String dataSourcePushFiltersTimerName = "data-source-push-filters";
    public static final String dataSourcePlanBatchInputPartitionsTimerName = "data-source-plan-batch-input-partitions";
    public static final String dataSourceBuildRangeFromFilterTimerName = "data-source-build-range-from-filter";
    public static final String dataSourceCheckAndMergeRangesTimerName = "data-source-check-and-merge-ranges";
    public static final String dataSourceComputeNeededSplitsToReduceToMedianVolumeTimerName = "data-source-computer-needed-splits";
    public static final String queryWriteTaskTimerName = "query-write-task";
    public static final String queryWriteTimerName = "query-write-start-to-close";
    public static final String queryResetWriteQueryAndBuffersTimerName = "query-write-reset-query-and-buffer";
    public static final String queryWriteRecordToBufferTimerName = "query-write-record-to-buffer";
    public static final String queryWriteRowTimerName = "query-write-row";
    public static final String queryWriteFlushBuffersTimerName = "query-write-flush-buffers";
    public static final String queryWriteCloseTileDBResourcesTimerName = "query-write-close";
    public static final String queryWriteCommitTimerName = "query-write-commit";
    private MetricRegistry metricRegistry;
    static Logger log = Logger.getLogger((String)TileDBMetricsSource.class.getName());

    public TileDBMetricsSource() {
        log.info((Object)"Creating TileDBMetricsSource");
        this.metricRegistry = new MetricRegistry();
        this.metricRegistry.timer(queryReadTimerName);
        this.metricRegistry.timer(tileDBReadQuerySubmitTimerName);
        this.metricRegistry.timer(queryInitTimerName);
        this.metricRegistry.timer(queryAllocBufferTimerName);
        this.metricRegistry.timer(queryGetScalarAttributeTimerName);
        this.metricRegistry.timer(queryGetVariableLengthAttributeTimerName);
        this.metricRegistry.timer(queryGetDimensionTimerName);
        this.metricRegistry.timer(queryCloseNativeArraysTimerName);
        this.metricRegistry.timer(queryNextTimerName);
        this.metricRegistry.timer(queryGetTimerName);
        this.metricRegistry.timer(dataSourceReadSchemaTimerName);
        this.metricRegistry.timer(dataSourcePruneColumnsTimerName);
        this.metricRegistry.timer(dataSourcePushFiltersTimerName);
        this.metricRegistry.timer(dataSourcePlanBatchInputPartitionsTimerName);
        this.metricRegistry.timer(dataSourceBuildRangeFromFilterTimerName);
        this.metricRegistry.timer(dataSourceCheckAndMergeRangesTimerName);
        this.metricRegistry.timer(dataSourceComputeNeededSplitsToReduceToMedianVolumeTimerName);
        this.metricRegistry.timer(queryWriteTimerName);
        this.metricRegistry.timer(queryWriteTaskTimerName);
        this.metricRegistry.timer(queryResetWriteQueryAndBuffersTimerName);
        this.metricRegistry.timer(queryWriteRecordToBufferTimerName);
        this.metricRegistry.timer(queryWriteRowTimerName);
        this.metricRegistry.timer(queryWriteFlushBuffersTimerName);
        this.metricRegistry.timer(queryWriteCloseTileDBResourcesTimerName);
        this.metricRegistry.timer(queryWriteCommitTimerName);
    }

    public String sourceName() {
        return sourceName;
    }

    public Timer registerTimer(String timerName) {
        return this.metricRegistry.timer(timerName);
    }

    public MetricRegistry metricRegistry() {
        return this.metricRegistry;
    }
}

