/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import java.util.HashMap;
import java.util.Optional;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.metrics.MetricsUpdater;
import org.apache.spark.metrics.SimpleTimer;
import org.apache.spark.metrics.TileDBMetricsSource;
import org.apache.spark.metrics.TileDBMetricsTimer;
import org.apache.spark.metrics.Timer;
import scala.collection.Seq;

public class TileDBWriteMetricsUpdater
extends MetricsUpdater {
    private OutputMetrics outputMetrics = null;
    private TileDBMetricsSource source = null;
    private HashMap<String, Timer> timers;

    public TileDBWriteMetricsUpdater(TaskContext task) {
        Optional<TileDBMetricsSource> tmp = this.getSource(task);
        if (tmp.isPresent()) {
            this.source = tmp.get();
        } else {
            SparkEnv env = SparkEnv.get();
            Seq sources = env.metricsSystem().getSourcesByName("tiledb");
            if (sources.length() > 1) {
                this.source = (TileDBMetricsSource)sources.head();
            }
        }
        this.timers = new HashMap();
        if (task != null) {
            TaskMetrics tm = task.taskMetrics();
            this.outputMetrics = tm.outputMetrics();
        }
    }

    public synchronized void startTimer(String timerName) {
        if (this.source != null) {
            this.timers.put(timerName, new TileDBMetricsTimer(this.source, timerName));
        } else {
            this.timers.put(timerName, new SimpleTimer());
        }
    }

    public void appendTaskMetrics(long recordCount, long sizeInBytes) {
        if (this.outputMetrics != null) {
            this.outputMetrics.setBytesWritten(sizeInBytes + this.outputMetrics.bytesWritten());
            this.outputMetrics.setRecordsWritten(recordCount + this.outputMetrics.recordsWritten());
        }
    }

    @Override
    public Long finish(String timerName) {
        if (this.timers.containsKey(timerName)) {
            return this.timers.get(timerName).stopTimer();
        }
        return null;
    }
}

