/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import java.util.Optional;

public class OptionDimPartition {
    private String name;
    private Integer idx;
    private Integer npartitions = 1;

    public OptionDimPartition(String dimNameOrIdx, String value) throws IllegalArgumentException {
        String[] splitDimId = dimNameOrIdx.split("\\.");
        if (splitDimId.length != 2 || !splitDimId[0].equalsIgnoreCase("dim")) {
            throw new IllegalArgumentException("Invalid dimension option key, expected 'dim.idx` or 'dim.name' got: " + dimNameOrIdx);
        }
        try {
            this.idx = Integer.parseInt(splitDimId[1]);
            if (this.idx < 0) {
                throw new IllegalArgumentException("Invalid dimension N partition(s) value, must be a positive integer: " + value);
            }
        }
        catch (NumberFormatException ex) {
            this.name = splitDimId[1];
        }
        if (!value.isEmpty()) {
            try {
                this.npartitions = Integer.parseInt(value);
                if (this.npartitions < 1) {
                    throw new IllegalArgumentException("Invalid dimension N partition(s) value, must be a >= 1: " + value);
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid dimension N partition(s) value, must be a >= 1: " + value);
            }
        }
    }

    public Optional<Integer> getDimIdx() {
        if (this.idx == null) {
            return Optional.empty();
        }
        return Optional.of(this.idx);
    }

    public Optional<String> getDimName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return Optional.of(this.name);
    }

    public Integer getNPartitions() {
        return this.npartitions;
    }
}

