/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.Pair;
import java.util.ArrayList;
import java.util.List;

public class StringPartitioner {
    private int MIN_ASCII_CHAR = 0;
    private int MAX_ASCII_CHAR = 127;
    private int minChar;
    private int maxChar;

    public StringPartitioner() {
        this.minChar = this.MIN_ASCII_CHAR;
        this.maxChar = this.MAX_ASCII_CHAR;
    }

    public StringPartitioner(int minChar, int maxChar) {
        this.minChar = minChar;
        this.maxChar = maxChar;
    }

    public String nextStr(String str) {
        int currentCharIdx;
        int strLen = str.length();
        char[] charArray = str.toCharArray();
        for (currentCharIdx = strLen - 1; currentCharIdx > 0 && charArray[currentCharIdx] == this.maxChar; --currentCharIdx) {
            charArray[currentCharIdx] = (char)this.minChar;
        }
        if (charArray[currentCharIdx] < this.maxChar) {
            int n = currentCharIdx;
            charArray[n] = (char)(charArray[n] + '\u0001');
        }
        return new String(charArray);
    }

    public String nextStr(String str, long n) {
        int i = 0;
        while ((long)i < n) {
            str = this.nextStr(str);
            ++i;
        }
        return str;
    }

    public int distance(String a1, String a2) {
        String tmp = a1;
        int dist = 0;
        while (tmp.compareTo(a2) < 0) {
            tmp = this.nextStr(tmp);
            ++dist;
        }
        return dist;
    }

    public static String addExtraChars(String str, char c, int n) {
        char[] newStr = new char[str.length() + n];
        int idx = 0;
        for (char character : str.toCharArray()) {
            newStr[idx++] = character;
        }
        while (idx < str.length() + n) {
            newStr[idx++] = c;
        }
        return new String(newStr);
    }

    public List<Pair<String, String>> split(String start, String end, int partitions) {
        String fixedStart = start;
        long width = this.distance(fixedStart, end);
        while (width / (long)partitions < 1L) {
            fixedStart = StringPartitioner.addExtraChars(fixedStart, (char)this.minChar, 1);
            width = this.distance(fixedStart, end);
        }
        long partitionWidth = width / (long)partitions;
        String tmpStart = fixedStart;
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < partitions; ++i) {
            String tmpEnd = i == partitions - 1 ? end : this.nextStr(tmpStart, partitionWidth);
            if (i == 0) {
                tmpStart = start;
            }
            if (tmpEnd.compareTo(end) > 0) {
                tmpEnd = end;
                list.add((Pair<String, String>)new Pair((Object)new String(tmpStart.toCharArray()), (Object)new String(tmpEnd.toCharArray())));
                break;
            }
            list.add((Pair<String, String>)new Pair((Object)new String(tmpStart.toCharArray()), (Object)new String(tmpEnd.toCharArray())));
            tmpStart = this.nextStr(tmpEnd, 1L);
        }
        return list;
    }
}

