/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.TileDBError;
import io.tiledb.spark.Range;
import io.tiledb.spark.util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SubArrayRanges
implements Comparable<SubArrayRanges> {
    private List<Range> ranges;
    private Class datatype;

    SubArrayRanges(List<Range> ranges, Class datatype) {
        this.ranges = ranges;
        this.datatype = datatype;
    }

    public Class getDatatype() {
        return this.datatype;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public int getDimensionWithLargestWidth() {
        if (this.datatype == Byte.class) {
            return IntStream.range(0, this.ranges.size()).boxed().max(Comparator.comparing(e -> ((Number)this.ranges.get((int)e).width()).byteValue())).get();
        }
        if (this.datatype == Short.class) {
            return IntStream.range(0, this.ranges.size()).boxed().max(Comparator.comparing(e -> ((Number)this.ranges.get((int)e).width()).shortValue())).get();
        }
        if (this.datatype == Integer.class) {
            return IntStream.range(0, this.ranges.size()).boxed().max(Comparator.comparing(e -> ((Number)this.ranges.get((int)e).width()).intValue())).get();
        }
        if (this.datatype == Long.class) {
            return IntStream.range(0, this.ranges.size()).boxed().max(Comparator.comparing(e -> ((Number)this.ranges.get((int)e).width()).longValue())).get();
        }
        if (this.datatype == Float.class) {
            return IntStream.range(0, this.ranges.size()).boxed().max(Comparator.comparing(e -> Float.valueOf(((Number)this.ranges.get((int)e).width()).floatValue()))).get();
        }
        if (this.datatype == Double.class) {
            return IntStream.range(0, this.ranges.size()).boxed().max(Comparator.comparing(e -> ((Number)this.ranges.get((int)e).width()).doubleValue())).get();
        }
        return 0;
    }

    public <T extends Number> T getVolume() {
        if (this.datatype == Byte.class) {
            return (T)this.volumeByte();
        }
        if (this.datatype == Short.class) {
            return (T)this.volumeShort();
        }
        if (this.datatype == Integer.class) {
            return (T)this.volumeInteger();
        }
        if (this.datatype == Long.class) {
            return (T)this.volumeLong();
        }
        if (this.datatype == Float.class) {
            return (T)this.volumeFloat();
        }
        if (this.datatype == Double.class) {
            return (T)this.volumeDouble();
        }
        return (T)Integer.valueOf(0);
    }

    private Long volumeByte() {
        long volume = 1L;
        for (Range dimRange : this.ranges) {
            volume *= ((Number)dimRange.width()).longValue();
        }
        return volume;
    }

    private Long volumeShort() {
        long volume = 1L;
        for (Range dimRange : this.ranges) {
            volume *= ((Number)dimRange.width()).longValue();
        }
        return volume;
    }

    private Long volumeInteger() {
        long volume = 1L;
        for (Range dimRange : this.ranges) {
            volume *= ((Number)dimRange.width()).longValue();
        }
        return volume;
    }

    private Long volumeLong() {
        long volume = 1L;
        for (Range dimRange : this.ranges) {
            volume *= ((Number)dimRange.width()).longValue();
        }
        return volume;
    }

    private Double volumeFloat() {
        double volume = 1.0;
        for (Range dimRange : this.ranges) {
            volume *= ((Number)dimRange.width()).doubleValue();
        }
        return volume;
    }

    private Double volumeDouble() {
        double volume = 1.0;
        for (Range dimRange : this.ranges) {
            volume *= ((Number)dimRange.width()).doubleValue();
        }
        return volume;
    }

    @Override
    public int compareTo(SubArrayRanges other) {
        if (this.datatype == Byte.class) {
            return this.volumeByte().compareTo(other.volumeByte());
        }
        if (this.datatype == Short.class) {
            return this.volumeShort().compareTo(other.volumeShort());
        }
        if (this.datatype == Integer.class) {
            return this.volumeInteger().compareTo(other.volumeInteger());
        }
        if (this.datatype == Long.class) {
            return this.volumeLong().compareTo(other.volumeLong());
        }
        if (this.datatype == Float.class) {
            return this.volumeFloat().compareTo(other.volumeFloat());
        }
        if (this.datatype == Double.class) {
            return this.volumeDouble().compareTo(other.volumeDouble());
        }
        return 0;
    }

    public boolean splittable() {
        for (Range range : this.ranges) {
            if (range.splittable()) continue;
            return false;
        }
        return true;
    }

    public List<SubArrayRanges> split(int buckets) throws TileDBError {
        ArrayList<SubArrayRanges> newSubarrays = new ArrayList<SubArrayRanges>();
        if (this.ranges.size() == 1) {
            if (this.ranges.get(0).splittable()) {
                for (Range newRange : this.ranges.get(0).splitRange(buckets)) {
                    ArrayList<Range> dimRanges = new ArrayList<Range>();
                    dimRanges.add(newRange);
                    newSubarrays.add(new SubArrayRanges(dimRanges, this.datatype));
                }
            }
        } else {
            int totalAvailableSplits = (int)Math.floor(Math.pow(buckets, 1.0 / (double)this.ranges.size()) * (double)this.ranges.size());
            List<Double> dimensionVolumeRatios = this.computeDimensionVolumeRations();
            List dimensionSplits = dimensionVolumeRatios.stream().map(e -> (int)Math.floor((double)totalAvailableSplits * e)).collect(Collectors.toList());
            int leftOvers = totalAvailableSplits - dimensionSplits.stream().reduce(0, Integer::sum);
            int[] sortedIndices = IntStream.range(0, dimensionVolumeRatios.size()).boxed().sorted((i, j) -> ((Double)dimensionVolumeRatios.get((int)i)).compareTo((Double)dimensionVolumeRatios.get((int)j))).mapToInt(ele -> ele).toArray();
            block1: while (leftOvers > 0) {
                for (int dimIndex : sortedIndices) {
                    dimensionSplits.set(dimIndex, (Integer)dimensionSplits.get(dimIndex) + 1);
                    if (--leftOvers <= 0) continue block1;
                }
            }
            ArrayList<List<Range>> newSplits = new ArrayList<List<Range>>();
            for (int i2 = 0; i2 < this.ranges.size(); ++i2) {
                if (!this.ranges.get(i2).splittable()) continue;
                int dimensionWeightedSplits = (Integer)dimensionSplits.get(i2);
                newSplits.add(new ArrayList<Range>(this.ranges.get(i2).splitRange(dimensionWeightedSplits)));
            }
            util.generateAllSubarrays(newSplits, newSubarrays, 0, new ArrayList<Range>());
        }
        return newSubarrays;
    }

    public List<SubArrayRanges> splitToPartitions(int partitions) throws TileDBError {
        ArrayList<SubArrayRanges> newSubarrays = new ArrayList<SubArrayRanges>();
        if (this.ranges.get(0).splittable()) {
            List<Range> newRanges;
            if (this.datatype.equals(String.class)) {
                newRanges = this.ranges.get(0).splitStringRangeToPartitions(partitions);
            } else {
                long actualWidth = ((Number)this.ranges.get(0).width()).longValue();
                double exactEffectiveWidth = (double)actualWidth * 1.0 / (double)partitions;
                newRanges = this.ranges.get(0).splitRangeToPartitions(partitions, exactEffectiveWidth);
            }
            for (Range newRange : newRanges) {
                ArrayList<Range> dimRanges = new ArrayList<Range>();
                dimRanges.add(newRange);
                newRange.width();
                for (int i = 1; i < this.ranges.size(); ++i) {
                    dimRanges.add(this.ranges.get(i));
                }
                newSubarrays.add(new SubArrayRanges(dimRanges, this.datatype));
            }
        }
        return newSubarrays;
    }

    private List<Double> computeDimensionVolumeRations() {
        List widths = this.ranges.stream().map(Range::width).collect(Collectors.toList());
        if (this.datatype == Byte.class) {
            long sum = widths.stream().map(e -> (Byte)e).mapToLong(Byte::longValue).sum();
            return widths.stream().map(e -> ((Byte)e).doubleValue() / (double)sum).collect(Collectors.toList());
        }
        if (this.datatype == Short.class) {
            long sum = widths.stream().map(e -> (Short)e).mapToLong(Short::longValue).sum();
            return widths.stream().map(e -> ((Short)e).doubleValue() / (double)sum).collect(Collectors.toList());
        }
        if (this.datatype == Integer.class) {
            long sum = widths.stream().map(e -> (Integer)e).mapToLong(Integer::longValue).sum();
            return widths.stream().map(e -> ((Integer)e).doubleValue() / (double)sum).collect(Collectors.toList());
        }
        if (this.datatype == Long.class) {
            long sum = widths.stream().map(e -> (Long)e).mapToLong(Long::longValue).sum();
            return widths.stream().map(e -> ((Long)e).doubleValue() / (double)sum).collect(Collectors.toList());
        }
        if (this.datatype == Float.class) {
            double sum = widths.stream().map(e -> (Float)e).mapToDouble(Float::doubleValue).sum();
            return widths.stream().map(e -> ((Float)e).doubleValue() / sum).collect(Collectors.toList());
        }
        double sum = widths.stream().map(e -> (Double)e).mapToDouble(Double::doubleValue).sum();
        return widths.stream().map(e -> (Double)e / sum).collect(Collectors.toList());
    }
}

