/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.ArrayType;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.FilterList;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.TileDBObject;
import io.tiledb.spark.DataSourceOptions;
import io.tiledb.spark.TileDBDataSourceOptions;
import io.tiledb.spark.TileDBDataWriterFactory;
import io.tiledb.spark.TileDBWriteSchema;
import io.tiledb.spark.util;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class TileDBBatchWrite
implements BatchWrite {
    private final Map<String, String> properties;
    private final TileDBDataSourceOptions tileDBDataSourceOptions;
    public final SaveMode saveMode;
    private final String uri;
    private final LogicalWriteInfo logicalWriteInfo;
    private final StructType sparkSchema;

    public TileDBBatchWrite(Map<String, String> properties, LogicalWriteInfo info, SaveMode saveMode) {
        this.properties = properties;
        this.tileDBDataSourceOptions = new TileDBDataSourceOptions(new DataSourceOptions((Map<String, String>)info.options()));
        this.uri = util.tryGetArrayURI(this.tileDBDataSourceOptions);
        this.logicalWriteInfo = info;
        this.sparkSchema = this.logicalWriteInfo.schema();
        this.saveMode = saveMode;
    }

    public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
        boolean isOkToWrite = this.tryWriteArraySchema();
        if (!isOkToWrite) {
            throw new RuntimeException("Writing to an existing array: '" + this.uri + "' with save mode " + this.saveMode);
        }
        Map<String, String> metadata = this.tileDBDataSourceOptions.getMetadata();
        Map<String, String> metadataTypes = this.tileDBDataSourceOptions.getMetadataTypes();
        if (!metadata.isEmpty()) {
            try (Array array = new Array(new Context(), this.uri, QueryType.TILEDB_WRITE);){
                for (Map.Entry<String, String> entry : metadata.entrySet()) {
                    String metaDatatype = metadataTypes.get(entry.getKey());
                    if (metaDatatype == null) {
                        throw new TileDBError("Please include the 'metadata_type' option for metadata." + entry.getKey());
                    }
                    NativeArray valueNativeArray = this.metadataValueToNativeArray(entry.getValue(), metaDatatype);
                    array.putMetadata(entry.getKey(), valueNativeArray);
                }
            }
            catch (TileDBError e) {
                throw new RuntimeException(e);
            }
        }
        return new TileDBDataWriterFactory(this.uri, this.logicalWriteInfo.schema(), this.tileDBDataSourceOptions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NativeArray metadataValueToNativeArray(String stringValue, String metaDatatype) throws TileDBError {
        try (Context context = new Context();){
            switch (metaDatatype) {
                case "TILEDB_INT32": {
                    int intValue = Integer.parseInt(stringValue);
                    NativeArray nativeArray = new NativeArray(context, (Object)new int[]{intValue}, Datatype.TILEDB_INT32);
                    return nativeArray;
                }
                case "TILEDB_FLOAT32": {
                    float floatValue = Float.parseFloat(stringValue);
                    NativeArray nativeArray = new NativeArray(context, (Object)new float[]{floatValue}, Datatype.TILEDB_FLOAT32);
                    return nativeArray;
                }
                case "TILEDB_STRING_ASCII": {
                    NativeArray nativeArray = new NativeArray(context, (Object)stringValue, Datatype.TILEDB_STRING_ASCII);
                    return nativeArray;
                }
            }
            throw new TileDBError("Metadata type: " + metaDatatype + " is not supported in TileDB-Spark.");
        }
    }

    public void commit(WriterCommitMessage[] messages) {
    }

    public void abort(WriterCommitMessage[] messages) {
        if (messages.length > 0) {
            try (Context ctx = new Context(this.tileDBDataSourceOptions.getTileDBConfigMap(false));){
                TileDBObject.remove((Context)ctx, (String)this.uri.toString());
            }
            catch (TileDBError err) {
                throw new RuntimeException("Error removing tiledb array at '" + this.uri + "' after aborted / failed write: " + err.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryWriteArraySchema() {
        try (Context ctx = new Context(this.tileDBDataSourceOptions.getTileDBConfigMap(false));){
            boolean arrayExists = Array.exists((Context)ctx, (String)this.uri.toString());
            if (this.saveMode == SaveMode.Append) {
                if (!arrayExists) {
                    TileDBBatchWrite.writeArraySchema(ctx, this.uri, this.sparkSchema, this.tileDBDataSourceOptions);
                }
                boolean bl = true;
                return bl;
            }
            if (this.saveMode != SaveMode.Overwrite) return false;
            if (arrayExists) {
                TileDBObject.remove((Context)ctx, (String)this.uri.toString());
            }
            TileDBBatchWrite.writeArraySchema(ctx, this.uri, this.sparkSchema, this.tileDBDataSourceOptions);
            boolean bl = true;
            return bl;
        }
        catch (TileDBError err) {
            err.printStackTrace();
            throw new RuntimeException(err.getMessage());
        }
    }

    private static void writeArraySchema(Context ctx, String uri, StructType sparkSchema, TileDBDataSourceOptions options) throws TileDBError {
        ArrayType type = ArrayType.TILEDB_SPARSE;
        try (ArraySchema arraySchema = new ArraySchema(ctx, type);
             Domain domain = new Domain(ctx);){
            Optional<Long> schemaCapacity;
            Optional<List<Pair<String, Object[]>>> coordsFilters;
            Optional<Layout> schemaTileOrder;
            String[] dimNames = TileDBWriteSchema.getSchemaDimensionOptions(sparkSchema, options);
            StructField[] sparkFields = sparkSchema.fields();
            for (int dimIdx = 0; dimIdx < dimNames.length; ++dimIdx) {
                String dimName = dimNames[dimIdx];
                int idx = sparkSchema.fieldIndex(dimName);
                try (Dimension dim = TileDBWriteSchema.toDimension(ctx, dimName, dimIdx, sparkFields[idx].dataType(), options);){
                    domain.addDimension(dim);
                    continue;
                }
            }
            arraySchema.setDomain(domain);
            for (StructField field : sparkFields) {
                if (Arrays.stream(dimNames).anyMatch(field.name()::equals)) continue;
                try (Attribute attr = TileDBWriteSchema.toAttribute(ctx, field, options);){
                    arraySchema.addAttribute(attr);
                }
            }
            Optional<Layout> schemaCellOrder = options.getSchemaCellOrder();
            if (schemaCellOrder.isPresent()) {
                arraySchema.setCellOrder(schemaCellOrder.get());
            }
            if ((schemaTileOrder = options.getSchemaTileOrder()).isPresent()) {
                arraySchema.setTileOrder(schemaTileOrder.get());
            }
            if ((coordsFilters = options.getSchemaCoordsFilterList()).isPresent()) {
                try (FilterList filterList = TileDBWriteSchema.createTileDBFilterList(ctx, coordsFilters.get());){
                    arraySchema.setCoodsFilterList(filterList);
                }
            }
            Optional<List<Pair<String, Object[]>>> offsetsFilters = options.getSchemaOffsetsFilterList();
            if (coordsFilters.isPresent()) {
                try (FilterList filterList = TileDBWriteSchema.createTileDBFilterList(ctx, offsetsFilters.get());){
                    arraySchema.setOffsetsFilterList(filterList);
                }
            }
            if ((schemaCapacity = options.getSchemaCapacity()).isPresent()) {
                arraySchema.setCapacity(schemaCapacity.get().longValue());
            }
            if (options.getSchemaAllowDups().isPresent() && options.getSchemaAllowDups().get().booleanValue()) {
                arraySchema.setAllowDups(1);
            }
            arraySchema.check();
            Array.create((String)uri, (ArraySchema)arraySchema);
        }
    }
}

