/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.TileDBError;
import io.tiledb.spark.DataSourceOptions;
import io.tiledb.spark.TileDBDataSourceOptions;
import io.tiledb.spark.TileDBReadSchema;
import io.tiledb.spark.TileDBTable;
import io.tiledb.spark.util;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class TileDBDataSource
implements TableProvider {
    public StructType inferSchema(CaseInsensitiveStringMap options) {
        TileDBDataSourceOptions tiledbOptions = new TileDBDataSourceOptions(new DataSourceOptions((Map<String, String>)options));
        TileDBReadSchema tileDBReadSchema = new TileDBReadSchema(util.tryGetArrayURI(tiledbOptions), tiledbOptions);
        if (tiledbOptions.printMetadata()) {
            try {
                this.printMetadata(tiledbOptions);
            }
            catch (TileDBError | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return tileDBReadSchema.getSparkSchema();
    }

    private void printMetadata(TileDBDataSourceOptions tileDBDataSourceOptions) throws TileDBError, URISyntaxException {
        Array array = new Array(new Context(), tileDBDataSourceOptions.getArrayURI().get());
        Map a = array.getMetadataMap();
        for (String key : a.keySet()) {
            System.out.println("<" + key + ", " + a.get(key) + ">");
        }
        array.close();
    }

    public Table getTable(StructType schema, Transform[] partitioning, Map<String, String> properties) {
        return new TileDBTable(schema, properties);
    }

    public boolean supportsExternalMetadata() {
        return true;
    }
}

