/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.Layout;
import io.tiledb.java.api.Pair;
import io.tiledb.spark.DataSourceOptions;
import io.tiledb.spark.OptionDimPartition;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TileDBDataSourceOptions
implements Serializable {
    private static final int QUERY_BUFFER_SIZE = 0xA00000;
    private static final int DEFAULT_PARTITIONS = 10;
    private HashMap<String, String> optionMap;

    public TileDBDataSourceOptions(DataSourceOptions options) {
        this.optionMap = new HashMap<String, String>(options.asMap());
    }

    public Optional<String> getArrayURI() throws URISyntaxException {
        if (this.optionMap.containsKey("path")) {
            return Optional.of(this.optionMap.get("path"));
        }
        if (this.optionMap.containsKey("uri")) {
            return Optional.of(this.optionMap.get("uri"));
        }
        return Optional.empty();
    }

    public long getReadBufferSizes() {
        if (this.optionMap.containsKey("read_buffer_size")) {
            return Long.parseLong(this.optionMap.get("read_buffer_size"));
        }
        return 0xA00000L;
    }

    public boolean getAllowReadBufferReallocation() {
        if (this.optionMap.containsKey("allow_read_buffer_realloc")) {
            return Boolean.parseBoolean(this.optionMap.get("allow_read_buffer_realloc"));
        }
        return true;
    }

    public boolean getTileDBFiltering() {
        if (this.optionMap.containsKey("tiledb_filtering")) {
            return Boolean.parseBoolean(this.optionMap.get("tiledb_filtering"));
        }
        return true;
    }

    public boolean printMetadata() {
        if (this.optionMap.containsKey("print_array_metadata")) {
            return Boolean.parseBoolean(this.optionMap.get("print_array_metadata"));
        }
        return false;
    }

    public int getPartitionCount() {
        if (this.optionMap.containsKey("partition_count")) {
            return Integer.parseInt(this.optionMap.get("partition_count"));
        }
        return 10;
    }

    public Optional<Layout> getArrayLayout() {
        if (this.optionMap.containsKey("order")) {
            String val = this.optionMap.get("order");
            Optional<Layout> arrayResultLayout = TileDBDataSourceOptions.tryParseOptionLayout(val);
            if (!arrayResultLayout.isPresent()) {
                throw new IllegalArgumentException("Unknown TileDB result layout order, valid values are 'row-major', 'col-major', 'global-order' and 'unordered', got: " + val);
            }
            return arrayResultLayout;
        }
        return Optional.empty();
    }

    public Optional<List<OptionDimPartition>> getDimPartitions() {
        List<Pair<String, String>> results = TileDBDataSourceOptions.collectOptionsWithKeyPrefixSuffix(this.optionMap, "partition.", null);
        if (results.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<OptionDimPartition> dimPartitions = new ArrayList<OptionDimPartition>();
        for (Pair<String, String> entry : results) {
            dimPartitions.add(new OptionDimPartition((String)entry.getFirst(), (String)entry.getSecond()));
        }
        return Optional.of(dimPartitions);
    }

    public Optional<List<Pair<String, Integer>>> getSchemaDimensionNames() {
        List<Pair<String, String>> results = TileDBDataSourceOptions.collectOptionsWithKeyPrefixSuffix(this.optionMap, "schema.dim.", ".name");
        if (results.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<Pair> schemaDimensions = new ArrayList<Pair>();
        for (Pair<String, String> entry : results) {
            Integer dimIdx;
            String dimIntString = (String)entry.getFirst();
            String val = (String)entry.getSecond();
            try {
                dimIdx = Integer.parseInt(dimIntString);
            }
            catch (NumberFormatException err) {
                continue;
            }
            schemaDimensions.add(new Pair((Object)val, (Object)dimIdx));
        }
        schemaDimensions.sort(Comparator.comparing(Pair::getSecond));
        return Optional.of(schemaDimensions);
    }

    public Map<String, String> getMetadata() {
        Map<String, String> results = TileDBDataSourceOptions.collectOptionsWithKeyPrefixSuffixMap(this.optionMap, "metadata_value.", null);
        return results;
    }

    public Map<String, String> getMetadataTypes() {
        Map<String, String> results = TileDBDataSourceOptions.collectOptionsWithKeyPrefixSuffixMap(this.optionMap, "metadata_type.", null);
        return results;
    }

    public Optional<Long> getTimestampStart() {
        Long val;
        String key = "timestamp_start";
        if (!this.optionMap.containsKey(key)) {
            return Optional.empty();
        }
        try {
            val = Long.parseLong(this.optionMap.get(key));
        }
        catch (NumberFormatException err) {
            return Optional.empty();
        }
        return Optional.of(val);
    }

    public Optional<Long> getTimestampEnd() {
        Long val;
        String key = "timestamp_end";
        if (!this.optionMap.containsKey(key)) {
            return Optional.empty();
        }
        try {
            val = Long.parseLong(this.optionMap.get(key));
        }
        catch (NumberFormatException err) {
            return Optional.empty();
        }
        return Optional.of(val);
    }

    public Optional<Long> getSchemaDimensionMinDomainLong(int dimIdx) {
        String dimExtentKey = "schema.dim." + dimIdx + ".min";
        return TileDBDataSourceOptions.tryParseOptionKeyLong(this.optionMap, dimExtentKey);
    }

    public Optional<Long> getSchemaDimensionMaxDomainLong(int dimIdx) {
        String dimExtentKey = "schema.dim." + dimIdx + ".max";
        return TileDBDataSourceOptions.tryParseOptionKeyLong(this.optionMap, dimExtentKey);
    }

    public Optional<Integer> getSchemaDimensionMinDomainInt(int dimIdx) {
        String dimExtentKey = "schema.dim." + dimIdx + ".min";
        return TileDBDataSourceOptions.tryParseOptionKeyInt(this.optionMap, dimExtentKey);
    }

    public Optional<Integer> getSchemaDimensionMaxDomainInt(int dimIdx) {
        String dimExtentKey = "schema.dim." + dimIdx + ".max";
        return TileDBDataSourceOptions.tryParseOptionKeyInt(this.optionMap, dimExtentKey);
    }

    public Optional<Long> getSchemaDimensionExtentLong(int dimIdx) {
        String dimExtentKey = "schema.dim." + dimIdx + ".extent";
        return TileDBDataSourceOptions.tryParseOptionKeyLong(this.optionMap, dimExtentKey);
    }

    public Optional<Double> getSchemaDimensionMinDomainDouble(int dimIdx) {
        String dimExtentKey = "schema.dim." + dimIdx + ".min";
        return TileDBDataSourceOptions.tryParseOptionKeyDouble(this.optionMap, dimExtentKey);
    }

    public Optional<Double> getSchemaDimensionMaxDomainDouble(int dimIdx) {
        String dimExtentKey = "schema.dim." + dimIdx + ".max";
        return TileDBDataSourceOptions.tryParseOptionKeyDouble(this.optionMap, dimExtentKey);
    }

    public Optional<Double> getSchemaDimensionExtentDouble(int dimIdx) {
        String dimExtentKey = "schema.dim." + dimIdx + ".extent";
        return TileDBDataSourceOptions.tryParseOptionKeyDouble(this.optionMap, dimExtentKey);
    }

    public Optional<List<Pair<String, Object[]>>> getAttributeFilterList(String attrName) {
        String filterListKey = "schema.attr." + attrName + ".filter_list";
        if (!this.optionMap.containsKey(filterListKey)) {
            return Optional.empty();
        }
        return TileDBDataSourceOptions.tryParseFilterList(this.optionMap.get(filterListKey));
    }

    public Optional<List<Pair<String, Object[]>>> getSchemaCoordsFilterList() {
        String filterListKey = "schema.coords_filter_list";
        if (!this.optionMap.containsKey(filterListKey)) {
            return Optional.empty();
        }
        return TileDBDataSourceOptions.tryParseFilterList(this.optionMap.get(filterListKey));
    }

    public Optional<List<Pair<String, Object[]>>> getSchemaOffsetsFilterList() {
        String filterListKey = "schema.offsets_filter_list";
        if (!this.optionMap.containsKey(filterListKey)) {
            return Optional.empty();
        }
        return TileDBDataSourceOptions.tryParseFilterList(this.optionMap.get(filterListKey));
    }

    public Optional<Layout> getSchemaCellOrder() {
        String cellOrderLayoutKey = "schema.cell_order";
        if (!this.optionMap.containsKey(cellOrderLayoutKey)) {
            return Optional.empty();
        }
        return TileDBDataSourceOptions.tryParseOptionLayout(this.optionMap.get(cellOrderLayoutKey));
    }

    public Optional<Layout> getSchemaTileOrder() {
        String tileOrderLayoutKey = "schema.tile_order";
        if (!this.optionMap.containsKey(tileOrderLayoutKey)) {
            return Optional.empty();
        }
        return TileDBDataSourceOptions.tryParseOptionLayout(this.optionMap.get(tileOrderLayoutKey));
    }

    public Optional<Long> getSchemaCapacity() {
        String capacityKey = "schema.capacity";
        return TileDBDataSourceOptions.tryParseOptionKeyLong(this.optionMap, capacityKey);
    }

    public Optional<Boolean> getSchemaAllowDups() {
        String allowDupsKey = "schema.set_allows_dups";
        return TileDBDataSourceOptions.tryParseOptionKeyBoolean(this.optionMap, allowDupsKey);
    }

    public long getWriteBufferSize() {
        Optional<Long> bufferSize = TileDBDataSourceOptions.tryParseOptionKeyLong(this.optionMap, "write_buffer_size");
        if (bufferSize.isPresent()) {
            return bufferSize.get();
        }
        return 0xA00000L;
    }

    public Map<String, String> getTileDBConfigMap(boolean useArrowConfig) {
        List<Pair<String, String>> results;
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (useArrowConfig) {
            configMap.put("sm.var_offsets.bitsize", "32");
            configMap.put("sm.var_offsets.mode", "elements");
            configMap.put("sm.var_offsets.extra_element", "true");
        }
        if ((results = TileDBDataSourceOptions.collectOptionsWithKeyPrefixSuffix(this.optionMap, "tiledb.", null)).isEmpty()) {
            return configMap;
        }
        for (Pair<String, String> entry : results) {
            configMap.put((String)entry.getFirst(), (String)entry.getSecond());
        }
        return configMap;
    }

    private static Optional<Layout> tryParseOptionLayout(String val) {
        if (val.equalsIgnoreCase("row-major") || val.equalsIgnoreCase("TILEDB_ROW_MAJOR")) {
            return Optional.of(Layout.TILEDB_ROW_MAJOR);
        }
        if (val.equalsIgnoreCase("col-major") || val.equalsIgnoreCase("TILEDB_COL_MAJOR")) {
            return Optional.of(Layout.TILEDB_COL_MAJOR);
        }
        if (val.equalsIgnoreCase("unordered") || val.equalsIgnoreCase("TILEDB_UNORDERED")) {
            return Optional.of(Layout.TILEDB_UNORDERED);
        }
        if (val.equalsIgnoreCase("global-order") || val.equalsIgnoreCase("TILEDB_GLOBAL_ORDER")) {
            return Optional.of(Layout.TILEDB_GLOBAL_ORDER);
        }
        return Optional.empty();
    }

    public static Optional<List<Pair<String, Object[]>>> tryParseFilterList(String csvList) throws IllegalArgumentException {
        ArrayList<Pair> filterResults = new ArrayList<Pair>();
        Pattern filterListRegex = Pattern.compile("\\(\\s?(.*?)\\s?,\\s?(.*?)\\s?\\)");
        Matcher filterListMatcher = filterListRegex.matcher(csvList);
        while (filterListMatcher.find()) {
            String filterString = filterListMatcher.group().replace(")", "").replace("(", "");
            String[] filterWithOptions = filterString.split("\\s*,\\s*");
            String filterName = filterWithOptions[0];
            if (!(filterName.equalsIgnoreCase("NONE") || filterName.equalsIgnoreCase("NOOP") || filterName.equalsIgnoreCase("GZIP") || filterName.equalsIgnoreCase("ZSTD") || filterName.equalsIgnoreCase("LZ4") || filterName.equalsIgnoreCase("RLE") || filterName.equalsIgnoreCase("BZIP2") || filterName.equalsIgnoreCase("DOUBLE_DELTA") || filterName.equalsIgnoreCase("BIT_WIDTH_REDUCTION") || filterName.equalsIgnoreCase("BITSHUFFLE") || filterName.equalsIgnoreCase("BYTESHUFFLE") || filterName.equalsIgnoreCase("POSITIVE_DELTA") || filterName.equalsIgnoreCase("SCALE_FLOAT"))) {
                throw new IllegalArgumentException("Unknown TileDB filter string value: " + filterName);
            }
            Object[] filterOptions = new Object[filterWithOptions.length - 1];
            if (filterWithOptions.length > 1) {
                try {
                    int j = 0;
                    for (int i = 1; i < filterWithOptions.length; ++i) {
                        filterOptions[j] = filterWithOptions[i];
                        ++j;
                    }
                }
                catch (NumberFormatException err) {
                    throw new IllegalArgumentException("Cannot parse filter options for filter: " + filterName);
                }
            }
            filterResults.add(new Pair((Object)filterName, (Object)filterOptions));
        }
        if (filterResults.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(filterResults);
    }

    private static Optional<Long> tryParseOptionKeyLong(Map<String, String> options, String key) {
        Long val;
        if (!options.containsKey(key)) {
            return Optional.empty();
        }
        try {
            val = Long.parseLong(options.get(key));
        }
        catch (NumberFormatException err) {
            return Optional.empty();
        }
        return Optional.of(val);
    }

    private static Optional<Integer> tryParseOptionKeyInt(Map<String, String> options, String key) {
        int val;
        if (!options.containsKey(key)) {
            return Optional.empty();
        }
        try {
            val = Integer.parseInt(options.get(key));
        }
        catch (NumberFormatException err) {
            return Optional.empty();
        }
        return Optional.of(val);
    }

    private static Optional<Double> tryParseOptionKeyDouble(Map<String, String> options, String key) {
        Double val;
        if (!options.containsKey(key)) {
            return Optional.empty();
        }
        try {
            val = Double.parseDouble(options.get(key));
        }
        catch (NumberFormatException err) {
            return Optional.empty();
        }
        return Optional.of(val);
    }

    private static Optional<Boolean> tryParseOptionKeyBoolean(Map<String, String> options, String key) {
        if (!options.containsKey(key)) {
            return Optional.empty();
        }
        Boolean val = Boolean.parseBoolean(options.get(key));
        return Optional.of(val);
    }

    private static List<Pair<String, String>> collectOptionsWithKeyPrefixSuffix(Map<String, String> options, String prefix, String suffix) {
        boolean hasSuffix;
        ArrayList<Pair<String, String>> results = new ArrayList<Pair<String, String>>();
        boolean hasPrefix = prefix != null && prefix.length() > 0;
        boolean bl = hasSuffix = suffix != null && suffix.length() > 0;
        if (options.isEmpty() || !hasPrefix) {
            return results;
        }
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String strippedKeySuffix;
            String strippedKeyPrefix;
            String key = entry.getKey();
            String val = entry.getValue();
            if (!key.startsWith(prefix) || (strippedKeyPrefix = key.substring(prefix.length())).length() == 0) continue;
            if (!hasSuffix) {
                results.add((Pair<String, String>)new Pair((Object)strippedKeyPrefix, (Object)val));
                continue;
            }
            if (!key.endsWith(suffix) || (strippedKeySuffix = strippedKeyPrefix.substring(0, strippedKeyPrefix.length() - suffix.length())).length() <= 0) continue;
            results.add((Pair<String, String>)new Pair((Object)strippedKeySuffix, (Object)val));
        }
        return results;
    }

    private static Map<String, String> collectOptionsWithKeyPrefixSuffixMap(Map<String, String> options, String prefix, String suffix) {
        boolean hasSuffix;
        HashMap<String, String> results = new HashMap<String, String>();
        boolean hasPrefix = prefix != null && prefix.length() > 0;
        boolean bl = hasSuffix = suffix != null && suffix.length() > 0;
        if (options.isEmpty() || !hasPrefix) {
            return results;
        }
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String strippedKeySuffix;
            String strippedKeyPrefix;
            String key = entry.getKey();
            String val = entry.getValue();
            if (!key.startsWith(prefix) || (strippedKeyPrefix = key.substring(prefix.length())).length() == 0) continue;
            if (!hasSuffix) {
                results.put(strippedKeyPrefix, val);
                continue;
            }
            if (!key.endsWith(suffix) || (strippedKeySuffix = strippedKeyPrefix.substring(0, strippedKeyPrefix.length() - suffix.length())).length() <= 0) continue;
            results.put(strippedKeySuffix, val);
        }
        return results;
    }
}

