/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.Query;
import io.tiledb.java.api.QueryStatus;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.SubArray;
import io.tiledb.java.api.TileDBError;
import io.tiledb.spark.Range;
import io.tiledb.spark.TileDBBatch;
import io.tiledb.spark.TileDBDataSourceOptions;
import io.tiledb.spark.TileDBReadSchema;
import io.tiledb.spark.util;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.log4j.Logger;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.TileDBReadMetricsUpdater;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.ArrowUtils;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public class TileDBPartitionReader
implements PartitionReader<ColumnarBatch> {
    static Logger log = Logger.getLogger((String)TileDBPartitionReader.class.getName());
    private final List<List<Range>> allRanges;
    private final int dimensionRangesNum;
    private final HardwareAbstractionLayer hardwareAbstractionLayer;
    private final TileDBReadMetricsUpdater metricsUpdater;
    private long read_query_buffer_size;
    private String arrayURI;
    private TileDBDataSourceOptions options;
    private Context ctx;
    private ArraySchema arraySchema;
    private Array array;
    private Query query;
    private Domain domain;
    private StructType sparkSchema;
    private ColumnarBatch resultBatch;
    private OnHeapColumnVector[] resultVectors;
    private QueryStatus queryStatus;
    private TaskContext task;
    private List<String> fieldNames;
    private List<Integer> fieldDataTypeSizes;
    private long currentNumRecords;
    private static final OffsetDateTime zeroDateTime = new Timestamp(0L).toInstant().atOffset(ZoneOffset.UTC).toInstant().atOffset(ZoneOffset.UTC);
    private ArrayList<ByteBuffer> queryByteBuffers;
    private List<ValueVector> validityValueVectors;
    private List<ValueVector> valueVectors;

    public TypeInfo getTypeInfo(String column) throws TileDBError {
        Datatype datatype;
        boolean isNullable;
        boolean isArray;
        boolean isVarLen;
        long multiplier = 1L;
        if (this.arraySchema.hasAttribute(column)) {
            Attribute a = this.arraySchema.getAttribute(column);
            isVarLen = a.isVar();
            isArray = a.getCellValNum() > 1L;
            isNullable = a.getNullable();
            datatype = a.getType();
            a.close();
        } else {
            Domain domain = this.arraySchema.getDomain();
            Dimension d = domain.getDimension(column);
            isVarLen = d.isVar();
            isArray = d.getCellValNum() > 1L;
            isNullable = false;
            datatype = d.getType();
            d.close();
            domain.close();
        }
        switch (datatype) {
            case TILEDB_CHAR: {
                return new TypeInfo(AttributeDatatype.CHAR, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_STRING_ASCII: {
                return new TypeInfo(AttributeDatatype.ASCII, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_INT8: {
                return new TypeInfo(AttributeDatatype.INT8, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_INT32: {
                return new TypeInfo(AttributeDatatype.INT32, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_FLOAT32: {
                return new TypeInfo(AttributeDatatype.FLOAT32, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_FLOAT64: {
                return new TypeInfo(AttributeDatatype.FlOAT64, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_INT16: {
                return new TypeInfo(AttributeDatatype.INT16, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_UINT8: {
                return new TypeInfo(AttributeDatatype.UINT8, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_UINT16: {
                return new TypeInfo(AttributeDatatype.UINT16, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_INT64: 
            case TILEDB_UINT32: 
            case TILEDB_UINT64: {
                return new TypeInfo(AttributeDatatype.LONG, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_DATETIME_US: {
                return new TypeInfo(AttributeDatatype.DATE, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_DATETIME_MS: {
                multiplier = 1000L;
                return new TypeInfo(AttributeDatatype.DATE, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_DATETIME_SEC: {
                multiplier = 1000000L;
                return new TypeInfo(AttributeDatatype.DATE, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_DATETIME_MIN: {
                multiplier = 60000000L;
                return new TypeInfo(AttributeDatatype.DATE, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_DATETIME_HR: {
                multiplier = 3600000000L;
                return new TypeInfo(AttributeDatatype.DATE, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_DATETIME_NS: {
                multiplier = -1000L;
                return new TypeInfo(AttributeDatatype.DATE, datatype, isVarLen, isArray, isNullable, multiplier, false);
            }
            case TILEDB_DATETIME_DAY: {
                return new TypeInfo(AttributeDatatype.DATE, datatype, isVarLen, isArray, isNullable, multiplier, true);
            }
            case TILEDB_DATETIME_WEEK: {
                multiplier = 7L;
                return new TypeInfo(AttributeDatatype.DATE, datatype, isVarLen, isArray, isNullable, multiplier, true);
            }
            case TILEDB_DATETIME_MONTH: {
                multiplier = -1L;
                return new TypeInfo(AttributeDatatype.DATE, datatype, isVarLen, isArray, isNullable, multiplier, true);
            }
            case TILEDB_DATETIME_YEAR: {
                multiplier = -12L;
                return new TypeInfo(AttributeDatatype.DATE, datatype, isVarLen, isArray, isNullable, multiplier, true);
            }
        }
        throw new RuntimeException("Unknown attribute datatype " + datatype);
    }

    public TileDBPartitionReader(String uri, TileDBReadSchema schema, TileDBDataSourceOptions options, List<List<Range>> dimensionRanges, List<List<Range>> attributeRanges) {
        this.arrayURI = uri;
        this.validityValueVectors = new ArrayList<ValueVector>();
        this.valueVectors = new ArrayList<ValueVector>();
        this.queryByteBuffers = new ArrayList();
        this.sparkSchema = schema.getSparkSchema();
        this.options = options;
        this.queryStatus = QueryStatus.TILEDB_UNINITIALIZED;
        this.dimensionRangesNum = dimensionRanges.size();
        this.allRanges = dimensionRanges;
        this.allRanges.addAll(attributeRanges);
        this.task = TaskContext.get();
        this.metricsUpdater = new TileDBReadMetricsUpdater(this.task);
        this.metricsUpdater.startTimer("query-read-start-to-close");
        this.metricsUpdater.startTimer("query-read-task");
        this.task.addTaskCompletionListener(context -> {
            double duration = (double)this.metricsUpdater.finish("query-read-task").longValue() / 1.0E9;
            log.debug((Object)("duration of read task " + this.task.toString() + " : " + duration + "s"));
        });
        this.read_query_buffer_size = options.getReadBufferSizes();
        SystemInfo systemInfo = new SystemInfo();
        this.hardwareAbstractionLayer = systemInfo.getHardware();
        try {
            this.ctx = new Context(options.getTileDBConfigMap(true));
            this.array = this.openArray(this.ctx, this.arrayURI, QueryType.TILEDB_READ, options);
            this.arraySchema = this.array.getSchema();
            this.domain = this.arraySchema.getDomain();
            if (this.sparkSchema.fields().length != 0) {
                this.fieldNames = Arrays.stream(this.sparkSchema.fields()).map(field -> field.name()).collect(Collectors.toList());
                this.fieldDataTypeSizes = Arrays.stream(this.sparkSchema.fields()).map(field -> field.dataType().defaultSize()).collect(Collectors.toList());
            } else {
                this.fieldNames = this.domain.getDimensions().stream().map(dimension -> {
                    try {
                        return dimension.getName();
                    }
                    catch (TileDBError error) {
                        return null;
                    }
                }).collect(Collectors.toList());
                this.fieldDataTypeSizes = this.domain.getDimensions().stream().map(dimension -> {
                    try {
                        return dimension.getType().getNativeSize();
                    }
                    catch (TileDBError error) {
                        return null;
                    }
                }).collect(Collectors.toList());
            }
            this.queryByteBuffers = new ArrayList<Object>(Collections.nCopies(this.fieldNames.size(), null));
            this.initQuery();
        }
        catch (TileDBError tileDBError) {
            tileDBError.printStackTrace();
        }
    }

    private Array openArray(Context ctx, String arrayURI, QueryType queryType, TileDBDataSourceOptions options) throws TileDBError {
        Optional<Long> timestampStart = options.getTimestampStart();
        Optional<Long> timestampEnd = options.getTimestampEnd();
        if (timestampStart.isPresent() && timestampEnd.isPresent()) {
            return new Array(ctx, arrayURI, queryType, BigInteger.valueOf(timestampStart.get()), BigInteger.valueOf(timestampEnd.get()));
        }
        if (timestampEnd.isPresent()) {
            return new Array(ctx, arrayURI, queryType, BigInteger.valueOf(timestampEnd.get()));
        }
        return new Array(ctx, arrayURI, queryType);
    }

    public boolean next() {
        this.metricsUpdater.startTimer("query-next");
        try {
            if (this.query == null) {
                this.initQuery();
            }
            if (this.queryStatus == QueryStatus.TILEDB_COMPLETED) {
                this.metricsUpdater.finish("query-next");
                return false;
            }
            do {
                this.metricsUpdater.startTimer("tiledb-read-query-submit");
                this.query.submit();
                this.metricsUpdater.finish("tiledb-read-query-submit");
                this.queryStatus = this.query.getQueryStatus();
                String fieldName = this.fieldNames.get(0);
                Pair queryResultBufferElementsNIO = this.query.resultBufferElementsNIO(fieldName, this.fieldDataTypeSizes.get(0).intValue());
                boolean isVar = this.domain.hasDimension(fieldName) ? this.domain.getDimension(fieldName).isVar() : this.arraySchema.getAttribute(fieldName).isVar();
                this.currentNumRecords = isVar ? (Long)queryResultBufferElementsNIO.getFirst() - 1L : (Long)queryResultBufferElementsNIO.getSecond();
                if (this.currentNumRecords == -1L) {
                    this.currentNumRecords = 0L;
                }
                if (this.queryStatus == QueryStatus.TILEDB_INCOMPLETE && this.currentNumRecords == 0L) {
                    throw new TileDBError("Read buffer size is too small. Please increase by using the -read_buffer_size- option");
                }
                if (this.currentNumRecords <= 0L) continue;
                this.metricsUpdater.finish("query-next");
                return true;
            } while (this.queryStatus == QueryStatus.TILEDB_INCOMPLETE);
        }
        catch (TileDBError err) {
            throw new RuntimeException(err.getMessage());
        }
        this.metricsUpdater.finish("query-next");
        return true;
    }

    public ColumnarBatch get() {
        this.metricsUpdater.startTimer("query-get");
        try {
            int nRows = (int)this.currentNumRecords;
            if (this.resultBatch == null) {
                ColumnVector[] colVecs = new ColumnVector[this.valueVectors.size()];
                for (int i = 0; i < this.valueVectors.size(); ++i) {
                    boolean isDateType;
                    String name = this.fieldNames.get(i);
                    TypeInfo typeInfo = this.getTypeInfo(name);
                    boolean bl = isDateType = typeInfo.multiplier != 1L || typeInfo.moreThanDay;
                    if (typeInfo.isNullable) {
                        ArrowBuf arrowBufValidity = this.valueVectors.get(i).getValidityBuffer();
                        ArrowBuf validityByteBuffer = this.validityValueVectors.get(i).getDataBuffer();
                        for (int j = 0; j < nRows; ++j) {
                            if (validityByteBuffer.getByte((long)j) == 0) {
                                BitVectorHelper.setValidityBit((ArrowBuf)arrowBufValidity, (int)j, (int)0);
                                continue;
                            }
                            BitVectorHelper.setValidityBit((ArrowBuf)arrowBufValidity, (int)j, (int)1);
                        }
                    }
                    if (isDateType) {
                        if (typeInfo.isVarLen) {
                            throw new TileDBError("Var length attributes/dimensions of type TILEDB_DATETIME_* are not currently supported: " + name);
                        }
                        this.filterDataBufferForDateTypes(this.valueVectors.get(i).getDataBuffer(), this.currentNumRecords, typeInfo);
                    }
                    colVecs[i] = new ArrowColumnVector(this.valueVectors.get(i));
                }
                this.resultBatch = new ColumnarBatch(colVecs);
            }
            this.resultBatch.setNumRows(nRows);
            this.metricsUpdater.updateTaskMetrics(nRows, this.calculateResultByteSize());
        }
        catch (TileDBError err) {
            throw new RuntimeException(err.getMessage());
        }
        this.metricsUpdater.finish("query-get");
        return this.resultBatch;
    }

    private void filterDataBufferForDateTypes(ArrowBuf dataBuffer, long currentNumRecords, TypeInfo typeInfo) {
        int i = 0;
        while ((long)i < currentNumRecords) {
            long newValue;
            if (typeInfo.moreThanDay) {
                OffsetDateTime ms = typeInfo.multiplier > 0L ? zeroDateTime.plusDays(dataBuffer.getLong((long)i) * typeInfo.multiplier) : zeroDateTime.plusMonths(dataBuffer.getLong((long)i) * Math.abs(typeInfo.multiplier));
                newValue = ChronoUnit.MICROS.between(zeroDateTime, ms);
            } else {
                newValue = typeInfo.multiplier > 0L ? dataBuffer.getLong((long)i) * typeInfo.multiplier : dataBuffer.getLong((long)i) / Math.abs(typeInfo.multiplier);
            }
            dataBuffer.setLong((long)i, newValue);
            ++i;
        }
    }

    private long calculateResultByteSize() throws TileDBError {
        long resultBytes = 0L;
        HashMap resultBufferElements = this.query.resultBufferSizes();
        for (Map.Entry elementCount : resultBufferElements.entrySet()) {
            if (((Pair)elementCount.getValue()).getFirst() != null) {
                resultBytes += ((Long)((Pair)elementCount.getValue()).getFirst()).longValue();
            }
            if (((Pair)elementCount.getValue()).getSecond() == null) continue;
            resultBytes += ((Long)((Pair)elementCount.getValue()).getSecond()).longValue();
        }
        return resultBytes;
    }

    public void close() {
        if (this.resultBatch != null) {
            this.resultBatch.close();
            this.resultBatch = null;
        }
        this.queryByteBuffers.clear();
        if (this.query != null) {
            this.query.close();
        }
        if (this.arraySchema != null) {
            this.arraySchema.close();
        }
        if (this.array != null) {
            this.array.close();
        }
        if (this.ctx != null) {
            this.ctx.close();
        }
        this.releaseArrowVectors();
        double duration = (double)this.metricsUpdater.finish("query-read-start-to-close").longValue() / 1.0E9;
        log.debug((Object)("duration of read-to-close" + this.task.toString() + " : " + duration + "s"));
    }

    private boolean initQuery() throws TileDBError {
        this.metricsUpdater.startTimer("query-init");
        this.query = new Query(this.array, QueryType.TILEDB_READ);
        if (this.allRanges.size() > 0) {
            List<Range> dimensionRanges = this.allRanges.get(0);
            int dimIndex = 0;
            SubArray subArray = new SubArray(this.ctx, this.array);
            for (Range range : dimensionRanges) {
                if (range.getFirst() == null || range.getSecond() == null) {
                    ++dimIndex;
                    continue;
                }
                if (this.arraySchema.getDomain().getDimension(Integer.valueOf(dimIndex)).isVar()) {
                    subArray.addRangeVar(dimIndex, range.getFirst().toString(), range.getSecond().toString());
                } else {
                    subArray.addRange(dimIndex, range.getFirst(), range.getSecond(), null);
                }
                ++dimIndex;
            }
            if (dimensionRanges.size() > 0) {
                this.query.setSubarray(subArray);
            }
            if (TileDBBatch.finalQueryCondition != null) {
                this.query.setCondition(TileDBBatch.finalQueryCondition);
            }
        }
        this.setOptionQueryLayout(this.options.getArrayLayout());
        this.createValueVectors(this.read_query_buffer_size);
        this.metricsUpdater.finish("query-init");
        return true;
    }

    private long calculateByteSizes() {
        long totalBufferSize = 0L;
        long bufferCount = 0L;
        long largestSingleBuffer = 0L;
        for (ByteBuffer byteBuffer : this.queryByteBuffers) {
            if (byteBuffer == null) continue;
            totalBufferSize += (long)byteBuffer.capacity();
            if ((long)byteBuffer.capacity() > largestSingleBuffer) {
                largestSingleBuffer = byteBuffer.capacity();
            }
            ++bufferCount;
        }
        log.info((Object)("Largest single buffer is " + largestSingleBuffer + " total data buffer count is " + bufferCount));
        return totalBufferSize;
    }

    private boolean canReallocBuffers() {
        long freeMemory = this.hardwareAbstractionLayer.getMemory().getAvailable();
        long totalBufferSizes = this.calculateByteSizes();
        log.info((Object)("Checking to realloc buffers from " + totalBufferSizes + " to " + 2L * totalBufferSizes + " with " + freeMemory + " memory free"));
        return freeMemory > 4L * totalBufferSizes;
    }

    private void reallocateQueryBuffers() throws TileDBError {
        if (!this.canReallocBuffers()) {
            throw new TileDBError("Not enough memory to complete query!");
        }
        if (this.resultBatch != null) {
            this.resultBatch.close();
        }
        this.query.resetBuffers();
        this.read_query_buffer_size *= 2L;
        this.createValueVectors(this.read_query_buffer_size);
    }

    private void createValueVectors(long readBufferSize) throws TileDBError {
        this.metricsUpdater.startTimer("query-alloc-buffers");
        int minDimDize = Integer.MAX_VALUE;
        Domain domain = this.arraySchema.getDomain();
        for (Dimension dimension : domain.getDimensions()) {
            int nativeSize = dimension.getType().getNativeSize();
            if (nativeSize < minDimDize) {
                minDimDize = nativeSize;
            }
            dimension.close();
        }
        domain.close();
        this.releaseArrowVectors();
        Iterator<Object> iterator = this.fieldNames.iterator();
        while (iterator.hasNext()) {
            VarCharVector valueVector;
            String fieldName;
            String name = fieldName = (String)iterator.next();
            TypeInfo typeInfo = this.getTypeInfo(name);
            RootAllocator allocator = ArrowUtils.rootAllocator();
            UInt2Vector validityValueVector = new UInt2Vector(fieldName, (BufferAllocator)allocator);
            switch (typeInfo.datatype) {
                case CHAR: 
                case ASCII: {
                    if (!typeInfo.isVarLen) {
                        throw new RuntimeException("Unhandled fixed-len char buffer for attribute " + fieldName);
                    }
                    valueVector = new VarCharVector(fieldName, (BufferAllocator)allocator);
                    break;
                }
                case UINT8: 
                case INT8: {
                    ArrowType.FloatingPoint arrowType = new ArrowType.Int(8, true);
                    if (typeInfo.isVarLen) {
                        ListVector lv = ListVector.empty((String)fieldName, (BufferAllocator)allocator);
                        lv.addOrGetVector(FieldType.nullable((ArrowType)arrowType));
                        valueVector = lv;
                        break;
                    }
                    valueVector = new TinyIntVector(fieldName, (BufferAllocator)allocator);
                    break;
                }
                case INT32: {
                    ArrowType.FloatingPoint arrowType = new ArrowType.Int(32, true);
                    if (typeInfo.isVarLen || typeInfo.isArray) {
                        ListVector lv = ListVector.empty((String)fieldName, (BufferAllocator)allocator);
                        lv.addOrGetVector(FieldType.nullable((ArrowType)arrowType));
                        valueVector = lv;
                        break;
                    }
                    valueVector = new IntVector(fieldName, (BufferAllocator)allocator);
                    break;
                }
                case FLOAT32: {
                    ArrowType.FloatingPoint arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                    if (typeInfo.isVarLen) {
                        ListVector lv = ListVector.empty((String)fieldName, (BufferAllocator)allocator);
                        lv.addOrGetVector(FieldType.nullable((ArrowType)arrowType));
                        valueVector = lv;
                        break;
                    }
                    valueVector = new Float4Vector(fieldName, (BufferAllocator)allocator);
                    break;
                }
                case FlOAT64: {
                    ArrowType.FloatingPoint arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                    if (typeInfo.isVarLen) {
                        ListVector lv = ListVector.empty((String)fieldName, (BufferAllocator)allocator);
                        lv.addOrGetVector(FieldType.nullable((ArrowType)arrowType));
                        valueVector = lv;
                        break;
                    }
                    valueVector = new Float8Vector(fieldName, (BufferAllocator)allocator);
                    break;
                }
                case INT16: 
                case UINT16: {
                    ArrowType.FloatingPoint arrowType = new ArrowType.Int(16, true);
                    if (typeInfo.isVarLen) {
                        ListVector lv = ListVector.empty((String)fieldName, (BufferAllocator)allocator);
                        lv.addOrGetVector(FieldType.nullable((ArrowType)arrowType));
                        valueVector = lv;
                        break;
                    }
                    valueVector = new SmallIntVector(fieldName, (BufferAllocator)allocator);
                    break;
                }
                case LONG: 
                case DATE: {
                    ArrowType.FloatingPoint arrowType = new ArrowType.Int(64, true);
                    if (typeInfo.isVarLen) {
                        ListVector lv = ListVector.empty((String)fieldName, (BufferAllocator)allocator);
                        lv.addOrGetVector(FieldType.nullable((ArrowType)arrowType));
                        valueVector = lv;
                        break;
                    }
                    valueVector = new BigIntVector(fieldName, (BufferAllocator)allocator);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled datatype for Arrow buffer, attribute " + fieldName);
                }
            }
            long maxRowsL = readBufferSize / util.getDefaultRecordByteCount(valueVector.getClass());
            int maxNumRows = util.longToInt(maxRowsL);
            if (maxNumRows == 0) {
                maxNumRows = 1;
            }
            if (valueVector instanceof ListVector) {
                ((ListVector)valueVector).setInitialCapacity(maxNumRows, 1.0);
            } else {
                valueVector.setInitialCapacity(maxNumRows);
            }
            validityValueVector.setInitialCapacity(maxNumRows);
            valueVector.allocateNew();
            if (typeInfo.isNullable) {
                validityValueVector.allocateNew();
            }
            this.createAndSetArrowBuffers((ValueVector)valueVector, (ValueVector)validityValueVector, typeInfo, name);
        }
        this.metricsUpdater.finish("query-alloc-buffers");
    }

    private void createAndSetArrowBuffers(ValueVector valueVector, ValueVector validityValueVector, TypeInfo typeInfo, String name) throws TileDBError {
        ByteBuffer data;
        if (valueVector instanceof ListVector) {
            ListVector lv = (ListVector)valueVector;
            ArrowBuf arrowData = lv.getDataVector().getDataBuffer();
            data = arrowData.nioBuffer(0L, (int)arrowData.capacity());
            ArrowBuf valueBitmap = lv.getDataVector().getValidityBuffer();
            int nbytes = (int)valueBitmap.capacity();
            for (int i = 0; i < nbytes; ++i) {
                valueBitmap.setByte((long)i, 255);
            }
        } else {
            ArrowBuf arrowData = valueVector.getDataBuffer();
            data = arrowData.nioBuffer(0L, (int)arrowData.capacity());
        }
        data.order(ByteOrder.nativeOrder());
        this.query.setDataBuffer(name, data);
        ArrowBuf arrowBufBitMapValidity = valueVector.getValidityBuffer();
        int j = 0;
        while ((long)j < arrowBufBitMapValidity.capacity()) {
            arrowBufBitMapValidity.setByte((long)j, 255);
            ++j;
        }
        if (typeInfo.isVarLen) {
            ArrowBuf arrowOffsets = valueVector.getOffsetBuffer();
            ByteBuffer offsets = arrowOffsets.nioBuffer(0L, (int)arrowOffsets.capacity());
            offsets.order(ByteOrder.nativeOrder());
            this.query.setOffsetsBuffer(name, offsets);
        }
        if (typeInfo.isNullable) {
            ArrowBuf arrowBufByteMapValidity = validityValueVector.getDataBuffer();
            ByteBuffer byteBufferValidity = arrowBufByteMapValidity.nioBuffer(0L, (int)arrowBufByteMapValidity.capacity());
            byteBufferValidity.order(ByteOrder.nativeOrder());
            this.query.setValidityBuffer(name, byteBufferValidity);
            this.validityValueVectors.add(validityValueVector);
        } else {
            validityValueVector.close();
            this.validityValueVectors.add(null);
        }
        this.queryByteBuffers.add(data);
        this.valueVectors.add(valueVector);
    }

    private void setOptionQueryLayout(Optional<Layout> layoutOption) throws TileDBError {
        if (this.arraySchema.isSparse()) {
            Layout defaultLayout = Layout.TILEDB_UNORDERED;
            if (layoutOption.isPresent()) {
                this.query.setLayout(layoutOption.get());
            } else {
                this.query.setLayout(defaultLayout);
            }
        } else {
            Layout defaultLayout = this.arraySchema.getCellOrder();
            if (layoutOption.isPresent()) {
                Layout layout = layoutOption.get();
                if (layout != Layout.TILEDB_UNORDERED) {
                    this.query.setLayout(layoutOption.get());
                } else {
                    this.query.setLayout(defaultLayout);
                }
            } else {
                this.query.setLayout(defaultLayout);
            }
        }
    }

    private void releaseArrowVectors() {
        if (this.validityValueVectors != null) {
            for (ValueVector v : this.validityValueVectors) {
                if (v == null) continue;
                v.close();
            }
            this.validityValueVectors.clear();
        }
        if (this.valueVectors != null) {
            for (ValueVector v : this.valueVectors) {
                v.close();
            }
            this.valueVectors.clear();
        }
    }

    public class TypeInfo {
        public AttributeDatatype datatype;
        public Datatype tileDBDataType;
        public boolean isVarLen;
        public boolean isArray;
        public boolean isNullable;
        public long multiplier;
        public boolean moreThanDay;

        public TypeInfo(AttributeDatatype datatype, Datatype tiledbDataType, boolean isVarLen, boolean isArray, boolean isNullable, long multiplier, boolean moreThanDay) {
            this.datatype = datatype;
            this.tileDBDataType = tiledbDataType;
            this.isVarLen = isVarLen;
            this.isArray = isArray;
            this.isNullable = isNullable;
            this.multiplier = multiplier;
            this.moreThanDay = moreThanDay;
        }
    }

    public static enum AttributeDatatype {
        CHAR,
        INT8,
        UINT8,
        INT16,
        INT32,
        FLOAT32,
        FlOAT64,
        UINT16,
        LONG,
        ASCII,
        DATE;

    }
}

