/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.spark;

import io.tiledb.java.api.TileDBError;
import io.tiledb.spark.TileDBBatch;
import io.tiledb.spark.TileDBDataSourceOptions;
import io.tiledb.spark.TileDBReadSchema;
import io.tiledb.spark.util;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.TileDBReadMetricsUpdater;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;

public class TileDBScan
implements Scan {
    private final TileDBReadSchema tileDBReadSchema;
    private final TileDBDataSourceOptions options;
    private final Filter[] pushedFilters;
    private final String uri;
    private final TileDBReadMetricsUpdater metricsUpdater;
    static Logger log = Logger.getLogger((String)TileDBScan.class.getName());

    public TileDBScan(TileDBReadSchema tileDBReadSchema, TileDBDataSourceOptions options, Filter[] pushedFilters) {
        this.tileDBReadSchema = tileDBReadSchema;
        this.options = options;
        this.pushedFilters = pushedFilters;
        this.metricsUpdater = new TileDBReadMetricsUpdater(TaskContext.get());
        this.uri = util.tryGetArrayURI(options);
    }

    public StructType readSchema() {
        this.metricsUpdater.startTimer("data-source-read-schema");
        log.trace((Object)("Reading schema for " + this.uri));
        StructType schema = this.tileDBReadSchema.getSparkSchema();
        log.trace((Object)("Read schema for " + this.uri + ": " + schema));
        this.metricsUpdater.finish("data-source-read-schema");
        return this.tileDBReadSchema.getSparkSchema();
    }

    public String description() {
        return super.description();
    }

    public Batch toBatch() {
        try {
            return new TileDBBatch(this.tileDBReadSchema, this.options, this.pushedFilters);
        }
        catch (TileDBError | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public MicroBatchStream toMicroBatchStream(String checkpointLocation) {
        return super.toMicroBatchStream(checkpointLocation);
    }

    public ContinuousStream toContinuousStream(String checkpointLocation) {
        return super.toContinuousStream(checkpointLocation);
    }

    public CustomMetric[] supportedCustomMetrics() {
        return super.supportedCustomMetrics();
    }
}

